/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.ui.headless;

import io.gatling.commons.util.Io$;
import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.config.RecorderMode;
import io.gatling.recorder.config.RecorderMode$Proxy$;
import io.gatling.recorder.controller.RecorderController;
import io.gatling.recorder.ui.EventInfo;
import io.gatling.recorder.ui.RecorderFrontend;
import io.gatling.recorder.ui.headless.HeadlessFrontend$;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005ErAB\u0001\u0003\u0011\u0003\u0011A\"\u0001\tIK\u0006$G.Z:t\rJ|g\u000e^3oI*\u00111\u0001B\u0001\tQ\u0016\fG\r\\3tg*\u0011QAB\u0001\u0003k&T!a\u0002\u0005\u0002\u0011I,7m\u001c:eKJT!!\u0003\u0006\u0002\u000f\u001d\fG\u000f\\5oO*\t1\"\u0001\u0002j_B\u0011QBD\u0007\u0002\u0005\u00191qB\u0001E\u0001\u0005A\u0011\u0001\u0003S3bI2,7o\u001d$s_:$XM\u001c3\u0014\u00059\t\u0002C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"AB!osJ+g\rC\u0003\u0019\u001d\u0011\u0005!$\u0001\u0004=S:LGOP\u0002\u0001)\u0005a\u0001b\u0002\u000f\u000f\u0005\u0004%I!H\u0001\u0010%\u0016\u001cwN\u001d3feBKGMR5mKV\ta\u0004\u0005\u0002 G5\t\u0001E\u0003\u0002\fC)\t!%\u0001\u0003kCZ\f\u0017B\u0001\u0013!\u0005\u00111\u0015\u000e\\3\t\r\u0019r\u0001\u0015!\u0003\u001f\u0003A\u0011VmY8sI\u0016\u0014\b+\u001b3GS2,\u0007EB\u0003\u0010\u0005\u0001!\u0001f\u0005\u0002(SA\u0011!fK\u0007\u0002\t%\u0011A\u0006\u0002\u0002\u0011%\u0016\u001cwN\u001d3fe\u001a\u0013xN\u001c;f]\u0012D\u0001BL\u0014\u0003\u0002\u0003\u0006IaL\u0001\u000bG>tGO]8mY\u0016\u0014\bC\u0001\u00193\u001b\u0005\t$B\u0001\u0018\u0007\u0013\t\u0019\u0014G\u0001\nSK\u000e|'\u000fZ3s\u0007>tGO]8mY\u0016\u0014\b\u0002C\u001b(\u0005\u0003\u0005\u000b1\u0002\u001c\u0002\u001b\r|gNZ5hkJ\fG/[8o!\t9$(D\u00019\u0015\tId!\u0001\u0004d_:4\u0017nZ\u0005\u0003wa\u0012QCU3d_J$WM]\"p]\u001aLw-\u001e:bi&|g\u000eC\u0003\u0019O\u0011\u0005Q\b\u0006\u0002?\u0003R\u0011q\b\u0011\t\u0003\u001b\u001dBQ!\u000e\u001fA\u0004YBQA\f\u001fA\u0002=BqaQ\u0014A\u0002\u0013%A)\u0001\u0004iCN\u0014VO\\\u000b\u0002\u000bB\u0011!CR\u0005\u0003\u000fN\u0011qAQ8pY\u0016\fg\u000eC\u0004JO\u0001\u0007I\u0011\u0002&\u0002\u0015!\f7OU;o?\u0012*\u0017\u000f\u0006\u0002L\u001dB\u0011!\u0003T\u0005\u0003\u001bN\u0011A!\u00168ji\"9q\nSA\u0001\u0002\u0004)\u0015a\u0001=%c!1\u0011k\nQ!\n\u0015\u000bq\u0001[1t%Vt\u0007\u0005C\u0003TO\u0011\u0005C+\u0001\u000btK2,7\r^3e%\u0016\u001cwN\u001d3fe6{G-Z\u000b\u0002+B\u0011qGV\u0005\u0003/b\u0012ABU3d_J$WM]'pI\u0016DQ!W\u0014\u0005Bi\u000b\u0001C]3dK&4X-\u0012<f]RLeNZ8\u0015\u0005-[\u0006\"\u0002/Y\u0001\u0004i\u0016!C3wK:$\u0018J\u001c4p!\tQc,\u0003\u0002`\t\tIQI^3oi&sgm\u001c\u0005\u0006C\u001e\"\tEY\u0001\u0005S:LG\u000fF\u0001L\u0011\u0015!w\u0005\"\u0011f\u0003YA\u0017M\u001c3mK\"\u000b'/\u0012=q_J$h)Y5mkJ,GCA&g\u0011\u001597\r1\u0001i\u0003\u001diWm]:bO\u0016\u0004\"!\u001b9\u000f\u0005)t\u0007CA6\u0014\u001b\u0005a'BA7\u001a\u0003\u0019a$o\\8u}%\u0011qnE\u0001\u0007!J,G-\u001a4\n\u0005E\u0014(AB*ue&twM\u0003\u0002p'!)Ao\nC!k\u0006Y\u0001.\u0019:GS2,\u0007+\u0019;i+\u0005A\u0007\"B<(\t\u0003\u0012\u0017A\u00065b]\u0012dW\rS1s\u000bb\u0004xN\u001d;Tk\u000e\u001cWm]:\t\u000be<C\u0011\t2\u0002!I,7m\u001c:eS:<7\u000b^1si\u0016$\u0007\"B>(\t\u0003b\u0018A\b5b]\u0012dWMR5mi\u0016\u0014h+\u00197jI\u0006$\u0018n\u001c8GC&dWO]3t)\tYU\u0010C\u0003\u007fu\u0002\u0007q0\u0001\u0005gC&dWO]3t!\u0015\t\t!a\u0003i\u001d\u0011\t\u0019!a\u0002\u000f\u0007-\f)!C\u0001\u0015\u0013\r\tIaE\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti!a\u0004\u0003\u0007M+\u0017OC\u0002\u0002\nMAa!a\u0005(\t\u0003\"\u0015AF1tWNKW.\u001e7bi&|gn\u0014<fe^\u0014\u0018\u000e^3\t\r\u0005]q\u0005\"\u0011c\u0003A\u0011XmY8sI&twm\u0015;paB,G\rC\u0004\u0002\u001c\u001d\"\t%!\b\u0002)!\fg\u000e\u001a7f\u001b&\u001c8/\u001b8h\u0011\u0006\u0014h)\u001b7f)\rY\u0015q\u0004\u0005\b\u0003C\tI\u00021\u0001i\u0003\u0011\u0001\u0018\r\u001e5\t\r\u0005\u0015r\u0005\"\u0003c\u00039\u0019'/Z1uK2{7m\u001b$jY\u0016Dq!!\u000b(\t\u0013\tY#\u0001\u0005qe&tG/\u0012:s)\rY\u0015Q\u0006\u0005\b\u0003_\t9\u00031\u0001i\u0003\ri7o\u001a")
public class HeadlessFrontend
extends RecorderFrontend {
    private final RecorderConfiguration configuration;
    private boolean hasRun;

    private boolean hasRun() {
        return this.hasRun;
    }

    private void hasRun_$eq(boolean x$1) {
        this.hasRun = x$1;
    }

    @Override
    public RecorderMode selectedRecorderMode() {
        return this.configuration.core().mode();
    }

    @Override
    public void receiveEventInfo(EventInfo eventInfo) {
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[Event] ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eventInfo})));
    }

    @Override
    public void init() {
        if (!this.hasRun()) {
            this.hasRun_$eq(true);
            Predef$.MODULE$.println((Object)"Starting Recorder in headless mode");
            RecorderMode recorderMode = this.selectedRecorderMode();
            RecorderMode$Proxy$ recorderMode$Proxy$ = RecorderMode$Proxy$.MODULE$;
            if (!(recorderMode != null ? !recorderMode.equals(recorderMode$Proxy$) : recorderMode$Proxy$ != null) && HeadlessFrontend$.MODULE$.io$gatling$recorder$ui$headless$HeadlessFrontend$$RecorderPidFile().exists()) {
                this.printErr(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Recorder lock file found at ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HeadlessFrontend$.MODULE$.io$gatling$recorder$ui$headless$HeadlessFrontend$$RecorderPidFile()})));
                this.printErr("Make sure that there is no other recording in progress.");
                throw package$.MODULE$.exit(1);
            }
            this.startRecording();
        } else {
            package$.MODULE$.runtime().halt(0);
        }
    }

    @Override
    public void handleHarExportFailure(String message) {
        this.printErr(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not convert HAR file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message})));
    }

    @Override
    public String harFilePath() {
        return (String)this.configuration.core().harFilePath().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
    }

    @Override
    public void handleHarExportSuccess() {
        Predef$.MODULE$.println((Object)"HAR file successfully converted.");
    }

    @Override
    public void recordingStarted() {
        this.createLockFile();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Recording started, proxy port is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.configuration.proxy().port())})));
        Predef$.MODULE$.println((Object)"To stop the Recorder and generate the Simulation, kill the Recorder process with: ");
        Predef$.MODULE$.println((Object)"- CTRL-C");
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"- Use the Recorder's PID, written to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HeadlessFrontend$.MODULE$.io$gatling$recorder$ui$headless$HeadlessFrontend$$RecorderPidFile()})));
        package$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.stopRecording(true));
    }

    @Override
    public void handleFilterValidationFailures(Seq<String> failures) {
    }

    @Override
    public boolean askSimulationOverwrite() {
        this.printErr("Another simulation with the same name exists.");
        return false;
    }

    @Override
    public void recordingStopped() {
        HeadlessFrontend$.MODULE$.io$gatling$recorder$ui$headless$HeadlessFrontend$$RecorderPidFile().delete();
        Predef$.MODULE$.println((Object)"New Gatling simulation created.");
    }

    @Override
    public void handleMissingHarFile(String path) {
        String errorMessage = path.isEmpty() ? "The HAR file to convert was not specified, either through recorder.conf or through CLI options." : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find the HAR file (path: ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}));
        this.printErr(errorMessage);
    }

    private void createLockFile() {
        String pid = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ManagementFactory.getRuntimeMXBean().getName().split("@"))).head();
        Io$.MODULE$.withCloseable((AutoCloseable)new PrintStream(HeadlessFrontend$.MODULE$.io$gatling$recorder$ui$headless$HeadlessFrontend$$RecorderPidFile()), (Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.println(pid);
            return BoxedUnit.UNIT;
        });
    }

    private void printErr(String msg) {
        Console$.MODULE$.err().println(msg);
    }

    public HeadlessFrontend(RecorderController controller, RecorderConfiguration configuration) {
        this.configuration = configuration;
        super(controller);
        this.hasRun = false;
    }
}

