/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.EmptyByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.DecoderResultProvider;
import io.netty.util.ReferenceCountUtil;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.ChannelOperations;
import reactor.util.Logger;
import reactor.util.Loggers;

final class ChannelOperationsHandler
extends ChannelInboundHandlerAdapter {
    final ConnectionObserver listener;
    final ChannelOperations.OnSetup opsFactory;
    static final Logger log = Loggers.getLogger(ChannelOperationsHandler.class);

    ChannelOperationsHandler(ChannelOperations.OnSetup opsFactory, ConnectionObserver listener) {
        this.listener = listener;
        this.opsFactory = opsFactory;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        Connection c = Connection.from(ctx.channel());
        this.listener.onStateChange(c, ConnectionObserver.State.CONNECTED);
        ChannelOperations<?, ?> ops = this.opsFactory.create(c, this.listener, null);
        if (ops != null) {
            ops.bind();
            this.listener.onStateChange(ops, ConnectionObserver.State.CONFIGURED);
        }
    }

    public final void channelInactive(ChannelHandlerContext ctx) {
        try {
            Connection connection = Connection.from(ctx.channel());
            ChannelOperations ops = connection.as(ChannelOperations.class);
            if (ops != null) {
                ops.onInboundClose();
            } else {
                this.listener.onStateChange(connection, ConnectionObserver.State.DISCONNECTING);
            }
        }
        catch (Throwable err) {
            this.exceptionCaught(ctx, err);
        }
    }

    public final void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg == null || msg == Unpooled.EMPTY_BUFFER || msg instanceof EmptyByteBuf) {
            return;
        }
        try {
            ChannelOperations<?, ?> ops = ChannelOperations.get(ctx.channel());
            if (ops != null) {
                ops.onInboundNext(ctx, msg);
            } else {
                if (log.isDebugEnabled()) {
                    String loggingMsg;
                    DecoderResult decoderResult;
                    if (msg instanceof DecoderResultProvider && (decoderResult = ((DecoderResultProvider)msg).decoderResult()).isFailure()) {
                        log.debug(ReactorNetty.format(ctx.channel(), "Decoding failed: " + msg + " : "), decoderResult.cause());
                    }
                    if (msg instanceof ByteBufHolder && ((ByteBufHolder)msg).content() != Unpooled.EMPTY_BUFFER) {
                        ByteBuf buffer = ((ByteBufHolder)msg).content();
                        loggingMsg = "\n" + ByteBufUtil.prettyHexDump((ByteBuf)buffer);
                    } else {
                        loggingMsg = msg instanceof ByteBuf ? "\n" + ByteBufUtil.prettyHexDump((ByteBuf)((ByteBuf)msg)) : msg.toString();
                    }
                    log.debug(ReactorNetty.format(ctx.channel(), "No ChannelOperation attached. Dropping: {}"), new Object[]{loggingMsg});
                }
                ReferenceCountUtil.release((Object)msg);
            }
        }
        catch (Throwable err) {
            ReferenceCountUtil.safeRelease((Object)msg);
            this.exceptionCaught(ctx, err);
        }
    }

    public final void exceptionCaught(ChannelHandlerContext ctx, Throwable err) {
        Connection connection = Connection.from(ctx.channel());
        ChannelOperations ops = connection.as(ChannelOperations.class);
        if (ops != null) {
            ops.onInboundError(err);
        } else {
            this.listener.onUncaughtException(connection, err);
        }
    }
}

