/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.exception;

import io.shardingsphere.core.exception.ShardingException;
import io.shardingsphere.core.parsing.lexer.Lexer;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.lexer.token.TokenType;

public final class SQLParsingException
extends ShardingException {
    private static final long serialVersionUID = -6408790652103666096L;
    private static final String UNMATCH_MESSAGE = "SQL syntax error, expected token is '%s', actual token is '%s', literals is '%s'.";
    private static final String TOKEN_ERROR_MESSAGE = "SQL syntax error, token is '%s', literals is '%s'.";

    public SQLParsingException(String message, Object ... args) {
        super(message, args);
    }

    public SQLParsingException(Lexer lexer, TokenType expectedTokenType) {
        super(String.format(UNMATCH_MESSAGE, expectedTokenType, lexer.getCurrentToken().getType(), lexer.getCurrentToken().getLiterals()), new Object[0]);
    }

    public SQLParsingException(LexerEngine lexerEngine) {
        super(String.format(TOKEN_ERROR_MESSAGE, lexerEngine.getCurrentToken().getType(), lexerEngine.getCurrentToken().getLiterals()), new Object[0]);
    }
}

