/*
 * Decompiled with CFR 0.152.
 */
package zipkin.reporter.urlconnection;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import zipkin.Component;
import zipkin.internal.Util;
import zipkin.reporter.BytesMessageEncoder;
import zipkin.reporter.Callback;
import zipkin.reporter.Encoding;
import zipkin.reporter.Sender;
import zipkin.reporter.urlconnection.AutoValue_URLConnectionSender;

public abstract class URLConnectionSender
implements Sender {
    transient boolean closeCalled;

    public static URLConnectionSender create(String endpoint) {
        return URLConnectionSender.builder().endpoint(endpoint).build();
    }

    public static Builder builder() {
        return new AutoValue_URLConnectionSender.Builder().encoding(Encoding.THRIFT).connectTimeout(10000).readTimeout(60000).compressionEnabled(true).messageMaxBytes(0x500000);
    }

    public Builder toBuilder() {
        return new AutoValue_URLConnectionSender.Builder(this);
    }

    abstract BytesMessageEncoder encoder();

    abstract URL endpoint();

    abstract int connectTimeout();

    abstract int readTimeout();

    abstract boolean compressionEnabled();

    abstract String mediaType();

    public int messageSizeInBytes(List<byte[]> encodedSpans) {
        return this.encoding().listSizeInBytes(encodedSpans);
    }

    public void sendSpans(List<byte[]> encodedSpans, Callback callback) {
        block3: {
            if (this.closeCalled) {
                throw new IllegalStateException("close");
            }
            try {
                byte[] message = this.encoder().encode(encodedSpans);
                this.send(message, this.mediaType());
                callback.onComplete();
            }
            catch (Throwable e) {
                callback.onError(e);
                if (!(e instanceof Error)) break block3;
                throw (Error)e;
            }
        }
    }

    public Component.CheckResult check() {
        try {
            this.send(new byte[]{91, 93}, "application/json");
            return Component.CheckResult.OK;
        }
        catch (Exception e) {
            return Component.CheckResult.failed((Exception)e);
        }
    }

    public void close() {
        this.closeCalled = true;
    }

    void send(byte[] body, String mediaType) throws IOException {
        Throwable throwable;
        Object compressor;
        HttpURLConnection connection = (HttpURLConnection)this.endpoint().openConnection();
        connection.setConnectTimeout(this.connectTimeout());
        connection.setReadTimeout(this.readTimeout());
        connection.setRequestMethod("POST");
        connection.addRequestProperty("Content-Type", mediaType);
        if (this.compressionEnabled()) {
            connection.addRequestProperty("Content-Encoding", "gzip");
            ByteArrayOutputStream gzipped = new ByteArrayOutputStream();
            compressor = new GZIPOutputStream(gzipped);
            throwable = null;
            try {
                ((FilterOutputStream)compressor).write(body);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (compressor != null) {
                    if (throwable != null) {
                        try {
                            ((DeflaterOutputStream)compressor).close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        ((DeflaterOutputStream)compressor).close();
                    }
                }
            }
            body = gzipped.toByteArray();
        }
        connection.setDoOutput(true);
        connection.setFixedLengthStreamingMode(body.length);
        connection.getOutputStream().write(body);
        try {
            InputStream in = connection.getInputStream();
            compressor = null;
            try {
                while (in.read() != -1) {
                }
            }
            catch (Throwable throwable4) {
                compressor = throwable4;
                throw throwable4;
            }
            finally {
                if (in != null) {
                    if (compressor != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable5) {
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (IOException e) {
            InputStream err = connection.getErrorStream();
            throwable = null;
            try {
                if (err != null) {
                    while (err.read() != -1) {
                    }
                }
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (err != null) {
                    if (throwable != null) {
                        try {
                            err.close();
                        }
                        catch (Throwable throwable7) {
                        }
                    } else {
                        err.close();
                    }
                }
            }
            throw e;
        }
    }

    URLConnectionSender() {
    }

    public static abstract class Builder {
        public final Builder endpoint(String endpoint) {
            Util.checkNotNull((Object)endpoint, (String)"endpoint ex: http://zipkinhost:9411/api/v1/spans");
            try {
                return this.endpoint(new URL(endpoint));
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }

        public abstract Builder endpoint(URL var1);

        public abstract Builder connectTimeout(int var1);

        public abstract Builder readTimeout(int var1);

        public abstract Builder compressionEnabled(boolean var1);

        public abstract Builder messageMaxBytes(int var1);

        public abstract Builder encoding(Encoding var1);

        abstract Encoding encoding();

        public final URLConnectionSender build() {
            if (this.encoding() == Encoding.JSON) {
                return this.mediaType("application/json").encoder(BytesMessageEncoder.JSON).autoBuild();
            }
            if (this.encoding() == Encoding.THRIFT) {
                return this.mediaType("application/x-thrift").encoder(BytesMessageEncoder.THRIFT).autoBuild();
            }
            throw new UnsupportedOperationException("Unsupported encoding: " + this.encoding().name());
        }

        abstract Builder encoder(BytesMessageEncoder var1);

        abstract Builder mediaType(String var1);

        abstract URLConnectionSender autoBuild();

        Builder() {
        }
    }
}

