/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.converter;

import java.io.IOException;
import java.util.List;
import org.mabb.fontverter.FVFont;
import org.mabb.fontverter.FontConverter;
import org.mabb.fontverter.GlyphMapReader;
import org.mabb.fontverter.cff.CffFontAdapter;
import org.mabb.fontverter.opentype.CffTable;
import org.mabb.fontverter.opentype.NameTable;
import org.mabb.fontverter.opentype.OpenTypeFont;

public class CFFToOpenTypeConverter
implements FontConverter {
    private CffFontAdapter cffFont;
    private OpenTypeFont otfFont;

    public CFFToOpenTypeConverter(CffFontAdapter cffFont) {
        this.cffFont = cffFont;
    }

    public CFFToOpenTypeConverter(byte[] cffdata) throws IOException {
        this.cffFont = CffFontAdapter.parse(cffdata);
    }

    @Override
    public FVFont convertFont(FVFont font) throws IOException {
        this.cffFont = (CffFontAdapter)font;
        return this.generateFont();
    }

    public OpenTypeFont generateFont() throws IOException {
        this.otfFont = OpenTypeFont.createBlankFont();
        this.otfFont.getSfntHeader().sfntFlavor = "OTTO";
        byte[] cffData = this.cffFont.getData();
        this.otfFont.addTable(new CffTable(cffData));
        this.convertGlyphIdToCodeMap();
        this.convertNameRecords(this.otfFont.getNameTable());
        this.convertHorizontalLayoutSettings();
        this.otfFont.finalizeFont();
        return this.otfFont;
    }

    private void convertGlyphIdToCodeMap() throws IOException {
        List<GlyphMapReader.GlyphMapping> glyphMappings = this.cffFont.getGlyphMaps();
        for (int i = 0; i < glyphMappings.size(); ++i) {
            GlyphMapReader.GlyphMapping mappingOn = glyphMappings.get(i);
            if (mappingOn.glyphId != 0) continue;
            glyphMappings.remove(mappingOn);
            break;
        }
        this.otfFont.getCmap().addGlyphMapping(glyphMappings);
    }

    private void convertNameRecords(NameTable name) throws IOException {
        name.setFontFamily(this.cffFont.getFamilyName());
        name.setVersion(this.cffFont.getVersion());
        name.setFontSubFamily(this.cffFont.getSubFamilyName());
        name.setPostScriptName(this.cffFont.getFamilyName());
        name.setCopyright(this.cffFont.getTrademarkNotice());
        name.setFontFullName(this.cffFont.getFullName());
    }

    private void convertHorizontalLayoutSettings() throws IOException {
        this.otfFont.getHhea().descender = this.cffFont.getUnderLinePosition().shortValue();
        this.otfFont.getHead().setMinX((short)this.cffFont.getMinX());
        this.otfFont.getHead().setMaxX((short)this.cffFont.getMaxX());
        this.otfFont.getHead().setMinY((short)this.cffFont.getMinY());
        this.otfFont.getHead().setMaxY((short)this.cffFont.getMaxY());
    }
}

