/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.opentype;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.fontbox.cff.CFFStandardEncoding;
import org.apache.fontbox.encoding.Encoding;
import org.mabb.fontverter.GlyphMapReader;
import org.mabb.fontverter.io.FontDataInputStream;
import org.mabb.fontverter.io.FontDataOutputStream;
import org.mabb.fontverter.opentype.CmapSubTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Format4SubTable
extends CmapSubTable {
    private static final Logger log = LoggerFactory.getLogger(Format4SubTable.class);
    private static final int FORMAT4_HEADER_SIZE = 16;
    private Map<Integer, Integer> charCodeToGlyphId = new LinkedHashMap<Integer, Integer>();
    List<Integer> deltas;
    List<Integer> ends;
    List<Integer> starts;
    List<Integer> idRangeOffsets;
    List<List<IndexedGlyph>> idRangeGlyphs;
    private int glyphsStartPos;

    public Format4SubTable() {
        this.formatNumber = 4;
    }

    @Override
    public byte[] getData() throws IOException {
        FontDataOutputStream writer = new FontDataOutputStream(FontDataOutputStream.OPEN_TYPE_CHARSET);
        if (this.rawReadData != null) {
            writer.writeUnsignedShort(this.formatNumber);
            writer.writeUnsignedShort(this.rawReadData.length + 4);
            writer.write(this.rawReadData);
            return writer.toByteArray();
        }
        this.calculateSegments();
        writer.writeUnsignedShort(this.formatNumber);
        writer.writeUnsignedShort(this.getLength());
        writer.writeUnsignedShort((int)this.getLanguageId());
        writer.writeUnsignedShort(this.getSegmentCount() * 2);
        writer.writeUnsignedShort(this.getSearchRange());
        writer.writeUnsignedShort(this.getEntrySelector());
        writer.writeUnsignedShort(this.getRangeShift());
        for (Integer endEntryOn : this.ends) {
            writer.writeUnsignedShort(endEntryOn);
        }
        writer.writeUnsignedShort(65535);
        writer.writeUnsignedShort(0);
        for (Integer startEntryOn : this.starts) {
            writer.writeUnsignedShort(startEntryOn);
        }
        writer.writeUnsignedShort(65535);
        for (Integer deltaEntryOn : this.deltas) {
            writer.writeUnsignedShort(deltaEntryOn);
        }
        writer.writeUnsignedShort(1);
        for (Integer rangeOffsets : this.idRangeOffsets) {
            writer.writeUnsignedShort(0);
        }
        writer.writeUnsignedShort(0);
        byte[] data = writer.toByteArray();
        this.setDataHeaderLength(data);
        return data;
    }

    private void writeIndexedGlyphs(FontDataOutputStream writer) throws IOException {
        this.glyphsStartPos = writer.currentPosition();
        for (int segIndex = 0; segIndex < this.idRangeOffsets.size(); ++segIndex) {
            Integer idRangeOn = this.idRangeOffsets.get(segIndex);
            if (idRangeOn == 0) continue;
            this.writeSegmentGlyphs(writer, segIndex);
        }
    }

    private void writeSegmentGlyphs(FontDataOutputStream writer, int segIndex) throws IOException {
        Integer idRangeOn = this.idRangeOffsets.get(segIndex);
        List<IndexedGlyph> glyphs = this.idRangeGlyphs.get(segIndex);
        for (int glyphIndex = 0; glyphIndex < glyphs.size(); ++glyphIndex) {
            int position = writer.currentPosition();
            long glyphOffset = this.glyphsStartPos + (idRangeOn / 2 + glyphIndex + (segIndex - this.getSegmentCount())) * 2;
            int paddingNeeded = (int)(glyphOffset - (long)position - 1L);
            if (paddingNeeded > 0) {
                writer.write(new byte[paddingNeeded]);
            }
            IndexedGlyph glyphOn = glyphs.get(glyphIndex);
            writer.writeUnsignedShort(glyphOn.glyphId);
            log.warn(String.format("Wrote cmapsub4 indexed glyph. glyphId:%d glyphOffset:%d idRangeOffset: %d charCode:%d", glyphOn.glyphId, glyphOffset, idRangeOn, glyphOn.charCode));
        }
    }

    private void calculateSegments() {
        this.initSegments();
        List<Map.Entry<Integer, Integer>> entries = this.getOrderedCharCodeToGlyphIds();
        int numSetOffsets = 0;
        int lastCharCode = -1;
        int lastGlyphId = -1;
        for (Map.Entry<Integer, Integer> entryOn : entries) {
            int lastDeltaOn;
            boolean needAddSegment;
            int charCodeOn = entryOn.getKey();
            int glyphIdOn = entryOn.getValue();
            int delta = glyphIdOn - charCodeOn;
            boolean bl = needAddSegment = charCodeOn != lastCharCode + 1 || lastGlyphId + 1 != glyphIdOn;
            if (needAddSegment) {
                this.starts.add(charCodeOn);
                this.deltas.add(delta);
                if (delta < 0) {
                    this.idRangeOffsets.add((numSetOffsets + 1) * 2);
                    ++numSetOffsets;
                } else {
                    this.idRangeOffsets.add(0);
                }
                this.idRangeGlyphs.add(new LinkedList());
            }
            if ((lastDeltaOn = this.deltas.get(this.deltas.size() - 1).intValue()) < 0) {
                List<IndexedGlyph> rangeGlyphs = this.idRangeGlyphs.get(this.idRangeGlyphs.size() - 1);
                rangeGlyphs.add(new IndexedGlyph(glyphIdOn, charCodeOn));
            }
            if (needAddSegment && lastCharCode != -1) {
                this.ends.add(lastCharCode);
            }
            lastCharCode = charCodeOn;
        }
        if (entries.size() >= 1) {
            this.ends.add(entries.get(entries.size() - 1).getKey());
        }
    }

    private void initSegments() {
        this.deltas = new LinkedList<Integer>();
        this.starts = new LinkedList<Integer>();
        this.ends = new LinkedList<Integer>();
        this.idRangeOffsets = new LinkedList<Integer>();
        this.idRangeGlyphs = new LinkedList<List<IndexedGlyph>>();
    }

    @Override
    public void readData(FontDataInputStream input) throws IOException {
        int length = input.readUnsignedShort();
        this.rawReadData = input.readBytes(length - 4);
        input = new FontDataInputStream(this.rawReadData);
        this.languageId = input.readUnsignedShort();
        int segmentCount = input.readUnsignedShort() / 2;
        int searchRange = input.readUnsignedShort();
        int entrySelector = input.readUnsignedShort();
        int rangeShift = input.readUnsignedShort();
        int[] charCodeRangeEnds = input.readUnsignedShortArray(segmentCount);
        int reservedPad = input.readUnsignedShort();
        int[] charCodeRangeStarts = input.readUnsignedShortArray(segmentCount);
        int[] idDelta = input.readUnsignedShortArray(segmentCount);
        int[] idRangeOffset = input.readUnsignedShortArray(segmentCount);
        long glyphIndexStartPos = input.getPosition();
        for (int segOn = 0; segOn < segmentCount - 1; ++segOn) {
            int start = charCodeRangeStarts[segOn];
            int end = charCodeRangeEnds[segOn];
            int delta = idDelta[segOn];
            int offset = idRangeOffset[segOn];
            for (int charCode = start; charCode <= end; ++charCode) {
                if (offset == 0) {
                    int glyphId = (delta + charCode) % 65536;
                    this.charCodeToGlyphId.put(charCode, glyphId);
                    continue;
                }
                long glyphOffset = (offset / 2 + (charCode - start) + (segOn - segmentCount)) * 2;
                input.seek((int)(glyphOffset += glyphIndexStartPos));
                int glyphArrIndex = input.readUnsignedShort();
                if (glyphArrIndex == 0) continue;
                glyphArrIndex = (glyphArrIndex + delta) % 65536;
                this.charCodeToGlyphId.put(charCode, glyphArrIndex);
            }
        }
    }

    private void setDataHeaderLength(byte[] data) throws IOException {
        FontDataOutputStream lengthWriter = new FontDataOutputStream(FontDataOutputStream.OPEN_TYPE_CHARSET);
        lengthWriter.writeUnsignedShort(data.length);
        byte[] lengthData = lengthWriter.toByteArray();
        data[2] = lengthData[0];
        data[3] = lengthData[1];
    }

    @Override
    public int glyphCount() {
        return this.charCodeToGlyphId.size() + 1;
    }

    private int getSegmentCount() {
        return this.ends.size() + 1;
    }

    private int getSearchRange() {
        double logFloor = Math.floor(this.log2(this.getSegmentCount()));
        return (int)(2.0 * Math.pow(2.0, logFloor));
    }

    private int getEntrySelector() {
        return (int)this.log2(this.getSearchRange() / 2);
    }

    private int getRangeShift() {
        return 2 * this.getSegmentCount() - this.getSearchRange();
    }

    private double log2(int number) {
        return Math.log(number) / Math.log(2.0);
    }

    private int getLength() {
        return 16 + this.charCodeToGlyphId.size() * 8;
    }

    public void addGlyphMapping(int characterCode, int glyphId) {
        this.charCodeToGlyphId.put(characterCode, glyphId);
    }

    @Override
    public List<GlyphMapReader.GlyphMapping> getGlyphMappings() {
        return GlyphMapReader.readCharCodesToGlyphs(this.charCodeToGlyphId, (Encoding)CFFStandardEncoding.getInstance());
    }

    private List<Map.Entry<Integer, Integer>> getOrderedCharCodeToGlyphIds() {
        ArrayList<Map.Entry<Integer, Integer>> charCodeEntries = new ArrayList<Map.Entry<Integer, Integer>>();
        for (Map.Entry<Integer, Integer> entryOn : this.charCodeToGlyphId.entrySet()) {
            charCodeEntries.add(entryOn);
        }
        Collections.sort(charCodeEntries, new Comparator<Map.Entry<Integer, Integer>>(){

            @Override
            public int compare(Map.Entry<Integer, Integer> o1, Map.Entry<Integer, Integer> o2) {
                return o1.getKey() < o2.getKey() ? -1 : (o1.getKey().equals(o2.getKey()) ? 0 : 1);
            }
        });
        return charCodeEntries;
    }

    private static class IndexedGlyph {
        public int glyphId;
        public int charCode;

        public IndexedGlyph(int glyphId, int charCode) {
            this.glyphId = glyphId;
            this.charCode = charCode;
        }
    }
}

