/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.registries;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.ComparatorRegistry;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.ldap.schema.parsers.ComparatorDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultComparatorRegistry
implements ComparatorRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultComparatorRegistry.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private final Map<String, Comparator<?>> byOidComparator = new ConcurrentHashMap();
    private final Map<String, ComparatorDescription> oidToDescription = new ConcurrentHashMap<String, ComparatorDescription>();

    @Override
    public void register(ComparatorDescription description, Comparator<?> comparator) throws NamingException {
        String oid = description.getNumericOid();
        if (this.byOidComparator.containsKey(oid)) {
            String msg = "Comparator '" + description + "' with OID " + oid + " already registered!";
            LOG.warn(msg);
            throw new NamingException(msg);
        }
        this.oidToDescription.put(oid, description);
        this.byOidComparator.put(oid, comparator);
        if (DEBUG) {
            LOG.debug("registed comparator with OID: {}", (Object)oid);
        }
    }

    private static String getSchema(ComparatorDescription desc) {
        List values = (List)desc.getExtensions().get("X-SCHEMA");
        if (values == null || values.size() == 0) {
            return "other";
        }
        return (String)values.get(0);
    }

    @Override
    public Comparator<?> lookup(String oid) throws NamingException {
        Comparator<?> c = this.byOidComparator.get(oid);
        if (c == null) {
            String msg = "Comparator not found for OID: " + oid;
            LOG.error(msg);
            throw new NamingException(msg);
        }
        if (DEBUG) {
            LOG.debug("looked up comparator with OID: {}", (Object)oid);
        }
        return c;
    }

    @Override
    public boolean hasComparator(String oid) {
        return this.byOidComparator.containsKey(oid);
    }

    @Override
    public String getSchemaName(String oid) throws NamingException {
        if (!OID.isOID((String)oid)) {
            String msg = "OID " + oid + " is not a numeric OID";
            LOG.error(msg);
            throw new NamingException(msg);
        }
        ComparatorDescription description = this.oidToDescription.get(oid);
        if (description != null) {
            return DefaultComparatorRegistry.getSchema(description);
        }
        String msg = "OID " + oid + " not found in oid to description map!";
        LOG.error(msg);
        throw new NamingException(msg);
    }

    @Override
    public Iterator<String> iterator() {
        return this.byOidComparator.keySet().iterator();
    }

    @Override
    public void unregister(String oid) throws NamingException {
        if (!OID.isOID((String)oid)) {
            String msg = "OID " + oid + " is not a numeric OID";
            LOG.error(msg);
            throw new NamingException(msg);
        }
        this.byOidComparator.remove(oid);
        this.oidToDescription.remove(oid);
    }

    @Override
    public void unregisterSchemaElements(String schemaName) {
        ArrayList<String> oids = new ArrayList<String>(this.byOidComparator.keySet());
        for (String oid : oids) {
            ComparatorDescription description = this.oidToDescription.get(oid);
            String schemaNameForOid = DefaultComparatorRegistry.getSchema(description);
            if (!schemaNameForOid.equalsIgnoreCase(schemaName)) continue;
            this.byOidComparator.remove(oid);
            this.oidToDescription.remove(oid);
        }
    }

    @Override
    public void renameSchema(String originalSchemaName, String newSchemaName) {
        ArrayList<String> oids = new ArrayList<String>(this.byOidComparator.keySet());
        for (String oid : oids) {
            ComparatorDescription description = this.oidToDescription.get(oid);
            String schemaNameForOid = DefaultComparatorRegistry.getSchema(description);
            if (!schemaNameForOid.equalsIgnoreCase(originalSchemaName)) continue;
            List schemaExt = (List)description.getExtensions().get("X-SCHEMA");
            schemaExt.clear();
            schemaExt.add(newSchemaName);
        }
    }

    @Override
    public Iterator<ComparatorDescription> comparatorDescriptionIterator() {
        return this.oidToDescription.values().iterator();
    }
}

