/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.jpa.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.util.AnnotationLiteral;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.SynchronizationType;
import javax.persistence.ValidationMode;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import org.apache.meecrowave.jpa.api.EntityManagerScoped;
import org.apache.meecrowave.jpa.internal.AnyLiteral;
import org.apache.meecrowave.jpa.internal.EntityManagerContext;
import org.apache.meecrowave.jpa.internal.UnitLiteral;

@Vetoed
public class EntityManagerBean
implements Bean<EntityManager>,
PassivationCapable {
    private final Set<Type> types = new HashSet<Class<EntityManager>>(Collections.singletonList(EntityManager.class));
    private final Set<Annotation> qualifiers = new HashSet<Annotation>();
    private final EntityManagerContext entityManagerContext;
    private final SynchronizationType synchronization;
    private final String id;
    private Supplier<EntityManager> instanceFactory;

    EntityManagerBean(EntityManagerContext context, String name, SynchronizationType synchronization) {
        this.entityManagerContext = context;
        this.qualifiers.addAll(Arrays.asList(new AnnotationLiteral[]{new UnitLiteral(name, synchronization), AnyLiteral.INSTANCE}));
        this.id = "meecrowave::jpa::entitymanager::" + name + "/" + synchronization.name();
        this.synchronization = synchronization;
    }

    void init(final PersistenceUnitInfo info, final BeanManager bm) {
        PersistenceProvider provider;
        try {
            provider = (PersistenceProvider)PersistenceProvider.class.cast(Thread.currentThread().getContextClassLoader().loadClass(info.getPersistenceProviderClassName()).newInstance());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Bad provider: " + info.getPersistenceProviderClassName());
        }
        EntityManagerFactory factory = provider.createContainerEntityManagerFactory(info, (Map)new HashMap(){
            {
                this.put("javax.persistence.bean.manager", bm);
                if (ValidationMode.NONE != info.getValidationMode()) {
                    Optional.ofNullable(EntityManagerBean.this.findValidatorFactory(bm)).ifPresent(factory -> this.put("javax.persistence.validation.factory", factory));
                }
            }
        });
        this.instanceFactory = this.synchronization == SynchronizationType.SYNCHRONIZED ? () -> ((EntityManagerFactory)factory).createEntityManager() : () -> factory.createEntityManager(this.synchronization);
    }

    private Object findValidatorFactory(BeanManager bm) {
        try {
            Class<?> type = Thread.currentThread().getContextClassLoader().loadClass("javax.validation.ValidatorFactory");
            Bean bean = bm.resolve(bm.getBeans(type, new Annotation[0]));
            if (bean == null || !bm.isNormalScope(bean.getScope())) {
                return null;
            }
            return bm.getReference(bean, type, bm.createCreationalContext(null));
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return null;
        }
    }

    public EntityManager create(CreationalContext<EntityManager> context) {
        EntityManager entityManager = this.instanceFactory.get();
        if (this.entityManagerContext.isTransactional()) {
            entityManager.getTransaction().begin();
        }
        return entityManager;
    }

    public void destroy(EntityManager instance, CreationalContext<EntityManager> context) {
        try {
            if (this.entityManagerContext.isTransactional()) {
                if (this.entityManagerContext.hasFailed()) {
                    instance.getTransaction().rollback();
                } else {
                    instance.getTransaction().commit();
                }
            }
        }
        finally {
            instance.close();
        }
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public Class<?> getBeanClass() {
        return EntityManager.class;
    }

    public boolean isNullable() {
        return false;
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public Class<? extends Annotation> getScope() {
        return EntityManagerScoped.class;
    }

    public String getName() {
        return null;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    public String getId() {
        return this.id;
    }
}

