/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.jar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Manifest
extends java.util.jar.Manifest
implements Iterable<String> {
    private static final String ATTRIBUTE_NAME = "Name";
    private static final String ATTRIBUTE_FROM = "From";
    private static final String DEFAULT_MANIFEST_VERSION = "1.0";
    private static final int MAX_LINE_LENGTH = 72;
    private static final int MAX_SECTION_LENGTH = 70;
    static final String EOL = "\r\n";
    private Section mainSection = new Section();

    private static Collection<String> getKeys(Attributes attributes) {
        ArrayList<String> result = new ArrayList<String>();
        for (Object objectObjectEntry : attributes.keySet()) {
            result.add(objectObjectEntry.toString());
        }
        return result;
    }

    @Override
    public Iterator<String> iterator() {
        return this.getEntries().keySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest getDefaultManifest() throws ArchiverException {
        Manifest manifest;
        String defManifest = "/org/codehaus/plexus/archiver/jar/defaultManifest.mf";
        InputStream in = Manifest.class.getResourceAsStream(defManifest);
        if (in == null) {
            throw new ArchiverException("Could not find default manifest: " + defManifest);
        }
        try {
            Manifest defaultManifest = new Manifest(new InputStreamReader(in, "UTF-8"));
            defaultManifest.getMainAttributes().putValue("Created-By", System.getProperty("java.vm.version") + " (" + System.getProperty("java.vm.vendor") + ")");
            manifest = defaultManifest;
        }
        catch (UnsupportedEncodingException e) {
            Manifest manifest2;
            try {
                manifest2 = new Manifest(new InputStreamReader(in));
            }
            catch (Throwable throwable) {
                try {
                    IOUtil.close((InputStream)in);
                    throw throwable;
                }
                catch (ManifestException e2) {
                    throw new ArchiverException("Default manifest is invalid !!", e2);
                }
                catch (IOException e3) {
                    throw new ArchiverException("Unable to read default manifest", e3);
                }
            }
            IOUtil.close((InputStream)in);
            return manifest2;
        }
        IOUtil.close((InputStream)in);
        return manifest;
    }

    public Manifest() {
        this.setManifestVersion();
    }

    private void setManifestVersion() {
        this.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, DEFAULT_MANIFEST_VERSION);
    }

    public Manifest(Reader r) throws ManifestException, IOException {
        super(Manifest.getInputStream(r));
        this.setManifestVersion();
    }

    public Manifest(InputStream is) throws IOException {
        super(is);
        this.setManifestVersion();
    }

    public void addConfiguredSection(Section section) throws ManifestException {
        String sectionName = section.getName();
        if (sectionName == null) {
            throw new ManifestException("Sections must have a name");
        }
        Attributes attributes = this.getOrCreateAttributes(sectionName);
        for (String s : section.attributes.keySet()) {
            Attribute attribute = section.getAttribute(s);
            attributes.putValue(attribute.getName(), attribute.getValue());
        }
    }

    private Attributes getOrCreateAttributes(String name) {
        Attributes attributes = this.getAttributes(name);
        if (attributes == null) {
            attributes = new Attributes();
            this.getEntries().put(name, attributes);
        }
        return attributes;
    }

    public void addConfiguredAttribute(Attribute attribute) throws ManifestException {
        Manifest.remap(this.getMainAttributes(), attribute);
    }

    public void write(PrintWriter writer) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        super.write(byteArrayOutputStream);
        for (byte b : byteArrayOutputStream.toByteArray()) {
            writer.write((char)b);
        }
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            this.write(new PrintWriter(sw));
        }
        catch (IOException e) {
            return null;
        }
        return sw.toString();
    }

    Enumeration<String> getWarnings() {
        Vector<String> warnings = new Vector<String>();
        Enumeration<String> warnEnum = this.mainSection.getWarnings();
        while (warnEnum.hasMoreElements()) {
            warnings.addElement(warnEnum.nextElement());
        }
        return warnings.elements();
    }

    public String getManifestVersion() {
        return DEFAULT_MANIFEST_VERSION;
    }

    public ExistingSection getMainSection() {
        return new ExistingSection(this.getMainAttributes(), null);
    }

    public ExistingSection getSection(String name) {
        Attributes attributes = this.getAttributes(name);
        if (attributes != null) {
            return new ExistingSection(attributes, name);
        }
        return null;
    }

    private static InputStream getInputStream(Reader r) throws IOException {
        int read;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((read = r.read()) != -1) {
            byteArrayOutputStream.write(read);
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    public static String remap(Attributes backingAttributes, Attribute attribute) throws ManifestException {
        if (attribute.getKey() == null || attribute.getValue() == null) {
            throw new ManifestException("Attributes must have name and value");
        }
        String attributeKey = attribute.getKey();
        if (attributeKey.equalsIgnoreCase("Class-Path")) {
            String classpathAttribute = backingAttributes.getValue(attributeKey);
            classpathAttribute = classpathAttribute == null ? attribute.getValue() : classpathAttribute + " " + attribute.getValue();
            backingAttributes.putValue("Class-Path", classpathAttribute);
        } else {
            backingAttributes.putValue(attribute.getName(), attribute.getValue());
            if (attribute.getKey().equalsIgnoreCase(ATTRIBUTE_NAME)) {
                return attribute.getValue();
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ExistingSection
    implements Iterable<String> {
        private final Attributes backingAttributes;
        private final String sectionName;

        public ExistingSection(Attributes backingAttributes, String sectionName) {
            this.backingAttributes = backingAttributes;
            this.sectionName = sectionName;
        }

        @Override
        public Iterator<String> iterator() {
            return Manifest.getKeys(this.backingAttributes).iterator();
        }

        public ExistingAttribute getAttribute(String attributeName) {
            Attributes.Name name = new Attributes.Name(attributeName);
            return this.backingAttributes.containsKey(name) ? new ExistingAttribute(this.backingAttributes, attributeName) : null;
        }

        public String getName() {
            return this.sectionName;
        }

        public String getAttributeValue(String attributeName) {
            return this.backingAttributes.getValue(attributeName);
        }

        public void removeAttribute(String attributeName) {
            this.backingAttributes.remove(new Attributes.Name(attributeName));
        }

        public void addConfiguredAttribute(Attribute attribute) throws ManifestException {
            this.backingAttributes.putValue(attribute.getName(), attribute.getValue());
        }

        public String addAttributeAndCheck(Attribute attribute) throws ManifestException {
            return Manifest.remap(this.backingAttributes, attribute);
        }

        public int hashCode() {
            return this.backingAttributes.hashCode();
        }

        public boolean equals(Object rhs) {
            return rhs instanceof ExistingSection && this.backingAttributes.equals(((ExistingSection)rhs).backingAttributes);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Section
    implements Iterable<String> {
        private Vector<String> warnings = new Vector();
        private String name = null;
        private Hashtable<String, Attribute> attributes = new Hashtable();
        private Vector<String> attributeIndex = new Vector();

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public Iterator<String> iterator() {
            return this.attributes.keySet().iterator();
        }

        public Attribute getAttribute(String attributeName) {
            return this.attributes.get(attributeName.toLowerCase());
        }

        public void addConfiguredAttribute(Attribute attribute) throws ManifestException {
            String check = this.addAttributeAndCheck(attribute);
            if (check != null) {
                throw new ManifestException("Specify the section name using the \"name\" attribute of the <section> element rather than using a \"Name\" manifest attribute");
            }
        }

        public String addAttributeAndCheck(Attribute attribute) throws ManifestException {
            if (attribute.getName() == null || attribute.getValue() == null) {
                throw new ManifestException("Attributes must have name and value");
            }
            if (attribute.getKey().equalsIgnoreCase(Manifest.ATTRIBUTE_NAME)) {
                this.warnings.addElement("\"Name\" attributes should not occur in the main section and must be the first element in all other sections: \"" + attribute.getName() + ": " + attribute.getValue() + "\"");
                return attribute.getValue();
            }
            if (attribute.getKey().startsWith(Manifest.ATTRIBUTE_FROM.toLowerCase())) {
                this.warnings.addElement("Manifest attributes should not start with \"From\" in \"" + attribute.getName() + ": " + attribute.getValue() + "\"");
            } else {
                String attributeKey = attribute.getKey();
                if (attributeKey.equalsIgnoreCase("Class-Path")) {
                    Attribute classpathAttribute = this.attributes.get(attributeKey);
                    if (classpathAttribute == null) {
                        this.storeAttribute(attribute);
                    } else {
                        this.warnings.addElement("Multiple Class-Path attributes are supported but violate the Jar specification and may not be correctly processed in all environments");
                        for (String value : attribute) {
                            classpathAttribute.addValue(value);
                        }
                    }
                } else {
                    if (this.attributes.containsKey(attributeKey)) {
                        throw new ManifestException("The attribute \"" + attribute.getName() + "\" may not occur more " + "than once in the same section");
                    }
                    this.storeAttribute(attribute);
                }
            }
            return null;
        }

        protected void storeAttribute(Attribute attribute) {
            if (attribute == null) {
                return;
            }
            String attributeKey = attribute.getKey();
            this.attributes.put(attributeKey, attribute);
            if (!this.attributeIndex.contains(attributeKey)) {
                this.attributeIndex.addElement(attributeKey);
            }
        }

        public Enumeration<String> getWarnings() {
            return this.warnings.elements();
        }

        public int hashCode() {
            int hashCode = 0;
            if (this.name != null) {
                hashCode += this.name.hashCode();
            }
            return hashCode += this.attributes.hashCode();
        }

        public boolean equals(Object rhs) {
            if (rhs == null || rhs.getClass() != this.getClass()) {
                return false;
            }
            if (rhs == this) {
                return true;
            }
            Section rhsSection = (Section)rhs;
            return rhsSection.attributes != null && this.attributes.equals(rhsSection.attributes);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ExistingAttribute
    extends Attribute
    implements Iterable<String> {
        private final Attributes attributes;

        public ExistingAttribute(Attributes attributes, String name) {
            this.attributes = attributes;
            this.name = name;
        }

        @Override
        public Iterator<String> iterator() {
            return Manifest.getKeys(this.attributes).iterator();
        }

        @Override
        public void setName(String name) {
            throw new UnsupportedOperationException("Cant do this");
        }

        @Override
        public String getKey() {
            return this.name;
        }

        @Override
        public void setValue(String value) {
            this.attributes.putValue(this.name, value);
        }

        @Override
        public String getValue() {
            return this.attributes.getValue(this.name);
        }

        @Override
        public void addValue(String value) {
            String value1 = this.getValue();
            value1 = value1 != null ? " " + value : value;
            this.setValue(value1);
        }

        @Override
        void write(PrintWriter writer) throws IOException {
            throw new UnsupportedOperationException("Cant do this");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Attribute
    extends BaseAttribute
    implements Iterable<String> {
        private Vector<String> values = new Vector();
        private int currentIndex = 0;

        public Attribute() {
        }

        public Attribute(String name, String value) {
            this.name = name;
            this.setValue(value);
        }

        @Override
        public Iterator<String> iterator() {
            return this.values.iterator();
        }

        @Override
        public int hashCode() {
            int hashCode = super.hashCode();
            return hashCode += this.values.hashCode();
        }

        @Override
        public boolean equals(Object rhs) {
            if (super.equals(rhs)) {
                return false;
            }
            if (rhs == null || rhs.getClass() != this.getClass()) {
                return false;
            }
            if (rhs == this) {
                return true;
            }
            Attribute rhsAttribute = (Attribute)rhs;
            String lhsKey = this.getKey();
            String rhsKey = rhsAttribute.getKey();
            if (lhsKey == null && rhsKey != null || lhsKey != null && rhsKey == null || !lhsKey.equals(rhsKey)) {
                return false;
            }
            return rhsAttribute.values != null && this.values.equals(rhsAttribute.values);
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getKey() {
            if (this.name == null) {
                return null;
            }
            return this.name.toLowerCase();
        }

        public void setValue(String value) {
            if (this.currentIndex >= this.values.size()) {
                this.values.addElement(value);
                this.currentIndex = this.values.size() - 1;
            } else {
                this.values.setElementAt(value, this.currentIndex);
            }
        }

        public String getValue() {
            if (this.values.size() == 0) {
                return null;
            }
            String fullValue = "";
            for (String value : this.values) {
                fullValue = fullValue + value + " ";
            }
            return fullValue.trim();
        }

        public void addValue(String value) {
            ++this.currentIndex;
            this.setValue(value);
        }

        void write(PrintWriter writer) throws IOException {
            StringWriter sWriter = new StringWriter();
            PrintWriter bufferWriter = new PrintWriter(sWriter);
            for (String value : this.values) {
                this.writeValue(bufferWriter, value);
            }
            byte[] convertedToUtf8 = sWriter.toString().getBytes("UTF-8");
            writer.print(new String(convertedToUtf8, "UTF-8"));
        }

        private void writeValue(PrintWriter writer, String value) throws IOException {
            String nameValue = this.name + ": " + value;
            StringTokenizer tokenizer = new StringTokenizer(nameValue, "\n\r");
            String prefix = "";
            while (tokenizer.hasMoreTokens()) {
                this.writeLine(writer, prefix + tokenizer.nextToken());
                prefix = " ";
            }
        }

        private void writeLine(PrintWriter writer, String line) throws IOException {
            while (line.getBytes().length > 72) {
                int breakIndex = 70;
                String section = line.substring(0, breakIndex);
                while (section.getBytes().length > 70 && breakIndex > 0) {
                    section = line.substring(0, --breakIndex);
                }
                if (breakIndex == 0) {
                    throw new IOException("Unable to write manifest line " + line);
                }
                writer.print(section + Manifest.EOL);
                line = " " + line.substring(breakIndex);
            }
            writer.print(line + Manifest.EOL);
        }
    }

    public static class BaseAttribute {
        protected String name = null;

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BaseAttribute)) {
                return false;
            }
            BaseAttribute that = (BaseAttribute)o;
            return !(this.name == null ? that.name != null : !this.name.equals(that.name));
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }
    }
}

