/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.key;

import java.util.Objects;
import org.jnosql.diana.api.TypeSupplier;
import org.jnosql.diana.api.Value;
import org.jnosql.diana.api.key.KeyValueEntity;

final class DefaultKeyValueEntity<T>
implements KeyValueEntity {
    private final T key;
    private final Value value;

    DefaultKeyValueEntity(T key, Value value) {
        this.key = Objects.requireNonNull(key, "key is required");
        this.value = Objects.requireNonNull(value, "value is required");
    }

    @Override
    public T getKey() {
        return this.key;
    }

    @Override
    public Value getValue() {
        return this.value;
    }

    @Override
    public Object get() {
        return this.value.get();
    }

    public Object get(TypeSupplier typeSupplier) {
        return this.value.get(typeSupplier);
    }

    public Object get(Class clazz) {
        return this.value.get(clazz);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("KeyValueEntity{");
        sb.append("key='").append(this.key).append('\'');
        sb.append(", value=").append(this.value);
        sb.append('}');
        return sb.toString();
    }
}

