/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.servlet.context;

import org.springframework.boot.web.server.WebServer;
import org.springframework.context.SmartLifecycle;

class WebServerGracefulShutdownLifecycle
implements SmartLifecycle {
    private final WebServer webServer;
    private volatile boolean running;

    WebServerGracefulShutdownLifecycle(WebServer webServer) {
        this.webServer = webServer;
    }

    public void start() {
        this.running = true;
    }

    public void stop() {
        throw new UnsupportedOperationException("Stop must not be invoked directly");
    }

    public void stop(Runnable callback) {
        this.running = false;
        this.webServer.shutDownGracefully(result -> callback.run());
    }

    public boolean isRunning() {
        return this.running;
    }
}

