/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.core;

import java.util.Map;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.serialization.Deserializer;
import org.springframework.lang.Nullable;

public interface ConsumerFactory<K, V> {
    default public Consumer<K, V> createConsumer() {
        return this.createConsumer(null);
    }

    default public Consumer<K, V> createConsumer(@Nullable String clientIdSuffix) {
        return this.createConsumer(null, clientIdSuffix);
    }

    default public Consumer<K, V> createConsumer(@Nullable String groupId, @Nullable String clientIdSuffix) {
        return this.createConsumer(groupId, null, clientIdSuffix);
    }

    public Consumer<K, V> createConsumer(@Nullable String var1, @Nullable String var2, @Nullable String var3);

    public boolean isAutoCommit();

    default public Map<String, Object> getConfigurationProperties() {
        throw new UnsupportedOperationException("'getConfigurationProperties()' is not supported");
    }

    default public Deserializer<K> getKeyDeserializer() {
        throw new UnsupportedOperationException("'getKeyDeserializer()' is not supported");
    }

    default public Deserializer<V> getValueDeserializer() {
        throw new UnsupportedOperationException("'getKeyDeserializer()' is not supported");
    }
}

