/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.fastjson.serializer;

import com.gexin.fastjson.JSON;
import com.gexin.fastjson.parser.DefaultJSONParser;
import com.gexin.fastjson.parser.JSONLexer;
import com.gexin.fastjson.parser.deserializer.ObjectDeserializer;
import java.lang.reflect.Type;

public class CharArrayCodec
implements ObjectDeserializer {
    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        return CharArrayCodec.deserialze(parser);
    }

    public static <T> T deserialze(DefaultJSONParser parser) {
        JSONLexer lexer = parser.lexer;
        if (lexer.token() == 4) {
            String val = lexer.stringVal();
            lexer.nextToken(16);
            return (T)val.toCharArray();
        }
        if (lexer.token() == 2) {
            Number val = lexer.integerValue();
            lexer.nextToken(16);
            return (T)val.toString().toCharArray();
        }
        Object value = parser.parse();
        return (T)(value == null ? null : JSON.toJSONString(value).toCharArray());
    }

    @Override
    public int getFastMatchToken() {
        return 4;
    }
}

