/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.fastjson.serializer;

import com.gexin.fastjson.parser.DefaultJSONParser;
import com.gexin.fastjson.parser.JSONLexer;
import com.gexin.fastjson.parser.deserializer.ObjectDeserializer;
import com.gexin.fastjson.serializer.JSONSerializer;
import com.gexin.fastjson.serializer.ObjectSerializer;
import com.gexin.fastjson.serializer.SerializeWriter;
import com.gexin.fastjson.serializer.SerializerFeature;
import com.gexin.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Type;

public class FloatCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static FloatCodec instance = new FloatCodec();

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.out;
        if (object == null) {
            out.writeNull(SerializerFeature.WriteNullNumberAsZero);
            return;
        }
        float floatValue = ((Float)object).floatValue();
        out.writeFloat(floatValue, true);
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        return FloatCodec.deserialze(parser);
    }

    public static <T> T deserialze(DefaultJSONParser parser) {
        JSONLexer lexer = parser.lexer;
        if (lexer.token() == 2) {
            String val = lexer.numberString();
            lexer.nextToken(16);
            return (T)Float.valueOf(Float.parseFloat(val));
        }
        if (lexer.token() == 3) {
            float val = lexer.floatValue();
            lexer.nextToken(16);
            return (T)Float.valueOf(val);
        }
        Object value = parser.parse();
        if (value == null) {
            return null;
        }
        return (T)TypeUtils.castToFloat(value);
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

