/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.fastjson.serializer;

import com.gexin.fastjson.JSONException;
import com.gexin.fastjson.parser.DefaultJSONParser;
import com.gexin.fastjson.parser.JSONLexer;
import com.gexin.fastjson.parser.deserializer.ObjectDeserializer;
import com.gexin.fastjson.serializer.JSONSerializer;
import com.gexin.fastjson.serializer.ObjectSerializer;
import com.gexin.fastjson.serializer.SerializeWriter;
import com.gexin.fastjson.serializer.SerializerFeature;
import com.gexin.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.concurrent.atomic.AtomicInteger;

public class IntegerCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static IntegerCodec instance = new IntegerCodec();

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.out;
        Number value = (Number)object;
        if (value == null) {
            out.writeNull(SerializerFeature.WriteNullNumberAsZero);
            return;
        }
        if (object instanceof Long) {
            out.writeLong(value.longValue());
        } else {
            out.writeInt(value.intValue());
        }
        if (out.isEnabled(SerializerFeature.WriteClassName)) {
            Class<?> clazz = value.getClass();
            if (clazz == Byte.class) {
                out.write(66);
            } else if (clazz == Short.class) {
                out.write(83);
            }
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        Integer intObj;
        JSONLexer lexer = parser.lexer;
        if (lexer.token() == 8) {
            lexer.nextToken(16);
            return null;
        }
        if (lexer.token() == 2) {
            int val;
            try {
                val = lexer.intValue();
            }
            catch (NumberFormatException ex) {
                throw new JSONException("int value overflow, field : " + fieldName, ex);
            }
            lexer.nextToken(16);
            intObj = val;
        } else if (lexer.token() == 3) {
            BigDecimal decimalValue = lexer.decimalValue();
            lexer.nextToken(16);
            intObj = decimalValue.intValue();
        } else {
            Object value = parser.parse();
            intObj = TypeUtils.castToInt(value);
        }
        if (clazz == AtomicInteger.class) {
            return (T)new AtomicInteger(intObj);
        }
        return (T)intObj;
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

