/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.rp.sdk.base.payload;

import com.gexin.fastjson.JSON;
import com.gexin.rp.sdk.base.payload.MultiMedia;
import com.gexin.rp.sdk.base.payload.Payload;
import com.gexin.rp.sdk.base.uitls.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class APNPayload
implements Payload {
    public static final String APN_SOUND_SILENCE = "com.gexin.ios.silence";
    public static final int PAYLOAD_MAX_BYTES = 3072;
    private AlertMsg alertMsg = null;
    private int badge = -1;
    private String sound_str = "default";
    private int contentAvailable = 0;
    private String category;
    private String apnsCollapseId;
    private Map<String, Object> customMsg = new HashMap<String, Object>();
    private String autoBadge = null;
    private int voicePlayType = 0;
    private String voicePlayMessage;
    private List<MultiMedia> multiMedias = new ArrayList<MultiMedia>();
    private String threadId;
    private Sound sound_d;

    @Override
    public String getPayload() {
        try {
            HashMap<String, Object> apsMap = new HashMap<String, Object>();
            if (this.contentAvailable == 1 && this.alertMsg != null && !this.alertMsg.isEmpty()) {
                throw new RuntimeException("when contentAvailable = 1, setting alertMsg is not supported.");
            }
            if (this.alertMsg != null) {
                apsMap.put("alert", this.alertMsg.getAlertMsg());
            }
            if (this.autoBadge != null) {
                apsMap.put("autoBadge", this.autoBadge);
            } else if (this.badge >= 0) {
                apsMap.put("badge", this.badge);
            }
            if (!APN_SOUND_SILENCE.equals(this.sound_str)) {
                apsMap.put("sound", this.sound_str);
            }
            if (this.sound_d != null && !this.sound_d.getAsMap().isEmpty()) {
                apsMap.put("sound", this.sound_d.getAsMap());
            }
            if (apsMap.isEmpty()) {
                throw new RuntimeException("format error");
            }
            if (this.contentAvailable > 0) {
                apsMap.put("content-available", this.contentAvailable);
            }
            if (this.category != null && this.category.length() > 0) {
                apsMap.put("category", this.category);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String key : this.customMsg.keySet()) {
                map.put(key, this.customMsg.get(key));
            }
            if (this.apnsCollapseId != null) {
                map.put("apns-collapse-id", this.apnsCollapseId);
            }
            if (this.threadId != null && this.threadId.length() > 0) {
                apsMap.put("thread-id", this.threadId);
            }
            map.put("aps", apsMap);
            if (this.multiMedias != null && this.multiMedias.size() > 0) {
                map.put("_grinfo_", this.checkMultiMedias());
            }
            if (this.voicePlayType == 1) {
                map.put("_gvp_t_", 1);
            } else if (this.voicePlayType == 2 && StringUtils.isNotBlank(this.voicePlayMessage)) {
                map.put("_gvp_t_", 2);
                map.put("_gvp_m_", this.voicePlayMessage);
            }
            return JSON.toJSONString(map);
        }
        catch (Exception e) {
            throw new RuntimeException("create apn payload error", e);
        }
    }

    public APNPayload setApnsCollapseId(String apnsCollapseId) {
        if (null != apnsCollapseId && apnsCollapseId.length() > 0) {
            this.apnsCollapseId = apnsCollapseId;
        }
        return this;
    }

    public String getApnsCollapseId() {
        return this.apnsCollapseId;
    }

    private List<MultiMedia> checkMultiMedias() {
        if (this.multiMedias.size() > 3) {
            throw new RuntimeException("MultiMedias size overlimit");
        }
        boolean needGeneRid = false;
        HashSet<String> rids = new HashSet<String>();
        for (MultiMedia media : this.multiMedias) {
            if (media.getResId() == null) {
                needGeneRid = true;
            } else {
                rids.add(media.getResId());
            }
            if (media.getResType() != null && media.getResUrl() != null) continue;
            throw new RuntimeException("MultiMedia resType and resUrl can't be null");
        }
        if (rids.size() != this.multiMedias.size()) {
            needGeneRid = true;
        }
        int index = 0;
        if (needGeneRid) {
            for (MultiMedia multiMedia : this.multiMedias) {
                multiMedia.setResId("grid-" + index++);
            }
        }
        return this.multiMedias;
    }

    public APNPayload addCustomMsg(String key, Object value) {
        if (key != null && key.length() > 0 && value != null) {
            this.customMsg.put(key, value);
        }
        return this;
    }

    public APNPayload setCategory(String category) {
        this.category = category;
        return this;
    }

    @Deprecated
    public APNPayload setBadge(int badge) {
        if (badge >= 0) {
            this.badge = badge;
        }
        return this;
    }

    public APNPayload setSound(String sound) {
        this.sound_str = sound == null || sound.isEmpty() ? "default" : sound;
        return this;
    }

    public APNPayload setContentAvailable(int contentAvailable) {
        if (contentAvailable > 0) {
            this.contentAvailable = contentAvailable;
        }
        return this;
    }

    public APNPayload setAlertMsg(AlertMsg alertMsg) {
        this.alertMsg = alertMsg;
        return this;
    }

    public void setVoicePlayType(int voicePlayType) {
        this.voicePlayType = voicePlayType;
    }

    public void setVoicePlayMessage(String voicePlayMessage) {
        this.voicePlayMessage = voicePlayMessage;
    }

    public String getAutoBadge() {
        return this.autoBadge;
    }

    public APNPayload setAutoBadge(String autoBadge) {
        if (autoBadge == null || !autoBadge.matches("^(-|\\+)?\\d+$")) {
            throw new RuntimeException("autoBadge invalid");
        }
        this.autoBadge = autoBadge;
        return this;
    }

    public APNPayload addMultiMedia(MultiMedia media) {
        this.multiMedias.add(media);
        return this;
    }

    public APNPayload setMultiMedias(List<MultiMedia> medias) {
        this.multiMedias = medias;
        return this;
    }

    public APNPayload setThreadId(String threadId) {
        this.threadId = threadId;
        return this;
    }

    public APNPayload setSound(Sound sound) {
        this.sound_d = sound;
        return this;
    }

    public static class Sound {
        private int critical = Integer.MIN_VALUE;
        private String name;
        private double volume = Double.MIN_VALUE;

        public Sound setCritical(int critical) {
            this.critical = critical;
            return this;
        }

        public Sound setName(String name) {
            this.name = name;
            return this;
        }

        public Sound setVolume(double volume) {
            if (volume > 1.0 || volume < 0.0) {
                throw new RuntimeException("volume of sound_d should between 0.0 and 1.0");
            }
            this.volume = BigDecimal.valueOf(volume).setScale(2, 4).doubleValue();
            return this;
        }

        public Map<String, Object> getAsMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (this.name != null && this.name.length() > 0) {
                map.put("name", this.name);
            }
            if (Integer.MIN_VALUE != this.critical) {
                map.put("critical", this.critical);
            }
            if (Double.MIN_VALUE != this.volume) {
                map.put("volume", this.volume);
            }
            return map;
        }
    }

    public static class DictionaryAlertMsg
    implements AlertMsg {
        private String title;
        private String body;
        private String titleLocKey;
        private List<String> titleLocArgs = new ArrayList<String>();
        private String actionLocKey;
        private String locKey;
        private List<String> locArgs = new ArrayList<String>();
        private String launchImage;
        private String subtitle;
        private String subtitleLocKey;
        private List<String> subtitleLocArgs = new ArrayList<String>();
        private String summaryArg;
        private int summaryArgCount = Integer.MIN_VALUE;

        public DictionaryAlertMsg setSubtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public DictionaryAlertMsg setSubtitleLocKey(String subtitleLocKey) {
            this.subtitleLocKey = subtitleLocKey;
            return this;
        }

        public DictionaryAlertMsg addSubtitleLocArgs(String subtitleLocArg) {
            if (subtitleLocArg != null && subtitleLocArg.length() > 0) {
                this.subtitleLocArgs.add(subtitleLocArg);
            }
            return this;
        }

        public DictionaryAlertMsg setTitle(String title) {
            this.title = title;
            return this;
        }

        public DictionaryAlertMsg setBody(String body) {
            this.body = body;
            return this;
        }

        public String getBody() {
            return this.body;
        }

        public DictionaryAlertMsg setTitleLocKey(String titleLocKey) {
            this.titleLocKey = titleLocKey;
            return this;
        }

        public DictionaryAlertMsg addTitleLocArg(String titleLocArg) {
            if (titleLocArg != null && titleLocArg.length() > 0) {
                this.titleLocArgs.add(titleLocArg);
            }
            return this;
        }

        public DictionaryAlertMsg setActionLocKey(String actionLocKey) {
            this.actionLocKey = actionLocKey;
            return this;
        }

        public DictionaryAlertMsg setLocKey(String locKey) {
            this.locKey = locKey;
            return this;
        }

        public DictionaryAlertMsg addLocArg(String locArg) {
            if (locArg != null && locArg.length() > 0) {
                this.locArgs.add(locArg);
            }
            return this;
        }

        public DictionaryAlertMsg setLaunchImage(String launchImage) {
            this.launchImage = launchImage;
            return this;
        }

        public DictionaryAlertMsg setSummaryArg(String summaryArg) {
            this.summaryArg = summaryArg;
            return this;
        }

        public DictionaryAlertMsg setSummaryArgCount(int summaryArgCount) {
            this.summaryArgCount = summaryArgCount;
            return this;
        }

        @Override
        public Object getAlertMsg() {
            HashMap<String, Object> alertMap = new HashMap<String, Object>();
            if (this.title != null && this.title.length() > 0) {
                alertMap.put("title", this.title);
            }
            if (this.body != null && this.body.length() > 0) {
                alertMap.put("body", this.body);
            }
            if (this.titleLocKey != null && this.titleLocKey.length() > 0) {
                alertMap.put("title-loc-key", this.titleLocKey);
            }
            if (this.titleLocArgs.size() > 0) {
                alertMap.put("title-loc-args", this.titleLocArgs);
            }
            if (this.actionLocKey != null && this.actionLocKey.length() > 0) {
                alertMap.put("action-loc-key", this.actionLocKey);
            }
            if (this.locKey != null && this.locKey.length() > 0) {
                alertMap.put("loc-key", this.locKey);
            }
            if (this.locArgs.size() > 0) {
                alertMap.put("loc-args", this.locArgs);
            }
            if (this.launchImage != null && this.launchImage.length() > 0) {
                alertMap.put("launch-image", this.launchImage);
            }
            if (this.subtitle != null && this.subtitle.length() > 0) {
                alertMap.put("subtitle", this.subtitle);
            }
            if (this.subtitleLocArgs.size() > 0) {
                alertMap.put("subtitle-loc-args", this.subtitleLocArgs);
            }
            if (this.subtitleLocKey != null && this.subtitleLocKey.length() > 0) {
                alertMap.put("subtitle-loc-key", this.subtitleLocKey);
            }
            if (this.summaryArg != null && this.summaryArg.length() > 0) {
                alertMap.put("summary-arg", this.summaryArg);
            }
            if (this.summaryArgCount != Integer.MIN_VALUE) {
                alertMap.put("summary-arg-count", this.summaryArgCount);
            }
            return alertMap;
        }

        @Override
        public boolean isEmpty() {
            Object alertMsg = this.getAlertMsg();
            return alertMsg == null || ((Map)alertMsg).isEmpty();
        }
    }

    public static class SimpleAlertMsg
    implements AlertMsg {
        private String alertMsg;

        public SimpleAlertMsg(String alertMsg) {
            this.alertMsg = alertMsg;
        }

        @Override
        public Object getAlertMsg() {
            return this.alertMsg;
        }

        @Override
        public boolean isEmpty() {
            return this.alertMsg == null || this.alertMsg.isEmpty();
        }
    }

    public static interface AlertMsg {
        public Object getAlertMsg();

        public boolean isEmpty();
    }
}

