/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.repository.Query;
import org.springframework.data.mongodb.repository.query.AbstractMongoQuery;
import org.springframework.data.mongodb.repository.query.BooleanUtil;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.mongodb.util.json.ParameterBindingContext;
import org.springframework.data.mongodb.util.json.ParameterBindingDocumentCodec;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

public class StringBasedMongoQuery
extends AbstractMongoQuery {
    private static final String COUNT_EXISTS_AND_DELETE = "Manually defined query for %s cannot be a count and exists or delete query at the same time!";
    private static final Logger LOG = LoggerFactory.getLogger(StringBasedMongoQuery.class);
    private static final ParameterBindingDocumentCodec CODEC = new ParameterBindingDocumentCodec();
    private final String query;
    private final String fieldSpec;
    private final SpelExpressionParser expressionParser;
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;
    private final boolean isCountQuery;
    private final boolean isExistsQuery;
    private final boolean isDeleteQuery;

    public StringBasedMongoQuery(MongoQueryMethod method, MongoOperations mongoOperations, SpelExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        this(method.getAnnotatedQuery(), method, mongoOperations, expressionParser, evaluationContextProvider);
    }

    public StringBasedMongoQuery(String query, MongoQueryMethod method, MongoOperations mongoOperations, SpelExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(method, mongoOperations);
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull((Object)expressionParser, (String)"SpelExpressionParser must not be null!");
        this.query = query;
        this.expressionParser = expressionParser;
        this.evaluationContextProvider = evaluationContextProvider;
        this.fieldSpec = method.getFieldSpecification();
        if (method.hasAnnotatedQuery()) {
            Query queryAnnotation = method.getQueryAnnotation();
            this.isCountQuery = queryAnnotation.count();
            this.isExistsQuery = queryAnnotation.exists();
            this.isDeleteQuery = queryAnnotation.delete();
            if (StringBasedMongoQuery.hasAmbiguousProjectionFlags(this.isCountQuery, this.isExistsQuery, this.isDeleteQuery)) {
                throw new IllegalArgumentException(String.format(COUNT_EXISTS_AND_DELETE, new Object[]{method}));
            }
        } else {
            this.isCountQuery = false;
            this.isExistsQuery = false;
            this.isDeleteQuery = false;
        }
    }

    @Override
    protected org.springframework.data.mongodb.core.query.Query createQuery(ConvertingParameterAccessor accessor) {
        ParameterBindingContext bindingContext = new ParameterBindingContext(accessor::getBindableValue, this.expressionParser, this.evaluationContextProvider.getEvaluationContext((Parameters)this.getQueryMethod().getParameters(), accessor.getValues()));
        Document queryObject = CODEC.decode(this.query, bindingContext);
        Document fieldsObject = CODEC.decode(this.fieldSpec, bindingContext);
        org.springframework.data.mongodb.core.query.Query query = new BasicQuery(queryObject, fieldsObject).with(accessor.getSort());
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Created query %s for %s fields.", query.getQueryObject(), query.getFieldsObject()));
        }
        return query;
    }

    @Override
    protected boolean isCountQuery() {
        return this.isCountQuery;
    }

    @Override
    protected boolean isExistsQuery() {
        return this.isExistsQuery;
    }

    @Override
    protected boolean isDeleteQuery() {
        return this.isDeleteQuery;
    }

    @Override
    protected boolean isLimiting() {
        return false;
    }

    private static boolean hasAmbiguousProjectionFlags(boolean isCountQuery, boolean isExistsQuery, boolean isDeleteQuery) {
        return BooleanUtil.countBooleanTrueValues(isCountQuery, isExistsQuery, isDeleteQuery) > 1;
    }
}

