/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio;

import io.netty.handler.codec.http.HttpHeaders;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class HandshakeData
implements Serializable {
    private static final long serialVersionUID = 1196350300161819978L;
    private HttpHeaders headers;
    private InetSocketAddress address;
    private Date time = new Date();
    private InetSocketAddress local;
    private String url;
    private Map<String, List<String>> urlParams;
    private boolean xdomain;

    public HandshakeData() {
    }

    public HandshakeData(HttpHeaders headers, Map<String, List<String>> urlParams, InetSocketAddress address, String url, boolean xdomain) {
        this(headers, urlParams, address, null, url, xdomain);
    }

    public HandshakeData(HttpHeaders headers, Map<String, List<String>> urlParams, InetSocketAddress address, InetSocketAddress local, String url, boolean xdomain) {
        this.headers = headers;
        this.urlParams = urlParams;
        this.address = address;
        this.local = local;
        this.url = url;
        this.xdomain = xdomain;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public InetSocketAddress getLocal() {
        return this.local;
    }

    public HttpHeaders getHttpHeaders() {
        return this.headers;
    }

    public Date getTime() {
        return this.time;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isXdomain() {
        return this.xdomain;
    }

    public Map<String, List<String>> getUrlParams() {
        return this.urlParams;
    }

    public String getSingleUrlParam(String name) {
        List<String> values = this.urlParams.get(name);
        if (values != null && values.size() == 1) {
            return values.iterator().next();
        }
        return null;
    }
}

