/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.fastjson.util;

import com.gexin.fastjson.annotation.JSONField;
import com.gexin.fastjson.util.ParameterizedTypeImpl;
import com.gexin.fastjson.util.TypeUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

public class FieldInfo
implements Comparable<FieldInfo> {
    public final String name;
    public final Method method;
    public final Field field;
    private int ordinal = 0;
    public final Class<?> fieldClass;
    public final Type fieldType;
    public final Class<?> declaringClass;
    public final boolean getOnly;
    public final int serialzeFeatures;
    public final int parserFeatures;
    public final String label;
    private final JSONField fieldAnnotation;
    private final JSONField methodAnnotation;
    public final boolean fieldAccess;
    public final boolean fieldTransient;
    public final char[] name_chars;
    public final boolean isEnum;
    public final boolean jsonDirect;
    public final String format;

    public FieldInfo(String name, Class<?> declaringClass, Class<?> fieldClass, Type fieldType, Field field, int ordinal, int serialzeFeatures, int parserFeatures) {
        this.name = name;
        this.declaringClass = declaringClass;
        this.fieldClass = fieldClass;
        this.fieldType = fieldType;
        this.method = null;
        this.field = field;
        this.ordinal = ordinal;
        this.serialzeFeatures = serialzeFeatures;
        this.parserFeatures = 0;
        this.isEnum = fieldClass.isEnum();
        if (field != null) {
            int modifiers = field.getModifiers();
            this.fieldAccess = (modifiers & 1) != 0 || this.method == null;
            this.fieldTransient = Modifier.isTransient(modifiers);
        } else {
            this.fieldTransient = false;
            this.fieldAccess = false;
        }
        this.name_chars = this.genFieldNameChars();
        if (field != null) {
            TypeUtils.setAccessible(field);
        }
        this.label = "";
        this.fieldAnnotation = null;
        this.methodAnnotation = null;
        this.getOnly = false;
        this.jsonDirect = false;
        this.format = null;
    }

    public FieldInfo(String name, Method method, Field field, Class<?> clazz, Type type, int ordinal, int serialzeFeatures, int parserFeatures, JSONField fieldAnnotation, JSONField methodAnnotation, String label) {
        TypeVariable tv;
        Type genericFieldType;
        Type fieldType;
        Class<?> fieldClass;
        String fieldName;
        if (field != null && (fieldName = field.getName()).equals(name)) {
            name = fieldName;
        }
        this.name = name;
        this.method = method;
        this.field = field;
        this.ordinal = ordinal;
        this.serialzeFeatures = serialzeFeatures;
        this.parserFeatures = parserFeatures;
        this.fieldAnnotation = fieldAnnotation;
        this.methodAnnotation = methodAnnotation;
        if (field != null) {
            int modifiers = field.getModifiers();
            this.fieldAccess = (modifiers & 1) != 0 || method == null;
            this.fieldTransient = Modifier.isTransient(modifiers);
        } else {
            this.fieldAccess = false;
            this.fieldTransient = false;
        }
        this.label = label != null && label.length() > 0 ? label : "";
        String format = null;
        JSONField annotation = this.getAnnotation();
        boolean jsonDirect = false;
        if (annotation != null) {
            format = annotation.format();
            if (format.trim().length() == 0) {
                format = null;
            }
            jsonDirect = annotation.jsonDirect();
        } else {
            jsonDirect = false;
        }
        this.format = format;
        this.name_chars = this.genFieldNameChars();
        if (method != null) {
            TypeUtils.setAccessible(method);
        }
        if (field != null) {
            TypeUtils.setAccessible(field);
        }
        boolean getOnly = false;
        if (method != null) {
            Class<?>[] types = method.getParameterTypes();
            if (types.length == 1) {
                fieldClass = types[0];
                fieldType = method.getGenericParameterTypes()[0];
            } else {
                fieldClass = method.getReturnType();
                fieldType = method.getGenericReturnType();
                getOnly = true;
            }
            this.declaringClass = method.getDeclaringClass();
        } else {
            fieldClass = field.getType();
            fieldType = field.getGenericType();
            this.declaringClass = field.getDeclaringClass();
            getOnly = Modifier.isFinal(field.getModifiers());
        }
        this.getOnly = getOnly;
        boolean bl = this.jsonDirect = jsonDirect && fieldClass == String.class;
        if (clazz != null && fieldClass == Object.class && fieldType instanceof TypeVariable && (genericFieldType = FieldInfo.getInheritGenericType(clazz, tv = (TypeVariable)fieldType)) != null) {
            this.fieldClass = TypeUtils.getClass(genericFieldType);
            this.fieldType = genericFieldType;
            this.isEnum = fieldClass.isEnum();
            return;
        }
        Type genericFieldType2 = fieldType;
        if (!(fieldType instanceof Class) && (genericFieldType2 = FieldInfo.getFieldType(clazz, type != null ? type : clazz, fieldType)) != fieldType) {
            if (genericFieldType2 instanceof ParameterizedType) {
                fieldClass = TypeUtils.getClass(genericFieldType2);
            } else if (genericFieldType2 instanceof Class) {
                fieldClass = TypeUtils.getClass(genericFieldType2);
            }
        }
        this.fieldType = genericFieldType2;
        this.fieldClass = fieldClass;
        this.isEnum = fieldClass.isEnum();
    }

    protected char[] genFieldNameChars() {
        int nameLen = this.name.length();
        char[] name_chars = new char[nameLen + 3];
        this.name.getChars(0, this.name.length(), name_chars, 1);
        name_chars[0] = 34;
        name_chars[nameLen + 1] = 34;
        name_chars[nameLen + 2] = 58;
        return name_chars;
    }

    public <T extends Annotation> T getAnnation(Class<T> annotationClass) {
        if (annotationClass == JSONField.class) {
            return (T)this.getAnnotation();
        }
        T annotatition = null;
        if (this.method != null) {
            annotatition = this.method.getAnnotation(annotationClass);
        }
        if (annotatition == null && this.field != null) {
            annotatition = this.field.getAnnotation(annotationClass);
        }
        return annotatition;
    }

    public static Type getFieldType(Class<?> clazz, Type type, Type fieldType) {
        TypeVariable<Class<?>>[] typeVariables;
        if (clazz == null || type == null) {
            return fieldType;
        }
        if (fieldType instanceof GenericArrayType) {
            Type componentTypeX;
            GenericArrayType genericArrayType = (GenericArrayType)fieldType;
            Type componentType = genericArrayType.getGenericComponentType();
            if (componentType != (componentTypeX = FieldInfo.getFieldType(clazz, type, componentType))) {
                Class<?> fieldTypeX = Array.newInstance(TypeUtils.getClass(componentTypeX), 0).getClass();
                return fieldTypeX;
            }
            return fieldType;
        }
        if (!TypeUtils.isGenericParamType(type)) {
            return fieldType;
        }
        if (fieldType instanceof TypeVariable) {
            ParameterizedType paramType = (ParameterizedType)TypeUtils.getGenericParamType(type);
            Class<?> parameterizedClass = TypeUtils.getClass(paramType);
            TypeVariable typeVar = (TypeVariable)fieldType;
            typeVariables = parameterizedClass.getTypeParameters();
            for (int i = 0; i < typeVariables.length; ++i) {
                if (!typeVariables[i].getName().equals(typeVar.getName())) continue;
                fieldType = paramType.getActualTypeArguments()[i];
                return fieldType;
            }
        }
        if (fieldType instanceof ParameterizedType) {
            ParameterizedType parameterizedFieldType = (ParameterizedType)fieldType;
            Type[] arguments = parameterizedFieldType.getActualTypeArguments();
            boolean changed = false;
            typeVariables = null;
            Type[] actualTypes = null;
            ParameterizedType paramType = null;
            if (type instanceof ParameterizedType) {
                paramType = (ParameterizedType)type;
                typeVariables = clazz.getTypeParameters();
            } else if (clazz.getGenericSuperclass() instanceof ParameterizedType) {
                paramType = (ParameterizedType)clazz.getGenericSuperclass();
                typeVariables = clazz.getSuperclass().getTypeParameters();
            }
            for (int i = 0; i < arguments.length && paramType != null; ++i) {
                Type feildTypeArguement = arguments[i];
                if (!(feildTypeArguement instanceof TypeVariable)) continue;
                TypeVariable typeVar = (TypeVariable)feildTypeArguement;
                for (int j = 0; j < typeVariables.length; ++j) {
                    if (!typeVariables[j].getName().equals(typeVar.getName())) continue;
                    if (actualTypes == null) {
                        actualTypes = paramType.getActualTypeArguments();
                    }
                    arguments[i] = actualTypes[j];
                    changed = true;
                }
            }
            if (changed) {
                fieldType = new ParameterizedTypeImpl(arguments, parameterizedFieldType.getOwnerType(), parameterizedFieldType.getRawType());
                return fieldType;
            }
        }
        return fieldType;
    }

    public static Type getInheritGenericType(Class<?> clazz, TypeVariable<?> tv) {
        Type type = null;
        Object gd = tv.getGenericDeclaration();
        do {
            ParameterizedType ptype;
            if ((type = clazz.getGenericSuperclass()) == null) {
                return null;
            }
            if (type instanceof ParameterizedType && (ptype = (ParameterizedType)type).getRawType() == gd) {
                TypeVariable<?>[] tvs = gd.getTypeParameters();
                Type[] types = ptype.getActualTypeArguments();
                for (int i = 0; i < tvs.length; ++i) {
                    if (tvs[i] != tv) continue;
                    return types[i];
                }
                return null;
            }
            clazz = TypeUtils.getClass(type);
        } while (type != null);
        return null;
    }

    public String toString() {
        return this.name;
    }

    public Member getMember() {
        if (this.method != null) {
            return this.method;
        }
        return this.field;
    }

    protected Class<?> getDeclaredClass() {
        if (this.method != null) {
            return this.method.getDeclaringClass();
        }
        if (this.field != null) {
            return this.field.getDeclaringClass();
        }
        return null;
    }

    @Override
    public int compareTo(FieldInfo o) {
        boolean oSameType;
        if (this.ordinal < o.ordinal) {
            return -1;
        }
        if (this.ordinal > o.ordinal) {
            return 1;
        }
        int result = this.name.compareTo(o.name);
        if (result != 0) {
            return result;
        }
        Class<?> thisDeclaringClass = this.getDeclaredClass();
        Class<?> otherDeclaringClass = o.getDeclaredClass();
        if (thisDeclaringClass != null && otherDeclaringClass != null && thisDeclaringClass != otherDeclaringClass) {
            if (thisDeclaringClass.isAssignableFrom(otherDeclaringClass)) {
                return -1;
            }
            if (otherDeclaringClass.isAssignableFrom(thisDeclaringClass)) {
                return 1;
            }
        }
        boolean isSampeType = this.field != null && this.field.getType() == this.fieldClass;
        boolean bl = oSameType = o.field != null && o.field.getType() == o.fieldClass;
        if (isSampeType && !oSameType) {
            return 1;
        }
        if (oSameType && !isSampeType) {
            return -1;
        }
        if (o.fieldClass.isPrimitive() && !this.fieldClass.isPrimitive()) {
            return 1;
        }
        if (this.fieldClass.isPrimitive() && !o.fieldClass.isPrimitive()) {
            return -1;
        }
        if (o.fieldClass.getName().startsWith("java.") && !this.fieldClass.getName().startsWith("java.")) {
            return 1;
        }
        if (this.fieldClass.getName().startsWith("java.") && !o.fieldClass.getName().startsWith("java.")) {
            return -1;
        }
        return this.fieldClass.getName().compareTo(o.fieldClass.getName());
    }

    public JSONField getAnnotation() {
        if (this.fieldAnnotation != null) {
            return this.fieldAnnotation;
        }
        return this.methodAnnotation;
    }

    public String getFormat() {
        return this.format;
    }

    public Object get(Object javaObject) throws IllegalAccessException, InvocationTargetException {
        if (this.method != null) {
            Object value = this.method.invoke(javaObject, new Object[0]);
            return value;
        }
        return this.field.get(javaObject);
    }

    public void set(Object javaObject, Object value) throws IllegalAccessException, InvocationTargetException {
        if (this.method != null) {
            this.method.invoke(javaObject, value);
            return;
        }
        this.field.set(javaObject, value);
    }

    public void setAccessible() throws SecurityException {
        if (this.method != null) {
            TypeUtils.setAccessible(this.method);
            return;
        }
        TypeUtils.setAccessible(this.field);
    }
}

