/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.rp.sdk.base.payload;

import com.gexin.fastjson.JSON;
import com.gexin.rp.sdk.base.payload.MultiMedia;
import com.gexin.rp.sdk.base.payload.Payload;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class APNPayload
implements Payload {
    public static final String APN_SOUND_SILENCE = "com.gexin.ios.silence";
    public static final int PAYLOAD_MAX_BYTES = 2048;
    private AlertMsg alertMsg = null;
    private int badge = -1;
    private String sound = "default";
    private int contentAvailable = 0;
    private String category;
    private String apnsCollapseId;
    private Map<String, Object> customMsg = new HashMap<String, Object>();
    private String autoBadge = null;
    private List<MultiMedia> multiMedias = new ArrayList<MultiMedia>();

    @Override
    public String getPayload() {
        try {
            HashMap<String, Object> apsMap = new HashMap<String, Object>();
            if (this.alertMsg != null) {
                apsMap.put("alert", this.alertMsg.getAlertMsg());
            }
            if (this.autoBadge != null) {
                apsMap.put("autoBadge", this.autoBadge);
            } else if (this.badge >= 0) {
                apsMap.put("badge", this.badge);
            }
            if (!APN_SOUND_SILENCE.equals(this.sound)) {
                apsMap.put("sound", this.sound);
            }
            if (apsMap.isEmpty()) {
                throw new RuntimeException("format error");
            }
            if (this.contentAvailable > 0) {
                apsMap.put("content-available", this.contentAvailable);
            }
            if (this.category != null && this.category.length() > 0) {
                apsMap.put("category", this.category);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String key : this.customMsg.keySet()) {
                map.put(key, this.customMsg.get(key));
            }
            if (this.apnsCollapseId != null) {
                map.put("apns-collapse-id", this.apnsCollapseId);
            }
            map.put("aps", apsMap);
            if (this.multiMedias != null && this.multiMedias.size() > 0) {
                map.put("_grinfo_", this.checkMultiMedias());
            }
            return JSON.toJSONString(map);
        }
        catch (Exception e) {
            throw new RuntimeException("create apn payload error", e);
        }
    }

    public APNPayload setApnsCollapseId(String apnsCollapseId) {
        if (null != apnsCollapseId && apnsCollapseId.length() > 0) {
            this.apnsCollapseId = apnsCollapseId;
        }
        return this;
    }

    private List<MultiMedia> checkMultiMedias() {
        if (this.multiMedias.size() > 3) {
            throw new RuntimeException("MultiMedias size overlimit");
        }
        boolean needGeneRid = false;
        HashSet<String> rids = new HashSet<String>();
        for (MultiMedia media : this.multiMedias) {
            if (media.getResId() == null) {
                needGeneRid = true;
            } else {
                rids.add(media.getResId());
            }
            if (media.getResType() != null && media.getResUrl() != null) continue;
            throw new RuntimeException("MultiMedia resType and resUrl can't be null");
        }
        if (rids.size() != this.multiMedias.size()) {
            needGeneRid = true;
        }
        int index = 0;
        if (needGeneRid) {
            for (MultiMedia multiMedia : this.multiMedias) {
                multiMedia.setResId("grid-" + index++);
            }
        }
        return this.multiMedias;
    }

    public APNPayload addCustomMsg(String key, Object value) {
        if (key != null && key.length() > 0 && value != null) {
            this.customMsg.put(key, value);
        }
        return this;
    }

    public APNPayload setCategory(String category) {
        this.category = category;
        return this;
    }

    @Deprecated
    public APNPayload setBadge(int badge) {
        if (badge >= 0) {
            this.badge = badge;
        }
        return this;
    }

    public APNPayload setSound(String sound) {
        this.sound = sound == null || sound.isEmpty() ? "default" : sound;
        return this;
    }

    public APNPayload setContentAvailable(int contentAvailable) {
        if (contentAvailable > 0) {
            this.contentAvailable = contentAvailable;
        }
        return this;
    }

    public APNPayload setAlertMsg(AlertMsg alertMsg) {
        this.alertMsg = alertMsg;
        return this;
    }

    public String getAutoBadge() {
        return this.autoBadge;
    }

    public APNPayload setAutoBadge(String autoBadge) {
        if (autoBadge == null || !autoBadge.matches("^(-|\\+)?\\d+$")) {
            throw new RuntimeException("autoBadge invalid");
        }
        this.autoBadge = autoBadge;
        return this;
    }

    public APNPayload addMultiMedia(MultiMedia media) {
        this.multiMedias.add(media);
        return this;
    }

    public APNPayload setMultiMedias(List<MultiMedia> medias) {
        this.multiMedias = medias;
        return this;
    }

    public static class DictionaryAlertMsg
    implements AlertMsg {
        private String title;
        private String body;
        private String titleLocKey;
        private List<String> titleLocArgs = new ArrayList<String>();
        private String actionLocKey;
        private String locKey;
        private List<String> locArgs = new ArrayList<String>();
        private String launchImage;
        private String subtitle;
        private String subtitleLocKey;
        private List<String> subtitleLocArgs = new ArrayList<String>();

        public DictionaryAlertMsg setSubtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public DictionaryAlertMsg setSubtitleLocKey(String subtitleLocKey) {
            this.subtitleLocKey = subtitleLocKey;
            return this;
        }

        public DictionaryAlertMsg addSubtitleLocArgs(String subtitleLocArg) {
            if (subtitleLocArg != null && subtitleLocArg.length() > 0) {
                this.subtitleLocArgs.add(subtitleLocArg);
            }
            return this;
        }

        public DictionaryAlertMsg setTitle(String title) {
            this.title = title;
            return this;
        }

        public DictionaryAlertMsg setBody(String body) {
            this.body = body;
            return this;
        }

        public DictionaryAlertMsg setTitleLocKey(String titleLocKey) {
            this.titleLocKey = titleLocKey;
            return this;
        }

        public DictionaryAlertMsg addTitleLocArg(String titleLocArg) {
            if (titleLocArg != null && titleLocArg.length() > 0) {
                this.titleLocArgs.add(titleLocArg);
            }
            return this;
        }

        public DictionaryAlertMsg setActionLocKey(String actionLocKey) {
            this.actionLocKey = actionLocKey;
            return this;
        }

        public DictionaryAlertMsg setLocKey(String locKey) {
            this.locKey = locKey;
            return this;
        }

        public DictionaryAlertMsg addLocArg(String locArg) {
            if (locArg != null && locArg.length() > 0) {
                this.locArgs.add(locArg);
            }
            return this;
        }

        public DictionaryAlertMsg setLaunchImage(String launchImage) {
            this.launchImage = launchImage;
            return this;
        }

        @Override
        public Object getAlertMsg() {
            HashMap<String, Object> alertMap = new HashMap<String, Object>();
            if (this.title != null && this.title.length() > 0) {
                alertMap.put("title", this.title);
            }
            if (this.body != null && this.body.length() > 0) {
                alertMap.put("body", this.body);
            }
            if (this.titleLocKey != null && this.titleLocKey.length() > 0) {
                alertMap.put("title-loc-key", this.titleLocKey);
            }
            if (this.titleLocArgs.size() > 0) {
                alertMap.put("title-loc-args", this.titleLocArgs);
            }
            if (this.actionLocKey != null && this.actionLocKey.length() > 0) {
                alertMap.put("action-loc-key", this.actionLocKey);
            }
            if (this.locKey != null && this.locKey.length() > 0) {
                alertMap.put("loc-key", this.locKey);
            }
            if (this.locArgs.size() > 0) {
                alertMap.put("loc-args", this.locArgs);
            }
            if (this.launchImage != null && this.launchImage.length() > 0) {
                alertMap.put("launch-image", this.launchImage);
            }
            if (this.subtitle != null && this.subtitle.length() > 0) {
                alertMap.put("subtitle", this.subtitle);
            }
            if (this.subtitleLocArgs.size() > 0) {
                alertMap.put("subtitle-loc-args", this.subtitleLocArgs);
            }
            if (this.subtitleLocKey != null && this.subtitleLocKey.length() > 0) {
                alertMap.put("subtitle-loc-key", this.subtitleLocKey);
            }
            return alertMap;
        }
    }

    public static class SimpleAlertMsg
    implements AlertMsg {
        private String alertMsg;

        public SimpleAlertMsg(String alertMsg) {
            this.alertMsg = alertMsg;
        }

        @Override
        public Object getAlertMsg() {
            return this.alertMsg;
        }
    }

    public static interface AlertMsg {
        public Object getAlertMsg();
    }
}

