/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.rp.sdk.base.uitls;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Base64Util {
    private static final Class<?> cls1;
    private static final Constructor<?> cons1;
    private static final Object obj1;
    private static final Method encodeMethod;
    private static final Class<?> cls2;
    private static final Constructor<?> cons2;
    private static final Object obj2;
    private static final Method decodeMethod;
    private static final ThreadLocal<Object> ENCODER_SUPPLIER;
    private static final ThreadLocal<Object> DECODER_SUPPLIER;

    public static String getBASE64(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            Object encoder = obj1;
            if (encodeMethod.getName().equals("encode") && (encoder = ENCODER_SUPPLIER.get()) == null) {
                encoder = cons1.newInstance(new Object[0]);
                ENCODER_SUPPLIER.set(encoder);
            }
            Object res = encodeMethod.invoke(obj1, new Object[]{bytes});
            return String.valueOf(res);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getBASE64FromFile(String fileName) throws IOException {
        if (fileName == null) {
            return null;
        }
        FileInputStream input = null;
        try {
            input = new FileInputStream(fileName);
            byte[] bytes = new byte[((InputStream)input).available()];
            ((InputStream)input).read(bytes);
            String string = Base64Util.getBASE64(bytes);
            return string;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (input != null) {
                ((InputStream)input).close();
            }
        }
    }

    public static byte[] getBytesFromBASE64(String s) {
        if (s == null) {
            return null;
        }
        try {
            Object decoder = obj2;
            if (decodeMethod.getName().equals("decodeBuffer") && (decoder = DECODER_SUPPLIER.get()) == null) {
                decoder = cons2.newInstance(new Object[0]);
                DECODER_SUPPLIER.set(decoder);
            }
            return (byte[])decodeMethod.invoke(decoder, s);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        ExecutorService pool = Executors.newFixedThreadPool(4);
        while (true) {
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    String content = "just for test!";
                    String retStr = new String(Base64Util.getBytesFromBASE64(Base64Util.getBASE64(content.getBytes())));
                    if (!content.equals(retStr)) {
                        System.out.println("?????:" + retStr);
                    } else {
                        System.out.print("-");
                    }
                }
            });
        }
    }

    static {
        ENCODER_SUPPLIER = new ThreadLocal();
        DECODER_SUPPLIER = new ThreadLocal();
        String javaVersion = System.getProperty("java.version");
        if (!javaVersion.startsWith("1.")) {
            try {
                cls1 = Class.forName("java.util.Base64$Encoder");
                cons1 = cls1.getDeclaredConstructor(Boolean.TYPE, byte[].class, Integer.TYPE, Boolean.TYPE);
                cons1.setAccessible(true);
                obj1 = cons1.newInstance(false, null, -1, true);
                encodeMethod = cls1.getMethod("encodeToString", byte[].class);
                cls2 = Class.forName("java.util.Base64$Decoder");
                cons2 = cls2.getDeclaredConstructor(Boolean.TYPE, Boolean.TYPE);
                cons2.setAccessible(true);
                obj2 = cons2.newInstance(false, false);
                decodeMethod = cls2.getMethod("decode", String.class);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        try {
            cls1 = Class.forName("sun.misc.BASE64Encoder");
            cons1 = cls1.getConstructor(new Class[0]);
            obj1 = cons1.newInstance(new Object[0]);
            encodeMethod = cls1.getMethod("encode", byte[].class);
            cls2 = Class.forName("sun.misc.BASE64Decoder");
            cons2 = cls2.getConstructor(new Class[0]);
            obj2 = cons2.newInstance(new Object[0]);
            decodeMethod = cls2.getMethod("decodeBuffer", String.class);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

