/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.rp.sdk.base.payload;

import com.gexin.rp.sdk.base.payload.Payload;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;

public class APNPayload
implements Payload {
    public static final String APN_SOUND_SILENCE = "com.gexin.ios.silence";
    public static final int PAYLOAD_MAX_BYTES = 2048;
    private static final ObjectMapper JSON = new ObjectMapper();
    private AlertMsg alertMsg = null;
    private int badge = -1;
    private String sound = "default";
    private int contentAvailable = 0;
    private String category;
    private Map<String, Object> customMsg = new HashMap<String, Object>();

    @Override
    public String getPayload() {
        try {
            HashMap<String, Object> apsMap = new HashMap<String, Object>();
            if (this.alertMsg != null) {
                apsMap.put("alert", this.alertMsg.getAlertMsg());
            }
            if (this.badge >= 0) {
                apsMap.put("badge", this.badge);
            }
            if (!APN_SOUND_SILENCE.equals(this.sound)) {
                apsMap.put("sound", this.sound);
            }
            if (apsMap.isEmpty()) {
                throw new RuntimeException("format error");
            }
            if (this.contentAvailable > 0) {
                apsMap.put("content-available", this.contentAvailable);
            }
            if (this.category != null && this.category.length() > 0) {
                apsMap.put("category", this.category);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String key : this.customMsg.keySet()) {
                map.put(key, this.customMsg.get(key));
            }
            map.put("aps", apsMap);
            return JSON.writeValueAsString(map);
        }
        catch (Exception e) {
            throw new RuntimeException("create apn payload error", e);
        }
    }

    public void addCustomMsg(String key, Object value) {
        if (key != null && key.length() > 0 && value != null) {
            this.customMsg.put(key, value);
        }
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setBadge(int badge) {
        if (badge >= 0) {
            this.badge = badge;
        }
    }

    public void setSound(String sound) {
        this.sound = sound == null || sound.isEmpty() ? "default" : sound;
    }

    public void setContentAvailable(int contentAvailable) {
        if (contentAvailable > 0) {
            this.contentAvailable = contentAvailable;
        }
    }

    public void setAlertMsg(AlertMsg alertMsg) {
        this.alertMsg = alertMsg;
    }

    public static interface AlertMsg {
        public Object getAlertMsg();
    }

    public static class DictionaryAlertMsg
    implements AlertMsg {
        private String title;
        private String body;
        private String titleLocKey;
        private List<String> titleLocArgs = new ArrayList<String>();
        private String actionLocKey;
        private String locKey;
        private List<String> locArgs = new ArrayList<String>();
        private String launchImage;

        public void setTitle(String title) {
            this.title = title;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public void setTitleLocKey(String titleLocKey) {
            this.titleLocKey = titleLocKey;
        }

        public void addTitleLocArg(String titleLocArg) {
            if (titleLocArg != null && titleLocArg.length() > 0) {
                this.titleLocArgs.add(titleLocArg);
            }
        }

        public void setActionLocKey(String actionLocKey) {
            this.actionLocKey = actionLocKey;
        }

        public void setLocKey(String locKey) {
            this.locKey = locKey;
        }

        public void addLocArg(String locArg) {
            if (locArg != null && locArg.length() > 0) {
                this.locArgs.add(locArg);
            }
        }

        public void setLaunchImage(String launchImage) {
            this.launchImage = launchImage;
        }

        @Override
        public Object getAlertMsg() {
            HashMap<String, Object> alertMap = new HashMap<String, Object>();
            if (this.title != null && this.title.length() > 0) {
                alertMap.put("title", this.title);
            }
            if (this.body != null && this.body.length() > 0) {
                alertMap.put("body", this.body);
            }
            if (this.titleLocKey != null && this.titleLocKey.length() > 0) {
                alertMap.put("title-loc-key", this.titleLocKey);
            }
            if (this.titleLocArgs.size() > 0) {
                alertMap.put("title-loc-args", this.titleLocArgs);
            }
            if (this.actionLocKey != null && this.actionLocKey.length() > 0) {
                alertMap.put("action-loc-key", this.actionLocKey);
            }
            if (this.locKey != null && this.locKey.length() > 0) {
                alertMap.put("loc-key", this.locKey);
            }
            if (this.locArgs.size() > 0) {
                alertMap.put("loc-args", this.locArgs);
            }
            if (this.launchImage != null && this.launchImage.length() > 0) {
                alertMap.put("launch-image", this.launchImage);
            }
            return alertMap;
        }
    }

    public static class SimpleAlertMsg
    implements AlertMsg {
        private String alertMsg;

        public SimpleAlertMsg(String alertMsg) {
            this.alertMsg = alertMsg;
        }

        @Override
        public Object getAlertMsg() {
            return this.alertMsg;
        }
    }
}

