/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.rp.sdk.base.uitls;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LangUtil {
    private static final String REGEX = "^(?:(?!0000)[0-9]{4}(?:(?:0[1-9]|1[0-2])(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])(?:29|30)|(?:0[13578]|1[02])31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)0229)$";
    private static final SimpleDateFormat DATEFORMAT = new SimpleDateFormat("yyyyMMdd");

    public static boolean validateDate(String date) {
        if (date == null) {
            return false;
        }
        if (!date.matches(REGEX)) {
            return false;
        }
        try {
            Date d = DATEFORMAT.parse(date);
            return d.getTime() < System.currentTimeMillis();
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static long convertToBig(String data, String fromBase, String toBase) {
        int newLen;
        if (fromBase == null) {
            fromBase = "0123456789ABCDEF";
        }
        if (toBase == null) {
            toBase = "0123456789";
        }
        data = data.toUpperCase();
        int fromCount = fromBase.length();
        int toCount = toBase.length();
        String result = "";
        int length = data.length();
        int[] numArr = new int[length];
        int i = 0;
        while (i < length) {
            numArr[i] = fromBase.indexOf(data.charAt(i));
            ++i;
        }
        do {
            int divide = 0;
            newLen = 0;
            int i2 = 0;
            while (i2 < length) {
                if ((divide = divide * fromCount + numArr[i2]) >= toCount) {
                    numArr[newLen++] = divide / toCount;
                    divide %= toCount;
                } else if (newLen > 0) {
                    numArr[newLen++] = 0;
                }
                ++i2;
            }
            length = newLen;
            result = String.valueOf(toBase.charAt(divide)) + result;
        } while (newLen != 0);
        return Long.parseLong(result);
    }

    public static Integer parseInt(Object value) {
        if (value != null) {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof String) {
                try {
                    return Integer.valueOf((String)value);
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return null;
    }

    public static String getASCIIString(String str) {
        if (str != null) {
            try {
                return URLEncoder.encode(str, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getUTF8String(String str) {
        if (str != null) {
            try {
                return URLDecoder.decode(str, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Long parseLong(Object value) {
        if (value != null) {
            if (value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof Integer) {
                return ((Integer)value).longValue();
            }
            if (value instanceof String) {
                try {
                    return Long.valueOf((String)value);
                }
                catch (Exception ex) {
                    return null;
                }
            }
        }
        return null;
    }

    public static String parseString(Object value) {
        if (value != null) {
            return String.valueOf(value);
        }
        return null;
    }

    public static Boolean parseBoolean(Object value) {
        if (value != null) {
            if (value instanceof Integer) {
                if ((Integer)value == 1) {
                    return true;
                }
                return false;
            }
            if (value instanceof String) {
                if (!"1".equals(value) && !"true".equals(value)) {
                    return false;
                }
                return true;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> List<T> parseList(Object list, Class<T> requiredType) {
        try {
            Object obj;
            if (!(list instanceof List)) {
                return null;
            }
            Iterator iterator = ((List)list).iterator();
            do {
                if (iterator.hasNext()) continue;
                return (List)list;
            } while (requiredType.isInstance(obj = iterator.next()));
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T, E> Map<T, E> parseMap(Object map, Class<T> keyType, Class<E> valueType) {
        try {
            Object value;
            if (!(map instanceof Map)) {
                return null;
            }
            Iterator iterator = ((Map)map).entrySet().iterator();
            do {
                if (!iterator.hasNext()) {
                    return (Map)map;
                }
                Map.Entry entry = iterator.next();
                Object key = entry.getKey();
                value = entry.getValue();
                if (keyType.isInstance(key)) continue;
                return null;
            } while (valueType.isInstance(value));
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static void main(String[] arg) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(2);
        System.out.println(LangUtil.parseList(list, Integer.class));
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add("a");
        list2.add("2");
        List<Integer> list3 = LangUtil.parseList(list2, Integer.class);
        System.out.println(list3);
        System.out.println(LangUtil.parseList("2", Integer.class));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("111", 11);
        map.put("112", "aa");
        System.out.println(LangUtil.parseMap(map, String.class, Object.class));
        System.out.println(LangUtil.parseMap("2", String.class, Object.class));
        System.out.println(LangUtil.parseMap(map, Integer.class, Object.class));
        System.out.println(LangUtil.parseMap(map, String.class, Integer.class));
        HashMap<String, ArrayList<Integer>> map1 = new HashMap<String, ArrayList<Integer>>();
        map1.put("aaa", list);
        System.out.println(LangUtil.parseMap(map1, String.class, List.class));
        ArrayList<HashMap<String, Object>> list4 = new ArrayList<HashMap<String, Object>>();
        list4.add(map);
        System.out.println(LangUtil.parseList(list4, Map.class));
    }
}

