/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.rp.sdk.base.uitls;

import com.gexin.rp.sdk.base.uitls.StackTraceUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Util {
    private static ThreadLocal<MessageDigest> messageDigestHolder = new ThreadLocal();
    static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    static {
        try {
            MessageDigest message = MessageDigest.getInstance("MD5");
            messageDigestHolder.set(message);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("\u521d\u59cb\u5316java.security.MessageDigest\u5931\u8d25:" + StackTraceUtil.getStackTrace(e), e);
        }
    }

    public static String getMD5Format(String data) {
        try {
            MessageDigest message = messageDigestHolder.get();
            if (message == null) {
                message = MessageDigest.getInstance("MD5");
                messageDigestHolder.set(message);
            }
            message.update(data.getBytes());
            byte[] b = message.digest();
            String digestHexStr = "";
            int i = 0;
            while (i < 16) {
                digestHexStr = String.valueOf(digestHexStr) + MD5Util.byteHEX(b[i]);
                ++i;
            }
            return digestHexStr;
        }
        catch (Exception e) {
            throw new RuntimeException("MD5\u683c\u5f0f\u5316\u65f6\u53d1\u751f\u5f02\u5e38[{}]: {}" + StackTraceUtil.getStackTrace(e), e);
        }
    }

    public static String getMD5Format(byte[] data) {
        try {
            MessageDigest message = messageDigestHolder.get();
            if (message == null) {
                message = MessageDigest.getInstance("MD5");
                messageDigestHolder.set(message);
            }
            message.update(data);
            byte[] b = message.digest();
            String digestHexStr = "";
            int i = 0;
            while (i < 16) {
                digestHexStr = String.valueOf(digestHexStr) + MD5Util.byteHEX(b[i]);
                ++i;
            }
            return digestHexStr;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String byteHEX(byte ib) {
        char[] ob = new char[]{hexDigits[ib >>> 4 & 0xF], hexDigits[ib & 0xF]};
        String s = new String(ob);
        return s;
    }
}

