/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.rp.sdk.base.uitls;

import com.gexin.rp.sdk.dto.GtReq;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public class TransparentJSONHelper {
    private static ObjectMapper mapper = new ObjectMapper();
    private static final Map<String, Object> EMPTY_MAP = new HashMap<String, Object>();
    private static final List<String> EMPTY_LIST = new ArrayList<String>();

    public static String toJSON(GtReq.Transparent transparent) throws JsonGenerationException, JsonMappingException, IOException {
        HashMap<String, Object> TransJson = new HashMap<String, Object>();
        TransJson.put("action", transparent.getAction());
        TransJson.put("id", transparent.getId());
        TransJson.put("appkey", transparent.getAppKey());
        TransJson.put("appid", transparent.getAppId());
        TransJson.put("messageid", transparent.getMessageId());
        TransJson.put("taskid", transparent.getTaskId());
        TransJson.put("action_chains", TransparentJSONHelper.toActionChainJSON(transparent.getActionChainList()));
        TransJson.put("push_info", TransparentJSONHelper.toPushInfoJSON(transparent.getPushInfo()));
        TransJson.put("condition", TransparentJSONHelper.getConditionJson(transparent.getConditionList()));
        return mapper.writeValueAsString(TransJson);
    }

    public static Object toPushInfoJSON(GtReq.PushInfo pushInfo) {
        HashMap<String, String> pushInfoJson = new HashMap<String, String>();
        pushInfoJson.put("message", pushInfo.getMessage());
        pushInfoJson.put("badge", pushInfo.getBadge());
        pushInfoJson.put("sound", pushInfo.getSound());
        pushInfoJson.put("action_key", pushInfo.getActionKey());
        pushInfoJson.put("payload", pushInfo.getPayload());
        pushInfoJson.put("loc-key", pushInfo.getLocKey());
        pushInfoJson.put("loc-args", pushInfo.getLocArgs());
        pushInfoJson.put("action-loc-key", pushInfo.getActionLocKey());
        pushInfoJson.put("launch-image", pushInfo.getLaunchImage());
        pushInfoJson.put("content-available", String.valueOf(pushInfo.getContentAvailable()));
        return pushInfoJson;
    }

    public static Object toActionChainJSON(List<GtReq.ActionChain> list) {
        ArrayList jsonArr = new ArrayList();
        for (GtReq.ActionChain chain : list) {
            HashMap<String, Object> actionChainJson = new HashMap<String, Object>();
            actionChainJson.put("actionid", String.valueOf(chain.getActionId()));
            if (chain.getType() != GtReq.ActionChain.Type.eoa) {
                actionChainJson.put("do", String.valueOf(chain.getNext()));
            }
            if (chain.getStype().length() > 0) {
                if (chain.getFieldCount() == 0) {
                    throw new RuntimeException("the extend field must to be set when use stype.");
                }
                actionChainJson.put("type", chain.getStype());
                for (GtReq.InnerFiled field : chain.getFieldList()) {
                    switch (field.getType()) {
                        case int32: {
                            actionChainJson.put(field.getKey(), Integer.parseInt(field.getVal()));
                            break;
                        }
                        case int64: {
                            actionChainJson.put(field.getKey(), Long.parseLong(field.getVal()));
                            break;
                        }
                        case floa: {
                            actionChainJson.put(field.getKey(), Float.valueOf(Float.parseFloat(field.getVal())));
                            break;
                        }
                        case doub: {
                            actionChainJson.put(field.getKey(), Double.parseDouble(field.getVal()));
                            break;
                        }
                        case bool: {
                            actionChainJson.put(field.getKey(), Boolean.parseBoolean(field.getVal()));
                            break;
                        }
                        default: {
                            actionChainJson.put(field.getKey(), field.getVal());
                        }
                    }
                }
            } else {
                GtReq.ActionChain.Type type = chain.getType();
                String typeStr = type == GtReq.ActionChain.Type.Goto ? "goto" : (type == GtReq.ActionChain.Type.eoa ? "null" : type.name());
                actionChainJson.put("type", typeStr);
                if (chain.hasTitle()) {
                    actionChainJson.put("title", chain.getTitle());
                }
                if (chain.hasText()) {
                    actionChainJson.put("text", chain.getText());
                }
                if (chain.hasLogo()) {
                    actionChainJson.put("logo", chain.getLogo());
                }
                if (chain.hasLogoURL()) {
                    actionChainJson.put("logo_url", chain.getLogoURL());
                }
                if (chain.hasClearable()) {
                    actionChainJson.put("is_noclear", String.valueOf(!chain.getClearable()));
                }
                if (chain.hasRing()) {
                    actionChainJson.put("is_noring", String.valueOf(!chain.getRing()));
                }
                if (chain.hasBuzz()) {
                    actionChainJson.put("is_novibrate", String.valueOf(!chain.getBuzz()));
                }
                if (chain.hasBannerURL()) {
                    actionChainJson.put("banner_url", chain.getBannerURL());
                }
                if (chain.hasImg()) {
                    actionChainJson.put("img", chain.getImg());
                }
                if (chain.getButtonsList() != null && !chain.getButtonsList().isEmpty()) {
                    actionChainJson.put("buttons", TransparentJSONHelper.toButtonJson(chain.getButtonsList()));
                }
                if (chain.hasAppid()) {
                    actionChainJson.put("appid", chain.getAppid());
                }
                if (chain.hasAppstartupid()) {
                    actionChainJson.put("appstartupid", TransparentJSONHelper.toAppStartUpJson(chain.getAppstartupid()));
                }
                if (chain.hasAutostart()) {
                    actionChainJson.put("is_autostart", String.valueOf(chain.getAutostart()));
                }
                if (chain.hasFailedAction()) {
                    actionChainJson.put("noinstall_action", String.valueOf(chain.getFailedAction()));
                }
                if (chain.hasUrl()) {
                    actionChainJson.put("url", chain.getUrl());
                }
                if (chain.hasWithcid()) {
                    actionChainJson.put("is_withcid", chain.getWithcid());
                }
                if (chain.hasAddress()) {
                    actionChainJson.put("address", chain.getAddress());
                }
                if (chain.hasContent()) {
                    actionChainJson.put("content", chain.getContent());
                }
                if (chain.hasCt()) {
                    actionChainJson.put("ct", String.valueOf(chain.getCt()));
                }
                if (chain.hasFlag()) {
                    actionChainJson.put("flag", chain.getFlag().name());
                }
                if (chain.hasSuccessedAction()) {
                    actionChainJson.put("do_installed", String.valueOf(chain.getSuccessedAction()));
                }
                if (chain.hasUninstalledAction()) {
                    actionChainJson.put("do_uninstalled", String.valueOf(chain.getUninstalledAction()));
                }
                if (chain.hasName()) {
                    actionChainJson.put("name", chain.getName());
                }
                if (chain.hasAutoInstall()) {
                    actionChainJson.put("is_autoinstall", String.valueOf(chain.getAutoInstall()));
                }
                if (chain.hasWifiAutodownload()) {
                    actionChainJson.put("is_wifi_autodownload", String.valueOf(chain.getWifiAutodownload()));
                }
                if (chain.hasForceDownload()) {
                    actionChainJson.put("is_no_forcedownload", String.valueOf(!chain.getForceDownload()));
                }
                if (chain.hasShowProgress()) {
                    actionChainJson.put("is_showprogress", String.valueOf(chain.getShowProgress()));
                }
                if (chain.hasPost()) {
                    actionChainJson.put("post", chain.getPost());
                }
                if (chain.hasHeaders()) {
                    actionChainJson.put("headers", chain.getHeaders());
                }
                if (chain.hasGroupable()) {
                    actionChainJson.put("is_grouped", String.valueOf(chain.getGroupable()));
                }
                if (chain.hasMmsTitle()) {
                    actionChainJson.put("mms_title", chain.getMmsTitle());
                }
                if (chain.hasMmsURL()) {
                    actionChainJson.put("mms_uri", chain.getMmsURL());
                }
                if (chain.hasPreload()) {
                    actionChainJson.put("is_preload", String.valueOf(chain.getPreload()));
                }
                if (chain.hasTaskid()) {
                    actionChainJson.put("taskid", chain.getTaskid());
                }
                if (chain.hasDuration()) {
                    actionChainJson.put("duration", String.valueOf(chain.getDuration()));
                }
                if (chain.hasDate()) {
                    actionChainJson.put("date", chain.getDate());
                }
                if (chain.hasIsWithnettype()) {
                    actionChainJson.put("is_withnettype", String.valueOf(chain.getIsWithnettype()));
                }
            }
            jsonArr.add(actionChainJson);
        }
        return jsonArr;
    }

    private static Object toAppStartUpJson(GtReq.AppStartUp extension) {
        HashMap<String, String> json = new HashMap<String, String>();
        if (extension.getAndroid() != null) {
            json.put("android", extension.getAndroid());
        }
        if (extension.getAndroid() != null) {
            json.put("symbia", extension.getSymbia());
        }
        if (extension.getIos() != null) {
            json.put("ios", extension.getIos());
        }
        return json;
    }

    private static Object toButtonJson(List<GtReq.Button> extension) {
        ArrayList jsonArr = new ArrayList();
        for (GtReq.Button button : extension) {
            HashMap<String, String> buttonJson = new HashMap<String, String>();
            buttonJson.put("text", button.getText());
            buttonJson.put("do", String.valueOf(button.getNext()));
            jsonArr.add(buttonJson);
        }
        return jsonArr;
    }

    public static Object getConditionJson(List<String> conditions) {
        if (conditions == null || conditions.isEmpty()) {
            return EMPTY_MAP;
        }
        HashMap<String, String> json = new HashMap<String, String>();
        for (String key : conditions) {
            int index;
            if (key == null || key.length() <= 0 || (index = key.indexOf(61)) == -1) continue;
            json.put(key.substring(0, index), key.substring(index + 1));
        }
        return json;
    }

    public static GtReq.Transparent fromJSON(String json) throws JsonParseException, JsonMappingException, IOException {
        Map mo = (Map)mapper.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
        return GtReq.Transparent.newBuilder().setAction((String)mo.get("action")).setId((String)mo.get("id")).setAppKey((String)mo.get("appkey")).setAppId((String)mo.get("appid")).setMessageId((String)mo.get("messageid")).setTaskId((String)mo.get("taskid")).addAllActionChain(TransparentJSONHelper.getActionChain((List)mo.get("action_chains"))).setPushInfo(TransparentJSONHelper.getPushInfo((Map)mo.get("push_info"))).addAllCondition(TransparentJSONHelper.getCondition((Map)mo.get("condition"))).build();
    }

    public static GtReq.PushInfo getPushInfo(Map<String, String> pushInfoJson) {
        GtReq.PushInfo.Builder builder = GtReq.PushInfo.newBuilder();
        if (pushInfoJson.containsKey("message")) {
            builder.setMessage(pushInfoJson.get("message"));
        }
        if (pushInfoJson.containsKey("badge")) {
            builder.setBadge(pushInfoJson.get("badge"));
        }
        if (pushInfoJson.containsKey("sound")) {
            builder.setSound(pushInfoJson.get("sound"));
        }
        if (pushInfoJson.containsKey("payload")) {
            builder.setPayload(pushInfoJson.get("payload"));
        }
        if (pushInfoJson.containsKey("loc-key")) {
            builder.setLocKey(pushInfoJson.get("loc-key"));
        }
        if (pushInfoJson.containsKey("loc-args")) {
            builder.setLocArgs(pushInfoJson.get("loc-args"));
        }
        if (pushInfoJson.containsKey("action-loc-key")) {
            builder.setActionLocKey(pushInfoJson.get("action-loc-key"));
        }
        if (pushInfoJson.containsKey("launch-image")) {
            builder.setLaunchImage(pushInfoJson.get("launch-image"));
        }
        if (pushInfoJson.containsKey("content-available")) {
            try {
                builder.setContentAvailable(Integer.parseInt(pushInfoJson.get("content-available")));
            }
            catch (NumberFormatException e) {
                builder.setContentAvailable(-1);
            }
        }
        return builder.build();
    }

    public static List<GtReq.ActionChain> getActionChain(List<Map<String, Object>> actionChainJsonArr) {
        ArrayList<GtReq.ActionChain> actionChains = new ArrayList<GtReq.ActionChain>();
        for (Map<String, Object> actionChainJson : actionChainJsonArr) {
            String stype;
            GtReq.ActionChain.Builder builder = GtReq.ActionChain.newBuilder();
            builder.setActionId(Integer.parseInt((String)actionChainJson.get("actionid")));
            String next = (String)actionChainJson.get("do");
            if (next != null && next.length() > 0) {
                builder.setNext(Integer.parseInt(next));
            }
            if ((stype = (String)actionChainJson.get("stype")) != null && stype.length() > 0) {
                builder.setType(GtReq.ActionChain.Type.mmsinbox2);
                builder.setStype(stype);
                for (String key : actionChainJson.keySet()) {
                    if ("actionid".equals(key) || "do".equals(key) || "type".equals(key) || "stype".equals(key)) continue;
                    GtReq.InnerFiled.Type valType = GtReq.InnerFiled.Type.str;
                    Object val = actionChainJson.get(key);
                    if (val instanceof String) {
                        valType = GtReq.InnerFiled.Type.str;
                    } else if (val instanceof Integer) {
                        valType = GtReq.InnerFiled.Type.int32;
                    } else if (val instanceof Long) {
                        valType = GtReq.InnerFiled.Type.int64;
                    } else if (val instanceof Float) {
                        valType = GtReq.InnerFiled.Type.floa;
                    } else if (val instanceof Double) {
                        valType = GtReq.InnerFiled.Type.doub;
                    } else if (val instanceof Boolean) {
                        valType = GtReq.InnerFiled.Type.bool;
                    }
                    builder.addField(GtReq.InnerFiled.newBuilder().setKey(key).setVal(String.valueOf(val)).setType(valType).build());
                }
                if (builder.getFieldCount() == 0) {
                    throw new RuntimeException("the extend field must to be set when use stype.");
                }
            } else {
                String type = (String)actionChainJson.get("type");
                type = type.equals("goto") ? "Goto" : (type.equals("null") ? "eoa" : type);
                builder.setType(GtReq.ActionChain.Type.valueOf(type));
                if (actionChainJson.containsKey("title")) {
                    builder.setTitle((String)actionChainJson.get("title"));
                }
                if (actionChainJson.containsKey("text")) {
                    builder.setText((String)actionChainJson.get("text"));
                }
                if (actionChainJson.containsKey("logo")) {
                    builder.setLogo((String)actionChainJson.get("logo"));
                }
                if (actionChainJson.containsKey("logo_url")) {
                    builder.setLogoURL((String)actionChainJson.get("logo_url"));
                }
                if (actionChainJson.containsKey("is_noclear")) {
                    builder.setClearable(!Boolean.parseBoolean((String)actionChainJson.get("is_noclear")));
                }
                if (actionChainJson.containsKey("is_noring")) {
                    builder.setRing(!Boolean.parseBoolean((String)actionChainJson.get("is_noring")));
                }
                if (actionChainJson.containsKey("is_novibrate")) {
                    builder.setBuzz(!Boolean.parseBoolean((String)actionChainJson.get("is_novibrate")));
                }
                if (actionChainJson.containsKey("banner_url")) {
                    builder.setBannerURL((String)actionChainJson.get("banner_url"));
                }
                if (actionChainJson.containsKey("img")) {
                    builder.setImg((String)actionChainJson.get("img"));
                }
                if (actionChainJson.containsKey("buttons")) {
                    builder.addAllButtons(TransparentJSONHelper.fromButtonJson((List)actionChainJson.get("buttons")));
                }
                if (actionChainJson.containsKey("appid")) {
                    builder.setAppid((String)actionChainJson.get("appid"));
                }
                if (actionChainJson.containsKey("appstartupid")) {
                    builder.setAppstartupid(TransparentJSONHelper.fromAppStartUpJson((Map)actionChainJson.get("appstartupid")));
                }
                if (actionChainJson.containsKey("is_autostart")) {
                    builder.setAutostart(Boolean.parseBoolean((String)actionChainJson.get("is_autostart")));
                }
                if (actionChainJson.containsKey("noinstall_action")) {
                    builder.setFailedAction(Integer.parseInt((String)actionChainJson.get("noinstall_action")));
                }
                if (actionChainJson.containsKey("url")) {
                    builder.setUrl((String)actionChainJson.get("url"));
                }
                if (actionChainJson.containsKey("is_withcid")) {
                    builder.setWithcid((String)actionChainJson.get("is_withcid"));
                }
                if (actionChainJson.containsKey("address")) {
                    builder.setAddress((String)actionChainJson.get("address"));
                }
                if (actionChainJson.containsKey("content")) {
                    builder.setContent((String)actionChainJson.get("content"));
                }
                if (actionChainJson.containsKey("ct")) {
                    builder.setCt(Long.parseLong((String)actionChainJson.get("ct")));
                }
                if (actionChainJson.containsKey("flag")) {
                    builder.setFlag(GtReq.SMSStatus.valueOf((String)actionChainJson.get("flag")));
                }
                if (actionChainJson.containsKey("do_installed")) {
                    builder.setSuccessedAction(Integer.parseInt((String)actionChainJson.get("do_installed")));
                }
                if (actionChainJson.containsKey("do_uninstalled")) {
                    builder.setUninstalledAction(Integer.parseInt((String)actionChainJson.get("do_uninstalled")));
                }
                if (actionChainJson.containsKey("name")) {
                    builder.setName((String)actionChainJson.get("name"));
                }
                if (actionChainJson.containsKey("is_autoinstall")) {
                    builder.setAutoInstall(Boolean.parseBoolean((String)actionChainJson.get("is_autoinstall")));
                }
                if (actionChainJson.containsKey("is_wifi_autodownload")) {
                    builder.setWifiAutodownload(Boolean.parseBoolean((String)actionChainJson.get("is_wifi_autodownload")));
                }
                if (actionChainJson.containsKey("is_no_forcedownload")) {
                    builder.setForceDownload(!Boolean.parseBoolean((String)actionChainJson.get("is_no_forcedownload")));
                }
                if (actionChainJson.containsKey("is_showprogress")) {
                    builder.setShowProgress(Boolean.parseBoolean((String)actionChainJson.get("is_showprogress")));
                }
                if (actionChainJson.containsKey("post")) {
                    builder.setPost((String)actionChainJson.get("post"));
                }
                if (actionChainJson.containsKey("headers")) {
                    builder.setHeaders((String)actionChainJson.get("headers"));
                }
                if (actionChainJson.containsKey("is_grouped")) {
                    builder.setGroupable(Boolean.parseBoolean((String)actionChainJson.get("is_grouped")));
                }
                if (actionChainJson.containsKey("mms_title")) {
                    builder.setMmsTitle((String)actionChainJson.get("mms_title"));
                }
                if (actionChainJson.containsKey("mms_uri")) {
                    builder.setMmsURL((String)actionChainJson.get("mms_uri"));
                }
                if (actionChainJson.containsKey("is_preload")) {
                    builder.setPreload(Boolean.parseBoolean((String)actionChainJson.get("is_preload")));
                }
                if (actionChainJson.containsKey("taskid")) {
                    builder.setTaskid((String)actionChainJson.get("taskid"));
                }
                if (actionChainJson.containsKey("duration")) {
                    builder.setDuration(Long.parseLong((String)actionChainJson.get("duration")));
                }
                if (actionChainJson.containsKey("date")) {
                    builder.setDate((String)actionChainJson.get("date"));
                }
                if (actionChainJson.containsKey("is_withnettype")) {
                    builder.setIsWithnettype(Boolean.parseBoolean((String)actionChainJson.get("is_withnettype")));
                }
            }
            actionChains.add(builder.build());
        }
        return actionChains;
    }

    private static GtReq.AppStartUp fromAppStartUpJson(Map<String, Object> json) {
        GtReq.AppStartUp.Builder builder = GtReq.AppStartUp.newBuilder();
        if (json.containsKey("android")) {
            builder.setAndroid((String)json.get("android"));
        }
        if (json.containsKey("symbia")) {
            builder.setSymbia((String)json.get("symbia"));
        }
        if (json.containsKey("ios")) {
            builder.setIos((String)json.get("ios"));
        }
        return builder.build();
    }

    private static List<GtReq.Button> fromButtonJson(List<Map<String, Object>> jsonArr) {
        ArrayList<GtReq.Button> buttons = new ArrayList<GtReq.Button>();
        for (Map<String, Object> json : jsonArr) {
            try {
                GtReq.Button.Builder builder = GtReq.Button.newBuilder();
                if (json.containsKey("text")) {
                    builder.setText((String)json.get("text"));
                }
                if (json.containsKey("do")) {
                    builder.setNext(Integer.parseInt((String)json.get("do")));
                }
                buttons.add(builder.build());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return buttons;
    }

    private static List<String> getCondition(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return EMPTY_LIST;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String key : map.keySet()) {
            list.add(String.valueOf(key) + "=" + map.get(key));
        }
        return list;
    }

    public static GtReq.Transparent parse(byte[] byteArray) throws InvalidProtocolBufferException {
        return GtReq.Transparent.parseFrom(byteArray);
    }
}

