/*
 * Decompiled with CFR 0.152.
 */
package com.github.trang.druid.autoconfigure;

import com.alibaba.druid.pool.DruidDataSource;
import com.github.trang.druid.autoconfigure.DruidDataSourceCustomizer;
import com.github.trang.druid.autoconfigure.datasource.DruidDataSource2;
import com.github.trang.druid.autoconfigure.util.CharMatcher;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.bind.PropertySourcesBinder;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotationMetadata;

@Import(value={DruidDataSourceImportSelector.class})
public class DruidDataSourceConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DruidDataSourceConfiguration.class);
    static final String BEAN_NAME = "dataSource";
    static final String BEAN_SUFFIX = "DataSource";
    static final String EMPTY = "";
    static final String POINT = ".";
    static final String PREFIX = "spring.datasource.druid.data-sources.";

    static BeanDefinition genericDruidBeanDefinition() {
        return BeanDefinitionBuilder.genericBeanDefinition(DruidDataSource2.class).setInitMethodName("init").setDestroyMethodName("close").getBeanDefinition();
    }

    static class DruidDataSourceImportSelector
    implements ImportSelector,
    EnvironmentAware {
        private RelaxedPropertyResolver resolver;

        DruidDataSourceImportSelector() {
        }

        public void setEnvironment(Environment environment) {
            this.resolver = new RelaxedPropertyResolver((PropertyResolver)environment, DruidDataSourceConfiguration.PREFIX);
        }

        public String[] selectImports(AnnotationMetadata metadata) {
            Map properties = this.resolver.getSubProperties(DruidDataSourceConfiguration.EMPTY);
            Stream.Builder<Class<DruidDataSourceBeanPostProcessor>> imposts = Stream.builder().add(DruidDataSourceBeanPostProcessor.class);
            imposts.add(properties.isEmpty() ? SingleDataSourceRegistrar.class : DynamicDataSourceRegistrar.class);
            return (String[])imposts.build().map(Class::getName).toArray(String[]::new);
        }
    }

    static class DruidDataSourceBeanPostProcessor
    implements BeanPostProcessor,
    EnvironmentAware {
        private ConfigurableEnvironment environment;
        private RelaxedPropertyResolver resolver;
        private List<DruidDataSourceCustomizer> customizers;

        DruidDataSourceBeanPostProcessor() {
        }

        public void setEnvironment(Environment environment) {
            this.environment = (ConfigurableEnvironment)environment;
            this.resolver = new RelaxedPropertyResolver((PropertyResolver)environment, DruidDataSourceConfiguration.PREFIX);
        }

        @Autowired
        public void setCustomizers(ObjectProvider<List<DruidDataSourceCustomizer>> customizersProvider) {
            this.customizers = (List)customizersProvider.getIfAvailable();
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof DruidDataSource) {
                boolean isSingle;
                ((DruidDataSource)bean).setName(beanName);
                if (!this.resolver.getSubProperties(DruidDataSourceConfiguration.EMPTY).isEmpty()) {
                    PropertySourcesBinder binder = new PropertySourcesBinder(this.environment);
                    binder.bindTo(DruidDataSourceConfiguration.PREFIX + beanName, bean);
                }
                if (this.customizers != null && !this.customizers.isEmpty()) {
                    for (DruidDataSourceCustomizer customizer : this.customizers) {
                        customizer.customize((DruidDataSource)bean);
                    }
                }
                if (isSingle = DruidDataSourceConfiguration.BEAN_NAME.equals(beanName)) {
                    log.debug("druid data-source init...");
                } else {
                    log.debug("druid {}-data-source init...", (Object)beanName);
                }
            }
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }
    }

    static class DynamicDataSourceRegistrar
    implements ImportBeanDefinitionRegistrar,
    EnvironmentAware {
        private RelaxedPropertyResolver resolver;

        DynamicDataSourceRegistrar() {
        }

        public void setEnvironment(Environment environment) {
            this.resolver = new RelaxedPropertyResolver((PropertyResolver)environment, DruidDataSourceConfiguration.PREFIX);
        }

        public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
            this.resolver.getSubProperties(DruidDataSourceConfiguration.EMPTY).keySet().stream().map(key -> key.substring(0, key.indexOf(DruidDataSourceConfiguration.POINT))).distinct().forEach(dataSourceName -> {
                String camelName = CharMatcher.separatedToCamel().apply((String)dataSourceName);
                registry.registerBeanDefinition(camelName, DruidDataSourceConfiguration.genericDruidBeanDefinition());
                if (!camelName.toLowerCase().endsWith(DruidDataSourceConfiguration.BEAN_SUFFIX.toLowerCase())) {
                    registry.registerAlias(camelName, camelName + DruidDataSourceConfiguration.BEAN_SUFFIX);
                }
            });
        }
    }

    static class SingleDataSourceRegistrar
    implements ImportBeanDefinitionRegistrar {
        SingleDataSourceRegistrar() {
        }

        public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
            if (!registry.containsBeanDefinition(DruidDataSourceConfiguration.BEAN_NAME)) {
                registry.registerBeanDefinition(DruidDataSourceConfiguration.BEAN_NAME, DruidDataSourceConfiguration.genericDruidBeanDefinition());
            }
        }
    }
}

