/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.mysql.codec;

import com.github.jasync.sql.db.Configuration;
import com.github.jasync.sql.db.ResultSet;
import com.github.jasync.sql.db.exceptions.DatabaseException;
import com.github.jasync.sql.db.general.ColumnData;
import com.github.jasync.sql.db.general.MutableResultSet;
import com.github.jasync.sql.db.mysql.binary.BinaryRowDecoder;
import com.github.jasync.sql.db.mysql.codec.LittleEndianByteBufAllocator;
import com.github.jasync.sql.db.mysql.codec.MySQLConnectionHandlerKt;
import com.github.jasync.sql.db.mysql.codec.MySQLFrameDecoder;
import com.github.jasync.sql.db.mysql.codec.MySQLHandlerDelegate;
import com.github.jasync.sql.db.mysql.codec.MySQLOneToOneEncoder;
import com.github.jasync.sql.db.mysql.codec.PreparedStatement;
import com.github.jasync.sql.db.mysql.codec.PreparedStatementHolder;
import com.github.jasync.sql.db.mysql.codec.SendLongDataEncoder;
import com.github.jasync.sql.db.mysql.message.client.AuthenticationSwitchResponse;
import com.github.jasync.sql.db.mysql.message.client.CloseStatementMessage;
import com.github.jasync.sql.db.mysql.message.client.HandshakeResponseMessage;
import com.github.jasync.sql.db.mysql.message.client.PreparedStatementExecuteMessage;
import com.github.jasync.sql.db.mysql.message.client.PreparedStatementPrepareMessage;
import com.github.jasync.sql.db.mysql.message.client.QueryMessage;
import com.github.jasync.sql.db.mysql.message.client.QuitMessage;
import com.github.jasync.sql.db.mysql.message.client.SendLongDataMessage;
import com.github.jasync.sql.db.mysql.message.server.AuthenticationSwitchRequest;
import com.github.jasync.sql.db.mysql.message.server.BinaryRowMessage;
import com.github.jasync.sql.db.mysql.message.server.ColumnDefinitionMessage;
import com.github.jasync.sql.db.mysql.message.server.EOFMessage;
import com.github.jasync.sql.db.mysql.message.server.ErrorMessage;
import com.github.jasync.sql.db.mysql.message.server.HandshakeMessage;
import com.github.jasync.sql.db.mysql.message.server.OkMessage;
import com.github.jasync.sql.db.mysql.message.server.PreparedStatementPrepareResponse;
import com.github.jasync.sql.db.mysql.message.server.ResultSetRowMessage;
import com.github.jasync.sql.db.mysql.message.server.ServerMessage;
import com.github.jasync.sql.db.mysql.util.CharsetMapper;
import com.github.jasync.sql.db.util.ChannelFutureTransformerKt;
import com.github.jasync.sql.db.util.CollectionsUtilsKt;
import com.github.jasync.sql.db.util.ExecutorServiceUtils;
import com.github.jasync.sql.db.util.FP;
import com.github.jasync.sql.db.util.FutureUtilsKt;
import com.github.jasync.sql.db.util.NettyUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.CodecException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ea\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u001dH\u0016J\u0010\u00104\u001a\u0002022\u0006\u00103\u001a\u00020\u001dH\u0016J\u0018\u00105\u001a\u0002022\u0006\u00103\u001a\u00020\u001d2\u0006\u00106\u001a\u00020\u0002H\u0014J\u0010\u00107\u001a\u0002022\u0006\u00103\u001a\u00020\u001dH\u0016J\u0010\u00108\u001a\u0002022\u0006\u00103\u001a\u00020\u001dH\u0016J\b\u00109\u001a\u000202H\u0002J\u0006\u0010:\u001a\u00020;J\u0014\u0010<\u001a\b\u0012\u0004\u0012\u00020*0\u00182\u0006\u0010=\u001a\u00020\u000eJ\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00000\u0018J\u0018\u0010?\u001a\u0002022\u0006\u00103\u001a\u00020\u001d2\u0006\u0010@\u001a\u00020AH\u0016J<\u0010B\u001a\b\u0012\u0004\u0012\u00020;0\u00182\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020F2\u000e\u0010G\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020H2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u001b0HH\u0002J\u0010\u0010J\u001a\u0002022\u0006\u0010K\u001a\u00020LH\u0002J\u0010\u0010M\u001a\u0002022\u0006\u0010@\u001a\u00020AH\u0002J\u0010\u0010N\u001a\u0002022\u0006\u00103\u001a\u00020\u001dH\u0016J\u0006\u0010O\u001a\u00020*J\u0010\u0010P\u001a\u00020*2\u0006\u0010Q\u001a\u00020\u0002H\u0002J\b\u0010R\u001a\u000202H\u0002J\u0010\u0010S\u001a\u0002022\u0006\u00106\u001a\u00020TH\u0002J \u0010U\u001a\u00020;2\u0006\u0010V\u001a\u00020W2\u0006\u0010C\u001a\u00020D2\u0006\u0010X\u001a\u00020FH\u0002J&\u0010Y\u001a\b\u0012\u0004\u0012\u00020;0\u00182\u0006\u0010C\u001a\u00020D2\u0006\u0010Z\u001a\u00020F2\u0006\u0010[\u001a\u00020\u0002H\u0002J$\u0010\\\u001a\b\u0012\u0004\u0012\u00020;0\u00182\u0006\u0010=\u001a\u00020\u000e2\u000e\u0010G\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020HJ\u000e\u0010]\u001a\u0002022\u0006\u0010=\u001a\u00020\u000eJ\f\u0010^\u001a\b\u0012\u0004\u0012\u00020_0\u0018J\u000e\u0010`\u001a\u00020;2\u0006\u00106\u001a\u00020aJ\u000e\u0010`\u001a\u00020;2\u0006\u00106\u001a\u00020bJ\u0010\u0010`\u001a\u00020;2\u0006\u00106\u001a\u00020cH\u0002J\u0010\u0010d\u001a\u00020;2\u0006\u00106\u001a\u00020\u0002H\u0002R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00000\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010+R*\u0010,\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020!0-j\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020!`.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006e"}, d2={"Lcom/github/jasync/sql/db/mysql/codec/MySQLConnectionHandler;", "Lio/netty/channel/SimpleChannelInboundHandler;", "", "configuration", "Lcom/github/jasync/sql/db/Configuration;", "charsetMapper", "Lcom/github/jasync/sql/db/mysql/util/CharsetMapper;", "handlerDelegate", "Lcom/github/jasync/sql/db/mysql/codec/MySQLHandlerDelegate;", "group", "Lio/netty/channel/EventLoopGroup;", "executionContext", "Ljava/util/concurrent/Executor;", "connectionId", "", "(Lcom/github/jasync/sql/db/Configuration;Lcom/github/jasync/sql/db/mysql/util/CharsetMapper;Lcom/github/jasync/sql/db/mysql/codec/MySQLHandlerDelegate;Lio/netty/channel/EventLoopGroup;Ljava/util/concurrent/Executor;Ljava/lang/String;)V", "binaryRowDecoder", "Lcom/github/jasync/sql/db/mysql/binary/BinaryRowDecoder;", "bootstrap", "Lio/netty/bootstrap/Bootstrap;", "kotlin.jvm.PlatformType", "getConfiguration", "()Lcom/github/jasync/sql/db/Configuration;", "connectionPromise", "Ljava/util/concurrent/CompletableFuture;", "currentColumns", "", "Lcom/github/jasync/sql/db/mysql/message/server/ColumnDefinitionMessage;", "currentContext", "Lio/netty/channel/ChannelHandlerContext;", "currentPreparedStatement", "Lcom/github/jasync/sql/db/mysql/codec/PreparedStatement;", "currentPreparedStatementHolder", "Lcom/github/jasync/sql/db/mysql/codec/PreparedStatementHolder;", "currentQuery", "Lcom/github/jasync/sql/db/general/MutableResultSet;", "currentQueryString", "decoder", "Lcom/github/jasync/sql/db/mysql/codec/MySQLFrameDecoder;", "encoder", "Lcom/github/jasync/sql/db/mysql/codec/MySQLOneToOneEncoder;", "isPreparedStatement", "", "Ljava/lang/Boolean;", "parsedStatements", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "sendLongDataEncoder", "Lcom/github/jasync/sql/db/mysql/codec/SendLongDataEncoder;", "channelActive", "", "ctx", "channelInactive", "channelRead0", "message", "channelRegistered", "channelUnregistered", "clearQueryState", "closeChannel", "Lio/netty/channel/ChannelFuture;", "closePreparedStatement", "query", "connect", "exceptionCaught", "cause", "", "executePreparedStatement", "statementId", "", "columnsCount", "", "values", "", "parameters", "handleEOF", "m", "Lcom/github/jasync/sql/db/mysql/message/server/ServerMessage;", "handleException", "handlerAdded", "isConnected", "isLong", "value", "onColumnDefinitionFinished", "onPreparedStatementPrepareResponse", "Lcom/github/jasync/sql/db/mysql/message/server/PreparedStatementPrepareResponse;", "sendBuffer", "buffer", "Lio/netty/buffer/ByteBuf;", "paramId", "sendLongParameter", "index", "longValue", "sendPreparedStatement", "sendQuery", "sendQuitMessage", "Lio/netty/channel/Channel;", "write", "Lcom/github/jasync/sql/db/mysql/message/client/AuthenticationSwitchResponse;", "Lcom/github/jasync/sql/db/mysql/message/client/HandshakeResponseMessage;", "Lcom/github/jasync/sql/db/mysql/message/client/QueryMessage;", "writeAndHandleError", "jasync-mysql"})
public final class MySQLConnectionHandler
extends SimpleChannelInboundHandler<Object> {
    private final Bootstrap bootstrap;
    private final CompletableFuture<MySQLConnectionHandler> connectionPromise;
    private final MySQLFrameDecoder decoder;
    private final MySQLOneToOneEncoder encoder;
    private final SendLongDataEncoder sendLongDataEncoder;
    private final List<ColumnDefinitionMessage> currentColumns;
    private final HashMap<String, PreparedStatementHolder> parsedStatements;
    private final BinaryRowDecoder binaryRowDecoder;
    private PreparedStatementHolder currentPreparedStatementHolder;
    private PreparedStatement currentPreparedStatement;
    private MutableResultSet<ColumnDefinitionMessage> currentQuery;
    private ChannelHandlerContext currentContext;
    private String currentQueryString;
    private Boolean isPreparedStatement;
    @NotNull
    private final Configuration configuration;
    private final MySQLHandlerDelegate handlerDelegate;
    private final EventLoopGroup group;
    private final Executor executionContext;
    private final String connectionId;

    @NotNull
    public final CompletableFuture<MySQLConnectionHandler> connect() {
        this.bootstrap.channel(NettyUtils.INSTANCE.getSocketChannelClass(this.group));
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(this){
            final /* synthetic */ MySQLConnectionHandler this$0;

            protected void initChannel(@NotNull Channel channel) {
                Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
                channel.pipeline().addLast(new ChannelHandler[]{(ChannelHandler)MySQLConnectionHandler.access$getDecoder$p(this.this$0), (ChannelHandler)MySQLConnectionHandler.access$getEncoder$p(this.this$0), (ChannelHandler)MySQLConnectionHandler.access$getSendLongDataEncoder$p(this.this$0), (ChannelHandler)this.this$0});
            }
            {
                this.this$0 = $outer;
            }
        });
        this.bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.bootstrap.option(ChannelOption.ALLOCATOR, (Object)LittleEndianByteBufAllocator.Companion.getINSTANCE());
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.configuration.getConnectionTimeout());
        ChannelFuture channelFuture = this.bootstrap.connect((SocketAddress)new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort()));
        Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"this.bootstrap.connect(I\u2026ost, configuration.port))");
        ChannelFuture channelFuture2 = channelFuture;
        ChannelFutureTransformerKt.onFailure((ChannelFuture)channelFuture2, (Executor)this.executionContext, (Function1)((Function1)new Function1<Throwable, Unit>(this){
            final /* synthetic */ MySQLConnectionHandler this$0;

            public final void invoke(@NotNull Throwable exception) {
                Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
                MySQLConnectionHandler.access$getConnectionPromise$p(this.this$0).completeExceptionally(exception);
            }
            {
                this.this$0 = mySQLConnectionHandler;
                super(1);
            }
        }));
        return this.connectionPromise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void channelRead0(@NotNull ChannelHandlerContext ctx, @NotNull Object message) {
        block27: {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            var3_3 = message;
            if (!(var3_3 instanceof ServerMessage)) break block27;
            switch (((ServerMessage)message).getKind()) {
                case 10: {
                    this.handlerDelegate.onHandshake((HandshakeMessage)message);
                    break;
                }
                case 0: {
                    this.clearQueryState();
                    this.handlerDelegate.onOk((OkMessage)message);
                    break;
                }
                case -1: {
                    this.clearQueryState();
                    this.handlerDelegate.onError((ErrorMessage)message);
                    break;
                }
                case -2: {
                    this.handleEOF((ServerMessage)message);
                    break;
                }
                case 100: {
                    m = (ColumnDefinitionMessage)message;
                    v0 = this.currentPreparedStatementHolder;
                    if (v0 != null) {
                        var5_7 = v0;
                        it = var5_7;
                        $i$a$-let-MySQLConnectionHandler$channelRead0$1 = false;
                        if (it.needsAny()) {
                            it.add(m);
                        }
                    }
                    var5_7 = this.currentColumns;
                    var5_7.add(message);
                    break;
                }
                case 101: {
                    this.onColumnDefinitionFinished();
                    break;
                }
                case 106: {
                    this.onPreparedStatementPrepareResponse((PreparedStatementPrepareResponse)message);
                    break;
                }
                case 104: {
                    rsrMessage = (ResultSetRowMessage)message;
                    size$iv = rsrMessage.size();
                    result$iv = new Object[size$iv];
                    var8_15 = 0;
                    var9_16 = result$iv.length;
                    while (var8_15 < var9_16) {
                        var10_17 = i$iv;
                        var18_23 = i$iv;
                        var17_22 = result$iv;
                        $i$a$-<init>-MySQLConnectionHandler$channelRead0$items$1 = false;
                        if (rsrMessage.get((int)it) != null) ** GOTO lbl54
                        v1 = null;
                        ** GOTO lbl72
lbl54:
                        // 1 sources

                        if (this.currentQuery == null) {
                            throw (Throwable)new NullPointerException("currentQuery is null");
                        }
                        v2 = this.currentQuery;
                        if (v2 == null) {
                            Intrinsics.throwNpe();
                        }
                        columnDescription = (ColumnDefinitionMessage)v2.getColumnTypes().get((int)it);
                        if (rsrMessage.get((int)it) == null) {
                            Intrinsics.throwNpe();
                        }
                        try {
                            var14_21 = columnDescription.getTextDecoder().decode((ColumnData)columnDescription, buf, this.configuration.getCharset());
                        }
                        finally {
                            buf.release();
                        }
                        v1 = var14_21;
lbl72:
                        // 2 sources

                        var17_22[var18_23] = var19_24 = v1;
                        ++i$iv;
                    }
                    items = result$iv;
                    v3 = this.currentQuery;
                    if (v3 == null) {
                        Intrinsics.throwNpe();
                    }
                    v3.addRow(items);
                    break;
                }
                case 105: {
                    m = (BinaryRowMessage)message;
                    try {
                        decodedRow = this.binaryRowDecoder.decode(m.getBuffer(), this.currentColumns);
                        v4 = this.currentQuery;
                        if (v4 == null) {
                            Intrinsics.throwNpe();
                        }
                        v4.addRow(decodedRow);
                        break;
                    }
                    finally {
                        m.getBuffer().release();
                    }
                }
                case 102: {
                    break;
                }
                case 103: {
                    this.onColumnDefinitionFinished();
                }
            }
        }
    }

    public void channelActive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        MySQLConnectionHandlerKt.access$getLogger$p().trace((Function0)new Function0<String>(this){
            final /* synthetic */ MySQLConnectionHandler this$0;

            @NotNull
            public final String invoke() {
                return "[connectionId:" + MySQLConnectionHandler.access$getConnectionId$p(this.this$0) + "] - Channel became active";
            }
            {
                this.this$0 = mySQLConnectionHandler;
                super(0);
            }
        });
        this.handlerDelegate.connected(ctx);
    }

    public void channelInactive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        MySQLConnectionHandlerKt.access$getLogger$p().trace((Function0)new Function0<String>(this){
            final /* synthetic */ MySQLConnectionHandler this$0;

            @NotNull
            public final String invoke() {
                return "[connectionId:" + MySQLConnectionHandler.access$getConnectionId$p(this.this$0) + "] - Channel became inactive";
            }
            {
                this.this$0 = mySQLConnectionHandler;
                super(0);
            }
        });
    }

    public void channelRegistered(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        MySQLConnectionHandlerKt.access$getLogger$p().trace((Function0)new Function0<String>(this){
            final /* synthetic */ MySQLConnectionHandler this$0;

            @NotNull
            public final String invoke() {
                return "[connectionId:" + MySQLConnectionHandler.access$getConnectionId$p(this.this$0) + "] - channelRegistered";
            }
            {
                this.this$0 = mySQLConnectionHandler;
                super(0);
            }
        });
        super.channelRegistered(ctx);
    }

    public void channelUnregistered(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        MySQLConnectionHandlerKt.access$getLogger$p().trace((Function0)new Function0<String>(this){
            final /* synthetic */ MySQLConnectionHandler this$0;

            @NotNull
            public final String invoke() {
                return "[connectionId:" + MySQLConnectionHandler.access$getConnectionId$p(this.this$0) + "] - channelUnregistered";
            }
            {
                this.this$0 = mySQLConnectionHandler;
                super(0);
            }
        });
        this.handlerDelegate.unregistered();
        super.channelUnregistered(ctx);
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
        Throwable throwable = cause;
        if (throwable instanceof CodecException) {
            Throwable throwable2 = cause.getCause();
            if (throwable2 == null) {
                throwable2 = cause;
            }
            this.handleException(throwable2);
        } else {
            this.handleException(cause);
        }
    }

    private final void handleException(Throwable cause) {
        if (!this.connectionPromise.isDone()) {
            FutureUtilsKt.failed(this.connectionPromise, (Throwable)cause);
        }
        this.handlerDelegate.exceptionCaught(cause);
    }

    public void handlerAdded(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        this.currentContext = ctx;
    }

    private final ChannelFuture write(QueryMessage message) {
        this.decoder.queryProcessStarted();
        return this.writeAndHandleError(message);
    }

    public final void sendQuery(@NotNull String query) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        this.isPreparedStatement = false;
        this.currentQueryString = query;
        this.write(new QueryMessage(query));
    }

    @NotNull
    public final CompletableFuture<ChannelFuture> sendPreparedStatement(@NotNull String query, @NotNull List<? extends Object> values) {
        CompletableFuture completableFuture;
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        Intrinsics.checkParameterIsNotNull(values, (String)"values");
        PreparedStatement preparedStatement = new PreparedStatement(query, values);
        this.isPreparedStatement = true;
        this.currentQueryString = query;
        this.currentColumns.clear();
        this.currentPreparedStatement = preparedStatement;
        PreparedStatementHolder item = this.parsedStatements.get(preparedStatement.getStatement());
        if (item != null) {
            completableFuture = this.executePreparedStatement(item.statementId(), item.getColumns().size(), preparedStatement.getValues(), item.getParameters());
        } else {
            this.decoder.preparedStatementPrepareStarted();
            completableFuture = ChannelFutureTransformerKt.toCompletableFuture((ChannelFuture)this.writeAndHandleError(new PreparedStatementPrepareMessage(preparedStatement.getStatement())));
        }
        return completableFuture;
    }

    @NotNull
    public final CompletableFuture<Boolean> closePreparedStatement(@NotNull String query) {
        CompletableFuture completableFuture;
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        PreparedStatementHolder statement = this.parsedStatements.get(query);
        if (statement != null) {
            this.parsedStatements.remove(query);
            this.writeAndHandleError(new CloseStatementMessage(statement.statementId()));
            completableFuture = FP.INSTANCE.successful((Object)true);
        } else {
            completableFuture = FP.INSTANCE.successful((Object)false);
        }
        return completableFuture;
    }

    @NotNull
    public final ChannelFuture write(@NotNull HandshakeResponseMessage message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.decoder.setHasDoneHandshake(true);
        return this.writeAndHandleError(message);
    }

    @NotNull
    public final ChannelFuture write(@NotNull AuthenticationSwitchResponse message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        return this.writeAndHandleError(message);
    }

    @NotNull
    public final CompletableFuture<Channel> sendQuitMessage() {
        CompletableFuture<Channel> future = new CompletableFuture<Channel>();
        ChannelHandlerContext channelHandlerContext = this.currentContext;
        if (channelHandlerContext == null) {
            Intrinsics.throwNpe();
        }
        Channel channel = channelHandlerContext.channel();
        channel.eventLoop().execute(new Runnable(this, channel, future){
            final /* synthetic */ MySQLConnectionHandler this$0;
            final /* synthetic */ Channel $channel;
            final /* synthetic */ CompletableFuture $future;

            public final void run() {
                MySQLConnectionHandler.access$clearQueryState(this.this$0);
                Channel channel = this.$channel;
                Intrinsics.checkExpressionValueIsNotNull((Object)channel, (String)"channel");
                if (channel.isActive()) {
                    ChannelFutureTransformerKt.installOnFuture((ChannelFuture)MySQLConnectionHandler.access$writeAndHandleError(this.this$0, QuitMessage.Companion.getInstance()), (CompletableFuture)this.$future);
                } else {
                    this.$future.complete(this.$channel);
                }
            }
            {
                this.this$0 = mySQLConnectionHandler;
                this.$channel = channel;
                this.$future = completableFuture;
            }
        });
        return future;
    }

    @NotNull
    public final ChannelFuture closeChannel() {
        ChannelHandlerContext channelHandlerContext = this.currentContext;
        if (channelHandlerContext == null) {
            Intrinsics.throwNpe();
        }
        ChannelFuture channelFuture = channelHandlerContext.channel().close();
        Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"this.currentContext!!.channel().close()");
        return channelFuture;
    }

    private final void clearQueryState() {
        this.currentColumns.clear();
        this.currentQuery = null;
        this.isPreparedStatement = null;
        this.currentQueryString = null;
    }

    public final boolean isConnected() {
        ChannelHandlerContext channelHandlerContext = this.currentContext;
        return channelHandlerContext != null && (channelHandlerContext = channelHandlerContext.channel()) != null ? channelHandlerContext.isActive() : false;
    }

    /*
     * WARNING - void declaration
     */
    private final CompletableFuture<ChannelFuture> executePreparedStatement(byte[] statementId, int columnsCount, List<? extends Object> values, List<ColumnDefinitionMessage> parameters) {
        CompletionStage completionStage;
        void $receiver$iv$iv;
        void longValues1;
        Iterator it;
        Pair $$_$_any;
        Object object;
        Collection collection;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        this.decoder.preparedStatementExecuteStarted(columnsCount, parameters.size());
        this.currentColumns.clear();
        Iterable iterable = $receiver$iv = (Iterable)values;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv2) {
            void any;
            void index;
            int n = index$iv$iv++;
            Collection collection2 = destination$iv$iv;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            Object t = item$iv$iv;
            int n3 = n2;
            collection = collection2;
            boolean bl = false;
            object = TuplesKt.to((Object)((int)index), (Object)any);
            collection.add(object);
        }
        $receiver$iv = (List)destination$iv$iv;
        Iterable<Object> first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $receiver$iv) {
            $$_$_any = (Pair)element$iv;
            boolean bl = false;
            Object any = $$_$_any.component2();
            if (any != null && this.isLong(any)) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List list = (List)pair.component1();
        List nonLongIndicesOpt1 = (List)pair.component2();
        $receiver$iv = nonLongIndicesOpt1;
        first$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            $$_$_any = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = ((Number)it.getFirst()).intValue();
            collection.add(object);
        }
        List nonLongIndices = (List)destination$iv$iv;
        Iterable $receiver$iv22 = (Iterable)longValues1;
        destination$iv$iv = $receiver$iv22;
        Collection destination$iv$iv2 = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        it = $receiver$iv$iv$iv.iterator();
        while (it.hasNext()) {
            Pair index;
            Pair pair2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            Pair it2 = (Pair)element$iv$iv;
            boolean bl = false;
            if (it2.getSecond() == null) {
                pair2 = null;
            } else {
                Object object2 = it2.getFirst();
                Object object3 = it2.getSecond();
                if (object3 == null) {
                    Intrinsics.throwNpe();
                }
                pair2 = TuplesKt.to((Object)object2, (Object)object3);
            }
            if (pair2 == null) continue;
            Pair it$iv$iv = index = pair2;
            destination$iv$iv2.add(it$iv$iv);
        }
        List longValues = (List)destination$iv$iv2;
        $receiver$iv22 = longValues;
        if (!$receiver$iv22.isEmpty()) {
            void channelFuture;
            void firstIndex;
            destination$iv$iv2 = (Pair)CollectionsUtilsKt.getHead((List)longValues);
            int $receiver$iv22 = ((Number)destination$iv$iv2.component1()).intValue();
            Object firstValue = destination$iv$iv2.component2();
            destination$iv$iv2 = new Ref.ObjectRef();
            ((Ref.ObjectRef)destination$iv$iv2).element = this.sendLongParameter(statementId, (int)firstIndex, firstValue);
            Object $receiver$iv3 = CollectionsUtilsKt.getTail((List)longValues);
            it = $receiver$iv3.iterator();
            while (it.hasNext()) {
                CompletionStage completionStage2;
                void executor$iv;
                void $receiver$iv4;
                Object element$iv = it.next();
                Pair $index_value = (Pair)element$iv;
                boolean bl = false;
                int index = ((Number)$index_value.component1()).intValue();
                Object value = $index_value.component2();
                CompletableFuture it$iv$iv = (CompletableFuture)channelFuture.element;
                Executor $i$a$1$let = this.executionContext;
                void var21_36 = channelFuture;
                boolean $i$f$flatMapAsync = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)$receiver$iv4.thenComposeAsync(new Function<ChannelFuture, CompletionStage<ChannelFuture>>(index, value, this, (Ref.ObjectRef)channelFuture, statementId){
                    final /* synthetic */ int $index$inlined;
                    final /* synthetic */ Object $value$inlined;
                    final /* synthetic */ MySQLConnectionHandler this$0;
                    final /* synthetic */ Ref.ObjectRef $channelFuture$inlined;
                    final /* synthetic */ byte[] $statementId$inlined;
                    {
                        this.$index$inlined = n;
                        this.$value$inlined = object;
                        this.this$0 = mySQLConnectionHandler;
                        this.$channelFuture$inlined = objectRef;
                        this.$statementId$inlined = byArray;
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    @NotNull
                    public final CompletableFuture apply(Object it) {
                        ChannelFuture it2 = (ChannelFuture)it;
                        boolean bl = false;
                        return MySQLConnectionHandler.access$sendLongParameter(this.this$0, this.$statementId$inlined, this.$index$inlined, this.$value$inlined);
                    }
                }, (Executor)executor$iv), (String)"thenComposeAsync(Function { f(it) }, executor)");
                var21_36.element = completionStage2;
            }
            CompletableFuture completableFuture = ((CompletableFuture)channelFuture.element).toCompletableFuture();
            Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"channelFuture.toCompletableFuture()");
            $receiver$iv3 = completableFuture;
            Executor executor$iv = this.executionContext;
            boolean $i$f$flatMapAsync = false;
            CompletionStage completionStage3 = ((CompletableFuture)$receiver$iv3).thenComposeAsync(new Function<ChannelFuture, CompletionStage<ChannelFuture>>(this, statementId, values, nonLongIndices, parameters){
                final /* synthetic */ MySQLConnectionHandler this$0;
                final /* synthetic */ byte[] $statementId$inlined;
                final /* synthetic */ List $values$inlined;
                final /* synthetic */ List $nonLongIndices$inlined;
                final /* synthetic */ List $parameters$inlined;
                {
                    this.this$0 = mySQLConnectionHandler;
                    this.$statementId$inlined = byArray;
                    this.$values$inlined = list;
                    this.$nonLongIndices$inlined = list2;
                    this.$parameters$inlined = list3;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                @NotNull
                public final CompletableFuture apply(Object it) {
                    ChannelFuture it2 = (ChannelFuture)it;
                    boolean bl = false;
                    return ChannelFutureTransformerKt.toCompletableFuture((ChannelFuture)MySQLConnectionHandler.access$writeAndHandleError(this.this$0, new PreparedStatementExecuteMessage(this.$statementId$inlined, this.$values$inlined, CollectionsKt.toSet((Iterable)this.$nonLongIndices$inlined), this.$parameters$inlined)));
                }
            }, executor$iv);
            completionStage = completionStage3;
            Intrinsics.checkExpressionValueIsNotNull((Object)completionStage3, (String)"thenComposeAsync(Function { f(it) }, executor)");
        } else {
            completionStage = ChannelFutureTransformerKt.toCompletableFuture((ChannelFuture)this.writeAndHandleError(new PreparedStatementExecuteMessage(statementId, values, CollectionsKt.toSet((Iterable)nonLongIndices), parameters)));
        }
        return completionStage;
    }

    private final boolean isLong(Object value) {
        Object object = value;
        return object instanceof byte[] ? CollectionsUtilsKt.getLength((byte[])((byte[])value)) > 1023 : (object instanceof ByteBuffer ? ((ByteBuffer)value).remaining() > 1023 : (object instanceof ByteBuf ? ((ByteBuf)value).readableBytes() > 1023 : false));
    }

    private final CompletableFuture<ChannelFuture> sendLongParameter(byte[] statementId, int index, Object longValue) {
        ChannelFuture channelFuture;
        Object object = longValue;
        if (object instanceof byte[]) {
            ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])longValue));
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf, (String)"Unpooled.wrappedBuffer(longValue)");
            channelFuture = this.sendBuffer(byteBuf, statementId, index);
        } else if (object instanceof ByteBuffer) {
            ByteBuf byteBuf = Unpooled.wrappedBuffer((ByteBuffer)((ByteBuffer)longValue));
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf, (String)"Unpooled.wrappedBuffer(longValue)");
            channelFuture = this.sendBuffer(byteBuf, statementId, index);
        } else if (object instanceof ByteBuf) {
            channelFuture = this.sendBuffer((ByteBuf)longValue, statementId, index);
        } else {
            String reason$iv = "no handle for " + longValue.getClass();
            boolean $i$f$XXX = false;
            throw (Throwable)new UnsupportedOperationException("An operation is not implemented: " + reason$iv);
        }
        return ChannelFutureTransformerKt.toCompletableFuture((ChannelFuture)channelFuture);
    }

    private final ChannelFuture sendBuffer(ByteBuf buffer, byte[] statementId, int paramId) {
        return this.writeAndHandleError(new SendLongDataMessage(statementId, buffer, paramId));
    }

    private final void onPreparedStatementPrepareResponse(PreparedStatementPrepareResponse message) {
        PreparedStatement preparedStatement = this.currentPreparedStatement;
        if (preparedStatement == null) {
            Intrinsics.throwNpe();
        }
        this.currentPreparedStatementHolder = new PreparedStatementHolder(preparedStatement.getStatement(), message);
    }

    private final void onColumnDefinitionFinished() {
        block2: {
            PreparedStatementHolder preparedStatementHolder;
            MySQLConnectionHandlerKt.access$getLogger$p().trace((Function0)new Function0<String>(this){
                final /* synthetic */ MySQLConnectionHandler this$0;

                @NotNull
                public final String invoke() {
                    return "[connectionId:" + MySQLConnectionHandler.access$getConnectionId$p(this.this$0) + "] - onColumnDefinitionFinished()";
                }
                {
                    this.this$0 = mySQLConnectionHandler;
                    super(0);
                }
            });
            Object object = this.currentPreparedStatementHolder;
            if (object == null || (object = ((PreparedStatementHolder)object).getColumns()) == null) {
                object = this.currentColumns;
            }
            List<ColumnDefinitionMessage> columns = object;
            this.currentQuery = new MutableResultSet(CollectionsKt.toList((Iterable)columns), null, 2, null);
            PreparedStatementHolder preparedStatementHolder2 = this.currentPreparedStatementHolder;
            if (preparedStatementHolder2 == null) break block2;
            PreparedStatementHolder it = preparedStatementHolder = preparedStatementHolder2;
            boolean bl = false;
            Map map = this.parsedStatements;
            String string = it.getStatement();
            PreparedStatementHolder preparedStatementHolder3 = it;
            map.put(string, preparedStatementHolder3);
            byte[] byArray = it.statementId();
            int n = it.getColumns().size();
            PreparedStatement preparedStatement = this.currentPreparedStatement;
            if (preparedStatement == null) {
                Intrinsics.throwNpe();
            }
            this.executePreparedStatement(byArray, n, preparedStatement.getValues(), it.getParameters());
            this.currentPreparedStatementHolder = null;
            this.currentPreparedStatement = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ChannelFuture writeAndHandleError(Object message) {
        ChannelFuture channelFuture;
        ChannelHandlerContext channelHandlerContext = this.currentContext;
        if (channelHandlerContext != null && (channelHandlerContext = channelHandlerContext.channel()) != null) {
            if (channelHandlerContext.isActive()) {
                ChannelHandlerContext channelHandlerContext2 = this.currentContext;
                if (channelHandlerContext2 == null) {
                    Intrinsics.throwNpe();
                }
                ChannelFuture channelFuture2 = channelHandlerContext2.writeAndFlush(message);
                Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture2, (String)"currentContext!!.writeAndFlush(message)");
                ChannelFuture res = channelFuture2;
                ChannelFutureTransformerKt.onFailure((ChannelFuture)res, (Executor)this.executionContext, (Function1)((Function1)new Function1<Throwable, Unit>(this){
                    final /* synthetic */ MySQLConnectionHandler this$0;

                    public final void invoke(@NotNull Throwable e) {
                        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                        MySQLConnectionHandler.access$handleException(this.this$0, e);
                    }
                    {
                        this.this$0 = mySQLConnectionHandler;
                        super(1);
                    }
                }));
                channelFuture = res;
                return channelFuture;
            }
        }
        DatabaseException error = new DatabaseException("This channel is not active and can't take messages");
        this.handleException((Throwable)error);
        ChannelHandlerContext channelHandlerContext3 = this.currentContext;
        if (channelHandlerContext3 == null) {
            Intrinsics.throwNpe();
        }
        ChannelFuture channelFuture3 = channelHandlerContext3.channel().newFailedFuture((Throwable)error);
        channelFuture = channelFuture3;
        Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture3, (String)"currentContext!!.channel().newFailedFuture(error)");
        return channelFuture;
    }

    private final void handleEOF(ServerMessage m) {
        ServerMessage serverMessage = m;
        if (serverMessage instanceof EOFMessage) {
            MutableResultSet<ColumnDefinitionMessage> resultSet = this.currentQuery;
            this.clearQueryState();
            if (resultSet != null) {
                this.handlerDelegate.onResultSet((ResultSet)resultSet, (EOFMessage)m);
            } else {
                this.handlerDelegate.onEOF((EOFMessage)m);
            }
        } else if (serverMessage instanceof AuthenticationSwitchRequest) {
            this.handlerDelegate.switchAuthentication((AuthenticationSwitchRequest)m);
        }
    }

    @NotNull
    public final Configuration getConfiguration() {
        return this.configuration;
    }

    public MySQLConnectionHandler(@NotNull Configuration configuration, @NotNull CharsetMapper charsetMapper, @NotNull MySQLHandlerDelegate handlerDelegate, @NotNull EventLoopGroup group, @NotNull Executor executionContext, @NotNull String connectionId) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)charsetMapper, (String)"charsetMapper");
        Intrinsics.checkParameterIsNotNull((Object)handlerDelegate, (String)"handlerDelegate");
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        Intrinsics.checkParameterIsNotNull((Object)executionContext, (String)"executionContext");
        Intrinsics.checkParameterIsNotNull((Object)connectionId, (String)"connectionId");
        this.configuration = configuration;
        this.handlerDelegate = handlerDelegate;
        this.group = group;
        this.executionContext = executionContext;
        this.connectionId = connectionId;
        this.bootstrap = (Bootstrap)new Bootstrap().group(this.group);
        this.connectionPromise = new CompletableFuture();
        this.decoder = new MySQLFrameDecoder(this.configuration.getCharset(), this.connectionId);
        this.encoder = new MySQLOneToOneEncoder(this.configuration.getCharset(), charsetMapper);
        this.sendLongDataEncoder = new SendLongDataEncoder();
        MySQLConnectionHandler mySQLConnectionHandler = this;
        mySQLConnectionHandler.currentColumns = list = (List)new ArrayList();
        this.parsedStatements = new HashMap();
        this.binaryRowDecoder = new BinaryRowDecoder();
    }

    public /* synthetic */ MySQLConnectionHandler(Configuration configuration, CharsetMapper charsetMapper, MySQLHandlerDelegate mySQLHandlerDelegate, EventLoopGroup eventLoopGroup, Executor executor, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            executor = ExecutorServiceUtils.INSTANCE.getCommonPool();
        }
        this(configuration, charsetMapper, mySQLHandlerDelegate, eventLoopGroup, executor, string);
    }

    public static final /* synthetic */ MySQLFrameDecoder access$getDecoder$p(MySQLConnectionHandler $this) {
        return $this.decoder;
    }

    public static final /* synthetic */ MySQLOneToOneEncoder access$getEncoder$p(MySQLConnectionHandler $this) {
        return $this.encoder;
    }

    public static final /* synthetic */ SendLongDataEncoder access$getSendLongDataEncoder$p(MySQLConnectionHandler $this) {
        return $this.sendLongDataEncoder;
    }

    public static final /* synthetic */ CompletableFuture access$getConnectionPromise$p(MySQLConnectionHandler $this) {
        return $this.connectionPromise;
    }

    public static final /* synthetic */ String access$getConnectionId$p(MySQLConnectionHandler $this) {
        return $this.connectionId;
    }

    public static final /* synthetic */ void access$clearQueryState(MySQLConnectionHandler $this) {
        $this.clearQueryState();
    }

    public static final /* synthetic */ ChannelFuture access$writeAndHandleError(MySQLConnectionHandler $this, Object message) {
        return $this.writeAndHandleError(message);
    }

    public static final /* synthetic */ CompletableFuture access$sendLongParameter(MySQLConnectionHandler $this, byte[] statementId, int index, Object longValue) {
        return $this.sendLongParameter(statementId, index, longValue);
    }

    public static final /* synthetic */ void access$handleException(MySQLConnectionHandler $this, Throwable cause) {
        $this.handleException(cause);
    }
}

