/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.r2dbc.mysql;

import com.github.jasync.r2dbc.mysql.JasyncBatch;
import com.github.jasync.r2dbc.mysql.JasyncStatement;
import io.r2dbc.spi.Batch;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.IsolationLevel;
import io.r2dbc.spi.Statement;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoExtensionsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tH\u0016J4\u0010\u0015\u001a&\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\f0\f \u0017*\u0012\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\f0\f\u0018\u00010\u00160\u00162\u0006\u0010\u0014\u001a\u00020\tH\u0002J\b\u0010\u0018\u001a\u00020\u0003H\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/github/jasync/r2dbc/mysql/JasyncClientConnection;", "Lio/r2dbc/spi/Connection;", "Ljava/util/function/Supplier;", "Lcom/github/jasync/sql/db/Connection;", "jasyncConnection", "(Lcom/github/jasync/sql/db/Connection;)V", "assertValidSavepointName", "", "name", "", "beginTransaction", "Lorg/reactivestreams/Publisher;", "Ljava/lang/Void;", "close", "commitTransaction", "createBatch", "Lio/r2dbc/spi/Batch;", "createSavepoint", "createStatement", "Lio/r2dbc/spi/Statement;", "sql", "executeVoid", "Lreactor/core/publisher/Mono;", "kotlin.jvm.PlatformType", "get", "releaseSavepoint", "rollbackTransaction", "rollbackTransactionToSavepoint", "setTransactionIsolationLevel", "isolationLevel", "Lio/r2dbc/spi/IsolationLevel;", "jasync-r2dbc-mysql"})
public final class JasyncClientConnection
implements Connection,
Supplier<com.github.jasync.sql.db.Connection> {
    private final com.github.jasync.sql.db.Connection jasyncConnection;

    @NotNull
    public Publisher<Void> beginTransaction() {
        Mono<Void> mono = this.executeVoid("START TRANSACTION");
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"executeVoid(\"START TRANSACTION\")");
        return (Publisher)mono;
    }

    @NotNull
    public Publisher<Void> commitTransaction() {
        Mono<Void> mono = this.executeVoid("COMMIT");
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"executeVoid(\"COMMIT\")");
        return (Publisher)mono;
    }

    @NotNull
    public Publisher<Void> createSavepoint(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.assertValidSavepointName(name);
        Mono<Void> mono = this.executeVoid("SAVEPOINT `" + name + '`');
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"executeVoid(\"SAVEPOINT `$name`\")");
        return (Publisher)mono;
    }

    @NotNull
    public Publisher<Void> releaseSavepoint(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.assertValidSavepointName(name);
        Mono<Void> mono = this.executeVoid("RELEASE SAVEPOINT `" + name + '`');
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"executeVoid(\"RELEASE SAVEPOINT `$name`\")");
        return (Publisher)mono;
    }

    @NotNull
    public Publisher<Void> rollbackTransactionToSavepoint(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.assertValidSavepointName(name);
        Mono<Void> mono = this.executeVoid("ROLLBACK TO SAVEPOINT `" + name + '`');
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"executeVoid(\"ROLLBACK TO SAVEPOINT `$name`\")");
        return (Publisher)mono;
    }

    @NotNull
    public Publisher<Void> rollbackTransaction() {
        Mono<Void> mono = this.executeVoid("ROLLBACK");
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"executeVoid(\"ROLLBACK\")");
        return (Publisher)mono;
    }

    @NotNull
    public Publisher<Void> setTransactionIsolationLevel(@NotNull IsolationLevel isolationLevel) {
        Intrinsics.checkParameterIsNotNull((Object)isolationLevel, (String)"isolationLevel");
        Mono<Void> mono = this.executeVoid("SET TRANSACTION ISOLATION LEVEL " + isolationLevel.asSql());
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"executeVoid(\"SET TRANSAC\u2026isolationLevel.asSql()}\")");
        return (Publisher)mono;
    }

    @NotNull
    public Statement createStatement(@NotNull String sql) {
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
        return new JasyncStatement(this, sql);
    }

    @NotNull
    public Publisher<Void> close() {
        Mono mono = Mono.defer((Supplier)new Supplier<Mono<? extends T>>(this){
            final /* synthetic */ JasyncClientConnection this$0;

            public final Mono<Void> get() {
                return MonoExtensionsKt.toMono((CompletableFuture)JasyncClientConnection.access$getJasyncConnection$p(this.this$0).disconnect()).then();
            }
            {
                this.this$0 = jasyncClientConnection;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)mono, (String)"Mono.defer { jasyncConne\u2026nnect().toMono().then() }");
        return (Publisher)mono;
    }

    @NotNull
    public Batch createBatch() {
        return new JasyncBatch(this);
    }

    @Override
    @NotNull
    public com.github.jasync.sql.db.Connection get() {
        return this.jasyncConnection;
    }

    private final Mono<Void> executeVoid(String sql) {
        return Mono.defer((Supplier)new Supplier<Mono<? extends T>>(this, sql){
            final /* synthetic */ JasyncClientConnection this$0;
            final /* synthetic */ String $sql;

            public final Mono<Void> get() {
                return MonoExtensionsKt.toMono((CompletableFuture)JasyncClientConnection.access$getJasyncConnection$p(this.this$0).sendQuery(this.$sql)).then();
            }
            {
                this.this$0 = jasyncClientConnection;
                this.$sql = string;
            }
        });
    }

    private final void assertValidSavepointName(String name) {
        CharSequence charSequence = name;
        if (charSequence.length() == 0) {
            throw (Throwable)new IllegalArgumentException("Savepoint name is empty");
        }
        if (StringsKt.indexOf$default((CharSequence)name, (char)'`', (int)0, (boolean)false, (int)6, null) != -1) {
            throw (Throwable)new IllegalArgumentException("Savepoint name must not contain backticks");
        }
    }

    public JasyncClientConnection(@NotNull com.github.jasync.sql.db.Connection jasyncConnection) {
        Intrinsics.checkParameterIsNotNull((Object)jasyncConnection, (String)"jasyncConnection");
        this.jasyncConnection = jasyncConnection;
    }

    public static final /* synthetic */ com.github.jasync.sql.db.Connection access$getJasyncConnection$p(JasyncClientConnection $this) {
        return $this.jasyncConnection;
    }
}

