/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.r2dbc.mysql;

import com.github.jasync.r2dbc.mysql.Bindings;
import com.github.jasync.r2dbc.mysql.JasyncDatabaseException;
import com.github.jasync.r2dbc.mysql.JasyncStatement;
import com.github.jasync.sql.db.Connection;
import com.github.jasync.sql.db.QueryResult;
import com.github.jasync.sql.db.exceptions.ConnectionTimeoutedException;
import com.github.jasync.sql.db.exceptions.InsufficientParametersException;
import com.github.jasync.sql.db.mysql.exceptions.MySQLException;
import com.github.jasync.sql.db.mysql.message.server.ErrorMessage;
import io.r2dbc.spi.R2dbcBadGrammarException;
import io.r2dbc.spi.R2dbcDataIntegrityViolationException;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.R2dbcPermissionDeniedException;
import io.r2dbc.spi.R2dbcTimeoutException;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Statement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxExtensionsKt;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoExtensionsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000e\u001a\u00020\u0001H\u0016J\u0018\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0018\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u001c\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016J\u001c\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016J\u0010\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u0019H\u0016J$\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u00042\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J!\u0010 \u001a\u00020\u00012\u0012\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\"\"\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010#R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/github/jasync/r2dbc/mysql/JasyncStatement;", "Lio/r2dbc/spi/Statement;", "clientSupplier", "Ljava/util/function/Supplier;", "Lcom/github/jasync/sql/db/Connection;", "sql", "", "(Ljava/util/function/Supplier;Ljava/lang/String;)V", "bindings", "Lcom/github/jasync/r2dbc/mysql/Bindings;", "generatedKeyName", "isPrepared", "", "selectLastInsertId", "add", "bind", "identifier", "", "value", "index", "", "bindNull", "type", "Ljava/lang/Class;", "execute", "Lorg/reactivestreams/Publisher;", "Lio/r2dbc/spi/Result;", "extraGeneratedQuery", "Lreactor/core/publisher/Mono;", "Lcom/github/jasync/sql/db/QueryResult;", "connection", "result", "returnGeneratedValues", "columns", "", "([Ljava/lang/String;)Lio/r2dbc/spi/Statement;", "jasync-r2dbc-mysql"})
public final class JasyncStatement
implements Statement {
    private final Bindings bindings;
    private boolean isPrepared;
    private boolean selectLastInsertId;
    private String generatedKeyName;
    private final Supplier<Connection> clientSupplier;
    private final String sql;

    @NotNull
    public Statement returnGeneratedValues(String ... columns) {
        Intrinsics.checkParameterIsNotNull((Object)columns, (String)"columns");
        if (columns.length == 1) {
            this.generatedKeyName = columns[0];
        }
        if (columns.length > 1) {
            throw (Throwable)new IllegalArgumentException("MySQL only supports a single generated value");
        }
        this.selectLastInsertId = true;
        return this;
    }

    @NotNull
    public Statement add() {
        if (this.isPrepared) {
            this.bindings.done();
        }
        return this;
    }

    @NotNull
    public Statement bind(@NotNull Object identifier, @NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)identifier, (String)"identifier");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (identifier instanceof String) {
            String string = (String)identifier;
            JasyncStatement jasyncStatement = this;
            int n = Integer.parseInt(string);
            return jasyncStatement.bind(n, value);
        }
        throw (Throwable)new IllegalArgumentException("cant bind identifier " + identifier + " with value '" + value + '\'');
    }

    @NotNull
    public Statement bind(int index, @NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.isPrepared = true;
        Map<Integer, Object> map2 = this.bindings.current();
        Integer n = index;
        Object object = value;
        map2.put(n, object);
        return this;
    }

    @NotNull
    public Statement bindNull(@NotNull Object identifier, @NotNull Class<?> type) {
        Intrinsics.checkParameterIsNotNull((Object)identifier, (String)"identifier");
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        if (identifier instanceof String) {
            String string = (String)identifier;
            JasyncStatement jasyncStatement = this;
            int n = Integer.parseInt(string);
            return jasyncStatement.bindNull(n, type);
        }
        throw (Throwable)new IllegalArgumentException("cant bind null identifier " + identifier);
    }

    @NotNull
    public Statement bindNull(int index, @NotNull Class<?> type) {
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        this.isPrepared = true;
        Map<Integer, Object> map2 = this.bindings.current();
        Integer n = index;
        Object v = null;
        map2.put(n, v);
        return this;
    }

    @NotNull
    public Publisher<? extends Result> execute() {
        Flux flux = Mono.fromSupplier(this.clientSupplier).flatMapMany(new Function<T, Publisher<? extends R>>(this){
            final /* synthetic */ JasyncStatement this$0;

            public final Publisher<QueryResult> apply(Connection connection) {
                Publisher publisher;
                if (JasyncStatement.access$isPrepared$p(this.this$0)) {
                    Flux allParams2 = FluxExtensionsKt.toFlux((Sequence)SequencesKt.mapIndexed((Sequence)CollectionsKt.asSequence((Iterable)JasyncStatement.access$getBindings$p(this.this$0).all()), (Function2)((Function2)new Function2<Integer, Map<Integer, ? extends Object>, List<? extends Object>>(this){
                        final /* synthetic */ execute.1 this$0;

                        /*
                         * WARNING - void declaration
                         */
                        @NotNull
                        public final List<Object> invoke(int i, @NotNull Map<Integer, ? extends Object> binding) {
                            void $receiver$iv$iv;
                            Iterable $receiver$iv;
                            Intrinsics.checkParameterIsNotNull(binding, (String)"binding");
                            Iterable iterable = $receiver$iv = (Iterable)RangesKt.until((int)0, (int)binding.size());
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                            Iterator<T> iterator = $receiver$iv$iv.iterator();
                            while (iterator.hasNext()) {
                                void it;
                                int item$iv$iv;
                                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                Map<Integer, ? extends Object> map2 = binding;
                                Map<Integer, ? extends Object> map3 = map2;
                                Integer n2 = (int)it;
                                if (!map3.containsKey(n2)) {
                                    throw (Throwable)new IllegalStateException("binding failed with bind index " + i + " and param index " + (int)it + " for query '" + JasyncStatement.access$getSql$p(this.this$0.this$0) + '\'');
                                }
                                Object object = binding.get((int)it);
                                collection.add(object);
                            }
                            return (List)destination$iv$iv;
                        }
                        {
                            this.this$0 = var1_1;
                            super(2);
                        }
                    })));
                    publisher = (Publisher)allParams2.concatMap((Function)new Function<T, Publisher<? extends V>>(this, connection){
                        final /* synthetic */ execute.1 this$0;
                        final /* synthetic */ Connection $connection;

                        @NotNull
                        public final Mono<QueryResult> apply(List<? extends Object> it) {
                            JasyncStatement jasyncStatement = this.this$0.this$0;
                            Connection connection = this.$connection;
                            Intrinsics.checkExpressionValueIsNotNull((Object)connection, (String)"connection");
                            String string = JasyncStatement.access$getSql$p(this.this$0.this$0);
                            List<? extends Object> list = it;
                            Intrinsics.checkExpressionValueIsNotNull(list, (String)"it");
                            return JasyncStatement.access$extraGeneratedQuery(jasyncStatement, connection, MonoExtensionsKt.toMono((CompletableFuture)this.$connection.sendPreparedStatement(string, list)));
                        }
                        {
                            this.this$0 = var1_1;
                            this.$connection = connection;
                        }
                    });
                } else {
                    Connection connection2 = connection;
                    Intrinsics.checkExpressionValueIsNotNull((Object)connection2, (String)"connection");
                    publisher = (Publisher)JasyncStatement.access$extraGeneratedQuery(this.this$0, connection2, MonoExtensionsKt.toMono((CompletableFuture)connection.sendQuery(JasyncStatement.access$getSql$p(this.this$0))));
                }
                return publisher;
            }
            {
                this.this$0 = jasyncStatement;
            }
        }).map((Function)execute.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)flux, (String)"Mono.fromSupplier(client\u2026.rows, it.rowsAffected) }");
        return (Publisher)FluxExtensionsKt.onErrorMap((Flux)flux, (KClass)Reflection.getOrCreateKotlinClass(Throwable.class), (Function1)((Function1)new Function1<Throwable, Throwable>(this){
            final /* synthetic */ JasyncStatement this$0;

            @NotNull
            public final Throwable invoke(@NotNull Throwable throwable) {
                ErrorMessage errorMessage;
                Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
                Throwable throwable2 = throwable;
                return throwable2 instanceof ConnectionTimeoutedException ? (Throwable)new R2dbcTimeoutException(throwable) : (throwable2 instanceof IllegalArgumentException ? throwable : (throwable2 instanceof IllegalStateException ? throwable : (throwable2 instanceof UnsupportedOperationException ? throwable : (throwable2 instanceof IOException ? throwable : (throwable2 instanceof MySQLException ? (Throwable)((errorMessage = ((MySQLException)throwable).getErrorMessage()).getErrorCode() == 1044 ? (R2dbcException)new R2dbcPermissionDeniedException(errorMessage.getErrorMessage(), errorMessage.getSqlState(), errorMessage.getErrorCode(), throwable) : (errorMessage.getErrorCode() == 1045 ? (R2dbcException)new R2dbcPermissionDeniedException(errorMessage.getErrorMessage(), errorMessage.getSqlState(), errorMessage.getErrorCode(), throwable) : (errorMessage.getErrorCode() == 1064 ? (R2dbcException)new R2dbcBadGrammarException(errorMessage.getErrorMessage(), errorMessage.getSqlState(), errorMessage.getErrorCode(), JasyncStatement.access$getSql$p(this.this$0), throwable) : (R2dbcException)new JasyncDatabaseException(errorMessage.getErrorMessage(), errorMessage.getSqlState(), errorMessage.getErrorCode(), throwable)))) : (throwable2 instanceof InsufficientParametersException ? (Throwable)new R2dbcDataIntegrityViolationException(throwable.getMessage(), throwable) : (Throwable)new R2dbcTimeoutException(throwable)))))));
            }
            {
                this.this$0 = jasyncStatement;
                super(1);
            }
        }));
    }

    private final Mono<QueryResult> extraGeneratedQuery(Connection connection, Mono<QueryResult> result) {
        Mono mono;
        if (this.selectLastInsertId) {
            Mono mono2 = result.flatMap(new Function<T, Mono<? extends R>>(this, connection){
                final /* synthetic */ JasyncStatement this$0;
                final /* synthetic */ Connection $connection;

                @NotNull
                public final Mono<QueryResult> apply(QueryResult it) {
                    return MonoExtensionsKt.toMono((CompletableFuture)this.$connection.sendQuery("SELECT LAST_INSERT_ID() AS " + JasyncStatement.access$getGeneratedKeyName$p(this.this$0)));
                }
                {
                    this.this$0 = jasyncStatement;
                    this.$connection = connection;
                }
            });
            mono = mono2;
            Intrinsics.checkExpressionValueIsNotNull((Object)mono2, (String)"result.flatMap { connect\u2026ratedKeyName\").toMono() }");
        } else {
            mono = result;
        }
        return mono;
    }

    public JasyncStatement(@NotNull Supplier<Connection> clientSupplier, @NotNull String sql) {
        Intrinsics.checkParameterIsNotNull(clientSupplier, (String)"clientSupplier");
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
        this.clientSupplier = clientSupplier;
        this.sql = sql;
        this.bindings = new Bindings();
        this.generatedKeyName = "LAST_INSERT_ID";
    }

    public static final /* synthetic */ boolean access$isPrepared$p(JasyncStatement $this) {
        return $this.isPrepared;
    }

    public static final /* synthetic */ void access$setPrepared$p(JasyncStatement $this, boolean bl) {
        $this.isPrepared = bl;
    }

    public static final /* synthetic */ Bindings access$getBindings$p(JasyncStatement $this) {
        return $this.bindings;
    }

    public static final /* synthetic */ String access$getSql$p(JasyncStatement $this) {
        return $this.sql;
    }

    public static final /* synthetic */ Mono access$extraGeneratedQuery(JasyncStatement $this, Connection connection, Mono result) {
        return $this.extraGeneratedQuery(connection, (Mono<QueryResult>)result);
    }

    public static final /* synthetic */ String access$getGeneratedKeyName$p(JasyncStatement $this) {
        return $this.generatedKeyName;
    }

    public static final /* synthetic */ void access$setGeneratedKeyName$p(JasyncStatement $this, String string) {
        $this.generatedKeyName = string;
    }
}

