/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapdb.query;

import java.util.Comparator;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.SortAccessor;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;
import org.springframework.data.mapdb.query.PropertyComparator;
import org.springframework.util.comparator.CompoundComparator;

public class MapDbSortAccessor
implements SortAccessor<Comparator<?>> {
    public Comparator<?> resolve(KeyValueQuery<?> query) {
        if (query == null || query.getSort() == null) {
            return null;
        }
        CompoundComparator compoundComparator = new CompoundComparator();
        for (Sort.Order order : query.getSort()) {
            if (order.getProperty().indexOf(46) > -1) {
                throw new UnsupportedOperationException("Embedded fields not implemented: " + order);
            }
            if (order.isIgnoreCase()) {
                throw new UnsupportedOperationException("Ignore case not implemented: " + order);
            }
            if (Sort.NullHandling.NATIVE != order.getNullHandling()) {
                throw new UnsupportedOperationException("Null handling not implemented: " + order);
            }
            PropertyComparator propertyComparator = new PropertyComparator(order.getProperty(), order.isAscending());
            compoundComparator.addComparator((Comparator)propertyComparator);
        }
        return compoundComparator;
    }
}

