/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapdb.query;

import java.util.Iterator;
import java.util.function.Predicate;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;
import org.springframework.data.mapdb.query.predicates.EqualsPredicate;
import org.springframework.data.mapdb.query.predicates.GreaterLessPredicate;
import org.springframework.data.mapdb.query.predicates.ILikePredicate;
import org.springframework.data.mapdb.query.predicates.LikePredicate;
import org.springframework.data.mapdb.query.predicates.NullCheckPredicate;
import org.springframework.data.mapdb.query.predicates.PropertyPredicate;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

public class QueryCreator
extends AbstractQueryCreator<KeyValueQuery<Predicate<?>>, Predicate<?>> {
    public QueryCreator(PartTree tree) {
        super(tree);
    }

    public QueryCreator(PartTree tree, ParameterAccessor parameters) {
        super(tree, parameters);
    }

    protected Predicate<?> create(Part part, Iterator<Object> iterator) {
        return this.from(part, iterator);
    }

    protected Predicate<?> and(Part part, Predicate<?> base, Iterator<Object> iterator) {
        return base.and(this.from(part, iterator));
    }

    protected Predicate<?> or(Predicate<?> base, Predicate<?> criteria) {
        return base.or(criteria);
    }

    protected KeyValueQuery<Predicate<?>> complete(Predicate<?> criteria, Sort sort) {
        KeyValueQuery keyValueQuery = new KeyValueQuery(criteria);
        if (sort != null) {
            keyValueQuery.setSort(sort);
        }
        return keyValueQuery;
    }

    private Predicate<?> from(Part part, Iterator<Comparable<?>> iterator) {
        String property = part.getProperty().toDotPath();
        Part.Type type = part.getType();
        boolean ignoreCase = part.shouldIgnoreCase() != Part.IgnoreCaseType.NEVER;
        Predicate<Object> predicate = null;
        switch (type) {
            case TRUE: {
                predicate = new EqualsPredicate(true);
                break;
            }
            case FALSE: {
                predicate = new EqualsPredicate(false);
                break;
            }
            case SIMPLE_PROPERTY: {
                if (ignoreCase) {
                    predicate = new ILikePredicate(iterator.next().toString());
                    break;
                }
                predicate = new EqualsPredicate(iterator.next());
                break;
            }
            case GREATER_THAN: 
            case GREATER_THAN_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_EQUAL: {
                predicate = this.fromInequalityVariant(type, ignoreCase, iterator);
                break;
            }
            case LIKE: {
                predicate = new LikePredicate(iterator.next().toString());
                break;
            }
            case IS_NULL: {
                predicate = NullCheckPredicate.isNull();
                break;
            }
            case IS_NOT_NULL: {
                predicate = NullCheckPredicate.notNull();
                break;
            }
            default: {
                throw new InvalidDataAccessApiUsageException(String.format("Found invalid part '%s' in query", type));
            }
        }
        return PropertyPredicate.wrap(predicate, property);
    }

    private Predicate<?> fromInequalityVariant(Part.Type type, boolean ignoreCase, Iterator<Comparable<?>> iterator) {
        if (ignoreCase && type != Part.Type.SIMPLE_PROPERTY) {
            throw new InvalidDataAccessApiUsageException(String.format("Ignore case not supported for '%s'", type));
        }
        switch (type) {
            case GREATER_THAN: {
                return GreaterLessPredicate.gr(iterator.next());
            }
            case GREATER_THAN_EQUAL: {
                return GreaterLessPredicate.ge(iterator.next());
            }
            case LESS_THAN: {
                return GreaterLessPredicate.ls(iterator.next());
            }
            case LESS_THAN_EQUAL: {
                return GreaterLessPredicate.le(iterator.next());
            }
        }
        throw new InvalidDataAccessApiUsageException(String.format("Logic error for '%s' in query", type));
    }
}

