/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapdb.query.predicates;

import java.util.function.Predicate;

public class GreaterLessPredicate
implements Predicate<Object> {
    private final boolean less;
    private final boolean equal;
    private final Comparable<?> value;

    private GreaterLessPredicate(boolean less, boolean equal, Comparable<?> value) {
        this.less = less;
        this.equal = equal;
        this.value = value;
    }

    @Override
    public boolean test(Object input) {
        if (input == null || !Comparable.class.isInstance(input)) {
            return false;
        }
        if (!this.value.getClass().isInstance(input) && !(this.value instanceof Number)) {
            return false;
        }
        Object inputToCompare = input;
        Double valueToCompare = this.value;
        if (this.value instanceof Number) {
            inputToCompare = ((Number)input).doubleValue();
            valueToCompare = ((Number)((Object)this.value)).doubleValue();
        }
        int result = ((Comparable)inputToCompare).compareTo(valueToCompare);
        return this.equal && result == 0 || (this.less ? result < 0 : result > 0);
    }

    public static GreaterLessPredicate le(Comparable<?> value) {
        return new GreaterLessPredicate(true, true, value);
    }

    public static GreaterLessPredicate ls(Comparable<?> value) {
        return new GreaterLessPredicate(true, false, value);
    }

    public static GreaterLessPredicate ge(Comparable<?> value) {
        return new GreaterLessPredicate(false, true, value);
    }

    public static GreaterLessPredicate gr(Comparable<?> value) {
        return new GreaterLessPredicate(false, false, value);
    }
}

