/*
 * Decompiled with CFR 0.152.
 */
package com.liumapp.qtools.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateTool {
    public static Date getEndDateByYearNumber(int year) {
        Calendar calendar = Calendar.getInstance();
        Date date = new Date(System.currentTimeMillis());
        calendar.setTime(date);
        calendar.add(1, year);
        date = calendar.getTime();
        return date;
    }

    public static String getDateString(Date date, String pattern) {
        return new SimpleDateFormat(pattern).format(date);
    }

    public static String getSimpleDateString(Date date) {
        return DateTool.getDateString(date, "yyyyMMddHH");
    }

    public static String getSimpleUTCDateString() {
        return DateTool.getSimpleDateString(DateTool.getUTCDate());
    }

    public static Date getUTCDate() {
        Calendar cal = Calendar.getInstance();
        int zoneOffset = cal.get(15);
        int dstOffset = cal.get(16);
        cal.add(14, -(zoneOffset + dstOffset));
        return cal.getTime();
    }

    public static String getBeiJingLocalTimeFromUTC(String utcDate, String pattern) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        Date UTCDate = format.parse(utcDate);
        format.setTimeZone(TimeZone.getTimeZone("GMT-8"));
        String localTime = format.format(UTCDate);
        return localTime;
    }
}

