/*
 * Decompiled with CFR 0.152.
 */
package com.liumapp.qtools.date;

import com.google.common.collect.Maps;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;

public final class ToolDatePlus {
    private static volatile ZoneId DEFAULT_ZONE_ID = ZoneId.systemDefault();
    private static final Map<String, DateTimeFormatter> DATE_TIME_FORMATTER_MAP = Maps.newConcurrentMap();

    private ToolDatePlus() {
        throw new UnsupportedOperationException("\u6211\u662f\u5de5\u5177\u7c7b\uff0c\u522b\u521d\u59cb\u5316\u6211\u3002\u3002\u3002");
    }

    public static LocalDateTime date2LocalDateTime(Date date) {
        Instant instant = date.toInstant();
        ZonedDateTime zdt = instant.atZone(DEFAULT_ZONE_ID);
        return zdt.toLocalDateTime();
    }

    public static LocalDateTime time2LocalDateTime(long time) {
        return ToolDatePlus.date2LocalDateTime(new Date(time));
    }

    public static Date localDateTime2Date(LocalDateTime localDateTime) {
        Instant instant = localDateTime.atZone(DEFAULT_ZONE_ID).toInstant();
        return Date.from(instant);
    }

    public static long localDateTime2time(LocalDateTime localDateTime) {
        return Timestamp.valueOf(localDateTime).getTime();
    }

    public static String format(Date date, String pattern) {
        return ToolDatePlus.date2LocalDateTime(date).format(DateTimeFormatter.ofPattern(pattern));
    }

    public static ZoneId getDefaultZoneId() {
        return DEFAULT_ZONE_ID;
    }

    public static void setDefaultZoneId(ZoneId defaultZoneId) {
        DEFAULT_ZONE_ID = defaultZoneId;
    }

    public static DateTimeFormatter pattern(String patternStr) {
        DateTimeFormatter result = DATE_TIME_FORMATTER_MAP.get(patternStr);
        if (result == null) {
            result = DateTimeFormatter.ofPattern(patternStr);
            DATE_TIME_FORMATTER_MAP.put(patternStr, result);
        }
        return result;
    }
}

