/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.redis;

import com.lordofthejars.nosqlunit.core.DatabaseOperation;
import com.lordofthejars.nosqlunit.redis.RedisConfiguration;
import com.lordofthejars.nosqlunit.redis.RedisOperation;
import redis.clients.jedis.BinaryJedisCommands;
import redis.clients.jedis.Jedis;

public class ManagedRedisConfigurationBuilder {
    private static final String LOCALHOST = "127.0.0.1";
    private static final int DEFAULT_PORT = 6379;
    private RedisConfiguration redisConfiguration = new RedisConfiguration();

    private ManagedRedisConfigurationBuilder() {
        this.redisConfiguration.setHost(LOCALHOST);
        this.redisConfiguration.setPort(6379);
    }

    public static ManagedRedisConfigurationBuilder newManagedRedisConfiguration() {
        return new ManagedRedisConfigurationBuilder();
    }

    public ManagedRedisConfigurationBuilder port(int port) {
        this.redisConfiguration.setPort(port);
        return this;
    }

    public ManagedRedisConfigurationBuilder connectionIdentifier(String connectionIdentifier) {
        this.redisConfiguration.setConnectionIdentifier(connectionIdentifier);
        return this;
    }

    public ManagedRedisConfigurationBuilder password(String password) {
        this.redisConfiguration.setPassword(password);
        return this;
    }

    public RedisConfiguration build() {
        String status;
        Jedis jedis = new Jedis(this.redisConfiguration.getHost(), this.redisConfiguration.getPort());
        if (this.redisConfiguration.getPassword() != null && !"OK".equalsIgnoreCase(status = jedis.auth(this.redisConfiguration.getPassword()))) {
            throw new IllegalStateException("Password is not valid and Redis access cannot be accept commands.");
        }
        this.redisConfiguration.setDatabaseOperation((DatabaseOperation<? extends BinaryJedisCommands>)new RedisOperation(jedis));
        return this.redisConfiguration;
    }
}

