/*
 * Copyright 2018 mayabot.com authors. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * <summary></summary>
 * <author>He Han</author>
 * <email>hankcs.cn@gmail.com</email>
 * <create-date>2014/11/2 8:05</create-date>
 *
 * <copyright file="Pinyins.java" company="上海林原信息科技有限公司">
 * Copyright (c) 2003-2014, 上海林原信息科技有限公司. All Right Reserved, http://www.linrunsoft.com/
 * This source is subject to the LinrunSpace License. Please contact 上海林原信息科技有限公司 to get more information.
 * </copyright>
 */
package com.mayabot.nlp.pinyin.model;

/**
 * 拼音，组成部分=声母+韵母+声调12345
 * @author hankcs
 */
public enum Pinyin
{
    a1(Shengmu.none, Yunmu.a, 1, "ā", "a", PinyinHead.a, 'a'),
    a2(Shengmu.none, Yunmu.a, 2, "á", "a", PinyinHead.a, 'a'),
    a3(Shengmu.none, Yunmu.a, 3, "ǎ", "a", PinyinHead.a, 'a'),
    a4(Shengmu.none, Yunmu.a, 4, "à", "a", PinyinHead.a, 'a'),
    a5(Shengmu.none, Yunmu.a, 5, "a", "a", PinyinHead.a, 'a'),
    ai1(Shengmu.none, Yunmu.ai, 1, "āi", "ai", PinyinHead.a, 'a'),
    ai2(Shengmu.none, Yunmu.ai, 2, "ái", "ai", PinyinHead.a, 'a'),
    ai3(Shengmu.none, Yunmu.ai, 3, "ǎi", "ai", PinyinHead.a, 'a'),
    ai4(Shengmu.none, Yunmu.ai, 4, "ài", "ai", PinyinHead.a, 'a'),
    an1(Shengmu.none, Yunmu.an, 1, "ān", "an", PinyinHead.a, 'a'),
    an2(Shengmu.none, Yunmu.an, 2, "án", "an", PinyinHead.a, 'a'),
    an3(Shengmu.none, Yunmu.an, 3, "ǎn", "an", PinyinHead.a, 'a'),
    an4(Shengmu.none, Yunmu.an, 4, "àn", "an", PinyinHead.a, 'a'),
    ang1(Shengmu.none, Yunmu.ang, 1, "āng", "ang", PinyinHead.a, 'a'),
    ang2(Shengmu.none, Yunmu.ang, 2, "áng", "ang", PinyinHead.a, 'a'),
    ang3(Shengmu.none, Yunmu.ang, 3, "ǎng", "ang", PinyinHead.a, 'a'),
    ang4(Shengmu.none, Yunmu.ang, 4, "àng", "ang", PinyinHead.a, 'a'),
    ao1(Shengmu.none, Yunmu.ao, 1, "āo", "ao", PinyinHead.a, 'a'),
    ao2(Shengmu.none, Yunmu.ao, 2, "áo", "ao", PinyinHead.a, 'a'),
    ao3(Shengmu.none, Yunmu.ao, 3, "ǎo", "ao", PinyinHead.a, 'a'),
    ao4(Shengmu.none, Yunmu.ao, 4, "ào", "ao", PinyinHead.a, 'a'),
    ba1(Shengmu.b, Yunmu.a, 1, "bā", "ba", PinyinHead.b, 'b'),
    ba2(Shengmu.b, Yunmu.a, 2, "bá", "ba", PinyinHead.b, 'b'),
    ba3(Shengmu.b, Yunmu.a, 3, "bǎ", "ba", PinyinHead.b, 'b'),
    ba4(Shengmu.b, Yunmu.a, 4, "bà", "ba", PinyinHead.b, 'b'),
    ba5(Shengmu.b, Yunmu.a, 5, "ba", "ba", PinyinHead.b, 'b'),
    bai1(Shengmu.b, Yunmu.ai, 1, "bāi", "bai", PinyinHead.b, 'b'),
    bai2(Shengmu.b, Yunmu.ai, 2, "bái", "bai", PinyinHead.b, 'b'),
    bai3(Shengmu.b, Yunmu.ai, 3, "bǎi", "bai", PinyinHead.b, 'b'),
    bai4(Shengmu.b, Yunmu.ai, 4, "bài", "bai", PinyinHead.b, 'b'),
    ban1(Shengmu.b, Yunmu.an, 1, "bān", "ban", PinyinHead.b, 'b'),
    ban3(Shengmu.b, Yunmu.an, 3, "bǎn", "ban", PinyinHead.b, 'b'),
    ban4(Shengmu.b, Yunmu.an, 4, "bàn", "ban", PinyinHead.b, 'b'),
    bang1(Shengmu.b, Yunmu.ang, 1, "bāng", "bang", PinyinHead.b, 'b'),
    bang3(Shengmu.b, Yunmu.ang, 3, "bǎng", "bang", PinyinHead.b, 'b'),
    bang4(Shengmu.b, Yunmu.ang, 4, "bàng", "bang", PinyinHead.b, 'b'),
    bao1(Shengmu.b, Yunmu.ao, 1, "bāo", "bao", PinyinHead.b, 'b'),
    bao2(Shengmu.b, Yunmu.ao, 2, "báo", "bao", PinyinHead.b, 'b'),
    bao3(Shengmu.b, Yunmu.ao, 3, "bǎo", "bao", PinyinHead.b, 'b'),
    bao4(Shengmu.b, Yunmu.ao, 4, "bào", "bao", PinyinHead.b, 'b'),
    bei1(Shengmu.b, Yunmu.ei, 1, "bēi", "bei", PinyinHead.b, 'b'),
    bei3(Shengmu.b, Yunmu.ei, 3, "běi", "bei", PinyinHead.b, 'b'),
    bei4(Shengmu.b, Yunmu.ei, 4, "bèi", "bei", PinyinHead.b, 'b'),
    bei5(Shengmu.b, Yunmu.ei, 5, "bei", "bei", PinyinHead.b, 'b'),
    ben1(Shengmu.b, Yunmu.en, 1, "bēn", "ben", PinyinHead.b, 'b'),
    ben3(Shengmu.b, Yunmu.en, 3, "běn", "ben", PinyinHead.b, 'b'),
    ben4(Shengmu.b, Yunmu.en, 4, "bèn", "ben", PinyinHead.b, 'b'),
    beng1(Shengmu.b, Yunmu.eng, 1, "bēng", "beng", PinyinHead.b, 'b'),
    beng2(Shengmu.b, Yunmu.eng, 2, "béng", "beng", PinyinHead.b, 'b'),
    beng3(Shengmu.b, Yunmu.eng, 3, "běng", "beng", PinyinHead.b, 'b'),
    beng4(Shengmu.b, Yunmu.eng, 4, "bèng", "beng", PinyinHead.b, 'b'),
    bi1(Shengmu.b, Yunmu.i, 1, "bī", "bi", PinyinHead.b, 'b'),
    bi2(Shengmu.b, Yunmu.i, 2, "bí", "bi", PinyinHead.b, 'b'),
    bi3(Shengmu.b, Yunmu.i, 3, "bǐ", "bi", PinyinHead.b, 'b'),
    bi4(Shengmu.b, Yunmu.i, 4, "bì", "bi", PinyinHead.b, 'b'),
    bian1(Shengmu.b, Yunmu.ian, 1, "biān", "bian", PinyinHead.b, 'b'),
    bian3(Shengmu.b, Yunmu.ian, 3, "biǎn", "bian", PinyinHead.b, 'b'),
    bian4(Shengmu.b, Yunmu.ian, 4, "biàn", "bian", PinyinHead.b, 'b'),
    bian5(Shengmu.b, Yunmu.ian, 5, "bian", "bian", PinyinHead.b, 'b'),
    biao1(Shengmu.b, Yunmu.iao, 1, "biāo", "biao", PinyinHead.b, 'b'),
    biao2(Shengmu.b, Yunmu.iao, 2, "biáo", "biao", PinyinHead.b, 'b'),
    biao3(Shengmu.b, Yunmu.iao, 3, "biǎo", "biao", PinyinHead.b, 'b'),
    biao4(Shengmu.b, Yunmu.iao, 4, "biào", "biao", PinyinHead.b, 'b'),
    bie1(Shengmu.b, Yunmu.ie, 1, "biē", "bie", PinyinHead.b, 'b'),
    bie2(Shengmu.b, Yunmu.ie, 2, "bié", "bie", PinyinHead.b, 'b'),
    bie3(Shengmu.b, Yunmu.ie, 3, "biě", "bie", PinyinHead.b, 'b'),
    bie4(Shengmu.b, Yunmu.ie, 4, "biè", "bie", PinyinHead.b, 'b'),
    bin1(Shengmu.b, Yunmu.in, 1, "bīn", "bin", PinyinHead.b, 'b'),
    bin3(Shengmu.b, Yunmu.in, 3, "bǐn", "bin", PinyinHead.b, 'b'),
    bin4(Shengmu.b, Yunmu.in, 4, "bìn", "bin", PinyinHead.b, 'b'),
    bing1(Shengmu.b, Yunmu.ing, 1, "bīng", "bing", PinyinHead.b, 'b'),
    bing3(Shengmu.b, Yunmu.ing, 3, "bǐng", "bing", PinyinHead.b, 'b'),
    bing4(Shengmu.b, Yunmu.ing, 4, "bìng", "bing", PinyinHead.b, 'b'),
    bo1(Shengmu.b, Yunmu.o, 1, "bō", "bo", PinyinHead.b, 'b'),
    bo2(Shengmu.b, Yunmu.o, 2, "bó", "bo", PinyinHead.b, 'b'),
    bo3(Shengmu.b, Yunmu.o, 3, "bǒ", "bo", PinyinHead.b, 'b'),
    bo4(Shengmu.b, Yunmu.o, 4, "bò", "bo", PinyinHead.b, 'b'),
    bo5(Shengmu.b, Yunmu.o, 5, "bo", "bo", PinyinHead.b, 'b'),
    bu1(Shengmu.b, Yunmu.u, 1, "bū", "bu", PinyinHead.b, 'b'),
    bu2(Shengmu.b, Yunmu.u, 2, "bú", "bu", PinyinHead.b, 'b'),
    bu3(Shengmu.b, Yunmu.u, 3, "bǔ", "bu", PinyinHead.b, 'b'),
    bu4(Shengmu.b, Yunmu.u, 4, "bù", "bu", PinyinHead.b, 'b'),
    ca1(Shengmu.c, Yunmu.a, 1, "cā", "ca", PinyinHead.c, 'c'),
    ca3(Shengmu.c, Yunmu.a, 3, "cǎ", "ca", PinyinHead.c, 'c'),
    ca4(Shengmu.c, Yunmu.a, 4, "cà", "ca", PinyinHead.c, 'c'),
    cai1(Shengmu.c, Yunmu.ai, 1, "cāi", "cai", PinyinHead.c, 'c'),
    cai2(Shengmu.c, Yunmu.ai, 2, "cái", "cai", PinyinHead.c, 'c'),
    cai3(Shengmu.c, Yunmu.ai, 3, "cǎi", "cai", PinyinHead.c, 'c'),
    cai4(Shengmu.c, Yunmu.ai, 4, "cài", "cai", PinyinHead.c, 'c'),
    can1(Shengmu.c, Yunmu.an, 1, "cān", "can", PinyinHead.c, 'c'),
    can2(Shengmu.c, Yunmu.an, 2, "cán", "can", PinyinHead.c, 'c'),
    can3(Shengmu.c, Yunmu.an, 3, "cǎn", "can", PinyinHead.c, 'c'),
    can4(Shengmu.c, Yunmu.an, 4, "càn", "can", PinyinHead.c, 'c'),
    cang1(Shengmu.c, Yunmu.ang, 1, "cāng", "cang", PinyinHead.c, 'c'),
    cang2(Shengmu.c, Yunmu.ang, 2, "cáng", "cang", PinyinHead.c, 'c'),
    cang3(Shengmu.c, Yunmu.ang, 3, "cǎng", "cang", PinyinHead.c, 'c'),
    cang4(Shengmu.c, Yunmu.ang, 4, "càng", "cang", PinyinHead.c, 'c'),
    cao1(Shengmu.c, Yunmu.ao, 1, "cāo", "cao", PinyinHead.c, 'c'),
    cao2(Shengmu.c, Yunmu.ao, 2, "cáo", "cao", PinyinHead.c, 'c'),
    cao3(Shengmu.c, Yunmu.ao, 3, "cǎo", "cao", PinyinHead.c, 'c'),
    cao4(Shengmu.c, Yunmu.ao, 4, "cào", "cao", PinyinHead.c, 'c'),
    ce4(Shengmu.c, Yunmu.e, 4, "cè", "ce", PinyinHead.c, 'c'),
    cen1(Shengmu.c, Yunmu.en, 1, "cēn", "cen", PinyinHead.c, 'c'),
    cen2(Shengmu.c, Yunmu.en, 2, "cén", "cen", PinyinHead.c, 'c'),
    ceng1(Shengmu.c, Yunmu.eng, 1, "cēng", "ceng", PinyinHead.c, 'c'),
    ceng2(Shengmu.c, Yunmu.eng, 2, "céng", "ceng", PinyinHead.c, 'c'),
    ceng4(Shengmu.c, Yunmu.eng, 4, "cèng", "ceng", PinyinHead.c, 'c'),
    cha1(Shengmu.ch, Yunmu.a, 1, "chā", "cha", PinyinHead.ch, 'c'),
    cha2(Shengmu.ch, Yunmu.a, 2, "chá", "cha", PinyinHead.ch, 'c'),
    cha3(Shengmu.ch, Yunmu.a, 3, "chǎ", "cha", PinyinHead.ch, 'c'),
    cha4(Shengmu.ch, Yunmu.a, 4, "chà", "cha", PinyinHead.ch, 'c'),
    cha5(Shengmu.ch, Yunmu.a, 5, "cha", "cha", PinyinHead.ch, 'c'),
    chai1(Shengmu.ch, Yunmu.ai, 1, "chāi", "chai", PinyinHead.ch, 'c'),
    chai2(Shengmu.ch, Yunmu.ai, 2, "chái", "chai", PinyinHead.ch, 'c'),
    chai3(Shengmu.ch, Yunmu.ai, 3, "chǎi", "chai", PinyinHead.ch, 'c'),
    chai4(Shengmu.ch, Yunmu.ai, 4, "chài", "chai", PinyinHead.ch, 'c'),
    chan1(Shengmu.ch, Yunmu.an, 1, "chān", "chan", PinyinHead.ch, 'c'),
    chan2(Shengmu.ch, Yunmu.an, 2, "chán", "chan", PinyinHead.ch, 'c'),
    chan3(Shengmu.ch, Yunmu.an, 3, "chǎn", "chan", PinyinHead.ch, 'c'),
    chan4(Shengmu.ch, Yunmu.an, 4, "chàn", "chan", PinyinHead.ch, 'c'),
    chang1(Shengmu.ch, Yunmu.ang, 1, "chāng", "chang", PinyinHead.ch, 'c'),
    chang2(Shengmu.ch, Yunmu.ang, 2, "cháng", "chang", PinyinHead.ch, 'c'),
    chang3(Shengmu.ch, Yunmu.ang, 3, "chǎng", "chang", PinyinHead.ch, 'c'),
    chang4(Shengmu.ch, Yunmu.ang, 4, "chàng", "chang", PinyinHead.ch, 'c'),
    chang5(Shengmu.ch, Yunmu.ang, 5, "chang", "chang", PinyinHead.ch, 'c'),
    chao1(Shengmu.ch, Yunmu.ao, 1, "chāo", "chao", PinyinHead.ch, 'c'),
    chao2(Shengmu.ch, Yunmu.ao, 2, "cháo", "chao", PinyinHead.ch, 'c'),
    chao3(Shengmu.ch, Yunmu.ao, 3, "chǎo", "chao", PinyinHead.ch, 'c'),
    chao4(Shengmu.ch, Yunmu.ao, 4, "chào", "chao", PinyinHead.ch, 'c'),
    che1(Shengmu.ch, Yunmu.e, 1, "chē", "che", PinyinHead.ch, 'c'),
    che3(Shengmu.ch, Yunmu.e, 3, "chě", "che", PinyinHead.ch, 'c'),
    che4(Shengmu.ch, Yunmu.e, 4, "chè", "che", PinyinHead.ch, 'c'),
    chen1(Shengmu.ch, Yunmu.en, 1, "chēn", "chen", PinyinHead.ch, 'c'),
    chen2(Shengmu.ch, Yunmu.en, 2, "chén", "chen", PinyinHead.ch, 'c'),
    chen3(Shengmu.ch, Yunmu.en, 3, "chěn", "chen", PinyinHead.ch, 'c'),
    chen4(Shengmu.ch, Yunmu.en, 4, "chèn", "chen", PinyinHead.ch, 'c'),
    chen5(Shengmu.ch, Yunmu.en, 5, "chen", "chen", PinyinHead.ch, 'c'),
    cheng1(Shengmu.ch, Yunmu.eng, 1, "chēng", "cheng", PinyinHead.ch, 'c'),
    cheng2(Shengmu.ch, Yunmu.eng, 2, "chéng", "cheng", PinyinHead.ch, 'c'),
    cheng3(Shengmu.ch, Yunmu.eng, 3, "chěng", "cheng", PinyinHead.ch, 'c'),
    cheng4(Shengmu.ch, Yunmu.eng, 4, "chèng", "cheng", PinyinHead.ch, 'c'),
    chi1(Shengmu.ch, Yunmu.i, 1, "chī", "chi", PinyinHead.ch, 'c'),
    chi2(Shengmu.ch, Yunmu.i, 2, "chí", "chi", PinyinHead.ch, 'c'),
    chi3(Shengmu.ch, Yunmu.i, 3, "chǐ", "chi", PinyinHead.ch, 'c'),
    chi4(Shengmu.ch, Yunmu.i, 4, "chì", "chi", PinyinHead.ch, 'c'),
    chi5(Shengmu.ch, Yunmu.i, 5, "chi", "chi", PinyinHead.ch, 'c'),
    chong1(Shengmu.ch, Yunmu.ong, 1, "chōng", "chong", PinyinHead.ch, 'c'),
    chong2(Shengmu.ch, Yunmu.ong, 2, "chóng", "chong", PinyinHead.ch, 'c'),
    chong3(Shengmu.ch, Yunmu.ong, 3, "chǒng", "chong", PinyinHead.ch, 'c'),
    chong4(Shengmu.ch, Yunmu.ong, 4, "chòng", "chong", PinyinHead.ch, 'c'),
    chou1(Shengmu.ch, Yunmu.ou, 1, "chōu", "chou", PinyinHead.ch, 'c'),
    chou2(Shengmu.ch, Yunmu.ou, 2, "chóu", "chou", PinyinHead.ch, 'c'),
    chou3(Shengmu.ch, Yunmu.ou, 3, "chǒu", "chou", PinyinHead.ch, 'c'),
    chou4(Shengmu.ch, Yunmu.ou, 4, "chòu", "chou", PinyinHead.ch, 'c'),
    chou5(Shengmu.ch, Yunmu.ou, 5, "chou", "chou", PinyinHead.ch, 'c'),
    chu1(Shengmu.ch, Yunmu.u, 1, "chū", "chu", PinyinHead.ch, 'c'),
    chu2(Shengmu.ch, Yunmu.u, 2, "chú", "chu", PinyinHead.ch, 'c'),
    chu3(Shengmu.ch, Yunmu.u, 3, "chǔ", "chu", PinyinHead.ch, 'c'),
    chu4(Shengmu.ch, Yunmu.u, 4, "chù", "chu", PinyinHead.ch, 'c'),
    chu5(Shengmu.ch, Yunmu.u, 5, "chu", "chu", PinyinHead.ch, 'c'),
    chua1(Shengmu.ch, Yunmu.ua, 1, "chuā", "chua", PinyinHead.ch, 'c'),
    chuai1(Shengmu.ch, Yunmu.uai, 1, "chuāi", "chuai", PinyinHead.ch, 'c'),
    chuai2(Shengmu.ch, Yunmu.uai, 2, "chuái", "chuai", PinyinHead.ch, 'c'),
    chuai3(Shengmu.ch, Yunmu.uai, 3, "chuǎi", "chuai", PinyinHead.ch, 'c'),
    chuai4(Shengmu.ch, Yunmu.uai, 4, "chuài", "chuai", PinyinHead.ch, 'c'),
    chuan1(Shengmu.ch, Yunmu.uan, 1, "chuān", "chuan", PinyinHead.ch, 'c'),
    chuan2(Shengmu.ch, Yunmu.uan, 2, "chuán", "chuan", PinyinHead.ch, 'c'),
    chuan3(Shengmu.ch, Yunmu.uan, 3, "chuǎn", "chuan", PinyinHead.ch, 'c'),
    chuan4(Shengmu.ch, Yunmu.uan, 4, "chuàn", "chuan", PinyinHead.ch, 'c'),
    chuang1(Shengmu.ch, Yunmu.uang, 1, "chuāng", "chuang", PinyinHead.ch, 'c'),
    chuang2(Shengmu.ch, Yunmu.uang, 2, "chuáng", "chuang", PinyinHead.ch, 'c'),
    chuang3(Shengmu.ch, Yunmu.uang, 3, "chuǎng", "chuang", PinyinHead.ch, 'c'),
    chuang4(Shengmu.ch, Yunmu.uang, 4, "chuàng", "chuang", PinyinHead.ch, 'c'),
    chui1(Shengmu.ch, Yunmu.ui, 1, "chuī", "chui", PinyinHead.ch, 'c'),
    chui2(Shengmu.ch, Yunmu.ui, 2, "chuí", "chui", PinyinHead.ch, 'c'),
    chui4(Shengmu.ch, Yunmu.ui, 4, "chuì", "chui", PinyinHead.ch, 'c'),
    chun1(Shengmu.ch, Yunmu.un, 1, "chūn", "chun", PinyinHead.ch, 'c'),
    chun2(Shengmu.ch, Yunmu.un, 2, "chún", "chun", PinyinHead.ch, 'c'),
    chun3(Shengmu.ch, Yunmu.un, 3, "chǔn", "chun", PinyinHead.ch, 'c'),
    chuo1(Shengmu.ch, Yunmu.uo, 1, "chuō", "chuo", PinyinHead.ch, 'c'),
    chuo2(Shengmu.ch, Yunmu.uo, 2, "chuó", "chuo", PinyinHead.ch, 'c'),
    chuo4(Shengmu.ch, Yunmu.uo, 4, "chuò", "chuo", PinyinHead.ch, 'c'),
    chuo5(Shengmu.ch, Yunmu.uo, 5, "chuo", "chuo", PinyinHead.ch, 'c'),
    ci1(Shengmu.c, Yunmu.i, 1, "cī", "ci", PinyinHead.c, 'c'),
    ci2(Shengmu.c, Yunmu.i, 2, "cí", "ci", PinyinHead.c, 'c'),
    ci3(Shengmu.c, Yunmu.i, 3, "cǐ", "ci", PinyinHead.c, 'c'),
    ci4(Shengmu.c, Yunmu.i, 4, "cì", "ci", PinyinHead.c, 'c'),
    cong1(Shengmu.c, Yunmu.ong, 1, "cōng", "cong", PinyinHead.c, 'c'),
    cong2(Shengmu.c, Yunmu.ong, 2, "cóng", "cong", PinyinHead.c, 'c'),
    cong4(Shengmu.c, Yunmu.ong, 4, "còng", "cong", PinyinHead.c, 'c'),
    cou3(Shengmu.c, Yunmu.ou, 3, "cǒu", "cou", PinyinHead.c, 'c'),
    cou4(Shengmu.c, Yunmu.ou, 4, "còu", "cou", PinyinHead.c, 'c'),
    cu1(Shengmu.c, Yunmu.u, 1, "cū", "cu", PinyinHead.c, 'c'),
    cu2(Shengmu.c, Yunmu.u, 2, "cú", "cu", PinyinHead.c, 'c'),
    cu3(Shengmu.c, Yunmu.u, 3, "cǔ", "cu", PinyinHead.c, 'c'),
    cu4(Shengmu.c, Yunmu.u, 4, "cù", "cu", PinyinHead.c, 'c'),
    cuan1(Shengmu.c, Yunmu.uan, 1, "cuān", "cuan", PinyinHead.c, 'c'),
    cuan2(Shengmu.c, Yunmu.uan, 2, "cuán", "cuan", PinyinHead.c, 'c'),
    cuan4(Shengmu.c, Yunmu.uan, 4, "cuàn", "cuan", PinyinHead.c, 'c'),
    cui1(Shengmu.c, Yunmu.ui, 1, "cuī", "cui", PinyinHead.c, 'c'),
    cui2(Shengmu.c, Yunmu.ui, 2, "cuí", "cui", PinyinHead.c, 'c'),
    cui3(Shengmu.c, Yunmu.ui, 3, "cuǐ", "cui", PinyinHead.c, 'c'),
    cui4(Shengmu.c, Yunmu.ui, 4, "cuì", "cui", PinyinHead.c, 'c'),
    cun1(Shengmu.c, Yunmu.un, 1, "cūn", "cun", PinyinHead.c, 'c'),
    cun2(Shengmu.c, Yunmu.un, 2, "cún", "cun", PinyinHead.c, 'c'),
    cun3(Shengmu.c, Yunmu.un, 3, "cǔn", "cun", PinyinHead.c, 'c'),
    cun4(Shengmu.c, Yunmu.un, 4, "cùn", "cun", PinyinHead.c, 'c'),
    cuo1(Shengmu.c, Yunmu.uo, 1, "cuō", "cuo", PinyinHead.c, 'c'),
    cuo2(Shengmu.c, Yunmu.uo, 2, "cuó", "cuo", PinyinHead.c, 'c'),
    cuo3(Shengmu.c, Yunmu.uo, 3, "cuǒ", "cuo", PinyinHead.c, 'c'),
    cuo4(Shengmu.c, Yunmu.uo, 4, "cuò", "cuo", PinyinHead.c, 'c'),
    da1(Shengmu.d, Yunmu.a, 1, "dā", "da", PinyinHead.d, 'd'),
    da2(Shengmu.d, Yunmu.a, 2, "dá", "da", PinyinHead.d, 'd'),
    da3(Shengmu.d, Yunmu.a, 3, "dǎ", "da", PinyinHead.d, 'd'),
    da4(Shengmu.d, Yunmu.a, 4, "dà", "da", PinyinHead.d, 'd'),
    da5(Shengmu.d, Yunmu.a, 5, "da", "da", PinyinHead.d, 'd'),
    dai1(Shengmu.d, Yunmu.ai, 1, "dāi", "dai", PinyinHead.d, 'd'),
    dai3(Shengmu.d, Yunmu.ai, 3, "dǎi", "dai", PinyinHead.d, 'd'),
    dai4(Shengmu.d, Yunmu.ai, 4, "dài", "dai", PinyinHead.d, 'd'),
    dan1(Shengmu.d, Yunmu.an, 1, "dān", "dan", PinyinHead.d, 'd'),
    dan2(Shengmu.d, Yunmu.an, 2, "dán", "dan", PinyinHead.d, 'd'),
    dan3(Shengmu.d, Yunmu.an, 3, "dǎn", "dan", PinyinHead.d, 'd'),
    dan4(Shengmu.d, Yunmu.an, 4, "dàn", "dan", PinyinHead.d, 'd'),
    dang1(Shengmu.d, Yunmu.ang, 1, "dāng", "dang", PinyinHead.d, 'd'),
    dang3(Shengmu.d, Yunmu.ang, 3, "dǎng", "dang", PinyinHead.d, 'd'),
    dang4(Shengmu.d, Yunmu.ang, 4, "dàng", "dang", PinyinHead.d, 'd'),
    dao1(Shengmu.d, Yunmu.ao, 1, "dāo", "dao", PinyinHead.d, 'd'),
    dao2(Shengmu.d, Yunmu.ao, 2, "dáo", "dao", PinyinHead.d, 'd'),
    dao3(Shengmu.d, Yunmu.ao, 3, "dǎo", "dao", PinyinHead.d, 'd'),
    dao4(Shengmu.d, Yunmu.ao, 4, "dào", "dao", PinyinHead.d, 'd'),
    de1(Shengmu.d, Yunmu.e, 1, "dē", "de", PinyinHead.d, 'd'),
    de2(Shengmu.d, Yunmu.e, 2, "dé", "de", PinyinHead.d, 'd'),
    de5(Shengmu.d, Yunmu.e, 5, "de", "de", PinyinHead.d, 'd'),
    dei1(Shengmu.d, Yunmu.ei, 1, "dēi", "dei", PinyinHead.d, 'd'),
    dei3(Shengmu.d, Yunmu.ei, 3, "děi", "dei", PinyinHead.d, 'd'),
    den1(Shengmu.d, Yunmu.en, 1, "dēn", "den", PinyinHead.d, 'd'),
    den4(Shengmu.d, Yunmu.en, 4, "dèn", "den", PinyinHead.d, 'd'),
    deng1(Shengmu.d, Yunmu.eng, 1, "dēng", "deng", PinyinHead.d, 'd'),
    deng3(Shengmu.d, Yunmu.eng, 3, "děng", "deng", PinyinHead.d, 'd'),
    deng4(Shengmu.d, Yunmu.eng, 4, "dèng", "deng", PinyinHead.d, 'd'),
    di1(Shengmu.d, Yunmu.i, 1, "dī", "di", PinyinHead.d, 'd'),
    di2(Shengmu.d, Yunmu.i, 2, "dí", "di", PinyinHead.d, 'd'),
    di3(Shengmu.d, Yunmu.i, 3, "dǐ", "di", PinyinHead.d, 'd'),
    di4(Shengmu.d, Yunmu.i, 4, "dì", "di", PinyinHead.d, 'd'),
    dia3(Shengmu.d, Yunmu.ia, 3, "diǎ", "dia", PinyinHead.d, 'd'),
    dian1(Shengmu.d, Yunmu.ian, 1, "diān", "dian", PinyinHead.d, 'd'),
    dian3(Shengmu.d, Yunmu.ian, 3, "diǎn", "dian", PinyinHead.d, 'd'),
    dian4(Shengmu.d, Yunmu.ian, 4, "diàn", "dian", PinyinHead.d, 'd'),
    diao1(Shengmu.d, Yunmu.iao, 1, "diāo", "diao", PinyinHead.d, 'd'),
    diao3(Shengmu.d, Yunmu.iao, 3, "diǎo", "diao", PinyinHead.d, 'd'),
    diao4(Shengmu.d, Yunmu.iao, 4, "diào", "diao", PinyinHead.d, 'd'),
    die1(Shengmu.d, Yunmu.ie, 1, "diē", "die", PinyinHead.d, 'd'),
    die2(Shengmu.d, Yunmu.ie, 2, "dié", "die", PinyinHead.d, 'd'),
    die4(Shengmu.d, Yunmu.ie, 4, "diè", "die", PinyinHead.d, 'd'),
    ding1(Shengmu.d, Yunmu.ing, 1, "dīng", "ding", PinyinHead.d, 'd'),
    ding2(Shengmu.d, Yunmu.ing, 2, "díng", "ding", PinyinHead.d, 'd'),
    ding3(Shengmu.d, Yunmu.ing, 3, "dǐng", "ding", PinyinHead.d, 'd'),
    ding4(Shengmu.d, Yunmu.ing, 4, "dìng", "ding", PinyinHead.d, 'd'),
    diu1(Shengmu.d, Yunmu.iu, 1, "diū", "diu", PinyinHead.d, 'd'),
    dong1(Shengmu.d, Yunmu.ong, 1, "dōng", "dong", PinyinHead.d, 'd'),
    dong3(Shengmu.d, Yunmu.ong, 3, "dǒng", "dong", PinyinHead.d, 'd'),
    dong4(Shengmu.d, Yunmu.ong, 4, "dòng", "dong", PinyinHead.d, 'd'),
    dou1(Shengmu.d, Yunmu.ou, 1, "dōu", "dou", PinyinHead.d, 'd'),
    dou2(Shengmu.d, Yunmu.ou, 2, "dóu", "dou", PinyinHead.d, 'd'),
    dou3(Shengmu.d, Yunmu.ou, 3, "dǒu", "dou", PinyinHead.d, 'd'),
    dou4(Shengmu.d, Yunmu.ou, 4, "dòu", "dou", PinyinHead.d, 'd'),
    du1(Shengmu.d, Yunmu.u, 1, "dū", "du", PinyinHead.d, 'd'),
    du2(Shengmu.d, Yunmu.u, 2, "dú", "du", PinyinHead.d, 'd'),
    du3(Shengmu.d, Yunmu.u, 3, "dǔ", "du", PinyinHead.d, 'd'),
    du4(Shengmu.d, Yunmu.u, 4, "dù", "du", PinyinHead.d, 'd'),
    duan1(Shengmu.d, Yunmu.uan, 1, "duān", "duan", PinyinHead.d, 'd'),
    duan3(Shengmu.d, Yunmu.uan, 3, "duǎn", "duan", PinyinHead.d, 'd'),
    duan4(Shengmu.d, Yunmu.uan, 4, "duàn", "duan", PinyinHead.d, 'd'),
    dui1(Shengmu.d, Yunmu.ui, 1, "duī", "dui", PinyinHead.d, 'd'),
    dui3(Shengmu.d, Yunmu.ui, 3, "duǐ", "dui", PinyinHead.d, 'd'),
    dui4(Shengmu.d, Yunmu.ui, 4, "duì", "dui", PinyinHead.d, 'd'),
    dun1(Shengmu.d, Yunmu.un, 1, "dūn", "dun", PinyinHead.d, 'd'),
    dun2(Shengmu.d, Yunmu.un, 2, "dún", "dun", PinyinHead.d, 'd'),
    dun3(Shengmu.d, Yunmu.un, 3, "dǔn", "dun", PinyinHead.d, 'd'),
    dun4(Shengmu.d, Yunmu.un, 4, "dùn", "dun", PinyinHead.d, 'd'),
    duo1(Shengmu.d, Yunmu.uo, 1, "duō", "duo", PinyinHead.d, 'd'),
    duo2(Shengmu.d, Yunmu.uo, 2, "duó", "duo", PinyinHead.d, 'd'),
    duo3(Shengmu.d, Yunmu.uo, 3, "duǒ", "duo", PinyinHead.d, 'd'),
    duo4(Shengmu.d, Yunmu.uo, 4, "duò", "duo", PinyinHead.d, 'd'),
    duo5(Shengmu.d, Yunmu.uo, 5, "duo", "duo", PinyinHead.d, 'd'),
    e1(Shengmu.none, Yunmu.e, 1, "ē", "e", PinyinHead.e, 'e'),
    e2(Shengmu.none, Yunmu.e, 2, "é", "e", PinyinHead.e, 'e'),
    e3(Shengmu.none, Yunmu.e, 3, "ě", "e", PinyinHead.e, 'e'),
    e4(Shengmu.none, Yunmu.e, 4, "è", "e", PinyinHead.e, 'e'),
    ei1(Shengmu.none, Yunmu.ei, 1, "ēi", "ei", PinyinHead.e, 'e'),
    ei2(Shengmu.none, Yunmu.ei, 2, "éi", "ei", PinyinHead.e, 'e'),
    ei3(Shengmu.none, Yunmu.ei, 3, "ěi", "ei", PinyinHead.e, 'e'),
    ei4(Shengmu.none, Yunmu.ei, 4, "èi", "ei", PinyinHead.e, 'e'),
    en1(Shengmu.none, Yunmu.en, 1, "ēn", "en", PinyinHead.e, 'e'),
    en3(Shengmu.none, Yunmu.en, 3, "ěn", "en", PinyinHead.e, 'e'),
    en4(Shengmu.none, Yunmu.en, 4, "èn", "en", PinyinHead.e, 'e'),
    eng1(Shengmu.none, Yunmu.eng, 1, "ēng", "eng", PinyinHead.e, 'e'),
    er2(Shengmu.none, Yunmu.er, 2, "ér", "er", PinyinHead.e, 'e'),
    er3(Shengmu.none, Yunmu.er, 3, "ěr", "er", PinyinHead.e, 'e'),
    er4(Shengmu.none, Yunmu.er, 4, "èr", "er", PinyinHead.e, 'e'),
    er5(Shengmu.none, Yunmu.er, 5, "er", "er", PinyinHead.e, 'e'),
    fa1(Shengmu.f, Yunmu.a, 1, "fā", "fa", PinyinHead.f, 'f'),
    fa2(Shengmu.f, Yunmu.a, 2, "fá", "fa", PinyinHead.f, 'f'),
    fa3(Shengmu.f, Yunmu.a, 3, "fǎ", "fa", PinyinHead.f, 'f'),
    fa4(Shengmu.f, Yunmu.a, 4, "fà", "fa", PinyinHead.f, 'f'),
    fan1(Shengmu.f, Yunmu.an, 1, "fān", "fan", PinyinHead.f, 'f'),
    fan2(Shengmu.f, Yunmu.an, 2, "fán", "fan", PinyinHead.f, 'f'),
    fan3(Shengmu.f, Yunmu.an, 3, "fǎn", "fan", PinyinHead.f, 'f'),
    fan4(Shengmu.f, Yunmu.an, 4, "fàn", "fan", PinyinHead.f, 'f'),
    fang1(Shengmu.f, Yunmu.ang, 1, "fāng", "fang", PinyinHead.f, 'f'),
    fang2(Shengmu.f, Yunmu.ang, 2, "fáng", "fang", PinyinHead.f, 'f'),
    fang3(Shengmu.f, Yunmu.ang, 3, "fǎng", "fang", PinyinHead.f, 'f'),
    fang4(Shengmu.f, Yunmu.ang, 4, "fàng", "fang", PinyinHead.f, 'f'),
    fang5(Shengmu.f, Yunmu.ang, 5, "fang", "fang", PinyinHead.f, 'f'),
    fei1(Shengmu.f, Yunmu.ei, 1, "fēi", "fei", PinyinHead.f, 'f'),
    fei2(Shengmu.f, Yunmu.ei, 2, "féi", "fei", PinyinHead.f, 'f'),
    fei3(Shengmu.f, Yunmu.ei, 3, "fěi", "fei", PinyinHead.f, 'f'),
    fei4(Shengmu.f, Yunmu.ei, 4, "fèi", "fei", PinyinHead.f, 'f'),
    fen1(Shengmu.f, Yunmu.en, 1, "fēn", "fen", PinyinHead.f, 'f'),
    fen2(Shengmu.f, Yunmu.en, 2, "fén", "fen", PinyinHead.f, 'f'),
    fen3(Shengmu.f, Yunmu.en, 3, "fěn", "fen", PinyinHead.f, 'f'),
    fen4(Shengmu.f, Yunmu.en, 4, "fèn", "fen", PinyinHead.f, 'f'),
    feng1(Shengmu.f, Yunmu.eng, 1, "fēng", "feng", PinyinHead.f, 'f'),
    feng2(Shengmu.f, Yunmu.eng, 2, "féng", "feng", PinyinHead.f, 'f'),
    feng3(Shengmu.f, Yunmu.eng, 3, "fěng", "feng", PinyinHead.f, 'f'),
    feng4(Shengmu.f, Yunmu.eng, 4, "fèng", "feng", PinyinHead.f, 'f'),
    fiao4(Shengmu.f, Yunmu.iao, 4, "fiào", "fiao", PinyinHead.f, 'f'),
    fo2(Shengmu.f, Yunmu.o, 2, "fó", "fo", PinyinHead.f, 'f'),
    fou1(Shengmu.f, Yunmu.ou, 1, "fōu", "fou", PinyinHead.f, 'f'),
    fou2(Shengmu.f, Yunmu.ou, 2, "fóu", "fou", PinyinHead.f, 'f'),
    fou3(Shengmu.f, Yunmu.ou, 3, "fǒu", "fou", PinyinHead.f, 'f'),
    fou4(Shengmu.f, Yunmu.ou, 4, "fòu", "fou", PinyinHead.f, 'f'),
    fu1(Shengmu.f, Yunmu.u, 1, "fū", "fu", PinyinHead.f, 'f'),
    fu2(Shengmu.f, Yunmu.u, 2, "fú", "fu", PinyinHead.f, 'f'),
    fu3(Shengmu.f, Yunmu.u, 3, "fǔ", "fu", PinyinHead.f, 'f'),
    fu4(Shengmu.f, Yunmu.u, 4, "fù", "fu", PinyinHead.f, 'f'),
    fu5(Shengmu.f, Yunmu.u, 5, "fu", "fu", PinyinHead.f, 'f'),
    ga1(Shengmu.g, Yunmu.a, 1, "gā", "ga", PinyinHead.g, 'g'),
    ga2(Shengmu.g, Yunmu.a, 2, "gá", "ga", PinyinHead.g, 'g'),
    ga3(Shengmu.g, Yunmu.a, 3, "gǎ", "ga", PinyinHead.g, 'g'),
    ga4(Shengmu.g, Yunmu.a, 4, "gà", "ga", PinyinHead.g, 'g'),
    gai1(Shengmu.g, Yunmu.ai, 1, "gāi", "gai", PinyinHead.g, 'g'),
    gai3(Shengmu.g, Yunmu.ai, 3, "gǎi", "gai", PinyinHead.g, 'g'),
    gai4(Shengmu.g, Yunmu.ai, 4, "gài", "gai", PinyinHead.g, 'g'),
    gan1(Shengmu.g, Yunmu.an, 1, "gān", "gan", PinyinHead.g, 'g'),
    gan2(Shengmu.g, Yunmu.an, 2, "gán", "gan", PinyinHead.g, 'g'),
    gan3(Shengmu.g, Yunmu.an, 3, "gǎn", "gan", PinyinHead.g, 'g'),
    gan4(Shengmu.g, Yunmu.an, 4, "gàn", "gan", PinyinHead.g, 'g'),
    gang1(Shengmu.g, Yunmu.ang, 1, "gāng", "gang", PinyinHead.g, 'g'),
    gang3(Shengmu.g, Yunmu.ang, 3, "gǎng", "gang", PinyinHead.g, 'g'),
    gang4(Shengmu.g, Yunmu.ang, 4, "gàng", "gang", PinyinHead.g, 'g'),
    gao1(Shengmu.g, Yunmu.ao, 1, "gāo", "gao", PinyinHead.g, 'g'),
    gao3(Shengmu.g, Yunmu.ao, 3, "gǎo", "gao", PinyinHead.g, 'g'),
    gao4(Shengmu.g, Yunmu.ao, 4, "gào", "gao", PinyinHead.g, 'g'),
    ge1(Shengmu.g, Yunmu.e, 1, "gē", "ge", PinyinHead.g, 'g'),
    ge2(Shengmu.g, Yunmu.e, 2, "gé", "ge", PinyinHead.g, 'g'),
    ge3(Shengmu.g, Yunmu.e, 3, "gě", "ge", PinyinHead.g, 'g'),
    ge4(Shengmu.g, Yunmu.e, 4, "gè", "ge", PinyinHead.g, 'g'),
    gei3(Shengmu.g, Yunmu.ei, 3, "gěi", "gei", PinyinHead.g, 'g'),
    gen1(Shengmu.g, Yunmu.en, 1, "gēn", "gen", PinyinHead.g, 'g'),
    gen2(Shengmu.g, Yunmu.en, 2, "gén", "gen", PinyinHead.g, 'g'),
    gen3(Shengmu.g, Yunmu.en, 3, "gěn", "gen", PinyinHead.g, 'g'),
    gen4(Shengmu.g, Yunmu.en, 4, "gèn", "gen", PinyinHead.g, 'g'),
    geng1(Shengmu.g, Yunmu.eng, 1, "gēng", "geng", PinyinHead.g, 'g'),
    geng3(Shengmu.g, Yunmu.eng, 3, "gěng", "geng", PinyinHead.g, 'g'),
    geng4(Shengmu.g, Yunmu.eng, 4, "gèng", "geng", PinyinHead.g, 'g'),
    gong1(Shengmu.g, Yunmu.ong, 1, "gōng", "gong", PinyinHead.g, 'g'),
    gong3(Shengmu.g, Yunmu.ong, 3, "gǒng", "gong", PinyinHead.g, 'g'),
    gong4(Shengmu.g, Yunmu.ong, 4, "gòng", "gong", PinyinHead.g, 'g'),
    gou1(Shengmu.g, Yunmu.ou, 1, "gōu", "gou", PinyinHead.g, 'g'),
    gou3(Shengmu.g, Yunmu.ou, 3, "gǒu", "gou", PinyinHead.g, 'g'),
    gou4(Shengmu.g, Yunmu.ou, 4, "gòu", "gou", PinyinHead.g, 'g'),
    gu1(Shengmu.g, Yunmu.u, 1, "gū", "gu", PinyinHead.g, 'g'),
    gu2(Shengmu.g, Yunmu.u, 2, "gú", "gu", PinyinHead.g, 'g'),
    gu3(Shengmu.g, Yunmu.u, 3, "gǔ", "gu", PinyinHead.g, 'g'),
    gu4(Shengmu.g, Yunmu.u, 4, "gù", "gu", PinyinHead.g, 'g'),
    gua1(Shengmu.g, Yunmu.ua, 1, "guā", "gua", PinyinHead.g, 'g'),
    gua3(Shengmu.g, Yunmu.ua, 3, "guǎ", "gua", PinyinHead.g, 'g'),
    gua4(Shengmu.g, Yunmu.ua, 4, "guà", "gua", PinyinHead.g, 'g'),
    guai1(Shengmu.g, Yunmu.uai, 1, "guāi", "guai", PinyinHead.g, 'g'),
    guai2(Shengmu.g, Yunmu.uai, 2, "guái", "guai", PinyinHead.g, 'g'),
    guai3(Shengmu.g, Yunmu.uai, 3, "guǎi", "guai", PinyinHead.g, 'g'),
    guai4(Shengmu.g, Yunmu.uai, 4, "guài", "guai", PinyinHead.g, 'g'),
    guan1(Shengmu.g, Yunmu.uan, 1, "guān", "guan", PinyinHead.g, 'g'),
    guan3(Shengmu.g, Yunmu.uan, 3, "guǎn", "guan", PinyinHead.g, 'g'),
    guan4(Shengmu.g, Yunmu.uan, 4, "guàn", "guan", PinyinHead.g, 'g'),
    guang1(Shengmu.g, Yunmu.uang, 1, "guāng", "guang", PinyinHead.g, 'g'),
    guang3(Shengmu.g, Yunmu.uang, 3, "guǎng", "guang", PinyinHead.g, 'g'),
    guang4(Shengmu.g, Yunmu.uang, 4, "guàng", "guang", PinyinHead.g, 'g'),
    gui1(Shengmu.g, Yunmu.ui, 1, "guī", "gui", PinyinHead.g, 'g'),
    gui2(Shengmu.g, Yunmu.ui, 2, "guí", "gui", PinyinHead.g, 'g'),
    gui3(Shengmu.g, Yunmu.ui, 3, "guǐ", "gui", PinyinHead.g, 'g'),
    gui4(Shengmu.g, Yunmu.ui, 4, "guì", "gui", PinyinHead.g, 'g'),
    gun1(Shengmu.g, Yunmu.un, 1, "gūn", "gun", PinyinHead.g, 'g'),
    gun3(Shengmu.g, Yunmu.un, 3, "gǔn", "gun", PinyinHead.g, 'g'),
    gun4(Shengmu.g, Yunmu.un, 4, "gùn", "gun", PinyinHead.g, 'g'),
    guo1(Shengmu.g, Yunmu.uo, 1, "guō", "guo", PinyinHead.g, 'g'),
    guo2(Shengmu.g, Yunmu.uo, 2, "guó", "guo", PinyinHead.g, 'g'),
    guo3(Shengmu.g, Yunmu.uo, 3, "guǒ", "guo", PinyinHead.g, 'g'),
    guo4(Shengmu.g, Yunmu.uo, 4, "guò", "guo", PinyinHead.g, 'g'),
    guo5(Shengmu.g, Yunmu.uo, 5, "guo", "guo", PinyinHead.g, 'g'),
    ha1(Shengmu.h, Yunmu.a, 1, "hā", "ha", PinyinHead.h, 'h'),
    ha2(Shengmu.h, Yunmu.a, 2, "há", "ha", PinyinHead.h, 'h'),
    ha3(Shengmu.h, Yunmu.a, 3, "hǎ", "ha", PinyinHead.h, 'h'),
    ha4(Shengmu.h, Yunmu.a, 4, "hà", "ha", PinyinHead.h, 'h'),
    hai1(Shengmu.h, Yunmu.ai, 1, "hāi", "hai", PinyinHead.h, 'h'),
    hai2(Shengmu.h, Yunmu.ai, 2, "hái", "hai", PinyinHead.h, 'h'),
    hai3(Shengmu.h, Yunmu.ai, 3, "hǎi", "hai", PinyinHead.h, 'h'),
    hai4(Shengmu.h, Yunmu.ai, 4, "hài", "hai", PinyinHead.h, 'h'),
    han1(Shengmu.h, Yunmu.an, 1, "hān", "han", PinyinHead.h, 'h'),
    han2(Shengmu.h, Yunmu.an, 2, "hán", "han", PinyinHead.h, 'h'),
    han3(Shengmu.h, Yunmu.an, 3, "hǎn", "han", PinyinHead.h, 'h'),
    han4(Shengmu.h, Yunmu.an, 4, "hàn", "han", PinyinHead.h, 'h'),
    han5(Shengmu.h, Yunmu.an, 5, "han", "han", PinyinHead.h, 'h'),
    hang1(Shengmu.h, Yunmu.ang, 1, "hāng", "hang", PinyinHead.h, 'h'),
    hang2(Shengmu.h, Yunmu.ang, 2, "háng", "hang", PinyinHead.h, 'h'),
    hang3(Shengmu.h, Yunmu.ang, 3, "hǎng", "hang", PinyinHead.h, 'h'),
    hang4(Shengmu.h, Yunmu.ang, 4, "hàng", "hang", PinyinHead.h, 'h'),
    hao1(Shengmu.h, Yunmu.ao, 1, "hāo", "hao", PinyinHead.h, 'h'),
    hao2(Shengmu.h, Yunmu.ao, 2, "háo", "hao", PinyinHead.h, 'h'),
    hao3(Shengmu.h, Yunmu.ao, 3, "hǎo", "hao", PinyinHead.h, 'h'),
    hao4(Shengmu.h, Yunmu.ao, 4, "hào", "hao", PinyinHead.h, 'h'),
    he1(Shengmu.h, Yunmu.e, 1, "hē", "he", PinyinHead.h, 'h'),
    he2(Shengmu.h, Yunmu.e, 2, "hé", "he", PinyinHead.h, 'h'),
    he4(Shengmu.h, Yunmu.e, 4, "hè", "he", PinyinHead.h, 'h'),
    hei1(Shengmu.h, Yunmu.ei, 1, "hēi", "hei", PinyinHead.h, 'h'),
    hen1(Shengmu.h, Yunmu.en, 1, "hēn", "hen", PinyinHead.h, 'h'),
    hen2(Shengmu.h, Yunmu.en, 2, "hén", "hen", PinyinHead.h, 'h'),
    hen3(Shengmu.h, Yunmu.en, 3, "hěn", "hen", PinyinHead.h, 'h'),
    hen4(Shengmu.h, Yunmu.en, 4, "hèn", "hen", PinyinHead.h, 'h'),
    heng1(Shengmu.h, Yunmu.eng, 1, "hēng", "heng", PinyinHead.h, 'h'),
    heng2(Shengmu.h, Yunmu.eng, 2, "héng", "heng", PinyinHead.h, 'h'),
    heng4(Shengmu.h, Yunmu.eng, 4, "hèng", "heng", PinyinHead.h, 'h'),
    hong1(Shengmu.h, Yunmu.ong, 1, "hōng", "hong", PinyinHead.h, 'h'),
    hong2(Shengmu.h, Yunmu.ong, 2, "hóng", "hong", PinyinHead.h, 'h'),
    hong3(Shengmu.h, Yunmu.ong, 3, "hǒng", "hong", PinyinHead.h, 'h'),
    hong4(Shengmu.h, Yunmu.ong, 4, "hòng", "hong", PinyinHead.h, 'h'),
    hou1(Shengmu.h, Yunmu.ou, 1, "hōu", "hou", PinyinHead.h, 'h'),
    hou2(Shengmu.h, Yunmu.ou, 2, "hóu", "hou", PinyinHead.h, 'h'),
    hou3(Shengmu.h, Yunmu.ou, 3, "hǒu", "hou", PinyinHead.h, 'h'),
    hou4(Shengmu.h, Yunmu.ou, 4, "hòu", "hou", PinyinHead.h, 'h'),
    hu1(Shengmu.h, Yunmu.u, 1, "hū", "hu", PinyinHead.h, 'h'),
    hu2(Shengmu.h, Yunmu.u, 2, "hú", "hu", PinyinHead.h, 'h'),
    hu3(Shengmu.h, Yunmu.u, 3, "hǔ", "hu", PinyinHead.h, 'h'),
    hu4(Shengmu.h, Yunmu.u, 4, "hù", "hu", PinyinHead.h, 'h'),
    hua1(Shengmu.h, Yunmu.ua, 1, "huā", "hua", PinyinHead.h, 'h'),
    hua2(Shengmu.h, Yunmu.ua, 2, "huá", "hua", PinyinHead.h, 'h'),
    hua3(Shengmu.h, Yunmu.ua, 3, "huǎ", "hua", PinyinHead.h, 'h'),
    hua4(Shengmu.h, Yunmu.ua, 4, "huà", "hua", PinyinHead.h, 'h'),
    huai1(Shengmu.h, Yunmu.uai, 1, "huāi", "huai", PinyinHead.h, 'h'),
    huai2(Shengmu.h, Yunmu.uai, 2, "huái", "huai", PinyinHead.h, 'h'),
    huai4(Shengmu.h, Yunmu.uai, 4, "huài", "huai", PinyinHead.h, 'h'),
    huan1(Shengmu.h, Yunmu.uan, 1, "huān", "huan", PinyinHead.h, 'h'),
    huan2(Shengmu.h, Yunmu.uan, 2, "huán", "huan", PinyinHead.h, 'h'),
    huan3(Shengmu.h, Yunmu.uan, 3, "huǎn", "huan", PinyinHead.h, 'h'),
    huan4(Shengmu.h, Yunmu.uan, 4, "huàn", "huan", PinyinHead.h, 'h'),
    huang1(Shengmu.h, Yunmu.uang, 1, "huāng", "huang", PinyinHead.h, 'h'),
    huang2(Shengmu.h, Yunmu.uang, 2, "huáng", "huang", PinyinHead.h, 'h'),
    huang3(Shengmu.h, Yunmu.uang, 3, "huǎng", "huang", PinyinHead.h, 'h'),
    huang4(Shengmu.h, Yunmu.uang, 4, "huàng", "huang", PinyinHead.h, 'h'),
    hui1(Shengmu.h, Yunmu.ui, 1, "huī", "hui", PinyinHead.h, 'h'),
    hui2(Shengmu.h, Yunmu.ui, 2, "huí", "hui", PinyinHead.h, 'h'),
    hui3(Shengmu.h, Yunmu.ui, 3, "huǐ", "hui", PinyinHead.h, 'h'),
    hui4(Shengmu.h, Yunmu.ui, 4, "huì", "hui", PinyinHead.h, 'h'),
    hun1(Shengmu.h, Yunmu.un, 1, "hūn", "hun", PinyinHead.h, 'h'),
    hun2(Shengmu.h, Yunmu.un, 2, "hún", "hun", PinyinHead.h, 'h'),
    hun3(Shengmu.h, Yunmu.un, 3, "hǔn", "hun", PinyinHead.h, 'h'),
    hun4(Shengmu.h, Yunmu.un, 4, "hùn", "hun", PinyinHead.h, 'h'),
    huo1(Shengmu.h, Yunmu.uo, 1, "huō", "huo", PinyinHead.h, 'h'),
    huo2(Shengmu.h, Yunmu.uo, 2, "huó", "huo", PinyinHead.h, 'h'),
    huo3(Shengmu.h, Yunmu.uo, 3, "huǒ", "huo", PinyinHead.h, 'h'),
    huo4(Shengmu.h, Yunmu.uo, 4, "huò", "huo", PinyinHead.h, 'h'),
    huo5(Shengmu.h, Yunmu.uo, 5, "huo", "huo", PinyinHead.h, 'h'),
    ja4(Shengmu.j, Yunmu.a, 4, "jà", "ja", PinyinHead.j, 'j'),
    ji1(Shengmu.j, Yunmu.i, 1, "jī", "ji", PinyinHead.j, 'j'),
    ji2(Shengmu.j, Yunmu.i, 2, "jí", "ji", PinyinHead.j, 'j'),
    ji3(Shengmu.j, Yunmu.i, 3, "jǐ", "ji", PinyinHead.j, 'j'),
    ji4(Shengmu.j, Yunmu.i, 4, "jì", "ji", PinyinHead.j, 'j'),
    ji5(Shengmu.j, Yunmu.i, 5, "ji", "ji", PinyinHead.j, 'j'),
    jia1(Shengmu.j, Yunmu.ia, 1, "jiā", "jia", PinyinHead.j, 'j'),
    jia2(Shengmu.j, Yunmu.ia, 2, "jiá", "jia", PinyinHead.j, 'j'),
    jia3(Shengmu.j, Yunmu.ia, 3, "jiǎ", "jia", PinyinHead.j, 'j'),
    jia4(Shengmu.j, Yunmu.ia, 4, "jià", "jia", PinyinHead.j, 'j'),
    jia5(Shengmu.j, Yunmu.ia, 5, "jia", "jia", PinyinHead.j, 'j'),
    jian1(Shengmu.j, Yunmu.ian, 1, "jiān", "jian", PinyinHead.j, 'j'),
    jian3(Shengmu.j, Yunmu.ian, 3, "jiǎn", "jian", PinyinHead.j, 'j'),
    jian4(Shengmu.j, Yunmu.ian, 4, "jiàn", "jian", PinyinHead.j, 'j'),
    jiang1(Shengmu.j, Yunmu.iang, 1, "jiāng", "jiang", PinyinHead.j, 'j'),
    jiang3(Shengmu.j, Yunmu.iang, 3, "jiǎng", "jiang", PinyinHead.j, 'j'),
    jiang4(Shengmu.j, Yunmu.iang, 4, "jiàng", "jiang", PinyinHead.j, 'j'),
    jiao1(Shengmu.j, Yunmu.iao, 1, "jiāo", "jiao", PinyinHead.j, 'j'),
    jiao2(Shengmu.j, Yunmu.iao, 2, "jiáo", "jiao", PinyinHead.j, 'j'),
    jiao3(Shengmu.j, Yunmu.iao, 3, "jiǎo", "jiao", PinyinHead.j, 'j'),
    jiao4(Shengmu.j, Yunmu.iao, 4, "jiào", "jiao", PinyinHead.j, 'j'),
    jie1(Shengmu.j, Yunmu.ie, 1, "jiē", "jie", PinyinHead.j, 'j'),
    jie2(Shengmu.j, Yunmu.ie, 2, "jié", "jie", PinyinHead.j, 'j'),
    jie3(Shengmu.j, Yunmu.ie, 3, "jiě", "jie", PinyinHead.j, 'j'),
    jie4(Shengmu.j, Yunmu.ie, 4, "jiè", "jie", PinyinHead.j, 'j'),
    jie5(Shengmu.j, Yunmu.ie, 5, "jie", "jie", PinyinHead.j, 'j'),
    jin1(Shengmu.j, Yunmu.in, 1, "jīn", "jin", PinyinHead.j, 'j'),
    jin3(Shengmu.j, Yunmu.in, 3, "jǐn", "jin", PinyinHead.j, 'j'),
    jin4(Shengmu.j, Yunmu.in, 4, "jìn", "jin", PinyinHead.j, 'j'),
    jing1(Shengmu.j, Yunmu.ing, 1, "jīng", "jing", PinyinHead.j, 'j'),
    jing3(Shengmu.j, Yunmu.ing, 3, "jǐng", "jing", PinyinHead.j, 'j'),
    jing4(Shengmu.j, Yunmu.ing, 4, "jìng", "jing", PinyinHead.j, 'j'),
    jiong1(Shengmu.j, Yunmu.iong, 1, "jiōng", "jiong", PinyinHead.j, 'j'),
    jiong3(Shengmu.j, Yunmu.iong, 3, "jiǒng", "jiong", PinyinHead.j, 'j'),
    jiong4(Shengmu.j, Yunmu.iong, 4, "jiòng", "jiong", PinyinHead.j, 'j'),
    jiu1(Shengmu.j, Yunmu.iu, 1, "jiū", "jiu", PinyinHead.j, 'j'),
    jiu3(Shengmu.j, Yunmu.iu, 3, "jiǔ", "jiu", PinyinHead.j, 'j'),
    jiu4(Shengmu.j, Yunmu.iu, 4, "jiù", "jiu", PinyinHead.j, 'j'),
    ju1(Shengmu.j, Yunmu.u, 1, "jū", "ju", PinyinHead.j, 'j'),
    ju2(Shengmu.j, Yunmu.u, 2, "jú", "ju", PinyinHead.j, 'j'),
    ju3(Shengmu.j, Yunmu.u, 3, "jǔ", "ju", PinyinHead.j, 'j'),
    ju4(Shengmu.j, Yunmu.u, 4, "jù", "ju", PinyinHead.j, 'j'),
    ju5(Shengmu.j, Yunmu.u, 5, "ju", "ju", PinyinHead.j, 'j'),
    juan1(Shengmu.j, Yunmu.uan, 1, "juān", "juan", PinyinHead.j, 'j'),
    juan2(Shengmu.j, Yunmu.uan, 2, "juán", "juan", PinyinHead.j, 'j'),
    juan3(Shengmu.j, Yunmu.uan, 3, "juǎn", "juan", PinyinHead.j, 'j'),
    juan4(Shengmu.j, Yunmu.uan, 4, "juàn", "juan", PinyinHead.j, 'j'),
    jue1(Shengmu.j, Yunmu.ue, 1, "juē", "jue", PinyinHead.j, 'j'),
    jue2(Shengmu.j, Yunmu.ue, 2, "jué", "jue", PinyinHead.j, 'j'),
    jue3(Shengmu.j, Yunmu.ue, 3, "juě", "jue", PinyinHead.j, 'j'),
    jue4(Shengmu.j, Yunmu.ue, 4, "juè", "jue", PinyinHead.j, 'j'),
    jun1(Shengmu.j, Yunmu.un, 1, "jūn", "jun", PinyinHead.j, 'j'),
    jun3(Shengmu.j, Yunmu.un, 3, "jǔn", "jun", PinyinHead.j, 'j'),
    jun4(Shengmu.j, Yunmu.un, 4, "jùn", "jun", PinyinHead.j, 'j'),
    ka1(Shengmu.k, Yunmu.a, 1, "kā", "ka", PinyinHead.k, 'k'),
    ka3(Shengmu.k, Yunmu.a, 3, "kǎ", "ka", PinyinHead.k, 'k'),
    ka4(Shengmu.k, Yunmu.a, 4, "kà", "ka", PinyinHead.k, 'k'),
    kai1(Shengmu.k, Yunmu.ai, 1, "kāi", "kai", PinyinHead.k, 'k'),
    kai3(Shengmu.k, Yunmu.ai, 3, "kǎi", "kai", PinyinHead.k, 'k'),
    kai4(Shengmu.k, Yunmu.ai, 4, "kài", "kai", PinyinHead.k, 'k'),
    kan1(Shengmu.k, Yunmu.an, 1, "kān", "kan", PinyinHead.k, 'k'),
    kan3(Shengmu.k, Yunmu.an, 3, "kǎn", "kan", PinyinHead.k, 'k'),
    kan4(Shengmu.k, Yunmu.an, 4, "kàn", "kan", PinyinHead.k, 'k'),
    kang1(Shengmu.k, Yunmu.ang, 1, "kāng", "kang", PinyinHead.k, 'k'),
    kang2(Shengmu.k, Yunmu.ang, 2, "káng", "kang", PinyinHead.k, 'k'),
    kang3(Shengmu.k, Yunmu.ang, 3, "kǎng", "kang", PinyinHead.k, 'k'),
    kang4(Shengmu.k, Yunmu.ang, 4, "kàng", "kang", PinyinHead.k, 'k'),
    kao1(Shengmu.k, Yunmu.ao, 1, "kāo", "kao", PinyinHead.k, 'k'),
    kao2(Shengmu.k, Yunmu.ao, 2, "káo", "kao", PinyinHead.k, 'k'),
    kao3(Shengmu.k, Yunmu.ao, 3, "kǎo", "kao", PinyinHead.k, 'k'),
    kao4(Shengmu.k, Yunmu.ao, 4, "kào", "kao", PinyinHead.k, 'k'),
    ke1(Shengmu.k, Yunmu.e, 1, "kē", "ke", PinyinHead.k, 'k'),
    ke2(Shengmu.k, Yunmu.e, 2, "ké", "ke", PinyinHead.k, 'k'),
    ke3(Shengmu.k, Yunmu.e, 3, "kě", "ke", PinyinHead.k, 'k'),
    ke4(Shengmu.k, Yunmu.e, 4, "kè", "ke", PinyinHead.k, 'k'),
    ke5(Shengmu.k, Yunmu.e, 5, "ke", "ke", PinyinHead.k, 'k'),
    kei1(Shengmu.k, Yunmu.ei, 1, "kēi", "kei", PinyinHead.k, 'k'),
    ken3(Shengmu.k, Yunmu.en, 3, "kěn", "ken", PinyinHead.k, 'k'),
    ken4(Shengmu.k, Yunmu.en, 4, "kèn", "ken", PinyinHead.k, 'k'),
    keng1(Shengmu.k, Yunmu.eng, 1, "kēng", "keng", PinyinHead.k, 'k'),
    keng3(Shengmu.k, Yunmu.eng, 3, "kěng", "keng", PinyinHead.k, 'k'),
    kong1(Shengmu.k, Yunmu.ong, 1, "kōng", "kong", PinyinHead.k, 'k'),
    kong3(Shengmu.k, Yunmu.ong, 3, "kǒng", "kong", PinyinHead.k, 'k'),
    kong4(Shengmu.k, Yunmu.ong, 4, "kòng", "kong", PinyinHead.k, 'k'),
    kou1(Shengmu.k, Yunmu.ou, 1, "kōu", "kou", PinyinHead.k, 'k'),
    kou3(Shengmu.k, Yunmu.ou, 3, "kǒu", "kou", PinyinHead.k, 'k'),
    kou4(Shengmu.k, Yunmu.ou, 4, "kòu", "kou", PinyinHead.k, 'k'),
    ku1(Shengmu.k, Yunmu.u, 1, "kū", "ku", PinyinHead.k, 'k'),
    ku3(Shengmu.k, Yunmu.u, 3, "kǔ", "ku", PinyinHead.k, 'k'),
    ku4(Shengmu.k, Yunmu.u, 4, "kù", "ku", PinyinHead.k, 'k'),
    kua1(Shengmu.k, Yunmu.ua, 1, "kuā", "kua", PinyinHead.k, 'k'),
    kua3(Shengmu.k, Yunmu.ua, 3, "kuǎ", "kua", PinyinHead.k, 'k'),
    kua4(Shengmu.k, Yunmu.ua, 4, "kuà", "kua", PinyinHead.k, 'k'),
    kuai1(Shengmu.k, Yunmu.uai, 1, "kuāi", "kuai", PinyinHead.k, 'k'),
    kuai3(Shengmu.k, Yunmu.uai, 3, "kuǎi", "kuai", PinyinHead.k, 'k'),
    kuai4(Shengmu.k, Yunmu.uai, 4, "kuài", "kuai", PinyinHead.k, 'k'),
    kuan1(Shengmu.k, Yunmu.uan, 1, "kuān", "kuan", PinyinHead.k, 'k'),
    kuan3(Shengmu.k, Yunmu.uan, 3, "kuǎn", "kuan", PinyinHead.k, 'k'),
    kuang1(Shengmu.k, Yunmu.uang, 1, "kuāng", "kuang", PinyinHead.k, 'k'),
    kuang2(Shengmu.k, Yunmu.uang, 2, "kuáng", "kuang", PinyinHead.k, 'k'),
    kuang3(Shengmu.k, Yunmu.uang, 3, "kuǎng", "kuang", PinyinHead.k, 'k'),
    kuang4(Shengmu.k, Yunmu.uang, 4, "kuàng", "kuang", PinyinHead.k, 'k'),
    kui1(Shengmu.k, Yunmu.ui, 1, "kuī", "kui", PinyinHead.k, 'k'),
    kui2(Shengmu.k, Yunmu.ui, 2, "kuí", "kui", PinyinHead.k, 'k'),
    kui3(Shengmu.k, Yunmu.ui, 3, "kuǐ", "kui", PinyinHead.k, 'k'),
    kui4(Shengmu.k, Yunmu.ui, 4, "kuì", "kui", PinyinHead.k, 'k'),
    kun1(Shengmu.k, Yunmu.un, 1, "kūn", "kun", PinyinHead.k, 'k'),
    kun3(Shengmu.k, Yunmu.un, 3, "kǔn", "kun", PinyinHead.k, 'k'),
    kun4(Shengmu.k, Yunmu.un, 4, "kùn", "kun", PinyinHead.k, 'k'),
    kuo3(Shengmu.k, Yunmu.uo, 3, "kuǒ", "kuo", PinyinHead.k, 'k'),
    kuo4(Shengmu.k, Yunmu.uo, 4, "kuò", "kuo", PinyinHead.k, 'k'),
    la1(Shengmu.l, Yunmu.a, 1, "lā", "la", PinyinHead.l, 'l'),
    la2(Shengmu.l, Yunmu.a, 2, "lá", "la", PinyinHead.l, 'l'),
    la3(Shengmu.l, Yunmu.a, 3, "lǎ", "la", PinyinHead.l, 'l'),
    la4(Shengmu.l, Yunmu.a, 4, "là", "la", PinyinHead.l, 'l'),
    la5(Shengmu.l, Yunmu.a, 5, "la", "la", PinyinHead.l, 'l'),
    lai2(Shengmu.l, Yunmu.ai, 2, "lái", "lai", PinyinHead.l, 'l'),
    lai3(Shengmu.l, Yunmu.ai, 3, "lǎi", "lai", PinyinHead.l, 'l'),
    lai4(Shengmu.l, Yunmu.ai, 4, "lài", "lai", PinyinHead.l, 'l'),
    lan2(Shengmu.l, Yunmu.an, 2, "lán", "lan", PinyinHead.l, 'l'),
    lan3(Shengmu.l, Yunmu.an, 3, "lǎn", "lan", PinyinHead.l, 'l'),
    lan4(Shengmu.l, Yunmu.an, 4, "làn", "lan", PinyinHead.l, 'l'),
    lan5(Shengmu.l, Yunmu.an, 5, "lan", "lan", PinyinHead.l, 'l'),
    lang1(Shengmu.l, Yunmu.ang, 1, "lāng", "lang", PinyinHead.l, 'l'),
    lang2(Shengmu.l, Yunmu.ang, 2, "láng", "lang", PinyinHead.l, 'l'),
    lang3(Shengmu.l, Yunmu.ang, 3, "lǎng", "lang", PinyinHead.l, 'l'),
    lang4(Shengmu.l, Yunmu.ang, 4, "làng", "lang", PinyinHead.l, 'l'),
    lao1(Shengmu.l, Yunmu.ao, 1, "lāo", "lao", PinyinHead.l, 'l'),
    lao2(Shengmu.l, Yunmu.ao, 2, "láo", "lao", PinyinHead.l, 'l'),
    lao3(Shengmu.l, Yunmu.ao, 3, "lǎo", "lao", PinyinHead.l, 'l'),
    lao4(Shengmu.l, Yunmu.ao, 4, "lào", "lao", PinyinHead.l, 'l'),
    le1(Shengmu.l, Yunmu.e, 1, "lē", "le", PinyinHead.l, 'l'),
    le4(Shengmu.l, Yunmu.e, 4, "lè", "le", PinyinHead.l, 'l'),
    le5(Shengmu.l, Yunmu.e, 5, "le", "le", PinyinHead.l, 'l'),
    lei1(Shengmu.l, Yunmu.ei, 1, "lēi", "lei", PinyinHead.l, 'l'),
    lei2(Shengmu.l, Yunmu.ei, 2, "léi", "lei", PinyinHead.l, 'l'),
    lei3(Shengmu.l, Yunmu.ei, 3, "lěi", "lei", PinyinHead.l, 'l'),
    lei4(Shengmu.l, Yunmu.ei, 4, "lèi", "lei", PinyinHead.l, 'l'),
    lei5(Shengmu.l, Yunmu.ei, 5, "lei", "lei", PinyinHead.l, 'l'),
    leng1(Shengmu.l, Yunmu.eng, 1, "lēng", "leng", PinyinHead.l, 'l'),
    leng2(Shengmu.l, Yunmu.eng, 2, "léng", "leng", PinyinHead.l, 'l'),
    leng3(Shengmu.l, Yunmu.eng, 3, "lěng", "leng", PinyinHead.l, 'l'),
    leng4(Shengmu.l, Yunmu.eng, 4, "lèng", "leng", PinyinHead.l, 'l'),
    li1(Shengmu.l, Yunmu.i, 1, "lī", "li", PinyinHead.l, 'l'),
    li2(Shengmu.l, Yunmu.i, 2, "lí", "li", PinyinHead.l, 'l'),
    li3(Shengmu.l, Yunmu.i, 3, "lǐ", "li", PinyinHead.l, 'l'),
    li4(Shengmu.l, Yunmu.i, 4, "lì", "li", PinyinHead.l, 'l'),
    li5(Shengmu.l, Yunmu.i, 5, "li", "li", PinyinHead.l, 'l'),
    lia3(Shengmu.l, Yunmu.ia, 3, "liǎ", "lia", PinyinHead.l, 'l'),
    lian1(Shengmu.l, Yunmu.ian, 1, "liān", "lian", PinyinHead.l, 'l'),
    lian2(Shengmu.l, Yunmu.ian, 2, "lián", "lian", PinyinHead.l, 'l'),
    lian3(Shengmu.l, Yunmu.ian, 3, "liǎn", "lian", PinyinHead.l, 'l'),
    lian4(Shengmu.l, Yunmu.ian, 4, "liàn", "lian", PinyinHead.l, 'l'),
    liang2(Shengmu.l, Yunmu.iang, 2, "liáng", "liang", PinyinHead.l, 'l'),
    liang3(Shengmu.l, Yunmu.iang, 3, "liǎng", "liang", PinyinHead.l, 'l'),
    liang4(Shengmu.l, Yunmu.iang, 4, "liàng", "liang", PinyinHead.l, 'l'),
    liang5(Shengmu.l, Yunmu.iang, 5, "liang", "liang", PinyinHead.l, 'l'),
    liao1(Shengmu.l, Yunmu.iao, 1, "liāo", "liao", PinyinHead.l, 'l'),
    liao2(Shengmu.l, Yunmu.iao, 2, "liáo", "liao", PinyinHead.l, 'l'),
    liao3(Shengmu.l, Yunmu.iao, 3, "liǎo", "liao", PinyinHead.l, 'l'),
    liao4(Shengmu.l, Yunmu.iao, 4, "liào", "liao", PinyinHead.l, 'l'),
    lie1(Shengmu.l, Yunmu.ie, 1, "liē", "lie", PinyinHead.l, 'l'),
    lie2(Shengmu.l, Yunmu.ie, 2, "lié", "lie", PinyinHead.l, 'l'),
    lie3(Shengmu.l, Yunmu.ie, 3, "liě", "lie", PinyinHead.l, 'l'),
    lie4(Shengmu.l, Yunmu.ie, 4, "liè", "lie", PinyinHead.l, 'l'),
    lie5(Shengmu.l, Yunmu.ie, 5, "lie", "lie", PinyinHead.l, 'l'),
    lin1(Shengmu.l, Yunmu.in, 1, "līn", "lin", PinyinHead.l, 'l'),
    lin2(Shengmu.l, Yunmu.in, 2, "lín", "lin", PinyinHead.l, 'l'),
    lin3(Shengmu.l, Yunmu.in, 3, "lǐn", "lin", PinyinHead.l, 'l'),
    lin4(Shengmu.l, Yunmu.in, 4, "lìn", "lin", PinyinHead.l, 'l'),
    ling1(Shengmu.l, Yunmu.ing, 1, "līng", "ling", PinyinHead.l, 'l'),
    ling2(Shengmu.l, Yunmu.ing, 2, "líng", "ling", PinyinHead.l, 'l'),
    ling3(Shengmu.l, Yunmu.ing, 3, "lǐng", "ling", PinyinHead.l, 'l'),
    ling4(Shengmu.l, Yunmu.ing, 4, "lìng", "ling", PinyinHead.l, 'l'),
    liu1(Shengmu.l, Yunmu.iu, 1, "liū", "liu", PinyinHead.l, 'l'),
    liu2(Shengmu.l, Yunmu.iu, 2, "liú", "liu", PinyinHead.l, 'l'),
    liu3(Shengmu.l, Yunmu.iu, 3, "liǔ", "liu", PinyinHead.l, 'l'),
    liu4(Shengmu.l, Yunmu.iu, 4, "liù", "liu", PinyinHead.l, 'l'),
    lo5(Shengmu.l, Yunmu.o, 5, "lo", "lo", PinyinHead.l, 'l'),
    long1(Shengmu.l, Yunmu.ong, 1, "lōng", "long", PinyinHead.l, 'l'),
    long2(Shengmu.l, Yunmu.ong, 2, "lóng", "long", PinyinHead.l, 'l'),
    long3(Shengmu.l, Yunmu.ong, 3, "lǒng", "long", PinyinHead.l, 'l'),
    long4(Shengmu.l, Yunmu.ong, 4, "lòng", "long", PinyinHead.l, 'l'),
    lou1(Shengmu.l, Yunmu.ou, 1, "lōu", "lou", PinyinHead.l, 'l'),
    lou2(Shengmu.l, Yunmu.ou, 2, "lóu", "lou", PinyinHead.l, 'l'),
    lou3(Shengmu.l, Yunmu.ou, 3, "lǒu", "lou", PinyinHead.l, 'l'),
    lou4(Shengmu.l, Yunmu.ou, 4, "lòu", "lou", PinyinHead.l, 'l'),
    lou5(Shengmu.l, Yunmu.ou, 5, "lou", "lou", PinyinHead.l, 'l'),
    lu1(Shengmu.l, Yunmu.u, 1, "lū", "lu", PinyinHead.l, 'l'),
    lu2(Shengmu.l, Yunmu.u, 2, "lú", "lu", PinyinHead.l, 'l'),
    lu3(Shengmu.l, Yunmu.u, 3, "lǔ", "lu", PinyinHead.l, 'l'),
    lu4(Shengmu.l, Yunmu.u, 4, "lù", "lu", PinyinHead.l, 'l'),
    lu5(Shengmu.l, Yunmu.u, 5, "lu", "lu", PinyinHead.l, 'l'),
    luan2(Shengmu.l, Yunmu.uan, 2, "luán", "luan", PinyinHead.l, 'l'),
    luan3(Shengmu.l, Yunmu.uan, 3, "luǎn", "luan", PinyinHead.l, 'l'),
    luan4(Shengmu.l, Yunmu.uan, 4, "luàn", "luan", PinyinHead.l, 'l'),
    lun1(Shengmu.l, Yunmu.un, 1, "lūn", "lun", PinyinHead.l, 'l'),
    lun2(Shengmu.l, Yunmu.un, 2, "lún", "lun", PinyinHead.l, 'l'),
    lun3(Shengmu.l, Yunmu.un, 3, "lǔn", "lun", PinyinHead.l, 'l'),
    lun4(Shengmu.l, Yunmu.un, 4, "lùn", "lun", PinyinHead.l, 'l'),
    luo1(Shengmu.l, Yunmu.uo, 1, "luō", "luo", PinyinHead.l, 'l'),
    luo2(Shengmu.l, Yunmu.uo, 2, "luó", "luo", PinyinHead.l, 'l'),
    luo3(Shengmu.l, Yunmu.uo, 3, "luǒ", "luo", PinyinHead.l, 'l'),
    luo4(Shengmu.l, Yunmu.uo, 4, "luò", "luo", PinyinHead.l, 'l'),
    luo5(Shengmu.l, Yunmu.uo, 5, "luo", "luo", PinyinHead.l, 'l'),
    lv2(Shengmu.l, Yunmu.u, 2, "lǘ", "lv", PinyinHead.l, 'l'),
    lv3(Shengmu.l, Yunmu.v, 3, "lǚ", "lv", PinyinHead.l, 'l'),
    lv4(Shengmu.l, Yunmu.v, 4, "lǜ", "lv", PinyinHead.l, 'l'),
    lve3(Shengmu.l, Yunmu.ve, 3, "lüě", "lve", PinyinHead.l, 'l'),
    lve4(Shengmu.l, Yunmu.ue, 4, "lüè", "lve", PinyinHead.l, 'l'),
    ma1(Shengmu.m, Yunmu.a, 1, "mā", "ma", PinyinHead.m, 'm'),
    ma2(Shengmu.m, Yunmu.a, 2, "má", "ma", PinyinHead.m, 'm'),
    ma3(Shengmu.m, Yunmu.a, 3, "mǎ", "ma", PinyinHead.m, 'm'),
    ma4(Shengmu.m, Yunmu.a, 4, "mà", "ma", PinyinHead.m, 'm'),
    ma5(Shengmu.m, Yunmu.a, 5, "ma", "ma", PinyinHead.m, 'm'),
    mai2(Shengmu.m, Yunmu.ai, 2, "mái", "mai", PinyinHead.m, 'm'),
    mai3(Shengmu.m, Yunmu.ai, 3, "mǎi", "mai", PinyinHead.m, 'm'),
    mai4(Shengmu.m, Yunmu.ai, 4, "mài", "mai", PinyinHead.m, 'm'),
    man1(Shengmu.m, Yunmu.an, 1, "mān", "man", PinyinHead.m, 'm'),
    man2(Shengmu.m, Yunmu.an, 2, "mán", "man", PinyinHead.m, 'm'),
    man3(Shengmu.m, Yunmu.an, 3, "mǎn", "man", PinyinHead.m, 'm'),
    man4(Shengmu.m, Yunmu.an, 4, "màn", "man", PinyinHead.m, 'm'),
    mang1(Shengmu.m, Yunmu.ang, 1, "māng", "mang", PinyinHead.m, 'm'),
    mang2(Shengmu.m, Yunmu.ang, 2, "máng", "mang", PinyinHead.m, 'm'),
    mang3(Shengmu.m, Yunmu.ang, 3, "mǎng", "mang", PinyinHead.m, 'm'),
    mao1(Shengmu.m, Yunmu.ao, 1, "māo", "mao", PinyinHead.m, 'm'),
    mao2(Shengmu.m, Yunmu.ao, 2, "máo", "mao", PinyinHead.m, 'm'),
    mao3(Shengmu.m, Yunmu.ao, 3, "mǎo", "mao", PinyinHead.m, 'm'),
    mao4(Shengmu.m, Yunmu.ao, 4, "mào", "mao", PinyinHead.m, 'm'),
    me1(Shengmu.m, Yunmu.e, 1, "mē", "me", PinyinHead.m, 'm'),
    me4(Shengmu.m, Yunmu.e, 4, "mè", "me", PinyinHead.m, 'm'),
    me5(Shengmu.m, Yunmu.e, 5, "me", "me", PinyinHead.m, 'm'),
    mei2(Shengmu.m, Yunmu.ei, 2, "méi", "mei", PinyinHead.m, 'm'),
    mei3(Shengmu.m, Yunmu.ei, 3, "měi", "mei", PinyinHead.m, 'm'),
    mei4(Shengmu.m, Yunmu.ei, 4, "mèi", "mei", PinyinHead.m, 'm'),
    men1(Shengmu.m, Yunmu.en, 1, "mēn", "men", PinyinHead.m, 'm'),
    men2(Shengmu.m, Yunmu.en, 2, "mén", "men", PinyinHead.m, 'm'),
    men3(Shengmu.m, Yunmu.en, 3, "měn", "men", PinyinHead.m, 'm'),
    men4(Shengmu.m, Yunmu.en, 4, "mèn", "men", PinyinHead.m, 'm'),
    men5(Shengmu.m, Yunmu.en, 5, "men", "men", PinyinHead.m, 'm'),
    meng1(Shengmu.m, Yunmu.eng, 1, "mēng", "meng", PinyinHead.m, 'm'),
    meng2(Shengmu.m, Yunmu.eng, 2, "méng", "meng", PinyinHead.m, 'm'),
    meng3(Shengmu.m, Yunmu.eng, 3, "měng", "meng", PinyinHead.m, 'm'),
    meng4(Shengmu.m, Yunmu.eng, 4, "mèng", "meng", PinyinHead.m, 'm'),
    mi1(Shengmu.m, Yunmu.i, 1, "mī", "mi", PinyinHead.m, 'm'),
    mi2(Shengmu.m, Yunmu.i, 2, "mí", "mi", PinyinHead.m, 'm'),
    mi3(Shengmu.m, Yunmu.i, 3, "mǐ", "mi", PinyinHead.m, 'm'),
    mi4(Shengmu.m, Yunmu.i, 4, "mì", "mi", PinyinHead.m, 'm'),
    mian2(Shengmu.m, Yunmu.ian, 2, "mián", "mian", PinyinHead.m, 'm'),
    mian3(Shengmu.m, Yunmu.ian, 3, "miǎn", "mian", PinyinHead.m, 'm'),
    mian4(Shengmu.m, Yunmu.ian, 4, "miàn", "mian", PinyinHead.m, 'm'),
    miao1(Shengmu.m, Yunmu.iao, 1, "miāo", "miao", PinyinHead.m, 'm'),
    miao2(Shengmu.m, Yunmu.iao, 2, "miáo", "miao", PinyinHead.m, 'm'),
    miao3(Shengmu.m, Yunmu.iao, 3, "miǎo", "miao", PinyinHead.m, 'm'),
    miao4(Shengmu.m, Yunmu.iao, 4, "miào", "miao", PinyinHead.m, 'm'),
    mie1(Shengmu.m, Yunmu.ie, 1, "miē", "mie", PinyinHead.m, 'm'),
    mie4(Shengmu.m, Yunmu.ie, 4, "miè", "mie", PinyinHead.m, 'm'),
    min2(Shengmu.m, Yunmu.in, 2, "mín", "min", PinyinHead.m, 'm'),
    min3(Shengmu.m, Yunmu.in, 3, "mǐn", "min", PinyinHead.m, 'm'),
    ming2(Shengmu.m, Yunmu.ing, 2, "míng", "ming", PinyinHead.m, 'm'),
    ming3(Shengmu.m, Yunmu.ing, 3, "mǐng", "ming", PinyinHead.m, 'm'),
    ming4(Shengmu.m, Yunmu.ing, 4, "mìng", "ming", PinyinHead.m, 'm'),
    miu4(Shengmu.m, Yunmu.iu, 4, "miù", "miu", PinyinHead.m, 'm'),
    mo1(Shengmu.m, Yunmu.o, 1, "mō", "mo", PinyinHead.m, 'm'),
    mo2(Shengmu.m, Yunmu.o, 2, "mó", "mo", PinyinHead.m, 'm'),
    mo3(Shengmu.m, Yunmu.o, 3, "mǒ", "mo", PinyinHead.m, 'm'),
    mo4(Shengmu.m, Yunmu.o, 4, "mò", "mo", PinyinHead.m, 'm'),
    mo5(Shengmu.m, Yunmu.o, 5, "mo", "mo", PinyinHead.m, 'm'),
    mou1(Shengmu.m, Yunmu.ou, 1, "mōu", "mou", PinyinHead.m, 'm'),
    mou2(Shengmu.m, Yunmu.ou, 2, "móu", "mou", PinyinHead.m, 'm'),
    mou3(Shengmu.m, Yunmu.ou, 3, "mǒu", "mou", PinyinHead.m, 'm'),
    mou4(Shengmu.m, Yunmu.ou, 4, "mòu", "mou", PinyinHead.m, 'm'),
    mu2(Shengmu.m, Yunmu.u, 2, "mú", "mu", PinyinHead.m, 'm'),
    mu3(Shengmu.m, Yunmu.u, 3, "mǔ", "mu", PinyinHead.m, 'm'),
    mu4(Shengmu.m, Yunmu.u, 4, "mù", "mu", PinyinHead.m, 'm'),
    na1(Shengmu.n, Yunmu.a, 1, "nā", "na", PinyinHead.n, 'n'),
    na2(Shengmu.n, Yunmu.a, 2, "ná", "na", PinyinHead.n, 'n'),
    na3(Shengmu.n, Yunmu.a, 3, "nǎ", "na", PinyinHead.n, 'n'),
    na4(Shengmu.n, Yunmu.a, 4, "nà", "na", PinyinHead.n, 'n'),
    na5(Shengmu.n, Yunmu.a, 5, "na", "na", PinyinHead.n, 'n'),
    nai2(Shengmu.n, Yunmu.ai, 2, "nái", "nai", PinyinHead.n, 'n'),
    nai3(Shengmu.n, Yunmu.ai, 3, "nǎi", "nai", PinyinHead.n, 'n'),
    nai4(Shengmu.n, Yunmu.ai, 4, "nài", "nai", PinyinHead.n, 'n'),
    nan1(Shengmu.n, Yunmu.an, 1, "nān", "nan", PinyinHead.n, 'n'),
    nan2(Shengmu.n, Yunmu.an, 2, "nán", "nan", PinyinHead.n, 'n'),
    nan3(Shengmu.n, Yunmu.an, 3, "nǎn", "nan", PinyinHead.n, 'n'),
    nan4(Shengmu.n, Yunmu.an, 4, "nàn", "nan", PinyinHead.n, 'n'),
    nang1(Shengmu.n, Yunmu.ang, 1, "nāng", "nang", PinyinHead.n, 'n'),
    nang2(Shengmu.n, Yunmu.ang, 2, "náng", "nang", PinyinHead.n, 'n'),
    nang3(Shengmu.n, Yunmu.ang, 3, "nǎng", "nang", PinyinHead.n, 'n'),
    nang4(Shengmu.n, Yunmu.ang, 4, "nàng", "nang", PinyinHead.n, 'n'),
    nao1(Shengmu.n, Yunmu.ao, 1, "nāo", "nao", PinyinHead.n, 'n'),
    nao2(Shengmu.n, Yunmu.ao, 2, "náo", "nao", PinyinHead.n, 'n'),
    nao3(Shengmu.n, Yunmu.ao, 3, "nǎo", "nao", PinyinHead.n, 'n'),
    nao4(Shengmu.n, Yunmu.ao, 4, "nào", "nao", PinyinHead.n, 'n'),
    ne2(Shengmu.n, Yunmu.e, 2, "né", "ne", PinyinHead.n, 'n'),
    ne4(Shengmu.n, Yunmu.e, 4, "nè", "ne", PinyinHead.n, 'n'),
    ne5(Shengmu.n, Yunmu.e, 5, "ne", "ne", PinyinHead.n, 'n'),
    nei3(Shengmu.n, Yunmu.ei, 3, "něi", "nei", PinyinHead.n, 'n'),
    nei4(Shengmu.n, Yunmu.ei, 4, "nèi", "nei", PinyinHead.n, 'n'),
    nen1(Shengmu.n, Yunmu.en, 1, "nēn", "nen", PinyinHead.n, 'n'),
    nen3(Shengmu.n, Yunmu.en, 3, "něn", "nen", PinyinHead.n, 'n'),
    nen4(Shengmu.n, Yunmu.en, 4, "nèn", "nen", PinyinHead.n, 'n'),
    neng2(Shengmu.n, Yunmu.eng, 2, "néng", "neng", PinyinHead.n, 'n'),
    neng3(Shengmu.n, Yunmu.eng, 3, "něng", "neng", PinyinHead.n, 'n'),
    ni1(Shengmu.n, Yunmu.i, 1, "nī", "ni", PinyinHead.n, 'n'),
    ni2(Shengmu.n, Yunmu.i, 2, "ní", "ni", PinyinHead.n, 'n'),
    ni3(Shengmu.n, Yunmu.i, 3, "nǐ", "ni", PinyinHead.n, 'n'),
    ni4(Shengmu.n, Yunmu.i, 4, "nì", "ni", PinyinHead.n, 'n'),
    nian1(Shengmu.n, Yunmu.ian, 1, "niān", "nian", PinyinHead.n, 'n'),
    nian2(Shengmu.n, Yunmu.ian, 2, "nián", "nian", PinyinHead.n, 'n'),
    nian3(Shengmu.n, Yunmu.ian, 3, "niǎn", "nian", PinyinHead.n, 'n'),
    nian4(Shengmu.n, Yunmu.ian, 4, "niàn", "nian", PinyinHead.n, 'n'),
    niang2(Shengmu.n, Yunmu.iang, 2, "niáng", "niang", PinyinHead.n, 'n'),
    niang4(Shengmu.n, Yunmu.iang, 4, "niàng", "niang", PinyinHead.n, 'n'),
    niao3(Shengmu.n, Yunmu.iao, 3, "niǎo", "niao", PinyinHead.n, 'n'),
    niao4(Shengmu.n, Yunmu.iao, 4, "niào", "niao", PinyinHead.n, 'n'),
    nie1(Shengmu.n, Yunmu.ie, 1, "niē", "nie", PinyinHead.n, 'n'),
    nie2(Shengmu.n, Yunmu.ie, 2, "nié", "nie", PinyinHead.n, 'n'),
    nie3(Shengmu.n, Yunmu.ie, 3, "niě", "nie", PinyinHead.n, 'n'),
    nie4(Shengmu.n, Yunmu.ie, 4, "niè", "nie", PinyinHead.n, 'n'),
    nin2(Shengmu.n, Yunmu.in, 2, "nín", "nin", PinyinHead.n, 'n'),
    nin3(Shengmu.n, Yunmu.in, 3, "nǐn", "nin", PinyinHead.n, 'n'),
    ning2(Shengmu.n, Yunmu.ing, 2, "níng", "ning", PinyinHead.n, 'n'),
    ning3(Shengmu.n, Yunmu.ing, 3, "nǐng", "ning", PinyinHead.n, 'n'),
    ning4(Shengmu.n, Yunmu.ing, 4, "nìng", "ning", PinyinHead.n, 'n'),
    niu1(Shengmu.n, Yunmu.iu, 1, "niū", "niu", PinyinHead.n, 'n'),
    niu2(Shengmu.n, Yunmu.iu, 2, "niú", "niu", PinyinHead.n, 'n'),
    niu3(Shengmu.n, Yunmu.iu, 3, "niǔ", "niu", PinyinHead.n, 'n'),
    niu4(Shengmu.n, Yunmu.iu, 4, "niù", "niu", PinyinHead.n, 'n'),
    nong2(Shengmu.n, Yunmu.ong, 2, "nóng", "nong", PinyinHead.n, 'n'),
    nong3(Shengmu.n, Yunmu.ong, 3, "nǒng", "nong", PinyinHead.n, 'n'),
    nong4(Shengmu.n, Yunmu.ong, 4, "nòng", "nong", PinyinHead.n, 'n'),
    nou2(Shengmu.n, Yunmu.ou, 2, "nóu", "nou", PinyinHead.n, 'n'),
    nou4(Shengmu.n, Yunmu.ou, 4, "nòu", "nou", PinyinHead.n, 'n'),
    nu2(Shengmu.n, Yunmu.u, 2, "nú", "nu", PinyinHead.n, 'n'),
    nu3(Shengmu.n, Yunmu.u, 3, "nǔ", "nu", PinyinHead.n, 'n'),
    nu4(Shengmu.n, Yunmu.u, 4, "nù", "nu", PinyinHead.n, 'n'),
    nuan2(Shengmu.n, Yunmu.uan, 2, "nuán", "nuan", PinyinHead.n, 'n'),
    nuan3(Shengmu.n, Yunmu.uan, 3, "nuǎn", "nuan", PinyinHead.n, 'n'),
    nuan4(Shengmu.n, Yunmu.uan, 4, "nuàn", "nuan", PinyinHead.n, 'n'),
    nun2(Shengmu.n, Yunmu.un, 2, "nún", "nun", PinyinHead.n, 'n'),
    nun4(Shengmu.n, Yunmu.un, 4, "nùn", "nun", PinyinHead.n, 'n'),
    nuo2(Shengmu.n, Yunmu.uo, 2, "nuó", "nuo", PinyinHead.n, 'n'),
    nuo3(Shengmu.n, Yunmu.uo, 3, "nuǒ", "nuo", PinyinHead.n, 'n'),
    nuo4(Shengmu.n, Yunmu.uo, 4, "nuò", "nuo", PinyinHead.n, 'n'),
    nv3(Shengmu.n, Yunmu.v, 3, "nǚ", "nv", PinyinHead.n, 'n'),
    nv4(Shengmu.n, Yunmu.v, 4, "nǜ", "nv", PinyinHead.n, 'n'),
    nve4(Shengmu.n, Yunmu.ue, 4, "nüè", "nve", PinyinHead.n, 'n'),
    o1(Shengmu.none, Yunmu.o, 1, "ō", "o", PinyinHead.o, 'o'),
    o2(Shengmu.none, Yunmu.o, 2, "ó", "o", PinyinHead.o, 'o'),
    o3(Shengmu.none, Yunmu.o, 3, "ǒ", "o", PinyinHead.o, 'o'),
    o4(Shengmu.none, Yunmu.o, 4, "ò", "o", PinyinHead.o, 'o'),
    o5(Shengmu.none, Yunmu.o, 5, "o", "o", PinyinHead.o, 'o'),
    ou1(Shengmu.none, Yunmu.ou, 1, "ōu", "ou", PinyinHead.o, 'o'),
    ou2(Shengmu.none, Yunmu.ou, 2, "óu", "ou", PinyinHead.o, 'o'),
    ou3(Shengmu.none, Yunmu.ou, 3, "ǒu", "ou", PinyinHead.o, 'o'),
    ou4(Shengmu.none, Yunmu.ou, 4, "òu", "ou", PinyinHead.o, 'o'),
    ou5(Shengmu.none, Yunmu.ou, 5, "ou", "ou", PinyinHead.o, 'o'),
    pa1(Shengmu.p, Yunmu.a, 1, "pā", "pa", PinyinHead.p, 'p'),
    pa2(Shengmu.p, Yunmu.a, 2, "pá", "pa", PinyinHead.p, 'p'),
    pa4(Shengmu.p, Yunmu.a, 4, "pà", "pa", PinyinHead.p, 'p'),
    pai1(Shengmu.p, Yunmu.ai, 1, "pāi", "pai", PinyinHead.p, 'p'),
    pai2(Shengmu.p, Yunmu.ai, 2, "pái", "pai", PinyinHead.p, 'p'),
    pai3(Shengmu.p, Yunmu.ai, 3, "pǎi", "pai", PinyinHead.p, 'p'),
    pai4(Shengmu.p, Yunmu.ai, 4, "pài", "pai", PinyinHead.p, 'p'),
    pan1(Shengmu.p, Yunmu.an, 1, "pān", "pan", PinyinHead.p, 'p'),
    pan2(Shengmu.p, Yunmu.an, 2, "pán", "pan", PinyinHead.p, 'p'),
    pan3(Shengmu.p, Yunmu.an, 3, "pǎn", "pan", PinyinHead.p, 'p'),
    pan4(Shengmu.p, Yunmu.an, 4, "pàn", "pan", PinyinHead.p, 'p'),
    pang1(Shengmu.p, Yunmu.ang, 1, "pāng", "pang", PinyinHead.p, 'p'),
    pang2(Shengmu.p, Yunmu.ang, 2, "páng", "pang", PinyinHead.p, 'p'),
    pang3(Shengmu.p, Yunmu.ang, 3, "pǎng", "pang", PinyinHead.p, 'p'),
    pang4(Shengmu.p, Yunmu.ang, 4, "pàng", "pang", PinyinHead.p, 'p'),
    pang5(Shengmu.p, Yunmu.ang, 5, "pang", "pang", PinyinHead.p, 'p'),
    pao1(Shengmu.p, Yunmu.ao, 1, "pāo", "pao", PinyinHead.p, 'p'),
    pao2(Shengmu.p, Yunmu.ao, 2, "páo", "pao", PinyinHead.p, 'p'),
    pao3(Shengmu.p, Yunmu.ao, 3, "pǎo", "pao", PinyinHead.p, 'p'),
    pao4(Shengmu.p, Yunmu.ao, 4, "pào", "pao", PinyinHead.p, 'p'),
    pei1(Shengmu.p, Yunmu.ei, 1, "pēi", "pei", PinyinHead.p, 'p'),
    pei2(Shengmu.p, Yunmu.ei, 2, "péi", "pei", PinyinHead.p, 'p'),
    pei3(Shengmu.p, Yunmu.ei, 3, "pěi", "pei", PinyinHead.p, 'p'),
    pei4(Shengmu.p, Yunmu.ei, 4, "pèi", "pei", PinyinHead.p, 'p'),
    pen1(Shengmu.p, Yunmu.en, 1, "pēn", "pen", PinyinHead.p, 'p'),
    pen2(Shengmu.p, Yunmu.en, 2, "pén", "pen", PinyinHead.p, 'p'),
    pen3(Shengmu.p, Yunmu.en, 3, "pěn", "pen", PinyinHead.p, 'p'),
    pen4(Shengmu.p, Yunmu.en, 4, "pèn", "pen", PinyinHead.p, 'p'),
    pen5(Shengmu.p, Yunmu.en, 5, "pen", "pen", PinyinHead.p, 'p'),
    peng1(Shengmu.p, Yunmu.eng, 1, "pēng", "peng", PinyinHead.p, 'p'),
    peng2(Shengmu.p, Yunmu.eng, 2, "péng", "peng", PinyinHead.p, 'p'),
    peng3(Shengmu.p, Yunmu.eng, 3, "pěng", "peng", PinyinHead.p, 'p'),
    peng4(Shengmu.p, Yunmu.eng, 4, "pèng", "peng", PinyinHead.p, 'p'),
    pi1(Shengmu.p, Yunmu.i, 1, "pī", "pi", PinyinHead.p, 'p'),
    pi2(Shengmu.p, Yunmu.i, 2, "pí", "pi", PinyinHead.p, 'p'),
    pi3(Shengmu.p, Yunmu.i, 3, "pǐ", "pi", PinyinHead.p, 'p'),
    pi4(Shengmu.p, Yunmu.i, 4, "pì", "pi", PinyinHead.p, 'p'),
    pi5(Shengmu.p, Yunmu.i, 5, "pi", "pi", PinyinHead.p, 'p'),
    pian1(Shengmu.p, Yunmu.ian, 1, "piān", "pian", PinyinHead.p, 'p'),
    pian2(Shengmu.p, Yunmu.ian, 2, "pián", "pian", PinyinHead.p, 'p'),
    pian3(Shengmu.p, Yunmu.ian, 3, "piǎn", "pian", PinyinHead.p, 'p'),
    pian4(Shengmu.p, Yunmu.ian, 4, "piàn", "pian", PinyinHead.p, 'p'),
    piao1(Shengmu.p, Yunmu.iao, 1, "piāo", "piao", PinyinHead.p, 'p'),
    piao2(Shengmu.p, Yunmu.iao, 2, "piáo", "piao", PinyinHead.p, 'p'),
    piao3(Shengmu.p, Yunmu.iao, 3, "piǎo", "piao", PinyinHead.p, 'p'),
    piao4(Shengmu.p, Yunmu.iao, 4, "piào", "piao", PinyinHead.p, 'p'),
    pie1(Shengmu.p, Yunmu.ie, 1, "piē", "pie", PinyinHead.p, 'p'),
    pie3(Shengmu.p, Yunmu.ie, 3, "piě", "pie", PinyinHead.p, 'p'),
    pie4(Shengmu.p, Yunmu.ie, 4, "piè", "pie", PinyinHead.p, 'p'),
    pin1(Shengmu.p, Yunmu.in, 1, "pīn", "pin", PinyinHead.p, 'p'),
    pin2(Shengmu.p, Yunmu.in, 2, "pín", "pin", PinyinHead.p, 'p'),
    pin3(Shengmu.p, Yunmu.in, 3, "pǐn", "pin", PinyinHead.p, 'p'),
    pin4(Shengmu.p, Yunmu.in, 4, "pìn", "pin", PinyinHead.p, 'p'),
    ping1(Shengmu.p, Yunmu.ing, 1, "pīng", "ping", PinyinHead.p, 'p'),
    ping2(Shengmu.p, Yunmu.ing, 2, "píng", "ping", PinyinHead.p, 'p'),
    ping3(Shengmu.p, Yunmu.ing, 3, "pǐng", "ping", PinyinHead.p, 'p'),
    ping4(Shengmu.p, Yunmu.ing, 4, "pìng", "ping", PinyinHead.p, 'p'),
    po1(Shengmu.p, Yunmu.o, 1, "pō", "po", PinyinHead.p, 'p'),
    po2(Shengmu.p, Yunmu.o, 2, "pó", "po", PinyinHead.p, 'p'),
    po3(Shengmu.p, Yunmu.o, 3, "pǒ", "po", PinyinHead.p, 'p'),
    po4(Shengmu.p, Yunmu.o, 4, "pò", "po", PinyinHead.p, 'p'),
    po5(Shengmu.p, Yunmu.o, 5, "po", "po", PinyinHead.p, 'p'),
    pou1(Shengmu.p, Yunmu.ou, 1, "pōu", "pou", PinyinHead.p, 'p'),
    pou2(Shengmu.p, Yunmu.ou, 2, "póu", "pou", PinyinHead.p, 'p'),
    pou3(Shengmu.p, Yunmu.ou, 3, "pǒu", "pou", PinyinHead.p, 'p'),
    pou4(Shengmu.p, Yunmu.ou, 4, "pòu", "pou", PinyinHead.p, 'p'),
    pu1(Shengmu.p, Yunmu.u, 1, "pū", "pu", PinyinHead.p, 'p'),
    pu2(Shengmu.p, Yunmu.u, 2, "pú", "pu", PinyinHead.p, 'p'),
    pu3(Shengmu.p, Yunmu.u, 3, "pǔ", "pu", PinyinHead.p, 'p'),
    pu4(Shengmu.p, Yunmu.u, 4, "pù", "pu", PinyinHead.p, 'p'),
    qi1(Shengmu.q, Yunmu.i, 1, "qī", "qi", PinyinHead.q, 'q'),
    qi2(Shengmu.q, Yunmu.i, 2, "qí", "qi", PinyinHead.q, 'q'),
    qi3(Shengmu.q, Yunmu.i, 3, "qǐ", "qi", PinyinHead.q, 'q'),
    qi4(Shengmu.q, Yunmu.i, 4, "qì", "qi", PinyinHead.q, 'q'),
    qi5(Shengmu.q, Yunmu.i, 5, "qi", "qi", PinyinHead.q, 'q'),
    qia1(Shengmu.q, Yunmu.ia, 1, "qiā", "qia", PinyinHead.q, 'q'),
    qia3(Shengmu.q, Yunmu.ia, 3, "qiǎ", "qia", PinyinHead.q, 'q'),
    qia4(Shengmu.q, Yunmu.ia, 4, "qià", "qia", PinyinHead.q, 'q'),
    qian1(Shengmu.q, Yunmu.ian, 1, "qiān", "qian", PinyinHead.q, 'q'),
    qian2(Shengmu.q, Yunmu.ian, 2, "qián", "qian", PinyinHead.q, 'q'),
    qian3(Shengmu.q, Yunmu.ian, 3, "qiǎn", "qian", PinyinHead.q, 'q'),
    qian4(Shengmu.q, Yunmu.ian, 4, "qiàn", "qian", PinyinHead.q, 'q'),
    qian5(Shengmu.q, Yunmu.ian, 5, "qian", "qian", PinyinHead.q, 'q'),
    qiang1(Shengmu.q, Yunmu.iang, 1, "qiāng", "qiang", PinyinHead.q, 'q'),
    qiang2(Shengmu.q, Yunmu.iang, 2, "qiáng", "qiang", PinyinHead.q, 'q'),
    qiang3(Shengmu.q, Yunmu.iang, 3, "qiǎng", "qiang", PinyinHead.q, 'q'),
    qiang4(Shengmu.q, Yunmu.iang, 4, "qiàng", "qiang", PinyinHead.q, 'q'),
    qiao1(Shengmu.q, Yunmu.iao, 1, "qiāo", "qiao", PinyinHead.q, 'q'),
    qiao2(Shengmu.q, Yunmu.iao, 2, "qiáo", "qiao", PinyinHead.q, 'q'),
    qiao3(Shengmu.q, Yunmu.iao, 3, "qiǎo", "qiao", PinyinHead.q, 'q'),
    qiao4(Shengmu.q, Yunmu.iao, 4, "qiào", "qiao", PinyinHead.q, 'q'),
    qie1(Shengmu.q, Yunmu.ie, 1, "qiē", "qie", PinyinHead.q, 'q'),
    qie2(Shengmu.q, Yunmu.ie, 2, "qié", "qie", PinyinHead.q, 'q'),
    qie3(Shengmu.q, Yunmu.ie, 3, "qiě", "qie", PinyinHead.q, 'q'),
    qie4(Shengmu.q, Yunmu.ie, 4, "qiè", "qie", PinyinHead.q, 'q'),
    qin1(Shengmu.q, Yunmu.in, 1, "qīn", "qin", PinyinHead.q, 'q'),
    qin2(Shengmu.q, Yunmu.in, 2, "qín", "qin", PinyinHead.q, 'q'),
    qin3(Shengmu.q, Yunmu.in, 3, "qǐn", "qin", PinyinHead.q, 'q'),
    qin4(Shengmu.q, Yunmu.in, 4, "qìn", "qin", PinyinHead.q, 'q'),
    qing1(Shengmu.q, Yunmu.ing, 1, "qīng", "qing", PinyinHead.q, 'q'),
    qing2(Shengmu.q, Yunmu.ing, 2, "qíng", "qing", PinyinHead.q, 'q'),
    qing3(Shengmu.q, Yunmu.ing, 3, "qǐng", "qing", PinyinHead.q, 'q'),
    qing4(Shengmu.q, Yunmu.ing, 4, "qìng", "qing", PinyinHead.q, 'q'),
    qiong1(Shengmu.q, Yunmu.iong, 1, "qiōng", "qiong", PinyinHead.q, 'q'),
    qiong2(Shengmu.q, Yunmu.iong, 2, "qióng", "qiong", PinyinHead.q, 'q'),
    qiong3(Shengmu.q, Yunmu.iong, 3, "qiǒng", "qiong", PinyinHead.q, 'q'),
    qiu1(Shengmu.q, Yunmu.iu, 1, "qiū", "qiu", PinyinHead.q, 'q'),
    qiu2(Shengmu.q, Yunmu.iu, 2, "qiú", "qiu", PinyinHead.q, 'q'),
    qiu3(Shengmu.q, Yunmu.iu, 3, "qiǔ", "qiu", PinyinHead.q, 'q'),
    qiu4(Shengmu.q, Yunmu.iu, 4, "qiù", "qiu", PinyinHead.q, 'q'),
    qu1(Shengmu.q, Yunmu.u, 1, "qū", "qu", PinyinHead.q, 'q'),
    qu2(Shengmu.q, Yunmu.u, 2, "qú", "qu", PinyinHead.q, 'q'),
    qu3(Shengmu.q, Yunmu.u, 3, "qǔ", "qu", PinyinHead.q, 'q'),
    qu4(Shengmu.q, Yunmu.u, 4, "qù", "qu", PinyinHead.q, 'q'),
    quan1(Shengmu.q, Yunmu.uan, 1, "quān", "quan", PinyinHead.q, 'q'),
    quan2(Shengmu.q, Yunmu.uan, 2, "quán", "quan", PinyinHead.q, 'q'),
    quan3(Shengmu.q, Yunmu.uan, 3, "quǎn", "quan", PinyinHead.q, 'q'),
    quan4(Shengmu.q, Yunmu.uan, 4, "quàn", "quan", PinyinHead.q, 'q'),
    que1(Shengmu.q, Yunmu.ue, 1, "quē", "que", PinyinHead.q, 'q'),
    que2(Shengmu.q, Yunmu.ue, 2, "qué", "que", PinyinHead.q, 'q'),
    que4(Shengmu.q, Yunmu.ue, 4, "què", "que", PinyinHead.q, 'q'),
    qun1(Shengmu.q, Yunmu.un, 1, "qūn", "qun", PinyinHead.q, 'q'),
    qun2(Shengmu.q, Yunmu.un, 2, "qún", "qun", PinyinHead.q, 'q'),
    qun3(Shengmu.q, Yunmu.un, 3, "qǔn", "qun", PinyinHead.q, 'q'),
    ran2(Shengmu.r, Yunmu.an, 2, "rán", "ran", PinyinHead.r, 'r'),
    ran3(Shengmu.r, Yunmu.an, 3, "rǎn", "ran", PinyinHead.r, 'r'),
    rang1(Shengmu.r, Yunmu.ang, 1, "rāng", "rang", PinyinHead.r, 'r'),
    rang2(Shengmu.r, Yunmu.ang, 2, "ráng", "rang", PinyinHead.r, 'r'),
    rang3(Shengmu.r, Yunmu.ang, 3, "rǎng", "rang", PinyinHead.r, 'r'),
    rang4(Shengmu.r, Yunmu.ang, 4, "ràng", "rang", PinyinHead.r, 'r'),
    rao2(Shengmu.r, Yunmu.ao, 2, "ráo", "rao", PinyinHead.r, 'r'),
    rao3(Shengmu.r, Yunmu.ao, 3, "rǎo", "rao", PinyinHead.r, 'r'),
    rao4(Shengmu.r, Yunmu.ao, 4, "rào", "rao", PinyinHead.r, 'r'),
    re2(Shengmu.r, Yunmu.e, 2, "ré", "re", PinyinHead.r, 'r'),
    re3(Shengmu.r, Yunmu.e, 3, "rě", "re", PinyinHead.r, 'r'),
    re4(Shengmu.r, Yunmu.e, 4, "rè", "re", PinyinHead.r, 'r'),
    ren2(Shengmu.r, Yunmu.en, 2, "rén", "ren", PinyinHead.r, 'r'),
    ren3(Shengmu.r, Yunmu.en, 3, "rěn", "ren", PinyinHead.r, 'r'),
    ren4(Shengmu.r, Yunmu.en, 4, "rèn", "ren", PinyinHead.r, 'r'),
    reng1(Shengmu.r, Yunmu.eng, 1, "rēng", "reng", PinyinHead.r, 'r'),
    reng2(Shengmu.r, Yunmu.eng, 2, "réng", "reng", PinyinHead.r, 'r'),
    reng4(Shengmu.r, Yunmu.eng, 4, "rèng", "reng", PinyinHead.r, 'r'),
    ri4(Shengmu.r, Yunmu.i, 4, "rì", "ri", PinyinHead.r, 'r'),
    rong2(Shengmu.r, Yunmu.ong, 2, "róng", "rong", PinyinHead.r, 'r'),
    rong3(Shengmu.r, Yunmu.ong, 3, "rǒng", "rong", PinyinHead.r, 'r'),
    rong4(Shengmu.r, Yunmu.ong, 4, "ròng", "rong", PinyinHead.r, 'r'),
    rou2(Shengmu.r, Yunmu.ou, 2, "róu", "rou", PinyinHead.r, 'r'),
    rou3(Shengmu.r, Yunmu.ou, 3, "rǒu", "rou", PinyinHead.r, 'r'),
    rou4(Shengmu.r, Yunmu.ou, 4, "ròu", "rou", PinyinHead.r, 'r'),
    ru1(Shengmu.r, Yunmu.u, 1, "rū", "ru", PinyinHead.r, 'r'),
    ru2(Shengmu.r, Yunmu.u, 2, "rú", "ru", PinyinHead.r, 'r'),
    ru3(Shengmu.r, Yunmu.u, 3, "rǔ", "ru", PinyinHead.r, 'r'),
    ru4(Shengmu.r, Yunmu.u, 4, "rù", "ru", PinyinHead.r, 'r'),
    ruan2(Shengmu.r, Yunmu.uan, 2, "ruán", "ruan", PinyinHead.r, 'r'),
    ruan3(Shengmu.r, Yunmu.uan, 3, "ruǎn", "ruan", PinyinHead.r, 'r'),
    ruan4(Shengmu.r, Yunmu.uan, 4, "ruàn", "ruan", PinyinHead.r, 'r'),
    rui2(Shengmu.r, Yunmu.ui, 2, "ruí", "rui", PinyinHead.r, 'r'),
    rui3(Shengmu.r, Yunmu.ui, 3, "ruǐ", "rui", PinyinHead.r, 'r'),
    rui4(Shengmu.r, Yunmu.ui, 4, "ruì", "rui", PinyinHead.r, 'r'),
    run2(Shengmu.r, Yunmu.un, 2, "rún", "run", PinyinHead.r, 'r'),
    run4(Shengmu.r, Yunmu.un, 4, "rùn", "run", PinyinHead.r, 'r'),
    ruo2(Shengmu.r, Yunmu.uo, 2, "ruó", "ruo", PinyinHead.r, 'r'),
    ruo4(Shengmu.r, Yunmu.uo, 4, "ruò", "ruo", PinyinHead.r, 'r'),
    sa1(Shengmu.s, Yunmu.a, 1, "sā", "sa", PinyinHead.s, 's'),
    sa3(Shengmu.s, Yunmu.a, 3, "sǎ", "sa", PinyinHead.s, 's'),
    sa4(Shengmu.s, Yunmu.a, 4, "sà", "sa", PinyinHead.s, 's'),
    sai1(Shengmu.s, Yunmu.ai, 1, "sāi", "sai", PinyinHead.s, 's'),
    sai3(Shengmu.s, Yunmu.ai, 3, "sǎi", "sai", PinyinHead.s, 's'),
    sai4(Shengmu.s, Yunmu.ai, 4, "sài", "sai", PinyinHead.s, 's'),
    sai5(Shengmu.s, Yunmu.ai, 5, "sai", "sai", PinyinHead.s, 's'),
    san1(Shengmu.s, Yunmu.an, 1, "sān", "san", PinyinHead.s, 's'),
    san3(Shengmu.s, Yunmu.an, 3, "sǎn", "san", PinyinHead.s, 's'),
    san4(Shengmu.s, Yunmu.an, 4, "sàn", "san", PinyinHead.s, 's'),
    san5(Shengmu.s, Yunmu.an, 5, "san", "san", PinyinHead.s, 's'),
    sang1(Shengmu.s, Yunmu.ang, 1, "sāng", "sang", PinyinHead.s, 's'),
    sang3(Shengmu.s, Yunmu.ang, 3, "sǎng", "sang", PinyinHead.s, 's'),
    sang4(Shengmu.s, Yunmu.ang, 4, "sàng", "sang", PinyinHead.s, 's'),
    sang5(Shengmu.s, Yunmu.ang, 5, "sang", "sang", PinyinHead.s, 's'),
    sao1(Shengmu.s, Yunmu.ao, 1, "sāo", "sao", PinyinHead.s, 's'),
    sao3(Shengmu.s, Yunmu.ao, 3, "sǎo", "sao", PinyinHead.s, 's'),
    sao4(Shengmu.s, Yunmu.ao, 4, "sào", "sao", PinyinHead.s, 's'),
    se1(Shengmu.s, Yunmu.e, 1, "sē", "se", PinyinHead.s, 's'),
    se4(Shengmu.s, Yunmu.e, 4, "sè", "se", PinyinHead.s, 's'),
    sen1(Shengmu.s, Yunmu.en, 1, "sēn", "sen", PinyinHead.s, 's'),
    sen3(Shengmu.s, Yunmu.en, 3, "sěn", "sen", PinyinHead.s, 's'),
    seng1(Shengmu.s, Yunmu.eng, 1, "sēng", "seng", PinyinHead.s, 's'),
    sha1(Shengmu.sh, Yunmu.a, 1, "shā", "sha", PinyinHead.sh, 's'),
    sha2(Shengmu.sh, Yunmu.a, 2, "shá", "sha", PinyinHead.sh, 's'),
    sha3(Shengmu.sh, Yunmu.a, 3, "shǎ", "sha", PinyinHead.sh, 's'),
    sha4(Shengmu.sh, Yunmu.a, 4, "shà", "sha", PinyinHead.sh, 's'),
    shai1(Shengmu.sh, Yunmu.ai, 1, "shāi", "shai", PinyinHead.sh, 's'),
    shai3(Shengmu.sh, Yunmu.ai, 3, "shǎi", "shai", PinyinHead.sh, 's'),
    shai4(Shengmu.sh, Yunmu.ai, 4, "shài", "shai", PinyinHead.sh, 's'),
    shan1(Shengmu.sh, Yunmu.an, 1, "shān", "shan", PinyinHead.sh, 's'),
    shan2(Shengmu.sh, Yunmu.an, 2, "shán", "shan", PinyinHead.sh, 's'),
    shan3(Shengmu.sh, Yunmu.an, 3, "shǎn", "shan", PinyinHead.sh, 's'),
    shan4(Shengmu.sh, Yunmu.an, 4, "shàn", "shan", PinyinHead.sh, 's'),
    shang1(Shengmu.sh, Yunmu.ang, 1, "shāng", "shang", PinyinHead.sh, 's'),
    shang2(Shengmu.sh, Yunmu.ang, 2, "sháng", "shang", PinyinHead.sh, 's'),
    shang3(Shengmu.sh, Yunmu.ang, 3, "shǎng", "shang", PinyinHead.sh, 's'),
    shang4(Shengmu.sh, Yunmu.ang, 4, "shàng", "shang", PinyinHead.sh, 's'),
    shang5(Shengmu.sh, Yunmu.ang, 5, "shang", "shang", PinyinHead.sh, 's'),
    shao1(Shengmu.sh, Yunmu.ao, 1, "shāo", "shao", PinyinHead.sh, 's'),
    shao2(Shengmu.sh, Yunmu.ao, 2, "sháo", "shao", PinyinHead.sh, 's'),
    shao3(Shengmu.sh, Yunmu.ao, 3, "shǎo", "shao", PinyinHead.sh, 's'),
    shao4(Shengmu.sh, Yunmu.ao, 4, "shào", "shao", PinyinHead.sh, 's'),
    she1(Shengmu.sh, Yunmu.e, 1, "shē", "she", PinyinHead.sh, 's'),
    she2(Shengmu.sh, Yunmu.e, 2, "shé", "she", PinyinHead.sh, 's'),
    she3(Shengmu.sh, Yunmu.e, 3, "shě", "she", PinyinHead.sh, 's'),
    she4(Shengmu.sh, Yunmu.e, 4, "shè", "she", PinyinHead.sh, 's'),
    shei2(Shengmu.sh, Yunmu.ei, 2, "shéi", "shei", PinyinHead.sh, 's'),
    shen1(Shengmu.sh, Yunmu.en, 1, "shēn", "shen", PinyinHead.sh, 's'),
    shen2(Shengmu.sh, Yunmu.en, 2, "shén", "shen", PinyinHead.sh, 's'),
    shen3(Shengmu.sh, Yunmu.en, 3, "shěn", "shen", PinyinHead.sh, 's'),
    shen4(Shengmu.sh, Yunmu.en, 4, "shèn", "shen", PinyinHead.sh, 's'),
    sheng1(Shengmu.sh, Yunmu.eng, 1, "shēng", "sheng", PinyinHead.sh, 's'),
    sheng2(Shengmu.sh, Yunmu.eng, 2, "shéng", "sheng", PinyinHead.sh, 's'),
    sheng3(Shengmu.sh, Yunmu.eng, 3, "shěng", "sheng", PinyinHead.sh, 's'),
    sheng4(Shengmu.sh, Yunmu.eng, 4, "shèng", "sheng", PinyinHead.sh, 's'),
    shi1(Shengmu.sh, Yunmu.i, 1, "shī", "shi", PinyinHead.sh, 's'),
    shi2(Shengmu.sh, Yunmu.i, 2, "shí", "shi", PinyinHead.sh, 's'),
    shi3(Shengmu.sh, Yunmu.i, 3, "shǐ", "shi", PinyinHead.sh, 's'),
    shi4(Shengmu.sh, Yunmu.i, 4, "shì", "shi", PinyinHead.sh, 's'),
    shi5(Shengmu.sh, Yunmu.i, 5, "shi", "shi", PinyinHead.sh, 's'),
    shou1(Shengmu.sh, Yunmu.ou, 1, "shōu", "shou", PinyinHead.sh, 's'),
    shou2(Shengmu.sh, Yunmu.ou, 2, "shóu", "shou", PinyinHead.sh, 's'),
    shou3(Shengmu.sh, Yunmu.ou, 3, "shǒu", "shou", PinyinHead.sh, 's'),
    shou4(Shengmu.sh, Yunmu.ou, 4, "shòu", "shou", PinyinHead.sh, 's'),
    shu1(Shengmu.sh, Yunmu.u, 1, "shū", "shu", PinyinHead.sh, 's'),
    shu2(Shengmu.sh, Yunmu.u, 2, "shú", "shu", PinyinHead.sh, 's'),
    shu3(Shengmu.sh, Yunmu.u, 3, "shǔ", "shu", PinyinHead.sh, 's'),
    shu4(Shengmu.sh, Yunmu.u, 4, "shù", "shu", PinyinHead.sh, 's'),
    shua1(Shengmu.sh, Yunmu.ua, 1, "shuā", "shua", PinyinHead.sh, 's'),
    shua3(Shengmu.sh, Yunmu.ua, 3, "shuǎ", "shua", PinyinHead.sh, 's'),
    shua4(Shengmu.sh, Yunmu.ua, 4, "shuà", "shua", PinyinHead.sh, 's'),
    shuai1(Shengmu.sh, Yunmu.uai, 1, "shuāi", "shuai", PinyinHead.sh, 's'),
    shuai3(Shengmu.sh, Yunmu.uai, 3, "shuǎi", "shuai", PinyinHead.sh, 's'),
    shuai4(Shengmu.sh, Yunmu.uai, 4, "shuài", "shuai", PinyinHead.sh, 's'),
    shuan1(Shengmu.sh, Yunmu.uan, 1, "shuān", "shuan", PinyinHead.sh, 's'),
    shuan4(Shengmu.sh, Yunmu.uan, 4, "shuàn", "shuan", PinyinHead.sh, 's'),
    shuang1(Shengmu.sh, Yunmu.uang, 1, "shuāng", "shuang", PinyinHead.sh, 's'),
    shuang3(Shengmu.sh, Yunmu.uang, 3, "shuǎng", "shuang", PinyinHead.sh, 's'),
    shuang4(Shengmu.sh, Yunmu.uang, 4, "shuàng", "shuang", PinyinHead.sh, 's'),
    shui2(Shengmu.sh, Yunmu.ui, 2, "shuí", "shui", PinyinHead.sh, 's'),
    shui3(Shengmu.sh, Yunmu.ui, 3, "shuǐ", "shui", PinyinHead.sh, 's'),
    shui4(Shengmu.sh, Yunmu.ui, 4, "shuì", "shui", PinyinHead.sh, 's'),
    shun1(Shengmu.sh, Yunmu.un, 1, "shūn", "shun", PinyinHead.sh, 's'),
    shun3(Shengmu.sh, Yunmu.un, 3, "shǔn", "shun", PinyinHead.sh, 's'),
    shun4(Shengmu.sh, Yunmu.un, 4, "shùn", "shun", PinyinHead.sh, 's'),
    shuo1(Shengmu.sh, Yunmu.uo, 1, "shuō", "shuo", PinyinHead.sh, 's'),
    shuo2(Shengmu.sh, Yunmu.uo, 2, "shuó", "shuo", PinyinHead.sh, 's'),
    shuo4(Shengmu.sh, Yunmu.uo, 4, "shuò", "shuo", PinyinHead.sh, 's'),
    si1(Shengmu.s, Yunmu.i, 1, "sī", "si", PinyinHead.s, 's'),
    si3(Shengmu.s, Yunmu.i, 3, "sǐ", "si", PinyinHead.s, 's'),
    si4(Shengmu.s, Yunmu.i, 4, "sì", "si", PinyinHead.s, 's'),
    song1(Shengmu.s, Yunmu.ong, 1, "sōng", "song", PinyinHead.s, 's'),
    song3(Shengmu.s, Yunmu.ong, 3, "sǒng", "song", PinyinHead.s, 's'),
    song4(Shengmu.s, Yunmu.ong, 4, "sòng", "song", PinyinHead.s, 's'),
    sou1(Shengmu.s, Yunmu.ou, 1, "sōu", "sou", PinyinHead.s, 's'),
    sou3(Shengmu.s, Yunmu.ou, 3, "sǒu", "sou", PinyinHead.s, 's'),
    sou4(Shengmu.s, Yunmu.ou, 4, "sòu", "sou", PinyinHead.s, 's'),
    su1(Shengmu.s, Yunmu.u, 1, "sū", "su", PinyinHead.s, 's'),
    su2(Shengmu.s, Yunmu.u, 2, "sú", "su", PinyinHead.s, 's'),
    su4(Shengmu.s, Yunmu.u, 4, "sù", "su", PinyinHead.s, 's'),
    suan1(Shengmu.s, Yunmu.uan, 1, "suān", "suan", PinyinHead.s, 's'),
    suan3(Shengmu.s, Yunmu.uan, 3, "suǎn", "suan", PinyinHead.s, 's'),
    suan4(Shengmu.s, Yunmu.uan, 4, "suàn", "suan", PinyinHead.s, 's'),
    sui1(Shengmu.s, Yunmu.ui, 1, "suī", "sui", PinyinHead.s, 's'),
    sui2(Shengmu.s, Yunmu.ui, 2, "suí", "sui", PinyinHead.s, 's'),
    sui3(Shengmu.s, Yunmu.ui, 3, "suǐ", "sui", PinyinHead.s, 's'),
    sui4(Shengmu.s, Yunmu.ui, 4, "suì", "sui", PinyinHead.s, 's'),
    sun1(Shengmu.s, Yunmu.un, 1, "sūn", "sun", PinyinHead.s, 's'),
    sun3(Shengmu.s, Yunmu.un, 3, "sǔn", "sun", PinyinHead.s, 's'),
    sun4(Shengmu.s, Yunmu.un, 4, "sùn", "sun", PinyinHead.s, 's'),
    suo1(Shengmu.s, Yunmu.uo, 1, "suō", "suo", PinyinHead.s, 's'),
    suo3(Shengmu.s, Yunmu.uo, 3, "suǒ", "suo", PinyinHead.s, 's'),
    suo4(Shengmu.s, Yunmu.uo, 4, "suò", "suo", PinyinHead.s, 's'),
    ta1(Shengmu.t, Yunmu.a, 1, "tā", "ta", PinyinHead.t, 't'),
    ta3(Shengmu.t, Yunmu.a, 3, "tǎ", "ta", PinyinHead.t, 't'),
    ta4(Shengmu.t, Yunmu.a, 4, "tà", "ta", PinyinHead.t, 't'),
    ta5(Shengmu.t, Yunmu.a, 5, "ta", "ta", PinyinHead.t, 't'),
    tai1(Shengmu.t, Yunmu.ai, 1, "tāi", "tai", PinyinHead.t, 't'),
    tai2(Shengmu.t, Yunmu.ai, 2, "tái", "tai", PinyinHead.t, 't'),
    tai3(Shengmu.t, Yunmu.ai, 3, "tǎi", "tai", PinyinHead.t, 't'),
    tai4(Shengmu.t, Yunmu.ai, 4, "tài", "tai", PinyinHead.t, 't'),
    tan1(Shengmu.t, Yunmu.an, 1, "tān", "tan", PinyinHead.t, 't'),
    tan2(Shengmu.t, Yunmu.an, 2, "tán", "tan", PinyinHead.t, 't'),
    tan3(Shengmu.t, Yunmu.an, 3, "tǎn", "tan", PinyinHead.t, 't'),
    tan4(Shengmu.t, Yunmu.an, 4, "tàn", "tan", PinyinHead.t, 't'),
    tang1(Shengmu.t, Yunmu.ang, 1, "tāng", "tang", PinyinHead.t, 't'),
    tang2(Shengmu.t, Yunmu.ang, 2, "táng", "tang", PinyinHead.t, 't'),
    tang3(Shengmu.t, Yunmu.ang, 3, "tǎng", "tang", PinyinHead.t, 't'),
    tang4(Shengmu.t, Yunmu.ang, 4, "tàng", "tang", PinyinHead.t, 't'),
    tao1(Shengmu.t, Yunmu.ao, 1, "tāo", "tao", PinyinHead.t, 't'),
    tao2(Shengmu.t, Yunmu.ao, 2, "táo", "tao", PinyinHead.t, 't'),
    tao3(Shengmu.t, Yunmu.ao, 3, "tǎo", "tao", PinyinHead.t, 't'),
    tao4(Shengmu.t, Yunmu.ao, 4, "tào", "tao", PinyinHead.t, 't'),
    te4(Shengmu.t, Yunmu.e, 4, "tè", "te", PinyinHead.t, 't'),
    teng1(Shengmu.t, Yunmu.eng, 1, "tēng", "teng", PinyinHead.t, 't'),
    teng2(Shengmu.t, Yunmu.eng, 2, "téng", "teng", PinyinHead.t, 't'),
    teng4(Shengmu.t, Yunmu.eng, 4, "tèng", "teng", PinyinHead.t, 't'),
    ti1(Shengmu.t, Yunmu.i, 1, "tī", "ti", PinyinHead.t, 't'),
    ti2(Shengmu.t, Yunmu.i, 2, "tí", "ti", PinyinHead.t, 't'),
    ti3(Shengmu.t, Yunmu.i, 3, "tǐ", "ti", PinyinHead.t, 't'),
    ti4(Shengmu.t, Yunmu.i, 4, "tì", "ti", PinyinHead.t, 't'),
    tian1(Shengmu.t, Yunmu.ian, 1, "tiān", "tian", PinyinHead.t, 't'),
    tian2(Shengmu.t, Yunmu.ian, 2, "tián", "tian", PinyinHead.t, 't'),
    tian3(Shengmu.t, Yunmu.ian, 3, "tiǎn", "tian", PinyinHead.t, 't'),
    tian4(Shengmu.t, Yunmu.ian, 4, "tiàn", "tian", PinyinHead.t, 't'),
    tian5(Shengmu.t, Yunmu.ian, 5, "tian", "tian", PinyinHead.t, 't'),
    tiao1(Shengmu.t, Yunmu.iao, 1, "tiāo", "tiao", PinyinHead.t, 't'),
    tiao2(Shengmu.t, Yunmu.iao, 2, "tiáo", "tiao", PinyinHead.t, 't'),
    tiao3(Shengmu.t, Yunmu.iao, 3, "tiǎo", "tiao", PinyinHead.t, 't'),
    tiao4(Shengmu.t, Yunmu.iao, 4, "tiào", "tiao", PinyinHead.t, 't'),
    tie1(Shengmu.t, Yunmu.ie, 1, "tiē", "tie", PinyinHead.t, 't'),
    tie2(Shengmu.t, Yunmu.ie, 2, "tié", "tie", PinyinHead.t, 't'),
    tie3(Shengmu.t, Yunmu.ie, 3, "tiě", "tie", PinyinHead.t, 't'),
    tie4(Shengmu.t, Yunmu.ie, 4, "tiè", "tie", PinyinHead.t, 't'),
    ting1(Shengmu.t, Yunmu.ing, 1, "tīng", "ting", PinyinHead.t, 't'),
    ting2(Shengmu.t, Yunmu.ing, 2, "tíng", "ting", PinyinHead.t, 't'),
    ting3(Shengmu.t, Yunmu.ing, 3, "tǐng", "ting", PinyinHead.t, 't'),
    ting4(Shengmu.t, Yunmu.ing, 4, "tìng", "ting", PinyinHead.t, 't'),
    tong1(Shengmu.t, Yunmu.ong, 1, "tōng", "tong", PinyinHead.t, 't'),
    tong2(Shengmu.t, Yunmu.ong, 2, "tóng", "tong", PinyinHead.t, 't'),
    tong3(Shengmu.t, Yunmu.ong, 3, "tǒng", "tong", PinyinHead.t, 't'),
    tong4(Shengmu.t, Yunmu.ong, 4, "tòng", "tong", PinyinHead.t, 't'),
    tou1(Shengmu.t, Yunmu.ou, 1, "tōu", "tou", PinyinHead.t, 't'),
    tou2(Shengmu.t, Yunmu.ou, 2, "tóu", "tou", PinyinHead.t, 't'),
    tou3(Shengmu.t, Yunmu.ou, 3, "tǒu", "tou", PinyinHead.t, 't'),
    tou4(Shengmu.t, Yunmu.ou, 4, "tòu", "tou", PinyinHead.t, 't'),
    tou5(Shengmu.t, Yunmu.ou, 5, "tou", "tou", PinyinHead.t, 't'),
    tu1(Shengmu.t, Yunmu.u, 1, "tū", "tu", PinyinHead.t, 't'),
    tu2(Shengmu.t, Yunmu.u, 2, "tú", "tu", PinyinHead.t, 't'),
    tu3(Shengmu.t, Yunmu.u, 3, "tǔ", "tu", PinyinHead.t, 't'),
    tu4(Shengmu.t, Yunmu.u, 4, "tù", "tu", PinyinHead.t, 't'),
    tu5(Shengmu.t, Yunmu.u, 5, "tu", "tu", PinyinHead.t, 't'),
    tuan1(Shengmu.t, Yunmu.uan, 1, "tuān", "tuan", PinyinHead.t, 't'),
    tuan2(Shengmu.t, Yunmu.uan, 2, "tuán", "tuan", PinyinHead.t, 't'),
    tuan3(Shengmu.t, Yunmu.uan, 3, "tuǎn", "tuan", PinyinHead.t, 't'),
    tuan4(Shengmu.t, Yunmu.uan, 4, "tuàn", "tuan", PinyinHead.t, 't'),
    tui1(Shengmu.t, Yunmu.ui, 1, "tuī", "tui", PinyinHead.t, 't'),
    tui2(Shengmu.t, Yunmu.ui, 2, "tuí", "tui", PinyinHead.t, 't'),
    tui3(Shengmu.t, Yunmu.ui, 3, "tuǐ", "tui", PinyinHead.t, 't'),
    tui4(Shengmu.t, Yunmu.ui, 4, "tuì", "tui", PinyinHead.t, 't'),
    tun1(Shengmu.t, Yunmu.un, 1, "tūn", "tun", PinyinHead.t, 't'),
    tun2(Shengmu.t, Yunmu.un, 2, "tún", "tun", PinyinHead.t, 't'),
    tun3(Shengmu.t, Yunmu.un, 3, "tǔn", "tun", PinyinHead.t, 't'),
    tun4(Shengmu.t, Yunmu.un, 4, "tùn", "tun", PinyinHead.t, 't'),
    tun5(Shengmu.t, Yunmu.un, 5, "tun", "tun", PinyinHead.t, 't'),
    tuo1(Shengmu.t, Yunmu.uo, 1, "tuō", "tuo", PinyinHead.t, 't'),
    tuo2(Shengmu.t, Yunmu.uo, 2, "tuó", "tuo", PinyinHead.t, 't'),
    tuo3(Shengmu.t, Yunmu.uo, 3, "tuǒ", "tuo", PinyinHead.t, 't'),
    tuo4(Shengmu.t, Yunmu.uo, 4, "tuò", "tuo", PinyinHead.t, 't'),
    wa1(Shengmu.w, Yunmu.a, 1, "wā", "wa", PinyinHead.w, 'w'),
    wa2(Shengmu.w, Yunmu.a, 2, "wá", "wa", PinyinHead.w, 'w'),
    wa3(Shengmu.w, Yunmu.a, 3, "wǎ", "wa", PinyinHead.w, 'w'),
    wa4(Shengmu.w, Yunmu.a, 4, "wà", "wa", PinyinHead.w, 'w'),
    wa5(Shengmu.w, Yunmu.a, 5, "wa", "wa", PinyinHead.w, 'w'),
    wai1(Shengmu.w, Yunmu.ai, 1, "wāi", "wai", PinyinHead.w, 'w'),
    wai3(Shengmu.w, Yunmu.ai, 3, "wǎi", "wai", PinyinHead.w, 'w'),
    wai4(Shengmu.w, Yunmu.ai, 4, "wài", "wai", PinyinHead.w, 'w'),
    wan1(Shengmu.w, Yunmu.an, 1, "wān", "wan", PinyinHead.w, 'w'),
    wan2(Shengmu.w, Yunmu.an, 2, "wán", "wan", PinyinHead.w, 'w'),
    wan3(Shengmu.w, Yunmu.an, 3, "wǎn", "wan", PinyinHead.w, 'w'),
    wan4(Shengmu.w, Yunmu.an, 4, "wàn", "wan", PinyinHead.w, 'w'),
    wang1(Shengmu.w, Yunmu.ang, 1, "wāng", "wang", PinyinHead.w, 'w'),
    wang2(Shengmu.w, Yunmu.ang, 2, "wáng", "wang", PinyinHead.w, 'w'),
    wang3(Shengmu.w, Yunmu.ang, 3, "wǎng", "wang", PinyinHead.w, 'w'),
    wang4(Shengmu.w, Yunmu.ang, 4, "wàng", "wang", PinyinHead.w, 'w'),
    wei1(Shengmu.w, Yunmu.ei, 1, "wēi", "wei", PinyinHead.w, 'w'),
    wei2(Shengmu.w, Yunmu.ei, 2, "wéi", "wei", PinyinHead.w, 'w'),
    wei3(Shengmu.w, Yunmu.ei, 3, "wěi", "wei", PinyinHead.w, 'w'),
    wei4(Shengmu.w, Yunmu.ei, 4, "wèi", "wei", PinyinHead.w, 'w'),
    wen1(Shengmu.w, Yunmu.en, 1, "wēn", "wen", PinyinHead.w, 'w'),
    wen2(Shengmu.w, Yunmu.en, 2, "wén", "wen", PinyinHead.w, 'w'),
    wen3(Shengmu.w, Yunmu.en, 3, "wěn", "wen", PinyinHead.w, 'w'),
    wen4(Shengmu.w, Yunmu.en, 4, "wèn", "wen", PinyinHead.w, 'w'),
    weng1(Shengmu.w, Yunmu.eng, 1, "wēng", "weng", PinyinHead.w, 'w'),
    weng3(Shengmu.w, Yunmu.eng, 3, "wěng", "weng", PinyinHead.w, 'w'),
    weng4(Shengmu.w, Yunmu.eng, 4, "wèng", "weng", PinyinHead.w, 'w'),
    wo1(Shengmu.w, Yunmu.o, 1, "wō", "wo", PinyinHead.w, 'w'),
    wo3(Shengmu.w, Yunmu.o, 3, "wǒ", "wo", PinyinHead.w, 'w'),
    wo4(Shengmu.w, Yunmu.o, 4, "wò", "wo", PinyinHead.w, 'w'),
    wu1(Shengmu.w, Yunmu.u, 1, "wū", "wu", PinyinHead.w, 'w'),
    wu2(Shengmu.w, Yunmu.u, 2, "wú", "wu", PinyinHead.w, 'w'),
    wu3(Shengmu.w, Yunmu.u, 3, "wǔ", "wu", PinyinHead.w, 'w'),
    wu4(Shengmu.w, Yunmu.u, 4, "wù", "wu", PinyinHead.w, 'w'),
    xi1(Shengmu.x, Yunmu.i, 1, "xī", "xi", PinyinHead.x, 'x'),
    xi2(Shengmu.x, Yunmu.i, 2, "xí", "xi", PinyinHead.x, 'x'),
    xi3(Shengmu.x, Yunmu.i, 3, "xǐ", "xi", PinyinHead.x, 'x'),
    xi4(Shengmu.x, Yunmu.i, 4, "xì", "xi", PinyinHead.x, 'x'),
    xia1(Shengmu.x, Yunmu.ia, 1, "xiā", "xia", PinyinHead.x, 'x'),
    xia2(Shengmu.x, Yunmu.ia, 2, "xiá", "xia", PinyinHead.x, 'x'),
    xia3(Shengmu.x, Yunmu.ia, 3, "xiǎ", "xia", PinyinHead.x, 'x'),
    xia4(Shengmu.x, Yunmu.ia, 4, "xià", "xia", PinyinHead.x, 'x'),
    xian1(Shengmu.x, Yunmu.ian, 1, "xiān", "xian", PinyinHead.x, 'x'),
    xian2(Shengmu.x, Yunmu.ian, 2, "xián", "xian", PinyinHead.x, 'x'),
    xian3(Shengmu.x, Yunmu.ian, 3, "xiǎn", "xian", PinyinHead.x, 'x'),
    xian4(Shengmu.x, Yunmu.ian, 4, "xiàn", "xian", PinyinHead.x, 'x'),
    xiang1(Shengmu.x, Yunmu.iang, 1, "xiāng", "xiang", PinyinHead.x, 'x'),
    xiang2(Shengmu.x, Yunmu.iang, 2, "xiáng", "xiang", PinyinHead.x, 'x'),
    xiang3(Shengmu.x, Yunmu.iang, 3, "xiǎng", "xiang", PinyinHead.x, 'x'),
    xiang4(Shengmu.x, Yunmu.iang, 4, "xiàng", "xiang", PinyinHead.x, 'x'),
    xiao1(Shengmu.x, Yunmu.iao, 1, "xiāo", "xiao", PinyinHead.x, 'x'),
    xiao2(Shengmu.x, Yunmu.iao, 2, "xiáo", "xiao", PinyinHead.x, 'x'),
    xiao3(Shengmu.x, Yunmu.iao, 3, "xiǎo", "xiao", PinyinHead.x, 'x'),
    xiao4(Shengmu.x, Yunmu.iao, 4, "xiào", "xiao", PinyinHead.x, 'x'),
    xie1(Shengmu.x, Yunmu.ie, 1, "xiē", "xie", PinyinHead.x, 'x'),
    xie2(Shengmu.x, Yunmu.ie, 2, "xié", "xie", PinyinHead.x, 'x'),
    xie3(Shengmu.x, Yunmu.ie, 3, "xiě", "xie", PinyinHead.x, 'x'),
    xie4(Shengmu.x, Yunmu.ie, 4, "xiè", "xie", PinyinHead.x, 'x'),
    xin1(Shengmu.x, Yunmu.in, 1, "xīn", "xin", PinyinHead.x, 'x'),
    xin2(Shengmu.x, Yunmu.in, 2, "xín", "xin", PinyinHead.x, 'x'),
    xin3(Shengmu.x, Yunmu.in, 3, "xǐn", "xin", PinyinHead.x, 'x'),
    xin4(Shengmu.x, Yunmu.in, 4, "xìn", "xin", PinyinHead.x, 'x'),
    xing1(Shengmu.x, Yunmu.ing, 1, "xīng", "xing", PinyinHead.x, 'x'),
    xing2(Shengmu.x, Yunmu.ing, 2, "xíng", "xing", PinyinHead.x, 'x'),
    xing3(Shengmu.x, Yunmu.ing, 3, "xǐng", "xing", PinyinHead.x, 'x'),
    xing4(Shengmu.x, Yunmu.ing, 4, "xìng", "xing", PinyinHead.x, 'x'),
    xiong1(Shengmu.x, Yunmu.iong, 1, "xiōng", "xiong", PinyinHead.x, 'x'),
    xiong2(Shengmu.x, Yunmu.iong, 2, "xióng", "xiong", PinyinHead.x, 'x'),
    xiong3(Shengmu.x, Yunmu.iong, 3, "xiǒng", "xiong", PinyinHead.x, 'x'),
    xiong4(Shengmu.x, Yunmu.iong, 4, "xiòng", "xiong", PinyinHead.x, 'x'),
    xiu1(Shengmu.x, Yunmu.iu, 1, "xiū", "xiu", PinyinHead.x, 'x'),
    xiu2(Shengmu.x, Yunmu.iu, 2, "xiú", "xiu", PinyinHead.x, 'x'),
    xiu3(Shengmu.x, Yunmu.iu, 3, "xiǔ", "xiu", PinyinHead.x, 'x'),
    xiu4(Shengmu.x, Yunmu.iu, 4, "xiù", "xiu", PinyinHead.x, 'x'),
    xu1(Shengmu.x, Yunmu.u, 1, "xū", "xu", PinyinHead.x, 'x'),
    xu2(Shengmu.x, Yunmu.u, 2, "xú", "xu", PinyinHead.x, 'x'),
    xu3(Shengmu.x, Yunmu.u, 3, "xǔ", "xu", PinyinHead.x, 'x'),
    xu4(Shengmu.x, Yunmu.u, 4, "xù", "xu", PinyinHead.x, 'x'),
    xu5(Shengmu.x, Yunmu.u, 5, "xu", "xu", PinyinHead.x, 'x'),
    xuan1(Shengmu.x, Yunmu.uan, 1, "xuān", "xuan", PinyinHead.x, 'x'),
    xuan2(Shengmu.x, Yunmu.uan, 2, "xuán", "xuan", PinyinHead.x, 'x'),
    xuan3(Shengmu.x, Yunmu.uan, 3, "xuǎn", "xuan", PinyinHead.x, 'x'),
    xuan4(Shengmu.x, Yunmu.uan, 4, "xuàn", "xuan", PinyinHead.x, 'x'),
    xue1(Shengmu.x, Yunmu.ue, 1, "xuē", "xue", PinyinHead.x, 'x'),
    xue2(Shengmu.x, Yunmu.ue, 2, "xué", "xue", PinyinHead.x, 'x'),
    xue3(Shengmu.x, Yunmu.ue, 3, "xuě", "xue", PinyinHead.x, 'x'),
    xue4(Shengmu.x, Yunmu.ue, 4, "xuè", "xue", PinyinHead.x, 'x'),
    xun1(Shengmu.x, Yunmu.un, 1, "xūn", "xun", PinyinHead.x, 'x'),
    xun2(Shengmu.x, Yunmu.un, 2, "xún", "xun", PinyinHead.x, 'x'),
    xun4(Shengmu.x, Yunmu.un, 4, "xùn", "xun", PinyinHead.x, 'x'),
    ya1(Shengmu.y, Yunmu.a, 1, "yā", "ya", PinyinHead.y, 'y'),
    ya2(Shengmu.y, Yunmu.a, 2, "yá", "ya", PinyinHead.y, 'y'),
    ya3(Shengmu.y, Yunmu.a, 3, "yǎ", "ya", PinyinHead.y, 'y'),
    ya4(Shengmu.y, Yunmu.a, 4, "yà", "ya", PinyinHead.y, 'y'),
    ya5(Shengmu.y, Yunmu.a, 5, "ya", "ya", PinyinHead.y, 'y'),
    yai2(Shengmu.y, Yunmu.ai, 2, "yái", "yai", PinyinHead.y, 'y'),
    yan1(Shengmu.y, Yunmu.an, 1, "yān", "yan", PinyinHead.y, 'y'),
    yan2(Shengmu.y, Yunmu.an, 2, "yán", "yan", PinyinHead.y, 'y'),
    yan3(Shengmu.y, Yunmu.an, 3, "yǎn", "yan", PinyinHead.y, 'y'),
    yan4(Shengmu.y, Yunmu.an, 4, "yàn", "yan", PinyinHead.y, 'y'),
    yang1(Shengmu.y, Yunmu.ang, 1, "yāng", "yang", PinyinHead.y, 'y'),
    yang2(Shengmu.y, Yunmu.ang, 2, "yáng", "yang", PinyinHead.y, 'y'),
    yang3(Shengmu.y, Yunmu.ang, 3, "yǎng", "yang", PinyinHead.y, 'y'),
    yang4(Shengmu.y, Yunmu.ang, 4, "yàng", "yang", PinyinHead.y, 'y'),
    yao1(Shengmu.y, Yunmu.ao, 1, "yāo", "yao", PinyinHead.y, 'y'),
    yao2(Shengmu.y, Yunmu.ao, 2, "yáo", "yao", PinyinHead.y, 'y'),
    yao3(Shengmu.y, Yunmu.ao, 3, "yǎo", "yao", PinyinHead.y, 'y'),
    yao4(Shengmu.y, Yunmu.ao, 4, "yào", "yao", PinyinHead.y, 'y'),
    ye1(Shengmu.y, Yunmu.e, 1, "yē", "ye", PinyinHead.y, 'y'),
    ye2(Shengmu.y, Yunmu.e, 2, "yé", "ye", PinyinHead.y, 'y'),
    ye3(Shengmu.y, Yunmu.e, 3, "yě", "ye", PinyinHead.y, 'y'),
    ye4(Shengmu.y, Yunmu.e, 4, "yè", "ye", PinyinHead.y, 'y'),
    ye5(Shengmu.y, Yunmu.e, 5, "ye", "ye", PinyinHead.y, 'y'),
    yi1(Shengmu.y, Yunmu.i, 1, "yī", "yi", PinyinHead.y, 'y'),
    yi2(Shengmu.y, Yunmu.i, 2, "yí", "yi", PinyinHead.y, 'y'),
    yi3(Shengmu.y, Yunmu.i, 3, "yǐ", "yi", PinyinHead.y, 'y'),
    yi4(Shengmu.y, Yunmu.i, 4, "yì", "yi", PinyinHead.y, 'y'),
    yi5(Shengmu.y, Yunmu.i, 5, "yi", "yi", PinyinHead.y, 'y'),
    yin1(Shengmu.y, Yunmu.in, 1, "yīn", "yin", PinyinHead.y, 'y'),
    yin2(Shengmu.y, Yunmu.in, 2, "yín", "yin", PinyinHead.y, 'y'),
    yin3(Shengmu.y, Yunmu.in, 3, "yǐn", "yin", PinyinHead.y, 'y'),
    yin4(Shengmu.y, Yunmu.in, 4, "yìn", "yin", PinyinHead.y, 'y'),
    ying1(Shengmu.y, Yunmu.ing, 1, "yīng", "ying", PinyinHead.y, 'y'),
    ying2(Shengmu.y, Yunmu.ing, 2, "yíng", "ying", PinyinHead.y, 'y'),
    ying3(Shengmu.y, Yunmu.ing, 3, "yǐng", "ying", PinyinHead.y, 'y'),
    ying4(Shengmu.y, Yunmu.ing, 4, "yìng", "ying", PinyinHead.y, 'y'),
    yo1(Shengmu.y, Yunmu.o, 1, "yō", "yo", PinyinHead.y, 'y'),
    yo5(Shengmu.y, Yunmu.o, 5, "yo", "yo", PinyinHead.y, 'y'),
    yong1(Shengmu.y, Yunmu.ong, 1, "yōng", "yong", PinyinHead.y, 'y'),
    yong2(Shengmu.y, Yunmu.ong, 2, "yóng", "yong", PinyinHead.y, 'y'),
    yong3(Shengmu.y, Yunmu.ong, 3, "yǒng", "yong", PinyinHead.y, 'y'),
    yong4(Shengmu.y, Yunmu.ong, 4, "yòng", "yong", PinyinHead.y, 'y'),
    you1(Shengmu.y, Yunmu.ou, 1, "yōu", "you", PinyinHead.y, 'y'),
    you2(Shengmu.y, Yunmu.ou, 2, "yóu", "you", PinyinHead.y, 'y'),
    you3(Shengmu.y, Yunmu.ou, 3, "yǒu", "you", PinyinHead.y, 'y'),
    you4(Shengmu.y, Yunmu.ou, 4, "yòu", "you", PinyinHead.y, 'y'),
    yu1(Shengmu.y, Yunmu.u, 1, "yū", "yu", PinyinHead.y, 'y'),
    yu2(Shengmu.y, Yunmu.u, 2, "yú", "yu", PinyinHead.y, 'y'),
    yu3(Shengmu.y, Yunmu.u, 3, "yǔ", "yu", PinyinHead.y, 'y'),
    yu4(Shengmu.y, Yunmu.u, 4, "yù", "yu", PinyinHead.y, 'y'),
    yuan1(Shengmu.y, Yunmu.uan, 1, "yuān", "yuan", PinyinHead.y, 'y'),
    yuan2(Shengmu.y, Yunmu.uan, 2, "yuán", "yuan", PinyinHead.y, 'y'),
    yuan3(Shengmu.y, Yunmu.uan, 3, "yuǎn", "yuan", PinyinHead.y, 'y'),
    yuan4(Shengmu.y, Yunmu.uan, 4, "yuàn", "yuan", PinyinHead.y, 'y'),
    yue1(Shengmu.y, Yunmu.ue, 1, "yuē", "yue", PinyinHead.y, 'y'),
    yue3(Shengmu.y, Yunmu.ue, 3, "yuě", "yue", PinyinHead.y, 'y'),
    yue4(Shengmu.y, Yunmu.ue, 4, "yuè", "yue", PinyinHead.y, 'y'),
    yun1(Shengmu.y, Yunmu.un, 1, "yūn", "yun", PinyinHead.y, 'y'),
    yun2(Shengmu.y, Yunmu.un, 2, "yún", "yun", PinyinHead.y, 'y'),
    yun3(Shengmu.y, Yunmu.un, 3, "yǔn", "yun", PinyinHead.y, 'y'),
    yun4(Shengmu.y, Yunmu.un, 4, "yùn", "yun", PinyinHead.y, 'y'),
    za1(Shengmu.z, Yunmu.a, 1, "zā", "za", PinyinHead.z, 'z'),
    za2(Shengmu.z, Yunmu.a, 2, "zá", "za", PinyinHead.z, 'z'),
    za3(Shengmu.z, Yunmu.a, 3, "zǎ", "za", PinyinHead.z, 'z'),
    zai1(Shengmu.z, Yunmu.ai, 1, "zāi", "zai", PinyinHead.z, 'z'),
    zai3(Shengmu.z, Yunmu.ai, 3, "zǎi", "zai", PinyinHead.z, 'z'),
    zai4(Shengmu.z, Yunmu.ai, 4, "zài", "zai", PinyinHead.z, 'z'),
    zan1(Shengmu.z, Yunmu.an, 1, "zān", "zan", PinyinHead.z, 'z'),
    zan2(Shengmu.z, Yunmu.an, 2, "zán", "zan", PinyinHead.z, 'z'),
    zan3(Shengmu.z, Yunmu.an, 3, "zǎn", "zan", PinyinHead.z, 'z'),
    zan4(Shengmu.z, Yunmu.an, 4, "zàn", "zan", PinyinHead.z, 'z'),
    zang1(Shengmu.z, Yunmu.ang, 1, "zāng", "zang", PinyinHead.z, 'z'),
    zang2(Shengmu.z, Yunmu.ang, 2, "záng", "zang", PinyinHead.z, 'z'),
    zang3(Shengmu.z, Yunmu.ang, 3, "zǎng", "zang", PinyinHead.z, 'z'),
    zang4(Shengmu.z, Yunmu.ang, 4, "zàng", "zang", PinyinHead.z, 'z'),
    zao1(Shengmu.z, Yunmu.ao, 1, "zāo", "zao", PinyinHead.z, 'z'),
    zao2(Shengmu.z, Yunmu.ao, 2, "záo", "zao", PinyinHead.z, 'z'),
    zao3(Shengmu.z, Yunmu.ao, 3, "zǎo", "zao", PinyinHead.z, 'z'),
    zao4(Shengmu.z, Yunmu.ao, 4, "zào", "zao", PinyinHead.z, 'z'),
    ze2(Shengmu.z, Yunmu.e, 2, "zé", "ze", PinyinHead.z, 'z'),
    ze4(Shengmu.z, Yunmu.e, 4, "zè", "ze", PinyinHead.z, 'z'),
    zei2(Shengmu.z, Yunmu.ei, 2, "zéi", "zei", PinyinHead.z, 'z'),
    zen1(Shengmu.z, Yunmu.en, 1, "zēn", "zen", PinyinHead.z, 'z'),
    zen3(Shengmu.z, Yunmu.en, 3, "zěn", "zen", PinyinHead.z, 'z'),
    zen4(Shengmu.z, Yunmu.en, 4, "zèn", "zen", PinyinHead.z, 'z'),
    zeng1(Shengmu.z, Yunmu.eng, 1, "zēng", "zeng", PinyinHead.z, 'z'),
    zeng4(Shengmu.z, Yunmu.eng, 4, "zèng", "zeng", PinyinHead.z, 'z'),
    zha1(Shengmu.zh, Yunmu.a, 1, "zhā", "zha", PinyinHead.zh, 'z'),
    zha2(Shengmu.zh, Yunmu.a, 2, "zhá", "zha", PinyinHead.zh, 'z'),
    zha3(Shengmu.zh, Yunmu.a, 3, "zhǎ", "zha", PinyinHead.zh, 'z'),
    zha4(Shengmu.zh, Yunmu.a, 4, "zhà", "zha", PinyinHead.zh, 'z'),
    zhai1(Shengmu.zh, Yunmu.ai, 1, "zhāi", "zhai", PinyinHead.zh, 'z'),
    zhai2(Shengmu.zh, Yunmu.ai, 2, "zhái", "zhai", PinyinHead.zh, 'z'),
    zhai3(Shengmu.zh, Yunmu.ai, 3, "zhǎi", "zhai", PinyinHead.zh, 'z'),
    zhai4(Shengmu.zh, Yunmu.ai, 4, "zhài", "zhai", PinyinHead.zh, 'z'),
    zhan1(Shengmu.zh, Yunmu.an, 1, "zhān", "zhan", PinyinHead.zh, 'z'),
    zhan2(Shengmu.zh, Yunmu.an, 2, "zhán", "zhan", PinyinHead.zh, 'z'),
    zhan3(Shengmu.zh, Yunmu.an, 3, "zhǎn", "zhan", PinyinHead.zh, 'z'),
    zhan4(Shengmu.zh, Yunmu.an, 4, "zhàn", "zhan", PinyinHead.zh, 'z'),
    zhang1(Shengmu.zh, Yunmu.ang, 1, "zhāng", "zhang", PinyinHead.zh, 'z'),
    zhang3(Shengmu.zh, Yunmu.ang, 3, "zhǎng", "zhang", PinyinHead.zh, 'z'),
    zhang4(Shengmu.zh, Yunmu.ang, 4, "zhàng", "zhang", PinyinHead.zh, 'z'),
    zhao1(Shengmu.zh, Yunmu.ao, 1, "zhāo", "zhao", PinyinHead.zh, 'z'),
    zhao2(Shengmu.zh, Yunmu.ao, 2, "zháo", "zhao", PinyinHead.zh, 'z'),
    zhao3(Shengmu.zh, Yunmu.ao, 3, "zhǎo", "zhao", PinyinHead.zh, 'z'),
    zhao4(Shengmu.zh, Yunmu.ao, 4, "zhào", "zhao", PinyinHead.zh, 'z'),
    zhe1(Shengmu.zh, Yunmu.e, 1, "zhē", "zhe", PinyinHead.zh, 'z'),
    zhe2(Shengmu.zh, Yunmu.e, 2, "zhé", "zhe", PinyinHead.zh, 'z'),
    zhe3(Shengmu.zh, Yunmu.e, 3, "zhě", "zhe", PinyinHead.zh, 'z'),
    zhe4(Shengmu.zh, Yunmu.e, 4, "zhè", "zhe", PinyinHead.zh, 'z'),
    zhe5(Shengmu.zh, Yunmu.e, 5, "zhe", "zhe", PinyinHead.zh, 'z'),
    zhei4(Shengmu.zh, Yunmu.ei, 4, "zhèi", "zhei", PinyinHead.zh, 'z'),
    zhen1(Shengmu.zh, Yunmu.en, 1, "zhēn", "zhen", PinyinHead.zh, 'z'),
    zhen3(Shengmu.zh, Yunmu.en, 3, "zhěn", "zhen", PinyinHead.zh, 'z'),
    zhen4(Shengmu.zh, Yunmu.en, 4, "zhèn", "zhen", PinyinHead.zh, 'z'),
    zheng1(Shengmu.zh, Yunmu.eng, 1, "zhēng", "zheng", PinyinHead.zh, 'z'),
    zheng3(Shengmu.zh, Yunmu.eng, 3, "zhěng", "zheng", PinyinHead.zh, 'z'),
    zheng4(Shengmu.zh, Yunmu.eng, 4, "zhèng", "zheng", PinyinHead.zh, 'z'),
    zhi1(Shengmu.zh, Yunmu.i, 1, "zhī", "zhi", PinyinHead.zh, 'z'),
    zhi2(Shengmu.zh, Yunmu.i, 2, "zhí", "zhi", PinyinHead.zh, 'z'),
    zhi3(Shengmu.zh, Yunmu.i, 3, "zhǐ", "zhi", PinyinHead.zh, 'z'),
    zhi4(Shengmu.zh, Yunmu.i, 4, "zhì", "zhi", PinyinHead.zh, 'z'),
    zhong1(Shengmu.zh, Yunmu.ong, 1, "zhōng", "zhong", PinyinHead.zh, 'z'),
    zhong3(Shengmu.zh, Yunmu.ong, 3, "zhǒng", "zhong", PinyinHead.zh, 'z'),
    zhong4(Shengmu.zh, Yunmu.ong, 4, "zhòng", "zhong", PinyinHead.zh, 'z'),
    zhou1(Shengmu.zh, Yunmu.ou, 1, "zhōu", "zhou", PinyinHead.zh, 'z'),
    zhou2(Shengmu.zh, Yunmu.ou, 2, "zhóu", "zhou", PinyinHead.zh, 'z'),
    zhou3(Shengmu.zh, Yunmu.ou, 3, "zhǒu", "zhou", PinyinHead.zh, 'z'),
    zhou4(Shengmu.zh, Yunmu.ou, 4, "zhòu", "zhou", PinyinHead.zh, 'z'),
    zhu1(Shengmu.zh, Yunmu.u, 1, "zhū", "zhu", PinyinHead.zh, 'z'),
    zhu2(Shengmu.zh, Yunmu.u, 2, "zhú", "zhu", PinyinHead.zh, 'z'),
    zhu3(Shengmu.zh, Yunmu.u, 3, "zhǔ", "zhu", PinyinHead.zh, 'z'),
    zhu4(Shengmu.zh, Yunmu.u, 4, "zhù", "zhu", PinyinHead.zh, 'z'),
    zhua1(Shengmu.zh, Yunmu.ua, 1, "zhuā", "zhua", PinyinHead.zh, 'z'),
    zhua3(Shengmu.zh, Yunmu.ua, 3, "zhuǎ", "zhua", PinyinHead.zh, 'z'),
    zhuai1(Shengmu.zh, Yunmu.uai, 1, "zhuāi", "zhuai", PinyinHead.zh, 'z'),
    zhuai3(Shengmu.zh, Yunmu.uai, 3, "zhuǎi", "zhuai", PinyinHead.zh, 'z'),
    zhuai4(Shengmu.zh, Yunmu.uai, 4, "zhuài", "zhuai", PinyinHead.zh, 'z'),
    zhuan1(Shengmu.zh, Yunmu.uan, 1, "zhuān", "zhuan", PinyinHead.zh, 'z'),
    zhuan3(Shengmu.zh, Yunmu.uan, 3, "zhuǎn", "zhuan", PinyinHead.zh, 'z'),
    zhuan4(Shengmu.zh, Yunmu.uan, 4, "zhuàn", "zhuan", PinyinHead.zh, 'z'),
    zhuang1(Shengmu.zh, Yunmu.uang, 1, "zhuāng", "zhuang", PinyinHead.zh, 'z'),
    zhuang3(Shengmu.zh, Yunmu.uang, 3, "zhuǎng", "zhuang", PinyinHead.zh, 'z'),
    zhuang4(Shengmu.zh, Yunmu.uang, 4, "zhuàng", "zhuang", PinyinHead.zh, 'z'),
    zhui1(Shengmu.zh, Yunmu.ui, 1, "zhuī", "zhui", PinyinHead.zh, 'z'),
    zhui3(Shengmu.zh, Yunmu.ui, 3, "zhuǐ", "zhui", PinyinHead.zh, 'z'),
    zhui4(Shengmu.zh, Yunmu.ui, 4, "zhuì", "zhui", PinyinHead.zh, 'z'),
    zhun1(Shengmu.zh, Yunmu.un, 1, "zhūn", "zhun", PinyinHead.zh, 'z'),
    zhun3(Shengmu.zh, Yunmu.un, 3, "zhǔn", "zhun", PinyinHead.zh, 'z'),
    zhun4(Shengmu.zh, Yunmu.un, 4, "zhùn", "zhun", PinyinHead.zh, 'z'),
    zhuo1(Shengmu.zh, Yunmu.uo, 1, "zhuō", "zhuo", PinyinHead.zh, 'z'),
    zhuo2(Shengmu.zh, Yunmu.uo, 2, "zhuó", "zhuo", PinyinHead.zh, 'z'),
    zhuo3(Shengmu.zh, Yunmu.uo, 3, "zhuǒ", "zhuo", PinyinHead.zh, 'z'),
    zhuo4(Shengmu.zh, Yunmu.uo, 4, "zhuò", "zhuo", PinyinHead.zh, 'z'),
    zi1(Shengmu.z, Yunmu.i, 1, "zī", "zi", PinyinHead.z, 'z'),
    zi2(Shengmu.z, Yunmu.i, 2, "zí", "zi", PinyinHead.z, 'z'),
    zi3(Shengmu.z, Yunmu.i, 3, "zǐ", "zi", PinyinHead.z, 'z'),
    zi4(Shengmu.z, Yunmu.i, 4, "zì", "zi", PinyinHead.z, 'z'),
    zi5(Shengmu.z, Yunmu.i, 5, "zi", "zi", PinyinHead.z, 'z'),
    zong1(Shengmu.z, Yunmu.ong, 1, "zōng", "zong", PinyinHead.z, 'z'),
    zong3(Shengmu.z, Yunmu.ong, 3, "zǒng", "zong", PinyinHead.z, 'z'),
    zong4(Shengmu.z, Yunmu.ong, 4, "zòng", "zong", PinyinHead.z, 'z'),
    zou1(Shengmu.z, Yunmu.ou, 1, "zōu", "zou", PinyinHead.z, 'z'),
    zou3(Shengmu.z, Yunmu.ou, 3, "zǒu", "zou", PinyinHead.z, 'z'),
    zou4(Shengmu.z, Yunmu.ou, 4, "zòu", "zou", PinyinHead.z, 'z'),
    zu1(Shengmu.z, Yunmu.u, 1, "zū", "zu", PinyinHead.z, 'z'),
    zu2(Shengmu.z, Yunmu.u, 2, "zú", "zu", PinyinHead.z, 'z'),
    zu3(Shengmu.z, Yunmu.u, 3, "zǔ", "zu", PinyinHead.z, 'z'),
    zu4(Shengmu.z, Yunmu.u, 4, "zù", "zu", PinyinHead.z, 'z'),
    zuan1(Shengmu.z, Yunmu.uan, 1, "zuān", "zuan", PinyinHead.z, 'z'),
    zuan3(Shengmu.z, Yunmu.uan, 3, "zuǎn", "zuan", PinyinHead.z, 'z'),
    zuan4(Shengmu.z, Yunmu.uan, 4, "zuàn", "zuan", PinyinHead.z, 'z'),
    zui1(Shengmu.z, Yunmu.ui, 1, "zuī", "zui", PinyinHead.z, 'z'),
    zui3(Shengmu.z, Yunmu.ui, 3, "zuǐ", "zui", PinyinHead.z, 'z'),
    zui4(Shengmu.z, Yunmu.ui, 4, "zuì", "zui", PinyinHead.z, 'z'),
    zun1(Shengmu.z, Yunmu.un, 1, "zūn", "zun", PinyinHead.z, 'z'),
    zun3(Shengmu.z, Yunmu.un, 3, "zǔn", "zun", PinyinHead.z, 'z'),
    zun4(Shengmu.z, Yunmu.un, 4, "zùn", "zun", PinyinHead.z, 'z'),
    zuo1(Shengmu.z, Yunmu.uo, 1, "zuō", "zuo", PinyinHead.z, 'z'),
    zuo2(Shengmu.z, Yunmu.uo, 2, "zuó", "zuo", PinyinHead.z, 'z'),
    zuo3(Shengmu.z, Yunmu.uo, 3, "zuǒ", "zuo", PinyinHead.z, 'z'),
    zuo4(Shengmu.z, Yunmu.uo, 4, "zuò", "zuo", PinyinHead.z, 'z'),
    zuo5(Shengmu.z, Yunmu.uo, 5, "zuo", "zuo", PinyinHead.z, 'z'),
    none5(Shengmu.none, Yunmu.none, 5, "none", "none", PinyinHead.none, ' '),

    ;

    /**
     * 构造一个拼音
     * @param shengmu 声母
     * @param yunmu 韵母
     * @param tone 音调
     * @param pinyinWithToneMark 包含音调的字符串形式
     * @param pinyinWithoutTone 不含音调的字符串形式
     */
    Pinyin(Shengmu shengmu, Yunmu yunmu, int tone, String pinyinWithToneMark, String pinyinWithoutTone, PinyinHead head, char firstChar)
    {
        this.shengmu = shengmu;
        this.yunmu = yunmu;
        this.tone = tone;
        this.pinyinWithToneMark = pinyinWithToneMark;
        this.pinyinWithoutTone = pinyinWithoutTone;
        this.head = head;
        this.firstChar = firstChar;
    }

    /**
     * 声母
     */
    private Shengmu shengmu;

    /**
     * 韵母
     */
    private Yunmu yunmu;
    /**
     * 音调
     */
    private int tone;

    /**
     * 输入法头
     */
    private PinyinHead head;

    /**
     * 首字母
     */
    private char firstChar;

    /**
     * 声母+韵母+āáǎàēéěèīíǐìōóǒòūúǔùǖǘǚǜ
     */
    private String pinyinWithToneMark;

    /**
     * 声母+韵母不含音调，纯字母
     */
    private String pinyinWithoutTone;

    /**
     * 获取声母
     * @return
     */
    public Shengmu getShengmu()
    {
        return shengmu;
    }

    /**
     * 获取韵母
     * @return
     */
    public Yunmu getYunmu()
    {
        return yunmu;
    }

    /**
     * 获取声调
     * @return
     */
    public int getTone()
    {
        return tone;
    }

    /**
     * 获取带音调的拼音
     * @return
     */
    public String getPinyinWithToneMark()
    {
        return pinyinWithToneMark;
    }

    /**
     * 获取纯字母的拼音
     * @return
     */
    public String getPinyinWithoutTone()
    {
        return pinyinWithoutTone;
    }

    /**
     * 获取输入法头
     * @return
     */
    public String getHeadString()
    {
        return head.toString();
    }

    /**
     * 获取输入法头
     * @return
     */
    public PinyinHead getHead()
    {
        return head;
    }

    /**
     * 获取首字母
     * @return
     */
    public char getFirstChar()
    {
        return firstChar;
    }
}
