/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.pinyin.split;

import com.mayabot.nlp.common.FastStringBuilder;
import com.mayabot.nlp.perceptron.PerceptronDefinition;
import com.mayabot.nlp.pinyin.split.PinyinSplitDefinition;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0010\u000e\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0005\u00a2\u0006\u0002\u0010\u0005J\"\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u000b0\u00072\u0006\u0010\f\u001a\u00020\u0003H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J6\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016H\u0016J\u0016\u0010\u0017\u001a\u00020\u00042\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0016J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0003H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lcom/mayabot/nlp/pinyin/split/PinyinSplitDefinition;", "Lcom/mayabot/nlp/perceptron/PerceptronDefinition;", "", "", "", "()V", "labels", "", "getLabels", "()Ljava/util/List;", "annotateText", "Lkotlin/Pair;", "text", "buffer", "Lcom/mayabot/nlp/common/FastStringBuilder;", "featureFunction", "", "sentence", "size", "", "position", "emit", "Lkotlin/Function0;", "inputList2InputSeq", "list", "labelIndex", "label", "mynlp-pinyin"})
public final class PinyinSplitDefinition
extends PerceptronDefinition<Character, String, char[]> {
    @NotNull
    private final List<String> labels = CollectionsKt.listOf((Object[])new String[]{"B", "M", "E", "S"});

    @NotNull
    public List<String> getLabels() {
        return this.labels;
    }

    public int labelIndex(@NotNull String label) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        switch (label) {
            case "B": {
                n = 0;
                break;
            }
            case "M": {
                n = 1;
                break;
            }
            case "E": {
                n = 2;
                break;
            }
            case "S": {
                n = 3;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    @NotNull
    public FastStringBuilder buffer() {
        return new FastStringBuilder(4);
    }

    public void featureFunction(@NotNull char[] sentence, int size, int position, @NotNull FastStringBuilder buffer, @NotNull Function0<Unit> emit) {
        Intrinsics.checkParameterIsNotNull((Object)sentence, (String)"sentence");
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        char CHAR_NULL = '\u0000';
        int lastIndex = size - position - 1;
        char pre2Char = position > 1 ? sentence[position - 2] : CHAR_NULL;
        char preChar = position > 0 ? sentence[position - 1] : CHAR_NULL;
        char curChar = sentence[position];
        char nextChar = lastIndex > 0 ? sentence[position + 1] : CHAR_NULL;
        char next2Char = lastIndex > 1 ? sentence[position + 2] : CHAR_NULL;
        buffer.clear();
        buffer.set2(curChar, '2');
        emit.invoke();
        if (position > 0) {
            buffer.clear();
            buffer.set2(preChar, '1');
            emit.invoke();
            buffer.clear();
            buffer.set4(preChar, '/', curChar, '5');
            emit.invoke();
            if (position > 1) {
                buffer.clear();
                buffer.set4(pre2Char, '/', preChar, '4');
                emit.invoke();
            }
        }
        if (lastIndex > 0) {
            buffer.clear();
            buffer.set2(nextChar, '3');
            emit.invoke();
            buffer.clear();
            buffer.set4(curChar, '/', nextChar, '6');
            emit.invoke();
            if (lastIndex > 1) {
                buffer.clear();
                buffer.set4(nextChar, '/', next2Char, '7');
                emit.invoke();
            }
        }
    }

    @NotNull
    public char[] inputList2InputSeq(@NotNull List<Character> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        return CollectionsKt.toCharArray((Collection)list);
    }

    @NotNull
    public List<Pair<Character, String>> annotateText(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return SequencesKt.toList((Sequence)SequencesKt.flatMap((Sequence)StringsKt.splitToSequence$default((CharSequence)text, (char[])new char[]{'\ufe4d'}, (boolean)false, (int)0, (int)6, null), (Function1)annotateText.1.INSTANCE));
    }
}

