/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.Curve;
import java.util.Collection;

class AlgorithmSupportMessage {
    private static String itemize(Collection collection) {
        StringBuilder sb = new StringBuilder();
        Object[] items = collection.toArray();
        int i = 0;
        while (i < items.length) {
            if (i != 0) {
                if (i < items.length - 1) {
                    sb.append(", ");
                } else if (i == items.length - 1) {
                    sb.append(" or ");
                }
            }
            sb.append(items[i].toString());
            ++i;
        }
        return sb.toString();
    }

    public static String unsupportedJWSAlgorithm(JWSAlgorithm unsupported, Collection<JWSAlgorithm> supported) {
        return "Unsupported JWS algorithm " + unsupported + ", must be " + AlgorithmSupportMessage.itemize(supported);
    }

    public static String unsupportedJWEAlgorithm(JWEAlgorithm unsupported, Collection<JWEAlgorithm> supported) {
        return "Unsupported JWE algorithm " + unsupported + ", must be " + AlgorithmSupportMessage.itemize(supported);
    }

    public static String unsupportedEncryptionMethod(EncryptionMethod unsupported, Collection<EncryptionMethod> supported) {
        return "Unsupported JWE encryption method " + unsupported + ", must be " + AlgorithmSupportMessage.itemize(supported);
    }

    public static String unsupportedEllipticCurve(Curve unsupported, Collection<Curve> supported) {
        return "Unsupported elliptic curve " + unsupported + ", must be " + AlgorithmSupportMessage.itemize(supported);
    }

    private AlgorithmSupportMessage() {
    }
}

