/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.http.AsyncCallback;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.storage.UpCompletionHandler;
import com.qiniu.util.Crc32;
import com.qiniu.util.StringMap;
import com.qiniu.util.UC;
import java.io.File;
import java.io.IOException;

public final class FormUploader {
    private final String token;
    private final String key;
    private final File file;
    private final byte[] data;
    private final String mime;
    private final boolean checkCrc;
    private StringMap params;
    private Client client;
    private String fileName;

    FormUploader(Client client, String upToken, String key, byte[] data, StringMap params, String mime, boolean checkCrc) {
        this(client, upToken, key, data, null, params, mime, checkCrc);
    }

    FormUploader(Client client, String upToken, String key, File file, StringMap params, String mime, boolean checkCrc) {
        this(client, upToken, key, null, file, params, mime, checkCrc);
    }

    private FormUploader(Client client, String upToken, String key, byte[] data, File file, StringMap params, String mime, boolean checkCrc) {
        this.client = client;
        this.token = upToken;
        this.key = key;
        this.file = file;
        this.data = data;
        this.params = params;
        this.mime = mime;
        this.checkCrc = checkCrc;
    }

    Response upload() throws QiniuException {
        this.buildParams();
        if (this.data != null) {
            return this.client.multipartPost(UC.zone((String)this.token).upHost, this.params, "file", this.fileName, this.data, this.mime, new StringMap());
        }
        return this.client.multipartPost(UC.zone((String)this.token).upHost, this.params, "file", this.fileName, this.file, this.mime, new StringMap());
    }

    void asyncUpload(final UpCompletionHandler handler) throws IOException {
        this.buildParams();
        if (this.data != null) {
            this.client.asyncMultipartPost(UC.zone((String)this.token).upHost, this.params, "file", this.fileName, this.data, this.mime, new StringMap(), new AsyncCallback(){

                @Override
                public void complete(Response r) {
                    handler.complete(FormUploader.this.key, r);
                }
            });
            return;
        }
        this.client.asyncMultipartPost(UC.zone((String)this.token).upHost, this.params, "file", this.fileName, this.file, this.mime, new StringMap(), new AsyncCallback(){

            @Override
            public void complete(Response r) {
                handler.complete(FormUploader.this.key, r);
            }
        });
    }

    private void buildParams() throws QiniuException {
        this.params.put("token", this.token);
        if (this.key != null) {
            this.params.put("key", this.key);
        }
        if (this.file != null) {
            this.fileName = this.file.getName();
        }
        if (this.fileName == null || this.fileName.trim().length() == 0) {
            this.fileName = "fileName";
        }
        if (this.checkCrc) {
            long crc32 = 0L;
            if (this.file != null) {
                try {
                    crc32 = Crc32.file(this.file);
                }
                catch (IOException e) {
                    throw new QiniuException(e);
                }
            } else {
                crc32 = Crc32.bytes(this.data);
            }
            this.params.put("crc32", "" + crc32);
        }
    }
}

