/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.util;

import com.qiniu.common.Config;
import com.qiniu.common.QiniuException;
import com.qiniu.common.Zone;
import com.qiniu.util.Json;
import com.qiniu.util.UrlSafeBase64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class UC {
    private static UC uc = new UC();
    private Map<AKBKT, ZoneInfo> zones = new ConcurrentHashMap<AKBKT, ZoneInfo>();
    private OkHttpClient client = new OkHttpClient.Builder().connectTimeout(10000L, TimeUnit.SECONDS).readTimeout(10000L, TimeUnit.SECONDS).writeTimeout(10000L, TimeUnit.SECONDS).build();

    private UC() {
    }

    public static Zone zone(String ak, String bkt) throws QiniuException {
        return uc.getZone(Config.zone, ak, bkt, Config.UPLOAD_BY_HTTPS);
    }

    public static Zone zone(String uptoken) throws QiniuException {
        try {
            String[] strings = uptoken.split(":");
            String ak = strings[0];
            String policy = new String(UrlSafeBase64.decode(strings[2]), Config.UTF_8);
            String bkt = Json.decode(policy).get("scope").toString().split(":")[0];
            return UC.zone(ak, bkt);
        }
        catch (QiniuException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QiniuException(e);
        }
    }

    public static String ucVal(String ak, String bkt) throws QiniuException {
        return uc.getUCVal(ak, bkt, Config.UPLOAD_BY_HTTPS);
    }

    public static void clear() {
        UC.uc.zones.clear();
    }

    private Zone getZone(Zone userSetZone, String ak, String bkt, boolean isHttps) throws QiniuException {
        if (userSetZone != null) {
            return userSetZone;
        }
        ZoneInfo zoneInfo = this.getZoneInfo(ak, bkt, isHttps);
        return zoneInfo.zone;
    }

    public String getUCVal(String ak, String bkt, boolean isHttps) throws QiniuException {
        ZoneInfo zoneInfo = this.getZoneInfo(ak, bkt, isHttps);
        return zoneInfo.ucjson;
    }

    ZoneInfo getZoneInfo(String ak, String bkt, boolean isHttps) throws QiniuException {
        AKBKT akbkt = new AKBKT(ak, bkt, isHttps);
        ZoneInfo zoneInfo = this.zones.get(akbkt);
        if (zoneInfo != null) {
            return zoneInfo;
        }
        this.build(akbkt);
        zoneInfo = this.zones.get(akbkt);
        return zoneInfo;
    }

    private void build(AKBKT akbkt) throws QiniuException {
        try {
            String address = Config.UC_HOST + "/v1/query?ak=" + akbkt.ak + "&bucket=" + akbkt.bkt;
            long start = System.currentTimeMillis();
            Response res = this.client.newCall(new Request.Builder().url(address).build()).execute();
            double duration = (double)(System.currentTimeMillis() - start) / 1000.0;
            this.build(akbkt, res, address, duration);
        }
        catch (QiniuException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QiniuException(e);
        }
    }

    private void build(AKBKT akbkt, Response res, String address, double duration) throws QiniuException {
        com.qiniu.http.Response qnRes = com.qiniu.http.Response.create(res, address, duration);
        if (!qnRes.isOK()) {
            throw new QiniuException(qnRes);
        }
        try {
            String ucVal = qnRes.bodyString();
            UCRet ret = qnRes.jsonToObject(UCRet.class);
            List<String> args = null;
            args = akbkt.isHttps ? ret.https.get("up") : ret.http.get("up");
            String[] zoneArgs = new String[2];
            zoneArgs[0] = this.getZoneHost(args.get(0));
            if (args.size() > 1) {
                zoneArgs[1] = this.getZoneHost(args.get(1));
            }
            if (zoneArgs[1] == null) {
                zoneArgs[1] = zoneArgs[0];
            }
            Zone new_zone = new Zone(zoneArgs[0], zoneArgs[1]);
            if (zoneArgs[0] == null || zoneArgs[0].trim().length() == 0 || new_zone == null || ucVal == null) {
                throw new QiniuException(qnRes);
            }
            this.zones.put(akbkt, new ZoneInfo(new_zone, ucVal));
        }
        catch (QiniuException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QiniuException(e);
        }
    }

    private String getZoneHost(String p) {
        if (p.startsWith("http")) {
            return p;
        }
        return null;
    }

    private class UCRet {
        Map<String, List<String>> http;
        Map<String, List<String>> https;

        private UCRet() {
        }
    }

    private class ZoneInfo {
        public final String ucjson;
        public final Zone zone;

        ZoneInfo(Zone zone, String ucjson) {
            this.zone = zone;
            this.ucjson = ucjson;
        }
    }

    private class AKBKT {
        String ak;
        String bkt;
        boolean isHttps;

        AKBKT(String ak, String bkt, boolean isHttps) {
            this.ak = ak.trim();
            this.bkt = bkt.trim();
            this.isHttps = isHttps;
        }

        public int hashCode() {
            return this.ak.hashCode() * this.bkt.hashCode() * (this.isHttps ? 5 : 1);
        }

        public boolean equals(Object obj) {
            if (obj instanceof AKBKT) {
                AKBKT that = (AKBKT)obj;
                return this.bkt.equals(that.bkt) && this.ak.equals(that.ak) && this.isHttps == that.isHttps;
            }
            return false;
        }
    }
}

