/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.qvs;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.qvs.QvsResponse;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;

public class RecordManager {
    private final String apiServer;
    private final Client client;
    private final Auth auth;

    public RecordManager(Auth auth) {
        this(auth, "http://qvs.qiniuapi.com");
    }

    public RecordManager(Auth auth, String apiServer) {
        this(auth, apiServer, new Client());
    }

    public RecordManager(Auth auth, String apiServer, Client client) {
        this.auth = auth;
        this.apiServer = apiServer;
        this.client = client;
    }

    public Response startRecord(String namespaceId, String streamId) throws QiniuException {
        String url = String.format("%s/v1/namespaces/%s/streams/%s/record/start", this.apiServer, namespaceId, streamId);
        return QvsResponse.post(url, new StringMap(), this.client, this.auth);
    }

    public Response stopRecord(String namespaceId, String streamId) throws QiniuException {
        String url = String.format("%s/v1/namespaces/%s/streams/%s/record/stop", this.apiServer, namespaceId, streamId);
        return QvsResponse.post(url, new StringMap(), this.client, this.auth);
    }

    public Response deleteStreamRecordHistories(String namespaceId, String streamId, String[] files) throws QiniuException {
        String url = String.format("%s/v1/namespaces/%s/streams/%s/recordhistories", this.apiServer, namespaceId, streamId);
        StringMap params = new StringMap();
        params.putNotNull("files", files);
        return QvsResponse.delete(url, params, this.client, this.auth);
    }

    public Response recordClipsSaveas(String namespaceId, String streamId, String fname, String format, int start, int end, boolean deleteTs, String pipeline, String notifyUrl, int deleteAfterDays) throws QiniuException {
        String url = String.format("%s/v1/namespaces/%s/streams/%s/saveas", this.apiServer, namespaceId, streamId);
        StringMap params = new StringMap();
        params.putNotNull("fname", fname);
        params.putNotNull("format", format);
        params.putNotNull("start", start);
        params.putNotNull("end", end);
        params.putNotNull("deleteTs", deleteTs);
        params.putNotNull("pipeline", pipeline);
        params.putNotNull("notifyUrl", notifyUrl);
        params.putNotNull("deleteAfterDays", deleteAfterDays);
        return QvsResponse.post(url, params, this.client, this.auth);
    }

    public Response recordsPlayback(String namespaceId, String streamId, int start, int end) throws QiniuException {
        String url = String.format("%s/v1/namespaces/%s/streams/%s/records/playback.m3u8?start=%d&end=%d", this.apiServer, namespaceId, streamId, start, end);
        return QvsResponse.get(url, this.client, this.auth);
    }
}

