/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.common;

import com.qiniu.common.AutoRegion;
import com.qiniu.common.RegionReqInfo;
import java.util.Arrays;
import java.util.List;

public class Region {
    private String region;
    private List<String> srcUpHosts;
    private List<String> accUpHosts;
    private String iovipHost;
    private String rsHost = "rs.qbox.me";
    private String rsfHost = "rsf.qbox.me";
    private String apiHost = "api.qiniu.com";

    public String getRegion() {
        return this.region;
    }

    public List<String> getSrcUpHosts() {
        return this.srcUpHosts;
    }

    public List<String> getAccUpHosts() {
        return this.accUpHosts;
    }

    public String getIovipHost() {
        return this.iovipHost;
    }

    public String getRsHost() {
        return this.rsHost;
    }

    public String getRsfHost() {
        return this.rsfHost;
    }

    public String getApiHost() {
        return this.apiHost;
    }

    public static Region region0() {
        return new Builder().region("z0").srcUpHost("up.qiniup.com", "up-jjh.qiniup.com", "up-xs.qiniup.com").accUpHost("upload.qiniup.com", "upload-jjh.qiniup.com", "upload-xs.qiniup.com").iovipHost("iovip.qbox.me").rsHost("rs.qbox.me").rsfHost("rsf.qbox.me").apiHost("api.qiniu.com").build();
    }

    public static Region huadong() {
        return Region.region0();
    }

    public static Region qvmRegion0() {
        return new Builder().region("z0").srcUpHost("free-qvm-z0-xs.qiniup.com").accUpHost("free-qvm-z0-xs.qiniup.com").iovipHost("iovip.qbox.me").rsHost("rs.qbox.me").rsfHost("rsf.qbox.me").apiHost("api.qiniu.com").build();
    }

    public static Region qvmHuadong() {
        return Region.qvmRegion0();
    }

    public static Region region1() {
        return new Builder().region("z1").srcUpHost("up-z1.qiniup.com").accUpHost("upload-z1.qiniup.com").iovipHost("iovip-z1.qbox.me").rsHost("rs-z1.qbox.me").rsfHost("rsf-z1.qbox.me").apiHost("api-z1.qiniu.com").build();
    }

    public static Region huabei() {
        return Region.region1();
    }

    public static Region qvmRegion1() {
        return new Builder().region("z1").srcUpHost("free-qvm-z1-zz.qiniup.com").accUpHost("free-qvm-z1-zz.qiniup.com").iovipHost("iovip-z1.qbox.me").rsHost("rs-z1.qbox.me").rsfHost("rsf-z1.qbox.me").apiHost("api-z1.qiniu.com").build();
    }

    public static Region qvmHuabei() {
        return Region.qvmRegion1();
    }

    public static Region region2() {
        return new Builder().region("z2").srcUpHost("up-z2.qiniup.com", "up-dg.qiniup.com", "up-fs.qiniup.com").accUpHost("upload-z2.qiniup.com", "upload-dg.qiniup.com", "upload-fs.qiniup.com").iovipHost("iovip-z2.qbox.me").rsHost("rs-z2.qbox.me").rsfHost("rsf-z2.qbox.me").apiHost("api-z2.qiniu.com").build();
    }

    public static Region huanan() {
        return Region.region2();
    }

    public static Region regionNa0() {
        return new Builder().region("na0").srcUpHost("up-na0.qiniup.com").accUpHost("upload-na0.qiniup.com").iovipHost("iovip-na0.qbox.me").rsHost("rs-na0.qbox.me").rsfHost("rsf-na0.qbox.me").apiHost("api-na0.qiniu.com").build();
    }

    public static Region beimei() {
        return Region.regionNa0();
    }

    public static Region regionAs0() {
        return new Builder().region("na0").srcUpHost("up-as0.qiniup.com").accUpHost("upload-as0.qiniup.com").iovipHost("iovip-as0.qbox.me").rsHost("rs-as0.qbox.me").rsfHost("rsf-as0.qbox.me").apiHost("api-as0.qiniu.com").build();
    }

    public static Region xinjiapo() {
        return Region.regionAs0();
    }

    public static Region autoRegion() {
        return new Builder().autoRegion();
    }

    public String getRegion(RegionReqInfo regionReqInfo) {
        return this.region;
    }

    public String getSrcUpHost(RegionReqInfo regionReqInfo) {
        return this.srcUpHosts.get(0);
    }

    public String getAccUpHost(RegionReqInfo regionReqInfo) {
        return this.accUpHosts.get(0);
    }

    public String getSrcUpHostBackup(RegionReqInfo regionReqInfo) {
        if (this.srcUpHosts.size() > 1) {
            return this.srcUpHosts.get(1);
        }
        return this.getSrcUpHost(regionReqInfo);
    }

    public String getAccUpHostBackup(RegionReqInfo regionReqInfo) {
        if (this.accUpHosts.size() > 1) {
            return this.accUpHosts.get(1);
        }
        return this.getAccUpHost(regionReqInfo);
    }

    public String getIovipHost(RegionReqInfo regionReqInfo) {
        return this.iovipHost;
    }

    public String getRsHost(RegionReqInfo regionReqInfo) {
        return this.rsHost;
    }

    public String getRsfHost(RegionReqInfo regionReqInfo) {
        return this.rsfHost;
    }

    public String getApiHost(RegionReqInfo regionReqInfo) {
        return this.apiHost;
    }

    public static class Builder {
        protected Region region;

        public Builder() {
            this.init();
        }

        public Builder(Region originRegion) {
            this.init();
            this.region.region = originRegion.region;
            this.region.srcUpHosts = originRegion.srcUpHosts;
            this.region.accUpHosts = originRegion.accUpHosts;
            this.region.iovipHost = originRegion.iovipHost;
            this.region.rsHost = originRegion.rsHost;
            this.region.rsfHost = originRegion.rsfHost;
            this.region.apiHost = originRegion.apiHost;
        }

        protected void init() {
            this.region = new Region();
        }

        public Builder region(String region) {
            this.region.region = region;
            return this;
        }

        public Builder srcUpHost(String ... srcUpHosts) {
            this.region.srcUpHosts = Arrays.asList(srcUpHosts);
            return this;
        }

        public Builder accUpHost(String ... accUpHosts) {
            this.region.accUpHosts = Arrays.asList(accUpHosts);
            return this;
        }

        public Builder iovipHost(String iovipHost) {
            this.region.iovipHost = iovipHost;
            return this;
        }

        public Builder rsHost(String rsHost) {
            this.region.rsHost = rsHost;
            return this;
        }

        public Builder rsfHost(String rsfHost) {
            this.region.rsfHost = rsfHost;
            return this;
        }

        public Builder apiHost(String apiHost) {
            this.region.apiHost = apiHost;
            return this;
        }

        public Region autoRegion() {
            return new AutoRegion();
        }

        public Region build() {
            return this.region;
        }
    }
}

