/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.util.osgi.manifest.internal;

import com.springsource.util.osgi.manifest.ExportedPackage;
import com.springsource.util.osgi.manifest.internal.BaseCompoundHeaderEntry;
import com.springsource.util.osgi.manifest.internal.HeaderUtils;
import com.springsource.util.osgi.manifest.parse.HeaderDeclaration;
import com.springsource.util.osgi.manifest.parse.HeaderParser;
import java.util.List;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardExportedPackage
extends BaseCompoundHeaderEntry
implements ExportedPackage {
    StandardExportedPackage(HeaderParser parser, String name) {
        super(parser, name);
    }

    @Override
    HeaderDeclaration parse(HeaderParser parser, String parseString) {
        List<HeaderDeclaration> header = parser.parsePackageHeader(parseString, "Export-Package");
        return header.get(0);
    }

    @Override
    public List<String> getExclude() {
        return HeaderUtils.toList("exclude", this.getDirectives());
    }

    @Override
    public List<String> getInclude() {
        return HeaderUtils.toList("include", this.getDirectives());
    }

    @Override
    public List<String> getMandatory() {
        return HeaderUtils.toList("mandatory", this.getDirectives());
    }

    @Override
    public String getPackageName() {
        return this.name;
    }

    @Override
    public List<String> getUses() {
        return HeaderUtils.toList("uses", this.getDirectives());
    }

    @Override
    public Version getVersion() {
        String value = this.getAttributes().get("version");
        if (value != null) {
            return new Version(value);
        }
        return Version.emptyVersion;
    }

    @Override
    public void setVersion(Version version) {
        if (version != null) {
            this.getAttributes().put("version", version.toString());
        } else {
            this.getAttributes().remove("version");
        }
    }

    @Override
    public void setPackageName(String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException("packageName must not be null");
        }
        this.name = packageName;
    }
}

