/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.config;

import de.codecentric.boot.admin.server.web.PathUtils;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;

@ConfigurationProperties(value="spring.boot.admin")
public class AdminServerProperties {
    private String contextPath = "";
    private MonitorProperties monitor = new MonitorProperties();
    private InstanceProxyProperties instanceProxy = new InstanceProxyProperties();
    private String[] metadataKeysToSanitize = new String[]{".*password$", ".*secret$", ".*key$", ".*$token$", ".*credentials.*", ".*vcap_services$"};
    private String[] probedEndpoints = new String[]{"health", "env", "metrics", "httptrace:trace", "httptrace", "threaddump:dump", "threaddump", "jolokia", "info", "logfile", "refresh", "flyway", "liquibase", "heapdump", "loggers", "auditevents", "mappings", "scheduledtasks", "configprops", "caches", "beans"};

    public void setContextPath(String contextPath) {
        this.contextPath = PathUtils.normalizePath(contextPath);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public MonitorProperties getMonitor() {
        return this.monitor;
    }

    public InstanceProxyProperties getInstanceProxy() {
        return this.instanceProxy;
    }

    public String[] getMetadataKeysToSanitize() {
        return this.metadataKeysToSanitize;
    }

    public String[] getProbedEndpoints() {
        return this.probedEndpoints;
    }

    public void setMonitor(MonitorProperties monitor) {
        this.monitor = monitor;
    }

    public void setInstanceProxy(InstanceProxyProperties instanceProxy) {
        this.instanceProxy = instanceProxy;
    }

    public void setMetadataKeysToSanitize(String[] metadataKeysToSanitize) {
        this.metadataKeysToSanitize = metadataKeysToSanitize;
    }

    public void setProbedEndpoints(String[] probedEndpoints) {
        this.probedEndpoints = probedEndpoints;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdminServerProperties)) {
            return false;
        }
        AdminServerProperties other = (AdminServerProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$contextPath = this.getContextPath();
        String other$contextPath = other.getContextPath();
        if (this$contextPath == null ? other$contextPath != null : !this$contextPath.equals(other$contextPath)) {
            return false;
        }
        MonitorProperties this$monitor = this.getMonitor();
        MonitorProperties other$monitor = other.getMonitor();
        if (this$monitor == null ? other$monitor != null : !((Object)this$monitor).equals(other$monitor)) {
            return false;
        }
        InstanceProxyProperties this$instanceProxy = this.getInstanceProxy();
        InstanceProxyProperties other$instanceProxy = other.getInstanceProxy();
        if (this$instanceProxy == null ? other$instanceProxy != null : !((Object)this$instanceProxy).equals(other$instanceProxy)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getMetadataKeysToSanitize(), other.getMetadataKeysToSanitize())) {
            return false;
        }
        return Arrays.deepEquals(this.getProbedEndpoints(), other.getProbedEndpoints());
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdminServerProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $contextPath = this.getContextPath();
        result = result * 59 + ($contextPath == null ? 43 : $contextPath.hashCode());
        MonitorProperties $monitor = this.getMonitor();
        result = result * 59 + ($monitor == null ? 43 : ((Object)$monitor).hashCode());
        InstanceProxyProperties $instanceProxy = this.getInstanceProxy();
        result = result * 59 + ($instanceProxy == null ? 43 : ((Object)$instanceProxy).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getMetadataKeysToSanitize());
        result = result * 59 + Arrays.deepHashCode(this.getProbedEndpoints());
        return result;
    }

    public String toString() {
        return "AdminServerProperties(contextPath=" + this.getContextPath() + ", monitor=" + this.getMonitor() + ", instanceProxy=" + this.getInstanceProxy() + ", metadataKeysToSanitize=" + Arrays.deepToString(this.getMetadataKeysToSanitize()) + ", probedEndpoints=" + Arrays.deepToString(this.getProbedEndpoints()) + ")";
    }

    public static class InstanceProxyProperties {
        private Set<String> ignoredHeaders = new HashSet<String>(Arrays.asList("Cookie", "Set-Cookie", "Authorization"));

        public Set<String> getIgnoredHeaders() {
            return this.ignoredHeaders;
        }

        public void setIgnoredHeaders(Set<String> ignoredHeaders) {
            this.ignoredHeaders = ignoredHeaders;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InstanceProxyProperties)) {
                return false;
            }
            InstanceProxyProperties other = (InstanceProxyProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Set<String> this$ignoredHeaders = this.getIgnoredHeaders();
            Set<String> other$ignoredHeaders = other.getIgnoredHeaders();
            return !(this$ignoredHeaders == null ? other$ignoredHeaders != null : !((Object)this$ignoredHeaders).equals(other$ignoredHeaders));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InstanceProxyProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<String> $ignoredHeaders = this.getIgnoredHeaders();
            result = result * 59 + ($ignoredHeaders == null ? 43 : ((Object)$ignoredHeaders).hashCode());
            return result;
        }

        public String toString() {
            return "AdminServerProperties.InstanceProxyProperties(ignoredHeaders=" + this.getIgnoredHeaders() + ")";
        }
    }

    public static class MonitorProperties {
        @DurationUnit(value=ChronoUnit.MILLIS)
        private Duration period = Duration.ofMillis(10000L);
        @DurationUnit(value=ChronoUnit.MILLIS)
        private Duration statusLifetime = Duration.ofMillis(10000L);
        @DurationUnit(value=ChronoUnit.MILLIS)
        private Duration connectTimeout = Duration.ofMillis(2000L);
        @DurationUnit(value=ChronoUnit.MILLIS)
        private Duration readTimeout = Duration.ofMillis(10000L);
        private int defaultRetries = 0;
        private Map<String, Integer> retries = new HashMap<String, Integer>();

        public Duration getPeriod() {
            return this.period;
        }

        public Duration getStatusLifetime() {
            return this.statusLifetime;
        }

        public Duration getConnectTimeout() {
            return this.connectTimeout;
        }

        public Duration getReadTimeout() {
            return this.readTimeout;
        }

        public int getDefaultRetries() {
            return this.defaultRetries;
        }

        public Map<String, Integer> getRetries() {
            return this.retries;
        }

        public void setPeriod(Duration period) {
            this.period = period;
        }

        public void setStatusLifetime(Duration statusLifetime) {
            this.statusLifetime = statusLifetime;
        }

        public void setConnectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public void setReadTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
        }

        public void setDefaultRetries(int defaultRetries) {
            this.defaultRetries = defaultRetries;
        }

        public void setRetries(Map<String, Integer> retries) {
            this.retries = retries;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MonitorProperties)) {
                return false;
            }
            MonitorProperties other = (MonitorProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Duration this$period = this.getPeriod();
            Duration other$period = other.getPeriod();
            if (this$period == null ? other$period != null : !((Object)this$period).equals(other$period)) {
                return false;
            }
            Duration this$statusLifetime = this.getStatusLifetime();
            Duration other$statusLifetime = other.getStatusLifetime();
            if (this$statusLifetime == null ? other$statusLifetime != null : !((Object)this$statusLifetime).equals(other$statusLifetime)) {
                return false;
            }
            Duration this$connectTimeout = this.getConnectTimeout();
            Duration other$connectTimeout = other.getConnectTimeout();
            if (this$connectTimeout == null ? other$connectTimeout != null : !((Object)this$connectTimeout).equals(other$connectTimeout)) {
                return false;
            }
            Duration this$readTimeout = this.getReadTimeout();
            Duration other$readTimeout = other.getReadTimeout();
            if (this$readTimeout == null ? other$readTimeout != null : !((Object)this$readTimeout).equals(other$readTimeout)) {
                return false;
            }
            if (this.getDefaultRetries() != other.getDefaultRetries()) {
                return false;
            }
            Map<String, Integer> this$retries = this.getRetries();
            Map<String, Integer> other$retries = other.getRetries();
            return !(this$retries == null ? other$retries != null : !((Object)this$retries).equals(other$retries));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MonitorProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Duration $period = this.getPeriod();
            result = result * 59 + ($period == null ? 43 : ((Object)$period).hashCode());
            Duration $statusLifetime = this.getStatusLifetime();
            result = result * 59 + ($statusLifetime == null ? 43 : ((Object)$statusLifetime).hashCode());
            Duration $connectTimeout = this.getConnectTimeout();
            result = result * 59 + ($connectTimeout == null ? 43 : ((Object)$connectTimeout).hashCode());
            Duration $readTimeout = this.getReadTimeout();
            result = result * 59 + ($readTimeout == null ? 43 : ((Object)$readTimeout).hashCode());
            result = result * 59 + this.getDefaultRetries();
            Map<String, Integer> $retries = this.getRetries();
            result = result * 59 + ($retries == null ? 43 : ((Object)$retries).hashCode());
            return result;
        }

        public String toString() {
            return "AdminServerProperties.MonitorProperties(period=" + this.getPeriod() + ", statusLifetime=" + this.getStatusLifetime() + ", connectTimeout=" + this.getConnectTimeout() + ", readTimeout=" + this.getReadTimeout() + ", defaultRetries=" + this.getDefaultRetries() + ", retries=" + this.getRetries() + ")";
        }
    }
}

