/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.woff;

import java.io.IOException;
import org.apache.commons.lang3.ArrayUtils;
import org.mabb.fontverter.CombinedFontConverter;
import org.mabb.fontverter.FontConverter;
import org.mabb.fontverter.FontNotSupportedException;
import org.mabb.fontverter.FontProperties;
import org.mabb.fontverter.FontVerter;
import org.mabb.fontverter.FontVerterUtils;
import org.mabb.fontverter.converter.OtfToWoffConverter;
import org.mabb.fontverter.converter.WoffToOtfConverter;
import org.mabb.fontverter.woff.Woff2Parser;
import org.mabb.fontverter.woff.WoffConstants;
import org.mabb.fontverter.woff.WoffFont;
import org.mabb.fontverter.woff.WoffOutputStream;
import org.mabb.fontverter.woff.WoffTable;
import org.meteogroup.jbrotli.Brotli;
import org.meteogroup.jbrotli.BrotliStreamCompressor;
import org.meteogroup.jbrotli.libloader.BrotliLibraryLoader;

public class Woff2Font
extends WoffFont {
    private byte[] cachedCompressedBlock;

    @Override
    public WoffTable createTable() {
        return new Woff2Table(new byte[0], WoffConstants.TableFlagType.arbitrary);
    }

    @Override
    public void addFontTable(byte[] data, String tag, long checksum) {
        Woff2Table table = new Woff2Table(data, WoffConstants.TableFlagType.fromString(tag));
        this.tables.add(table);
    }

    @Override
    public boolean detectFormat(byte[] fontFile) {
        return FontVerterUtils.bytesStartsWith(fontFile, "wOF2");
    }

    @Override
    public void read(byte[] fontFile) throws IOException {
        Woff2Parser parser = new Woff2Parser();
        parser.parse(fontFile, this);
    }

    @Override
    byte[] getCompressedDataBlock() throws IOException {
        if (this.cachedCompressedBlock == null) {
            this.cachedCompressedBlock = this.brotliCompress(super.getCompressedDataBlock());
        }
        return this.cachedCompressedBlock;
    }

    @Override
    byte[] getRawData() throws IOException {
        byte[] bytes = super.getRawData();
        byte[] pad = FontVerterUtils.tablePaddingNeeded(bytes);
        bytes = ArrayUtils.addAll((byte[])bytes, (byte[])pad);
        return bytes;
    }

    private byte[] brotliCompress(byte[] bytes) {
        BrotliLibraryLoader.loadBrotli();
        Brotli.Parameter param = new Brotli.Parameter().setMode(Brotli.Mode.TEXT).setQuality(11).setLgwin(10).setLgblock(0);
        BrotliStreamCompressor streamCompressor = new BrotliStreamCompressor(param);
        byte[] compressed = streamCompressor.compressArray(bytes, true);
        streamCompressor.close();
        return compressed;
    }

    @Override
    public FontProperties getProperties() {
        FontProperties properties = new FontProperties();
        properties.setMimeType("application/font-woff2");
        properties.setFileEnding("woff");
        properties.setCssFontFaceFormat("woff2");
        return properties;
    }

    @Override
    public FontConverter createConverterForType(FontVerter.FontFormat fontFormat) throws FontNotSupportedException {
        if (fontFormat == FontVerter.FontFormat.OTF) {
            return new WoffToOtfConverter();
        }
        if (fontFormat == FontVerter.FontFormat.WOFF1) {
            return new CombinedFontConverter(new WoffToOtfConverter(), new OtfToWoffConverter());
        }
        throw new FontNotSupportedException("Font conversion not supported");
    }

    public static class Woff2Table
    extends WoffTable {
        private int transform = -1;
        protected WoffConstants.TableFlagType flag;

        public Woff2Table(byte[] table, WoffConstants.TableFlagType flag) {
            super(table);
            this.flag = flag;
        }

        @Override
        protected byte[] compress(byte[] bytes) throws IOException {
            return bytes;
        }

        @Override
        public byte[] getDirectoryData() throws IOException {
            WoffOutputStream writer = new WoffOutputStream();
            writer.writeFlagByte(this.flag.getValue(), this.getTransform());
            writer.writeUIntBase128(this.tableData.length);
            if (this.isTableTransformed()) {
                writer.writeUIntBase128(this.getCompressedData().length);
            }
            return writer.toByteArray();
        }

        public int getTransformedLength() throws IOException {
            if (this.isTableTransformed()) {
                return this.getCompressedData().length;
            }
            return this.tableData.length;
        }

        public void setTransform(int transform) {
            this.transform = transform;
        }

        public int getTransform() {
            if (this.transform == -1) {
                this.transform = this.initTransformValue();
            }
            return this.transform;
        }

        private int initTransformValue() {
            if (this.flag == WoffConstants.TableFlagType.glyf || this.flag == WoffConstants.TableFlagType.loca) {
                return 3;
            }
            return 0;
        }

        boolean isTableTransformed() {
            if (this.flag == WoffConstants.TableFlagType.glyf || this.flag == WoffConstants.TableFlagType.loca) {
                return this.transform != 3;
            }
            return this.transform != 0;
        }

        public WoffConstants.TableFlagType getFlag() {
            return this.flag;
        }

        @Override
        public String getTag() {
            return this.flag.toString();
        }
    }
}

