/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.cellprocessor.time;

import java.time.DateTimeException;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Objects;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.util.CsvContext;

public abstract class AbstractTemporalAccessorFormattingProcessor<T extends TemporalAccessor>
extends CellProcessorAdaptor {
    private final DateTimeFormatter formatter;

    public AbstractTemporalAccessorFormattingProcessor() {
        this.formatter = null;
    }

    public AbstractTemporalAccessorFormattingProcessor(CellProcessor next) {
        super(next);
        this.formatter = null;
    }

    public AbstractTemporalAccessorFormattingProcessor(DateTimeFormatter formatter) {
        AbstractTemporalAccessorFormattingProcessor.checkPreconditions(formatter);
        this.formatter = formatter;
    }

    public AbstractTemporalAccessorFormattingProcessor(DateTimeFormatter formatter, CellProcessor next) {
        super(next);
        AbstractTemporalAccessorFormattingProcessor.checkPreconditions(formatter);
        this.formatter = formatter;
    }

    private static void checkPreconditions(DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter should not be null");
    }

    public Object execute(Object value, CsvContext context) {
        this.validateInputNotNull(value, context);
        Class<T> ourType = this.getType();
        if (!value.getClass().equals(ourType)) {
            throw new SuperCsvCellProcessorException(ourType, value, context, (CellProcessor)this);
        }
        TemporalAccessor timeType = (TemporalAccessor)ourType.cast(value);
        try {
            if (this.formatter != null) {
                return this.formatter.format(timeType);
            }
            return timeType.toString();
        }
        catch (IllegalArgumentException | DateTimeException e) {
            throw new SuperCsvCellProcessorException(String.format("Failed to format value as a %s", ourType.getSimpleName()), context, (CellProcessor)this, (Throwable)e);
        }
    }

    protected abstract Class<T> getType();
}

