/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.css.dom;

import com.gargoylesoftware.css.dom.AbstractCSSRuleImpl;
import com.gargoylesoftware.css.dom.CSSRuleListImpl;
import com.gargoylesoftware.css.dom.CSSStyleSheetImpl;
import com.gargoylesoftware.css.dom.DOMExceptionImpl;
import com.gargoylesoftware.css.dom.MediaListImpl;
import com.gargoylesoftware.css.parser.CSSException;
import com.gargoylesoftware.css.parser.CSSOMParser;
import com.gargoylesoftware.css.parser.InputSource;
import com.gargoylesoftware.css.util.LangUtils;
import com.gargoylesoftware.css.util.ThrowCssExceptionErrorHandler;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSMediaRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.stylesheets.MediaList;

public class CSSMediaRuleImpl
extends AbstractCSSRuleImpl
implements CSSMediaRule {
    private MediaList media_;
    private CSSRuleList cssRules_;

    public void setMedia(MediaList media) {
        this.media_ = media;
    }

    public void setCssRules(CSSRuleList cssRules) {
        this.cssRules_ = cssRules;
    }

    public CSSMediaRuleImpl(CSSStyleSheetImpl parentStyleSheet, CSSRule parentRule, MediaList media) {
        super(parentStyleSheet, parentRule);
        this.media_ = media;
    }

    @Override
    public short getType() {
        return 4;
    }

    @Override
    public String getCssText() {
        StringBuilder sb = new StringBuilder("@media ");
        sb.append(((MediaListImpl)this.getMedia()).getMediaText());
        sb.append(" {");
        for (int i = 0; i < this.getCssRules().getLength(); ++i) {
            CSSRule rule = this.getCssRules().item(i);
            sb.append(rule.getCssText()).append(" ");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        CSSStyleSheetImpl parentStyleSheet = this.getParentStyleSheetImpl();
        if (parentStyleSheet != null && parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource is = new InputSource(new StringReader(cssText));
            CSSOMParser parser = new CSSOMParser();
            CSSRule r = parser.parseRule(is);
            if (r.getType() != 4) {
                throw new DOMExceptionImpl(13, 6);
            }
            this.media_ = ((CSSMediaRuleImpl)r).media_;
            this.cssRules_ = ((CSSMediaRuleImpl)r).cssRules_;
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    @Override
    public MediaList getMedia() {
        return this.media_;
    }

    @Override
    public CSSRuleList getCssRules() {
        if (this.cssRules_ == null) {
            this.cssRules_ = new CSSRuleListImpl();
        }
        return this.cssRules_;
    }

    @Override
    public int insertRule(String rule, int index) throws DOMException {
        CSSStyleSheetImpl parentStyleSheet = this.getParentStyleSheetImpl();
        if (parentStyleSheet != null && parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource is = new InputSource(new StringReader(rule));
            CSSOMParser parser = new CSSOMParser();
            parser.setParentStyleSheet(parentStyleSheet);
            parser.setErrorHandler(ThrowCssExceptionErrorHandler.INSTANCE);
            CSSRule r = parser.parseRule(is);
            ((CSSRuleListImpl)this.getCssRules()).insert(r, index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DOMExceptionImpl(1, 1, e.getMessage());
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        return index;
    }

    @Override
    public void deleteRule(int index) throws DOMException {
        CSSStyleSheetImpl parentStyleSheet = this.getParentStyleSheetImpl();
        if (parentStyleSheet != null && parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            ((CSSRuleListImpl)this.getCssRules()).delete(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DOMExceptionImpl(1, 1, e.getMessage());
        }
    }

    public void setRuleList(CSSRuleListImpl rules) {
        this.cssRules_ = rules;
    }

    public String toString() {
        return this.getCssText();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CSSMediaRule)) {
            return false;
        }
        CSSMediaRule cmr = (CSSMediaRule)obj;
        return super.equals(obj) && LangUtils.equals(this.getMedia(), cmr.getMedia()) && LangUtils.equals(this.getCssRules(), cmr.getCssRules());
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = LangUtils.hashCode(hash, this.media_);
        hash = LangUtils.hashCode(hash, this.cssRules_);
        return hash;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.cssRules_);
        out.writeObject(this.media_);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.cssRules_ = (CSSRuleList)in.readObject();
        if (this.cssRules_ != null) {
            for (int i = 0; i < this.cssRules_.getLength(); ++i) {
                CSSRule cssRule = this.cssRules_.item(i);
                if (!(cssRule instanceof AbstractCSSRuleImpl)) continue;
                ((AbstractCSSRuleImpl)((Object)cssRule)).setParentRule(this);
                ((AbstractCSSRuleImpl)((Object)cssRule)).setParentStyleSheet(this.getParentStyleSheetImpl());
            }
        }
        this.media_ = (MediaList)in.readObject();
    }
}

