/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.delegate.event;

import org.activiti.engine.delegate.event.ActivitiEntityEvent;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.ActivitiEventType;

public class BaseEntityEventListener
implements ActivitiEventListener {
    protected boolean failOnException;
    protected Class<?> entityClass;

    public BaseEntityEventListener() {
        this(true, null);
    }

    public BaseEntityEventListener(boolean failOnException) {
        this(failOnException, null);
    }

    public BaseEntityEventListener(boolean failOnException, Class<?> entityClass) {
        this.failOnException = failOnException;
        this.entityClass = entityClass;
    }

    @Override
    public final void onEvent(ActivitiEvent event) {
        if (this.isValidEvent(event)) {
            if (event.getType() == ActivitiEventType.ENTITY_CREATED) {
                this.onCreate(event);
            } else if (event.getType() == ActivitiEventType.ENTITY_INITIALIZED) {
                this.onInitialized(event);
            } else if (event.getType() == ActivitiEventType.ENTITY_DELETED) {
                this.onDelete(event);
            } else if (event.getType() == ActivitiEventType.ENTITY_UPDATED) {
                this.onUpdate(event);
            } else {
                this.onEntityEvent(event);
            }
        }
    }

    @Override
    public boolean isFailOnException() {
        return this.failOnException;
    }

    protected boolean isValidEvent(ActivitiEvent event) {
        boolean valid = false;
        if (event instanceof ActivitiEntityEvent) {
            valid = this.entityClass == null ? true : this.entityClass.isAssignableFrom(((ActivitiEntityEvent)event).getEntity().getClass());
        }
        return valid;
    }

    protected void onCreate(ActivitiEvent event) {
    }

    protected void onInitialized(ActivitiEvent event) {
    }

    protected void onDelete(ActivitiEvent event) {
    }

    protected void onUpdate(ActivitiEvent event) {
    }

    protected void onEntityEvent(ActivitiEvent event) {
    }
}

