/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.calendar;

import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.api.internal.Internal;
import org.activiti.engine.impl.calendar.AdvancedSchedulerResolver;
import org.activiti.engine.impl.calendar.AdvancedSchedulerResolverWithTimeZone;
import org.activiti.engine.impl.calendar.AdvancedSchedulerResolverWithoutTimeZone;
import org.activiti.engine.impl.calendar.CycleBusinessCalendar;
import org.activiti.engine.runtime.ClockReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Internal
public class AdvancedCycleBusinessCalendar
extends CycleBusinessCalendar {
    private Integer defaultScheduleVersion;
    private static final Integer DEFAULT_VERSION = 2;
    private static final Logger logger = LoggerFactory.getLogger(AdvancedCycleBusinessCalendar.class);
    private static final Map<Integer, AdvancedSchedulerResolver> resolvers = new ConcurrentHashMap<Integer, AdvancedSchedulerResolver>();

    public AdvancedCycleBusinessCalendar(ClockReader clockReader) {
        super(clockReader);
    }

    public AdvancedCycleBusinessCalendar(ClockReader clockReader, Integer defaultScheduleVersion) {
        this(clockReader);
        this.defaultScheduleVersion = defaultScheduleVersion;
    }

    public Integer getDefaultScheduleVersion() {
        return this.defaultScheduleVersion == null ? DEFAULT_VERSION : this.defaultScheduleVersion;
    }

    public void setDefaultScheduleVersion(Integer defaultScheduleVersion) {
        this.defaultScheduleVersion = defaultScheduleVersion;
    }

    @Override
    public Date resolveDuedate(String duedateDescription, int maxIterations) {
        logger.info("Resolving Due Date: " + duedateDescription);
        String timeZone = this.getValueFrom("DSTZONE", duedateDescription);
        String version = this.getValueFrom("VER", duedateDescription);
        duedateDescription = this.removeValueFrom("VER", this.removeValueFrom("START", this.removeValueFrom("DSTZONE", duedateDescription))).trim();
        try {
            logger.info("Base Due Date: " + duedateDescription);
            Date date = resolvers.get(version == null ? this.getDefaultScheduleVersion() : Integer.valueOf(version)).resolve(duedateDescription, this.clockReader, timeZone == null ? this.clockReader.getCurrentTimeZone() : TimeZone.getTimeZone(timeZone));
            logger.info("Calculated Date: " + (date == null ? "Will Not Run Again" : date));
            return date;
        }
        catch (Exception e) {
            throw new ActivitiIllegalArgumentException("Cannot parse duration", e);
        }
    }

    private String getValueFrom(String field, String duedateDescription) {
        int fieldIndex = duedateDescription.indexOf(field + ":");
        if (fieldIndex > -1) {
            int nextWhiteSpace = duedateDescription.indexOf(" ", fieldIndex);
            fieldIndex += field.length() + 1;
            if (nextWhiteSpace > -1) {
                return duedateDescription.substring(fieldIndex, nextWhiteSpace);
            }
            return duedateDescription.substring(fieldIndex);
        }
        return null;
    }

    private String removeValueFrom(String field, String duedateDescription) {
        int fieldIndex = duedateDescription.indexOf(field + ":");
        if (fieldIndex > -1) {
            int nextWhiteSpace = duedateDescription.indexOf(" ", fieldIndex);
            if (nextWhiteSpace > -1) {
                return duedateDescription.replace(duedateDescription.substring(fieldIndex, nextWhiteSpace), "");
            }
            return duedateDescription.substring(0, fieldIndex);
        }
        return duedateDescription;
    }

    static {
        resolvers.put(1, new AdvancedSchedulerResolverWithoutTimeZone());
        resolvers.put(2, new AdvancedSchedulerResolverWithTimeZone());
    }
}

