/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.util;

import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.deploy.DeploymentManager;
import org.activiti.engine.impl.persistence.deploy.ProcessDefinitionCacheEntry;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntityManager;
import org.activiti.engine.repository.ProcessDefinition;

public class ProcessDefinitionUtil {
    public static ProcessDefinition getProcessDefinition(String processDefinitionId) {
        return ProcessDefinitionUtil.getProcessDefinition(processDefinitionId, false);
    }

    public static ProcessDefinition getProcessDefinition(String processDefinitionId, boolean checkCacheOnly) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (checkCacheOnly) {
            ProcessDefinitionCacheEntry cacheEntry = processEngineConfiguration.getProcessDefinitionCache().get(processDefinitionId);
            if (cacheEntry != null) {
                return cacheEntry.getProcessDefinition();
            }
            return null;
        }
        return processEngineConfiguration.getDeploymentManager().findDeployedProcessDefinitionById(processDefinitionId);
    }

    public static Process getProcess(String processDefinitionId) {
        DeploymentManager deploymentManager = Context.getProcessEngineConfiguration().getDeploymentManager();
        ProcessDefinition processDefinitionEntity = deploymentManager.findDeployedProcessDefinitionById(processDefinitionId);
        return deploymentManager.resolveProcessDefinition(processDefinitionEntity).getProcess();
    }

    public static BpmnModel getBpmnModel(String processDefinitionId) {
        DeploymentManager deploymentManager = Context.getProcessEngineConfiguration().getDeploymentManager();
        ProcessDefinition processDefinitionEntity = deploymentManager.findDeployedProcessDefinitionById(processDefinitionId);
        return deploymentManager.resolveProcessDefinition(processDefinitionEntity).getBpmnModel();
    }

    public static BpmnModel getBpmnModelFromCache(String processDefinitionId) {
        ProcessDefinitionCacheEntry cacheEntry = Context.getProcessEngineConfiguration().getProcessDefinitionCache().get(processDefinitionId);
        if (cacheEntry != null) {
            return cacheEntry.getBpmnModel();
        }
        return null;
    }

    public static boolean isProcessDefinitionSuspended(String processDefinitionId) {
        ProcessDefinitionEntity processDefinition = ProcessDefinitionUtil.getProcessDefinitionFromDatabase(processDefinitionId);
        return processDefinition.isSuspended();
    }

    public static ProcessDefinitionEntity getProcessDefinitionFromDatabase(String processDefinitionId) {
        ProcessDefinitionEntityManager processDefinitionEntityManager = Context.getProcessEngineConfiguration().getProcessDefinitionEntityManager();
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)processDefinitionEntityManager.findById(processDefinitionId);
        if (processDefinition == null) {
            throw new ActivitiException("No process definition found with id " + processDefinitionId);
        }
        return processDefinition;
    }
}

